/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_notify.h"

#include "librpc/gen_ndr/ndr_file_id.h"
#include "librpc/gen_ndr/ndr_server_id.h"
_PUBLIC_ enum ndr_err_code ndr_push_notify_entry(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct notify_entry *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->filter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->subdir_filter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dir_fd));
		NDR_CHECK(ndr_push_file_id(ndr, NDR_SCALARS, &r->dir_id));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->path));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->path_len));
		NDR_CHECK(ndr_push_pointer(ndr, NDR_SCALARS, r->private_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_notify_entry(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct notify_entry *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->filter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->subdir_filter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dir_fd));
		NDR_CHECK(ndr_pull_file_id(ndr, NDR_SCALARS, &r->dir_id));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->path));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->path_len));
		NDR_CHECK(ndr_pull_pointer(ndr, NDR_SCALARS, &r->private_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_notify_entry(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct notify_entry *r)
{
	ndr_print_notify_entry(ndr, name, r);
}

_PUBLIC_ void ndr_print_notify_entry(struct ndr_print *ndr, const char *name, const struct notify_entry *r)
{
	ndr_print_struct(ndr, name, "notify_entry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "server", &r->server);
	ndr_print_uint32(ndr, "filter", r->filter);
	ndr_print_uint32(ndr, "subdir_filter", r->subdir_filter);
	ndr_print_uint32(ndr, "dir_fd", r->dir_fd);
	ndr_print_file_id(ndr, "dir_id", &r->dir_id);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "path", r->path);
		ndr->flags = _flags_save_string;
	}
	ndr_print_uint32(ndr, "path_len", r->path_len);
	ndr_print_pointer(ndr, "private_data", r->private_data);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_notify_entry_array(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct notify_entry_array *r)
{
	uint32_t cntr_entries_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_entries));
		for (cntr_entries_0 = 0; cntr_entries_0 < (r->num_entries); cntr_entries_0++) {
			NDR_CHECK(ndr_push_notify_entry(ndr, NDR_SCALARS, &r->entries[cntr_entries_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_notify_entry_array(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct notify_entry_array *r)
{
	uint32_t size_entries_0 = 0;
	uint32_t cntr_entries_0;
	TALLOC_CTX *_mem_save_entries_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_entries));
		size_entries_0 = r->num_entries;
		NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_0);
		_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
		for (cntr_entries_0 = 0; cntr_entries_0 < (size_entries_0); cntr_entries_0++) {
			NDR_CHECK(ndr_pull_notify_entry(ndr, NDR_SCALARS, &r->entries[cntr_entries_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_notify_entry_array(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct notify_entry_array *r)
{
	ndr_print_notify_entry_array(ndr, name, r);
}

_PUBLIC_ void ndr_print_notify_entry_array(struct ndr_print *ndr, const char *name, const struct notify_entry_array *r)
{
	uint32_t cntr_entries_0;
	ndr_print_struct(ndr, name, "notify_entry_array");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_entries", r->num_entries);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "entries", (uint32_t)(r->num_entries));
	ndr->depth++;
	for (cntr_entries_0 = 0; cntr_entries_0 < (r->num_entries); cntr_entries_0++) {
		ndr_print_notify_entry(ndr, "entries", &r->entries[cntr_entries_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_notify_db_entry(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct notify_db_entry *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_server_id(ndr, NDR_SCALARS, &r->server));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->filter));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->subdir_filter));
		NDR_CHECK(ndr_push_pointer(ndr, NDR_SCALARS, r->private_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_notify_db_entry(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct notify_db_entry *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_server_id(ndr, NDR_SCALARS, &r->server));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->filter));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->subdir_filter));
		NDR_CHECK(ndr_pull_pointer(ndr, NDR_SCALARS, &r->private_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_notify_db_entry(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct notify_db_entry *r)
{
	ndr_print_notify_db_entry(ndr, name, r);
}

_PUBLIC_ void ndr_print_notify_db_entry(struct ndr_print *ndr, const char *name, const struct notify_db_entry *r)
{
	ndr_print_struct(ndr, name, "notify_db_entry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_server_id(ndr, "server", &r->server);
	ndr_print_uint32(ndr, "filter", r->filter);
	ndr_print_uint32(ndr, "subdir_filter", r->subdir_filter);
	ndr_print_pointer(ndr, "private_data", r->private_data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_notify_depth(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct notify_depth *r)
{
	uint32_t cntr_entries_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_mask));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->max_mask_subdir));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_entries));
		for (cntr_entries_0 = 0; cntr_entries_0 < (r->num_entries); cntr_entries_0++) {
			NDR_CHECK(ndr_push_notify_entry(ndr, NDR_SCALARS, &r->entries[cntr_entries_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_notify_depth(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct notify_depth *r)
{
	uint32_t size_entries_0 = 0;
	uint32_t cntr_entries_0;
	TALLOC_CTX *_mem_save_entries_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_mask));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->max_mask_subdir));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_entries));
		size_entries_0 = r->num_entries;
		NDR_PULL_ALLOC_N(ndr, r->entries, size_entries_0);
		_mem_save_entries_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->entries, 0);
		for (cntr_entries_0 = 0; cntr_entries_0 < (size_entries_0); cntr_entries_0++) {
			NDR_CHECK(ndr_pull_notify_entry(ndr, NDR_SCALARS, &r->entries[cntr_entries_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_entries_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_notify_depth(struct ndr_print *ndr, const char *name, const struct notify_depth *r)
{
	uint32_t cntr_entries_0;
	ndr_print_struct(ndr, name, "notify_depth");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "max_mask", r->max_mask);
	ndr_print_uint32(ndr, "max_mask_subdir", r->max_mask_subdir);
	ndr_print_uint32(ndr, "num_entries", r->num_entries);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "entries", (uint32_t)(r->num_entries));
	ndr->depth++;
	for (cntr_entries_0 = 0; cntr_entries_0 < (r->num_entries); cntr_entries_0++) {
		ndr_print_notify_entry(ndr, "entries", &r->entries[cntr_entries_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_notify_array(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct notify_array *r)
{
	uint32_t cntr_depth_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_depths));
		for (cntr_depth_0 = 0; cntr_depth_0 < (r->num_depths); cntr_depth_0++) {
			NDR_CHECK(ndr_push_notify_depth(ndr, NDR_SCALARS, &r->depth[cntr_depth_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_notify_array(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct notify_array *r)
{
	uint32_t size_depth_0 = 0;
	uint32_t cntr_depth_0;
	TALLOC_CTX *_mem_save_depth_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_depths));
		size_depth_0 = r->num_depths;
		NDR_PULL_ALLOC_N(ndr, r->depth, size_depth_0);
		_mem_save_depth_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->depth, 0);
		for (cntr_depth_0 = 0; cntr_depth_0 < (size_depth_0); cntr_depth_0++) {
			NDR_CHECK(ndr_pull_notify_depth(ndr, NDR_SCALARS, &r->depth[cntr_depth_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_depth_0, 0);
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_notify_array(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct notify_array *r)
{
	ndr_print_notify_array(ndr, name, r);
}

_PUBLIC_ void ndr_print_notify_array(struct ndr_print *ndr, const char *name, const struct notify_array *r)
{
	uint32_t cntr_depth_0;
	ndr_print_struct(ndr, name, "notify_array");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "num_depths", r->num_depths);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "depth", (uint32_t)(r->num_depths));
	ndr->depth++;
	for (cntr_depth_0 = 0; cntr_depth_0 < (r->num_depths); cntr_depth_0++) {
		ndr_print_notify_depth(ndr, "depth", &r->depth[cntr_depth_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_notify_event(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct notify_event *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->action));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->dir));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->path));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_pointer(ndr, NDR_SCALARS, r->private_data));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_notify_event(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct notify_event *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->action));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->dir));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->path));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_pointer(ndr, NDR_SCALARS, &r->private_data));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_notify_event(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct notify_event *r)
{
	ndr_print_notify_event(ndr, name, r);
}

_PUBLIC_ void ndr_print_notify_event(struct ndr_print *ndr, const char *name, const struct notify_event *r)
{
	ndr_print_struct(ndr, name, "notify_event");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "action", r->action);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "dir", r->dir);
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_string(ndr, "path", r->path);
		ndr->flags = _flags_save_string;
	}
	ndr_print_pointer(ndr, "private_data", r->private_data);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FILE_NOTIFY_ACTION(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum FILE_NOTIFY_ACTION r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FILE_NOTIFY_ACTION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum FILE_NOTIFY_ACTION *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FILE_NOTIFY_ACTION(struct ndr_print *ndr, const char *name, enum FILE_NOTIFY_ACTION r)
{
	const char *val = NULL;

	switch (r) {
		case FILE_ACTION_ADDED: val = "FILE_ACTION_ADDED"; break;
		case FILE_ACTION_REMOVED: val = "FILE_ACTION_REMOVED"; break;
		case FILE_ACTION_MODIFIED: val = "FILE_ACTION_MODIFIED"; break;
		case FILE_ACTION_RENAMED_OLD_NAME: val = "FILE_ACTION_RENAMED_OLD_NAME"; break;
		case FILE_ACTION_RENAMED_NEW_NAME: val = "FILE_ACTION_RENAMED_NEW_NAME"; break;
		case FILE_ACTION_ADDED_STREAM: val = "FILE_ACTION_ADDED_STREAM"; break;
		case FILE_ACTION_REMOVED_STREAM: val = "FILE_ACTION_REMOVED_STREAM"; break;
		case FILE_ACTION_MODIFIED_STREAM: val = "FILE_ACTION_MODIFIED_STREAM"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_FILE_NOTIFY_INFORMATION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct FILE_NOTIFY_INFORMATION *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->NextEntryOffset));
			NDR_CHECK(ndr_push_FILE_NOTIFY_ACTION(ndr, NDR_SCALARS, r->Action));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m(r->FileName1) * 2));
			{
				libndr_flags _flags_save_uint16 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM);
				NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->FileName1, strlen_m(r->FileName1), sizeof(uint16_t), CH_UTF16));
				ndr->flags = _flags_save_uint16;
			}
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->_pad));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_FILE_NOTIFY_INFORMATION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct FILE_NOTIFY_INFORMATION *r)
{
	uint32_t size_FileName1_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->NextEntryOffset));
			NDR_CHECK(ndr_pull_FILE_NOTIFY_ACTION(ndr, NDR_SCALARS, &r->Action));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->FileNameLength));
			{
				libndr_flags _flags_save_uint16 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM);
				size_FileName1_0 = strlen_m(r->FileName1);
				NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->FileName1, size_FileName1_0, sizeof(uint16_t), CH_UTF16));
				ndr->flags = _flags_save_uint16;
			}
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->_pad));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_FILE_NOTIFY_INFORMATION(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct FILE_NOTIFY_INFORMATION *r)
{
	ndr_print_FILE_NOTIFY_INFORMATION(ndr, name, r);
}

_PUBLIC_ void ndr_print_FILE_NOTIFY_INFORMATION(struct ndr_print *ndr, const char *name, const struct FILE_NOTIFY_INFORMATION *r)
{
	ndr_print_struct(ndr, name, "FILE_NOTIFY_INFORMATION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN4);
		ndr->depth++;
		ndr_print_uint32(ndr, "NextEntryOffset", r->NextEntryOffset);
		ndr_print_FILE_NOTIFY_ACTION(ndr, "Action", r->Action);
		ndr_print_uint32(ndr, "FileNameLength", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m(r->FileName1) * 2:r->FileNameLength);
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM);
			ndr_print_string(ndr, "FileName1", r->FileName1);
			ndr->flags = _flags_save_uint16;
		}
		ndr_print_DATA_BLOB(ndr, "_pad", r->_pad);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ size_t ndr_size_FILE_NOTIFY_INFORMATION(const struct FILE_NOTIFY_INFORMATION *r, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_ALIGN4;
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_FILE_NOTIFY_INFORMATION);
}

#ifndef SKIP_NDR_TABLE_notify
static const struct ndr_interface_public_struct notify_public_structs[] = {
	{
		.name = "notify_entry",
		.struct_size = sizeof(struct notify_entry ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_notify_entry,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_notify_entry,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_notify_entry,
	},
	{
		.name = "notify_entry_array",
		.struct_size = sizeof(struct notify_entry_array ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_notify_entry_array,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_notify_entry_array,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_notify_entry_array,
	},
	{
		.name = "notify_db_entry",
		.struct_size = sizeof(struct notify_db_entry ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_notify_db_entry,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_notify_db_entry,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_notify_db_entry,
	},
	{
		.name = "notify_array",
		.struct_size = sizeof(struct notify_array ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_notify_array,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_notify_array,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_notify_array,
	},
	{
		.name = "notify_event",
		.struct_size = sizeof(struct notify_event ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_notify_event,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_notify_event,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_notify_event,
	},
	{
		.name = "FILE_NOTIFY_INFORMATION",
		.struct_size = sizeof(struct FILE_NOTIFY_INFORMATION ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_FILE_NOTIFY_INFORMATION,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_FILE_NOTIFY_INFORMATION,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_FILE_NOTIFY_INFORMATION,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call notify_calls[] = {
	{ .name = NULL }
};

static const char * const notify_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\notify]", 
};

static const struct ndr_interface_string_array notify_endpoints = {
	.count	= 1,
	.names	= notify_endpoint_strings
};

static const char * const notify_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array notify_authservices = {
	.count	= 1,
	.names	= notify_authservice_strings
};


const struct ndr_interface_table ndr_table_notify = {
	.name		= "notify",
	.num_calls	= 0,
	.calls		= notify_calls,
	.num_public_structs	= 6,
	.public_structs		= notify_public_structs,
	.endpoints	= &notify_endpoints,
	.authservices	= &notify_authservices
};

#endif /* SKIP_NDR_TABLE_notify */
