/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_winbind
#define _PIDL_HEADER_winbind

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/samr.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/idmap.h"
#ifndef _HEADER_winbind
#define _HEADER_winbind

struct wbint_TransID {
	enum id_type type_hint;
	uint32_t domain_index;
	uint32_t rid;
	struct unixid xid;
};

struct wbint_TransIDArray {
	uint32_t num_ids;
	struct wbint_TransID *ids;/* [size_is(num_ids)] */
};

struct wbint_userinfo {
	const char *domain_name;/* [charset(UTF8),unique] */
	const char *acct_name;/* [charset(UTF8),unique] */
	const char *full_name;/* [charset(UTF8),unique] */
	const char *homedir;/* [charset(UTF8),unique] */
	const char *shell;/* [charset(UTF8),unique] */
	uint64_t uid;
	uint64_t primary_gid;
	const char *primary_group_name;/* [charset(UTF8),unique] */
	struct dom_sid user_sid;
	struct dom_sid group_sid;
}/* [public] */;

struct wbint_SidArray {
	uint32_t num_sids;
	struct dom_sid *sids;/* [size_is(num_sids)] */
}/* [public] */;

struct wbint_RidArray {
	uint32_t num_rids;
	uint32_t *rids;/* [size_is(num_rids)] */
}/* [public] */;

struct wbint_Principal {
	struct dom_sid sid;
	enum lsa_SidType type;
	const char *name;/* [charset(UTF8),unique] */
}/* [public] */;

struct wbint_Principals {
	uint32_t num_principals;
	struct wbint_Principal *principals;/* [size_is(num_principals)] */
}/* [public] */;

struct wbint_userinfos {
	uint32_t num_userinfos;
	struct wbint_userinfo *userinfos;/* [size_is(num_userinfos)] */
}/* [public] */;

struct wbint_Validation {
	uint16_t level;
	union netr_Validation *validation;/* [switch_is(level),unique] */
	const char *krb5ccname;/* [charset(UTF8),unique] */
}/* [public] */;

struct wbint_AuthUserInfo {
	const char *username;/* [charset(UTF8),unique] */
	const char *password;/* [charset(UTF8),flag(LIBNDR_FLAG_IS_SECRET),unique] */
	const char *krb5_cc_type;/* [charset(UTF8),unique] */
	uint64_t uid;
}/* [public] */;

struct wbint_PamAuthCrapValidation {
	uint16_t level;
	union netr_Validation *validation;/* [switch_is(level),unique] */
}/* [public] */;

enum DomainInfoFlags
#ifndef USE_UINT_ENUMS
 {
	WB_DOMINFO_DOMAIN_UNKNOWN=(int)(0x0000),
	WB_DOMINFO_DOMAIN_NATIVE=(int)(0x0001),
	WB_DOMINFO_DOMAIN_AD=(int)(0x0002),
	WB_DOMINFO_DOMAIN_PRIMARY=(int)(0x0004),
	WB_DOMINFO_DOMAIN_OFFLINE=(int)(0x0008)
}
#else
 { __do_not_use_enum_DomainInfoFlags=INT_MAX}
#define WB_DOMINFO_DOMAIN_UNKNOWN ( 0x0000 )
#define WB_DOMINFO_DOMAIN_NATIVE ( 0x0001 )
#define WB_DOMINFO_DOMAIN_AD ( 0x0002 )
#define WB_DOMINFO_DOMAIN_PRIMARY ( 0x0004 )
#define WB_DOMINFO_DOMAIN_OFFLINE ( 0x0008 )
#endif
;

union netr_LogonLevel;

union netr_Validation;

enum winbind_SamLogonInternalFlags
#ifndef USE_UINT_ENUMS
 {
	WB_SAMLOGON_FOR_NETLOGON=(int)(0x0001)
}
#else
 { __do_not_use_enum_winbind_SamLogonInternalFlags=INT_MAX}
#define WB_SAMLOGON_FOR_NETLOGON ( 0x0001 )
#endif
;

union netr_CONTROL_DATA_INFORMATION;

union netr_CONTROL_QUERY_INFORMATION;


struct wbint_Ping {
	struct {
		uint32_t in_data;
	} in;

	struct {
		uint32_t *out_data;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupSid {
	struct {
		struct dom_sid *sid;/* [ref] */
	} in;

	struct {
		enum lsa_SidType *type;/* [ref] */
		const char **domain;/* [charset(UTF8),ref] */
		const char **name;/* [charset(UTF8),ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupSids {
	struct {
		struct lsa_SidArray *sids;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [ref] */
		struct lsa_TransNameArray *names;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupName {
	struct {
		const char *domain;/* [charset(UTF8),ref] */
		const char *name;/* [charset(UTF8),ref] */
		uint32_t flags;
	} in;

	struct {
		enum lsa_SidType *type;/* [ref] */
		struct dom_sid *sid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_Sids2UnixIDs {
	struct {
		struct lsa_RefDomainList *domains;/* [ref] */
		struct wbint_TransIDArray *ids;/* [ref] */
	} in;

	struct {
		struct wbint_TransIDArray *ids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_UnixIDs2Sids {
	struct {
		const char *domain_name;/* [charset(UTF8),ref] */
		struct dom_sid domain_sid;
		uint32_t num_ids;
		struct unixid *xids;
	} in;

	struct {
		struct dom_sid *sids;
		struct unixid *xids;
		NTSTATUS result;
	} out;

};


struct wbint_AllocateUid {
	struct {
		uint64_t *uid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_AllocateGid {
	struct {
		uint64_t *gid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_GetNssInfo {
	struct {
		struct wbint_userinfo *info;/* [ref] */
	} in;

	struct {
		struct wbint_userinfo *info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupUserAliases {
	struct {
		struct wbint_SidArray *sids;/* [ref] */
	} in;

	struct {
		struct wbint_RidArray *rids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupUserGroups {
	struct {
		struct dom_sid *sid;/* [ref] */
	} in;

	struct {
		struct wbint_SidArray *sids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_QuerySequenceNumber {
	struct {
		uint32_t *sequence;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupGroupMembers {
	struct {
		struct dom_sid *sid;/* [ref] */
		enum lsa_SidType type;
	} in;

	struct {
		struct wbint_Principals *members;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupAliasMembers {
	struct {
		struct dom_sid *sid;/* [ref] */
		enum lsa_SidType type;
	} in;

	struct {
		struct wbint_SidArray *sids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_QueryGroupList {
	struct {
		struct wbint_Principals *groups;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_QueryUserRidList {
	struct {
		struct wbint_RidArray *rids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_DsGetDcName {
	struct {
		const char *domain_name;/* [charset(UTF8),ref] */
		struct GUID *domain_guid;/* [unique] */
		const char *site_name;/* [charset(UTF8),unique] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **dc_info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupRids {
	struct {
		struct dom_sid *domain_sid;/* [ref] */
		struct wbint_RidArray *rids;/* [ref] */
	} in;

	struct {
		const char **domain_name;/* [charset(UTF8),ref] */
		struct wbint_Principals *names;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_CheckMachineAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct wbint_ChangeMachineAccount {
	struct {
		const char *dcname;/* [charset(UTF8),unique] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct wbint_PingDc {
	struct {
		const char **dcname;/* [charset(UTF8),ref] */
		NTSTATUS result;
	} out;

};


struct wbint_ListTrustedDomains {
	struct {
		const char *client_name;/* [charset(UTF8),ref] */
		uint64_t client_pid;
	} in;

	struct {
		struct netr_DomainTrustList *domains;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_PamAuth {
	struct {
		const char *client_name;/* [charset(UTF8),ref] */
		uint64_t client_pid;
		uint32_t flags;
		struct wbint_AuthUserInfo *info;/* [ref] */
		struct wbint_SidArray *require_membership_of_sid;/* [ref] */
	} in;

	struct {
		struct wbint_Validation *validation;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_PamAuthCrap {
	struct {
		const char *client_name;/* [charset(UTF8),ref] */
		uint64_t client_pid;
		uint32_t flags;
		const char *user;/* [charset(UTF8),ref] */
		const char *domain;/* [charset(UTF8),ref] */
		const char *workstation;/* [charset(UTF8),ref] */
		DATA_BLOB lm_resp;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
		DATA_BLOB nt_resp;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
		DATA_BLOB chal;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
		uint32_t logon_parameters;
		struct wbint_SidArray *require_membership_of_sid;/* [ref] */
	} in;

	struct {
		uint8_t *authoritative;/* [ref] */
		struct wbint_PamAuthCrapValidation *validation;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_PamLogOff {
	struct {
		const char *client_name;/* [charset(UTF8),ref] */
		uint64_t client_pid;
		uint32_t flags;
		const char *user;/* [charset(UTF8),ref] */
		const char *krb5ccname;/* [charset(UTF8),ref] */
		uint64_t uid;
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct wbint_PamAuthCrapChangePassword {
	struct {
		const char *client_name;/* [charset(UTF8),ref] */
		uint64_t client_pid;
		const char *user;/* [charset(UTF8),ref] */
		const char *domain;/* [charset(UTF8),ref] */
		DATA_BLOB new_nt_pswd;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
		DATA_BLOB old_nt_hash_enc;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
		DATA_BLOB new_lm_pswd;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
		DATA_BLOB old_lm_hash_enc;/* [flag(LIBNDR_FLAG_IS_SECRET)] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct wbint_PamAuthChangePassword {
	struct {
		const char *client_name;/* [charset(UTF8),ref] */
		uint64_t client_pid;
		uint32_t flags;
		const char *user;/* [charset(UTF8),ref] */
		const char *old_password;/* [charset(UTF8),flag(LIBNDR_FLAG_IS_SECRET),ref] */
		const char *new_password;/* [charset(UTF8),flag(LIBNDR_FLAG_IS_SECRET),ref] */
	} in;

	struct {
		struct samr_DomInfo1 **dominfo;/* [ref] */
		enum samPwdChangeReason *reject_reason;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_InitConnection {
	struct {
		const char *dcname;/* [charset(UTF8),ref] */
	} in;

	struct {
		const char **name;/* [charset(UTF8),ref] */
		const char **alt_name;/* [charset(UTF8),ref] */
		struct dom_sid *sid;/* [ref] */
		enum DomainInfoFlags *flags;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_NormalizeNameMap {
	struct {
		const char *domain_name;/* [charset(UTF8),ref] */
		const char *name;/* [charset(UTF8),ref] */
	} in;

	struct {
		const char **mapped_name;/* [charset(UTF8),ref] */
		NTSTATUS result;
	} out;

};


struct wbint_NormalizeNameUnmap {
	struct {
		const char *name;/* [charset(UTF8),ref] */
	} in;

	struct {
		const char **unmapped_name;/* [charset(UTF8),ref] */
		NTSTATUS result;
	} out;

};


struct winbind_SamLogon {
	struct {
		enum winbind_SamLogonInternalFlags internal_flags;
		uint16_t logon_level;
		union netr_LogonLevel logon;/* [switch_is(logon_level)] */
		uint16_t validation_level;
	} in;

	struct {
		union netr_Validation validation;/* [switch_is(validation_level)] */
		uint8_t authoritative;
		NTSTATUS result;
	} out;

};


struct winbind_DsrUpdateReadOnlyServerDnsRecords {
	struct {
		const char *site_name;/* [charset(UTF16),unique] */
		uint32_t dns_ttl;
		struct NL_DNS_NAME_INFO_ARRAY *dns_names;/* [ref] */
	} in;

	struct {
		struct NL_DNS_NAME_INFO_ARRAY *dns_names;/* [ref] */
		NTSTATUS result;
	} out;

};


struct winbind_LogonControl {
	struct {
		enum netr_LogonControlCode function_code;
		uint32_t level;
		union netr_CONTROL_DATA_INFORMATION *data;/* [ref,switch_is(function_code)] */
	} in;

	struct {
		union netr_CONTROL_QUERY_INFORMATION *query;/* [ref,switch_is(level)] */
		WERROR result;
	} out;

};


struct winbind_GetForestTrustInformation {
	struct {
		const char *trusted_domain_name;/* [charset(UTF16),unique] */
		uint32_t flags;
	} in;

	struct {
		struct lsa_ForestTrustInformation **forest_trust_info;/* [ref] */
		WERROR result;
	} out;

};


struct winbind_SendToSam {
	struct {
		struct netr_SendToSamBase message;
	} in;

	struct {
		NTSTATUS result;
	} out;

};

#endif /* _HEADER_winbind */
#endif /* _PIDL_HEADER_winbind */
