/* MediaInterfaces.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MediaInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* Going forward, Shotwell will use MediaInterfaces, which allow for various operations and features*/
/* to be added only to the MediaSources that support them (or make sense for).  For example, adding*/
/* a library-mode photo or video to an Event makes perfect sense, but does not make sense for a*/
/* direct-mode photo.  All three are MediaSources, and to make DirectPhoto descend from another*/
/* base class is only inviting chaos and a tremendous amount of replicated code.*/
/**/
/* A key point to make of all MediaInterfaces is that they require MediaSource as a base class.*/
/* Thus, any code dealing with one of these interfaces knows they are also dealing with a*/
/* MediaSource.*/
/**/
/* TODO: Make Eventable and Taggable interfaces, which are the only types Event and Tag will deal*/
/* with (rather than MediaSources).*/
/**/
/* TODO: Make Trashable interface, which are much like Flaggable.*/
/**/
/* TODO: ContainerSources may also have specific needs in the future; an interface-based system*/
/* may make sense as well when that need arises.*/
/**/
/**/
/* TransactionController*/
/**/
/* Because many operations in Shotwell need to be performed on collections of objects all at once,*/
/* and that most of these objects are backed by a database, the TransactionController object gives */
/* a way to generically group a series of operations on one or more similar objects into a single*/
/* transaction. This class is listed here because it's used by the various media interfaces to offer*/
/* multiple operations.*/
/**/
/* begin() and commit() may be called multiple times in layering fashion.  The implementation*/
/* accounts for this.  If either throws an exception it should be assumed that the object is in*/
/* a "clean" state; that is, if begin() throws an exception, there is no need to call commit(),*/
/* and if commit() throws an exception, it does not need to be called again to revert the object*/
/* state.*/
/**/
/* This means that any user who calls begin() *must* match it with a corresponding commit(), even*/
/* if there is an error during the transaction.  It is up to the user to back out any undesired*/
/* changes.*/
/**/
/* Because of the nature of this object, it's assumed that every object type will share one*/
/* between all callers.*/
/**/
/* The object is thread-safe.  There is no guarantee that the underlying persistent store is,*/
/* however.*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
typedef struct _TransactionControllerPrivate TransactionControllerPrivate;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecTransactionController ParamSpecTransactionController;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TransactionController {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TransactionControllerPrivate * priv;
};

struct _TransactionControllerClass {
	GTypeClass parent_class;
	void (*finalize) (TransactionController *self);
	void (*begin_impl) (TransactionController* self, GError** error);
	void (*commit_impl) (TransactionController* self, GError** error);
};

struct _TransactionControllerPrivate {
	gint count;
	GRecMutex __lock_count;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _ParamSpecTransactionController {
	GParamSpec parent_instance;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, GDateTime* target_time);
	GDateTime* (*get_exposure_time) (Dateable* self);
};

static gint TransactionController_private_offset;
static gpointer transaction_controller_parent_class = NULL;

VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN void transaction_controller_begin_impl (TransactionController* self,
                                        GError** error);
VALA_EXTERN void transaction_controller_commit_impl (TransactionController* self,
                                         GError** error);
VALA_EXTERN void transaction_controller_begin (TransactionController* self);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN void app_window_panic (const gchar* msg);
static void transaction_controller_real_begin_impl (TransactionController* self,
                                             GError** error);
VALA_EXTERN void transaction_controller_commit (TransactionController* self);
static void transaction_controller_real_commit_impl (TransactionController* self,
                                              GError** error);
VALA_EXTERN TransactionController* transaction_controller_construct (GType object_type);
static void transaction_controller_finalize (TransactionController * obj);
static GType transaction_controller_get_type_once (void);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType flaggable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Flaggable, g_object_unref)
VALA_EXTERN gboolean flaggable_is_flagged (Flaggable* self);
VALA_EXTERN void flaggable_mark_flagged (Flaggable* self);
VALA_EXTERN void flaggable_mark_unflagged (Flaggable* self);
VALA_EXTERN void flaggable_mark_many_flagged_unflagged (GeeCollection* flag,
                                            GeeCollection* unflag,
                                            TransactionController* controller,
                                            GError** error);
static GType flaggable_get_type_once (void);
VALA_EXTERN GType monitorable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitorable, g_object_unref)
VALA_EXTERN gboolean monitorable_is_offline (Monitorable* self);
VALA_EXTERN void monitorable_mark_online (Monitorable* self);
VALA_EXTERN void monitorable_mark_offline (Monitorable* self);
VALA_EXTERN void monitorable_mark_many_online_offline (GeeCollection* online,
                                           GeeCollection* offline,
                                           TransactionController* controller,
                                           GError** error);
VALA_EXTERN void monitorable_set_master_file (Monitorable* self,
                                  GFile* file);
VALA_EXTERN void monitorable_set_many_master_file (GeeMap* map,
                                       TransactionController* controller,
                                       GError** error);
VALA_EXTERN void monitorable_set_master_timestamp (Monitorable* self,
                                       GFileInfo* info);
VALA_EXTERN void monitorable_set_many_master_timestamp (GeeMap* map,
                                            TransactionController* controller,
                                            GError** error);
static GType monitorable_get_type_once (void);
VALA_EXTERN GType dateable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Dateable, g_object_unref)
VALA_EXTERN void dateable_set_exposure_time (Dateable* self,
                                 GDateTime* target_time);
VALA_EXTERN GDateTime* dateable_get_exposure_time (Dateable* self);
static GType dateable_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
transaction_controller_get_instance_private (TransactionController* self)
{
	return G_STRUCT_MEMBER_P (self, TransactionController_private_offset);
}

void
transaction_controller_begin (TransactionController* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
	{
		g_rec_mutex_lock (&self->priv->__lock_count);
		{
			gint _tmp0_;
			_tmp0_ = self->priv->count;
			self->priv->count = _tmp0_ + 1;
			if (_tmp0_ != 0) {
				{
					g_rec_mutex_unlock (&self->priv->__lock_count);
				}
				return;
			}
			{
				transaction_controller_begin_impl (self, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* err = NULL;
				gint _tmp1_;
				GError* _tmp2_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp1_ = self->priv->count;
				self->priv->count = _tmp1_ - 1;
				_tmp2_ = err;
				if (_tmp2_->domain == DATABASE_ERROR) {
					GError* _tmp3_;
					_tmp3_ = err;
					app_window_database_error ((GError*) _tmp3_);
				} else {
					GError* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp4_ = err;
					_tmp5_ = _tmp4_->message;
					_tmp6_ = g_strdup_printf ("%s", _tmp5_);
					_tmp7_ = _tmp6_;
					app_window_panic (_tmp7_);
					_g_free0 (_tmp7_);
				}
				_g_error_free0 (err);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_count);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
transaction_controller_real_begin_impl (TransactionController* self,
                                        GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `transaction_controller_begin_impl'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
transaction_controller_begin_impl (TransactionController* self,
                                   GError** error)
{
	TransactionControllerClass* _klass_;
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
	_klass_ = TRANSACTION_CONTROLLER_GET_CLASS (self);
	if (_klass_->begin_impl) {
		_klass_->begin_impl (self, error);
	}
}

void
transaction_controller_commit (TransactionController* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
	{
		g_rec_mutex_lock (&self->priv->__lock_count);
		{
			gint _tmp0_;
			_vala_assert (self->priv->count > 0, "count > 0");
			self->priv->count = self->priv->count - 1;
			_tmp0_ = self->priv->count;
			if (_tmp0_ != 0) {
				{
					g_rec_mutex_unlock (&self->priv->__lock_count);
				}
				return;
			}
			{
				transaction_controller_commit_impl (self, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* err = NULL;
				GError* _tmp1_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp1_ = err;
				if (_tmp1_->domain == DATABASE_ERROR) {
					GError* _tmp2_;
					_tmp2_ = err;
					app_window_database_error ((GError*) _tmp2_);
				} else {
					GError* _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp3_ = err;
					_tmp4_ = _tmp3_->message;
					_tmp5_ = g_strdup_printf ("%s", _tmp4_);
					_tmp6_ = _tmp5_;
					app_window_panic (_tmp6_);
					_g_free0 (_tmp6_);
				}
				_g_error_free0 (err);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_count);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
transaction_controller_real_commit_impl (TransactionController* self,
                                         GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `transaction_controller_commit_impl'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
transaction_controller_commit_impl (TransactionController* self,
                                    GError** error)
{
	TransactionControllerClass* _klass_;
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (self));
	_klass_ = TRANSACTION_CONTROLLER_GET_CLASS (self);
	if (_klass_->commit_impl) {
		_klass_->commit_impl (self, error);
	}
}

TransactionController*
transaction_controller_construct (GType object_type)
{
	TransactionController* self = NULL;
	self = (TransactionController*) g_type_create_instance (object_type);
	return self;
}

static void
value_transaction_controller_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_transaction_controller_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		transaction_controller_unref (value->data[0].v_pointer);
	}
}

static void
value_transaction_controller_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = transaction_controller_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_transaction_controller_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_transaction_controller_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TransactionController * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = transaction_controller_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_transaction_controller_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	TransactionController ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = transaction_controller_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_transaction_controller (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	ParamSpecTransactionController* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TRANSACTION_CONTROLLER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_transaction_controller (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRANSACTION_CONTROLLER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_transaction_controller (GValue* value,
                                  gpointer v_object)
{
	TransactionController * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRANSACTION_CONTROLLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRANSACTION_CONTROLLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		transaction_controller_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		transaction_controller_unref (old);
	}
}

void
value_take_transaction_controller (GValue* value,
                                   gpointer v_object)
{
	TransactionController * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRANSACTION_CONTROLLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRANSACTION_CONTROLLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		transaction_controller_unref (old);
	}
}

static void
transaction_controller_class_init (TransactionControllerClass * klass,
                                   gpointer klass_data)
{
	transaction_controller_parent_class = g_type_class_peek_parent (klass);
	((TransactionControllerClass *) klass)->finalize = transaction_controller_finalize;
	g_type_class_adjust_private_offset (klass, &TransactionController_private_offset);
	((TransactionControllerClass *) klass)->begin_impl = (void (*) (TransactionController*, GError**)) transaction_controller_real_begin_impl;
	((TransactionControllerClass *) klass)->commit_impl = (void (*) (TransactionController*, GError**)) transaction_controller_real_commit_impl;
}

static void
transaction_controller_instance_init (TransactionController * self,
                                      gpointer klass)
{
	self->priv = transaction_controller_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_count);
	self->priv->count = 0;
	self->ref_count = 1;
}

static void
transaction_controller_finalize (TransactionController * obj)
{
	TransactionController * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRANSACTION_CONTROLLER, TransactionController);
	g_signal_handlers_destroy (self);
	{
		g_rec_mutex_lock (&self->priv->__lock_count);
		{
			_vala_assert (self->priv->count == 0, "count == 0");
		}
		__finally0:
		{
			g_rec_mutex_unlock (&self->priv->__lock_count);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
	}
	g_rec_mutex_clear (&self->priv->__lock_count);
}

static GType
transaction_controller_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_transaction_controller_init, value_transaction_controller_free_value, value_transaction_controller_copy_value, value_transaction_controller_peek_pointer, "p", value_transaction_controller_collect_value, "p", value_transaction_controller_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TransactionControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) transaction_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TransactionController), 0, (GInstanceInitFunc) transaction_controller_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType transaction_controller_type_id;
	transaction_controller_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TransactionController", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	TransactionController_private_offset = g_type_add_instance_private (transaction_controller_type_id, sizeof (TransactionControllerPrivate));
	return transaction_controller_type_id;
}

GType
transaction_controller_get_type (void)
{
	static volatile gsize transaction_controller_type_id__once = 0;
	if (g_once_init_enter (&transaction_controller_type_id__once)) {
		GType transaction_controller_type_id;
		transaction_controller_type_id = transaction_controller_get_type_once ();
		g_once_init_leave (&transaction_controller_type_id__once, transaction_controller_type_id);
	}
	return transaction_controller_type_id__once;
}

gpointer
transaction_controller_ref (gpointer instance)
{
	TransactionController * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
transaction_controller_unref (gpointer instance)
{
	TransactionController * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRANSACTION_CONTROLLER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gboolean
flaggable_is_flagged (Flaggable* self)
{
	FlaggableIface* _iface_;
	g_return_val_if_fail (IS_FLAGGABLE (self), FALSE);
	_iface_ = FLAGGABLE_GET_INTERFACE (self);
	if (_iface_->is_flagged) {
		return _iface_->is_flagged (self);
	}
	return FALSE;
}

void
flaggable_mark_flagged (Flaggable* self)
{
	FlaggableIface* _iface_;
	g_return_if_fail (IS_FLAGGABLE (self));
	_iface_ = FLAGGABLE_GET_INTERFACE (self);
	if (_iface_->mark_flagged) {
		_iface_->mark_flagged (self);
	}
}

void
flaggable_mark_unflagged (Flaggable* self)
{
	FlaggableIface* _iface_;
	g_return_if_fail (IS_FLAGGABLE (self));
	_iface_ = FLAGGABLE_GET_INTERFACE (self);
	if (_iface_->mark_unflagged) {
		_iface_->mark_unflagged (self);
	}
}

void
flaggable_mark_many_flagged_unflagged (GeeCollection* flag,
                                       GeeCollection* unflag,
                                       TransactionController* controller,
                                       GError** error)
{
	g_return_if_fail ((flag == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (flag, GEE_TYPE_COLLECTION));
	g_return_if_fail ((unflag == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (unflag, GEE_TYPE_COLLECTION));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	transaction_controller_begin (controller);
	if (flag != NULL) {
		{
			GeeIterator* _flaggable_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (flag, GEE_TYPE_ITERABLE, GeeIterable));
			_flaggable_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				Flaggable* flaggable = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Flaggable* _tmp4_;
				_tmp1_ = _flaggable_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _flaggable_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				flaggable = (Flaggable*) _tmp3_;
				_tmp4_ = flaggable;
				flaggable_mark_flagged (_tmp4_);
				_g_object_unref0 (flaggable);
			}
			_g_object_unref0 (_flaggable_it);
		}
	}
	if (unflag != NULL) {
		{
			GeeIterator* _flaggable_it = NULL;
			GeeIterator* _tmp5_;
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (unflag, GEE_TYPE_ITERABLE, GeeIterable));
			_flaggable_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				Flaggable* flaggable = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				Flaggable* _tmp9_;
				_tmp6_ = _flaggable_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _flaggable_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				flaggable = (Flaggable*) _tmp8_;
				_tmp9_ = flaggable;
				flaggable_mark_unflagged (_tmp9_);
				_g_object_unref0 (flaggable);
			}
			_g_object_unref0 (_flaggable_it);
		}
	}
	transaction_controller_commit (controller);
}

static void
flaggable_default_init (FlaggableIface * iface,
                        gpointer iface_data)
{
}

static GType
flaggable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FlaggableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flaggable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType flaggable_type_id;
	flaggable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Flaggable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (flaggable_type_id, TYPE_MEDIA_SOURCE);
	return flaggable_type_id;
}

GType
flaggable_get_type (void)
{
	static volatile gsize flaggable_type_id__once = 0;
	if (g_once_init_enter (&flaggable_type_id__once)) {
		GType flaggable_type_id;
		flaggable_type_id = flaggable_get_type_once ();
		g_once_init_leave (&flaggable_type_id__once, flaggable_type_id);
	}
	return flaggable_type_id__once;
}

gboolean
monitorable_is_offline (Monitorable* self)
{
	MonitorableIface* _iface_;
	g_return_val_if_fail (IS_MONITORABLE (self), FALSE);
	_iface_ = MONITORABLE_GET_INTERFACE (self);
	if (_iface_->is_offline) {
		return _iface_->is_offline (self);
	}
	return FALSE;
}

void
monitorable_mark_online (Monitorable* self)
{
	MonitorableIface* _iface_;
	g_return_if_fail (IS_MONITORABLE (self));
	_iface_ = MONITORABLE_GET_INTERFACE (self);
	if (_iface_->mark_online) {
		_iface_->mark_online (self);
	}
}

void
monitorable_mark_offline (Monitorable* self)
{
	MonitorableIface* _iface_;
	g_return_if_fail (IS_MONITORABLE (self));
	_iface_ = MONITORABLE_GET_INTERFACE (self);
	if (_iface_->mark_offline) {
		_iface_->mark_offline (self);
	}
}

void
monitorable_mark_many_online_offline (GeeCollection* online,
                                      GeeCollection* offline,
                                      TransactionController* controller,
                                      GError** error)
{
	g_return_if_fail ((online == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (online, GEE_TYPE_COLLECTION));
	g_return_if_fail ((offline == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (offline, GEE_TYPE_COLLECTION));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	transaction_controller_begin (controller);
	if (online != NULL) {
		{
			GeeIterator* _monitorable_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (online, GEE_TYPE_ITERABLE, GeeIterable));
			_monitorable_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				Monitorable* monitorable = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Monitorable* _tmp4_;
				_tmp1_ = _monitorable_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _monitorable_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				monitorable = (Monitorable*) _tmp3_;
				_tmp4_ = monitorable;
				monitorable_mark_online (_tmp4_);
				_g_object_unref0 (monitorable);
			}
			_g_object_unref0 (_monitorable_it);
		}
	}
	if (offline != NULL) {
		{
			GeeIterator* _monitorable_it = NULL;
			GeeIterator* _tmp5_;
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (offline, GEE_TYPE_ITERABLE, GeeIterable));
			_monitorable_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				Monitorable* monitorable = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				Monitorable* _tmp9_;
				_tmp6_ = _monitorable_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _monitorable_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				monitorable = (Monitorable*) _tmp8_;
				_tmp9_ = monitorable;
				monitorable_mark_offline (_tmp9_);
				_g_object_unref0 (monitorable);
			}
			_g_object_unref0 (_monitorable_it);
		}
	}
	transaction_controller_commit (controller);
}

void
monitorable_set_master_file (Monitorable* self,
                             GFile* file)
{
	MonitorableIface* _iface_;
	g_return_if_fail (IS_MONITORABLE (self));
	_iface_ = MONITORABLE_GET_INTERFACE (self);
	if (_iface_->set_master_file) {
		_iface_->set_master_file (self, file);
	}
}

void
monitorable_set_many_master_file (GeeMap* map,
                                  TransactionController* controller,
                                  GError** error)
{
	GeeMapIterator* map_iter = NULL;
	GeeMapIterator* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	transaction_controller_begin (controller);
	_tmp0_ = gee_map_map_iterator (map);
	map_iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		Monitorable* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		GFile* _tmp7_;
		_tmp1_ = map_iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = map_iter;
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
		_tmp4_ = (Monitorable*) _tmp3_;
		_tmp5_ = map_iter;
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
		_tmp7_ = (GFile*) _tmp6_;
		monitorable_set_master_file (_tmp4_, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
	}
	transaction_controller_commit (controller);
	_g_object_unref0 (map_iter);
}

void
monitorable_set_master_timestamp (Monitorable* self,
                                  GFileInfo* info)
{
	MonitorableIface* _iface_;
	g_return_if_fail (IS_MONITORABLE (self));
	_iface_ = MONITORABLE_GET_INTERFACE (self);
	if (_iface_->set_master_timestamp) {
		_iface_->set_master_timestamp (self, info);
	}
}

void
monitorable_set_many_master_timestamp (GeeMap* map,
                                       TransactionController* controller,
                                       GError** error)
{
	GeeMapIterator* map_iter = NULL;
	GeeMapIterator* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	transaction_controller_begin (controller);
	_tmp0_ = gee_map_map_iterator (map);
	map_iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		Monitorable* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		GFileInfo* _tmp7_;
		_tmp1_ = map_iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = map_iter;
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
		_tmp4_ = (Monitorable*) _tmp3_;
		_tmp5_ = map_iter;
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
		_tmp7_ = (GFileInfo*) _tmp6_;
		monitorable_set_master_timestamp (_tmp4_, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
	}
	transaction_controller_commit (controller);
	_g_object_unref0 (map_iter);
}

static void
monitorable_default_init (MonitorableIface * iface,
                          gpointer iface_data)
{
}

static GType
monitorable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MonitorableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitorable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType monitorable_type_id;
	monitorable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Monitorable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (monitorable_type_id, TYPE_MEDIA_SOURCE);
	return monitorable_type_id;
}

GType
monitorable_get_type (void)
{
	static volatile gsize monitorable_type_id__once = 0;
	if (g_once_init_enter (&monitorable_type_id__once)) {
		GType monitorable_type_id;
		monitorable_type_id = monitorable_get_type_once ();
		g_once_init_leave (&monitorable_type_id__once, monitorable_type_id);
	}
	return monitorable_type_id__once;
}

void
dateable_set_exposure_time (Dateable* self,
                            GDateTime* target_time)
{
	DateableIface* _iface_;
	g_return_if_fail (IS_DATEABLE (self));
	_iface_ = DATEABLE_GET_INTERFACE (self);
	if (_iface_->set_exposure_time) {
		_iface_->set_exposure_time (self, target_time);
	}
}

GDateTime*
dateable_get_exposure_time (Dateable* self)
{
	DateableIface* _iface_;
	g_return_val_if_fail (IS_DATEABLE (self), NULL);
	_iface_ = DATEABLE_GET_INTERFACE (self);
	if (_iface_->get_exposure_time) {
		return _iface_->get_exposure_time (self);
	}
	return NULL;
}

static void
dateable_default_init (DateableIface * iface,
                       gpointer iface_data)
{
}

static GType
dateable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DateableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dateable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType dateable_type_id;
	dateable_type_id = g_type_register_static (G_TYPE_INTERFACE, "Dateable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (dateable_type_id, TYPE_MEDIA_SOURCE);
	return dateable_type_id;
}

GType
dateable_get_type (void)
{
	static volatile gsize dateable_type_id__once = 0;
	if (g_once_init_enter (&dateable_type_id__once)) {
		GType dateable_type_id;
		dateable_type_id = dateable_get_type_once ();
		g_once_init_leave (&dateable_type_id__once, dateable_type_id);
	}
	return dateable_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

