// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by "deep-copy -type ConfigSpec -type PKIStatusSpec -type SpecSpec -type MemberSpec -header-file ../../../../hack/boilerplate.txt -o deep_copy.generated.go ."; DO NOT EDIT.

package etcd

import (
	"net/netip"
)

// DeepCopy generates a deep copy of ConfigSpec.
func (o ConfigSpec) DeepCopy() ConfigSpec {
	var cp ConfigSpec = o
	if o.AdvertiseValidSubnets != nil {
		cp.AdvertiseValidSubnets = make([]string, len(o.AdvertiseValidSubnets))
		copy(cp.AdvertiseValidSubnets, o.AdvertiseValidSubnets)
	}
	if o.AdvertiseExcludeSubnets != nil {
		cp.AdvertiseExcludeSubnets = make([]string, len(o.AdvertiseExcludeSubnets))
		copy(cp.AdvertiseExcludeSubnets, o.AdvertiseExcludeSubnets)
	}
	if o.ListenValidSubnets != nil {
		cp.ListenValidSubnets = make([]string, len(o.ListenValidSubnets))
		copy(cp.ListenValidSubnets, o.ListenValidSubnets)
	}
	if o.ListenExcludeSubnets != nil {
		cp.ListenExcludeSubnets = make([]string, len(o.ListenExcludeSubnets))
		copy(cp.ListenExcludeSubnets, o.ListenExcludeSubnets)
	}
	if o.ExtraArgs != nil {
		cp.ExtraArgs = make(map[string]string, len(o.ExtraArgs))
		for k2, v2 := range o.ExtraArgs {
			cp.ExtraArgs[k2] = v2
		}
	}
	return cp
}

// DeepCopy generates a deep copy of PKIStatusSpec.
func (o PKIStatusSpec) DeepCopy() PKIStatusSpec {
	var cp PKIStatusSpec = o
	return cp
}

// DeepCopy generates a deep copy of SpecSpec.
func (o SpecSpec) DeepCopy() SpecSpec {
	var cp SpecSpec = o
	if o.AdvertisedAddresses != nil {
		cp.AdvertisedAddresses = make([]netip.Addr, len(o.AdvertisedAddresses))
		copy(cp.AdvertisedAddresses, o.AdvertisedAddresses)
	}
	if o.ListenPeerAddresses != nil {
		cp.ListenPeerAddresses = make([]netip.Addr, len(o.ListenPeerAddresses))
		copy(cp.ListenPeerAddresses, o.ListenPeerAddresses)
	}
	if o.ListenClientAddresses != nil {
		cp.ListenClientAddresses = make([]netip.Addr, len(o.ListenClientAddresses))
		copy(cp.ListenClientAddresses, o.ListenClientAddresses)
	}
	if o.ExtraArgs != nil {
		cp.ExtraArgs = make(map[string]string, len(o.ExtraArgs))
		for k2, v2 := range o.ExtraArgs {
			cp.ExtraArgs[k2] = v2
		}
	}
	return cp
}

// DeepCopy generates a deep copy of MemberSpec.
func (o MemberSpec) DeepCopy() MemberSpec {
	var cp MemberSpec = o
	return cp
}
