#pragma once
/*
 * Copyright 2010-2020, Tarantool AUTHORS, please see AUTHORS file.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY <COPYRIGHT HOLDER> ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * <COPYRIGHT HOLDER> OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
struct ev_loop;
struct ev_timer;

/**
 * A set of wrappers around libev functions. Libev is not used directly, because
 * in unit tests these wrappers are redefined to use fakeev event loop in order
 * to speed the tests up, and have more control over the event loop.
 */

/** A wrapper around ev_timer_start(). */
void
raft_ev_timer_start(struct ev_loop *loop, struct ev_timer *watcher);

/** A wrapper around ev_timer_remaining(). */
double
raft_ev_timer_remaining(struct ev_loop *loop, struct ev_timer *watcher);

/** A wrapper around ev_timer_stop(). */
void
raft_ev_timer_stop(struct ev_loop *loop, struct ev_timer *watcher);

/** A wrapper around ev_monotonic_now(). */
double
raft_ev_monotonic_now(struct ev_loop *loop);

/** A wrapper around loop(), which returns this cord's ev_loop. */
struct ev_loop *
raft_loop(void);

#define raft_ev_is_active ev_is_active

#define raft_ev_is_pending ev_is_pending

#define raft_ev_timer_init ev_timer_init

#define raft_ev_timer_set ev_timer_set

#define raft_ev_timer_is_active(w)						\
	(raft_ev_is_active(w) || raft_ev_is_pending(w))
