/* THIS FILE IS AUTOGENERATED FROM ImageDecoder.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_IMAGEDECODERBINDING_H_
#define DOM_IMAGEDECODERBINDING_H_

#include "ImageBitmapBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "js/Value.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/dom/VideoFrame.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

struct ImageDecodeOptionsAtoms;
struct ImageDecodeResultAtoms;
class ImageDecoder;
struct ImageDecoderInitAtoms;
class ImageTrack;
class ImageTrackList;
class MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream;
struct NativePropertyHooks;
class OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream;
class ProtoAndIfaceCache;
class ReadableStream;
class VideoFrame;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream& aUnion);


struct ImageDecodeOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCompleteFramesOnly;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mFrameIndex;

  ImageDecodeOptions();

  explicit inline ImageDecodeOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ImageDecodeOptions(ImageDecodeOptions&& aOther) = default;

  explicit inline ImageDecodeOptions(const ImageDecodeOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ImageDecodeOptions&
  operator=(const ImageDecodeOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ImageDecodeOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastImageDecodeOptions : public ImageDecodeOptions
{
  inline FastImageDecodeOptions()
    : ImageDecodeOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ImageDecodeResult : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mComplete;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::dom::VideoFrame> mImage;

  ImageDecodeResult();

  explicit inline ImageDecodeResult(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ImageDecodeResult(ImageDecodeResult&& aOther) = default;

  explicit inline ImageDecodeResult(const ImageDecodeResult& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mImage, "mImage", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mImage);
  }

  ImageDecodeResult&
  operator=(const ImageDecodeResult& aOther);

private:
  static bool
  InitIds(JSContext* cx, ImageDecodeResultAtoms* atomsCache);
};

namespace binding_detail {
struct FastImageDecodeResult : public ImageDecodeResult
{
  inline FastImageDecodeResult()
    : ImageDecodeResult(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream : public AllUnionBase,
                                                                           public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream, true, ArrayBuffer, ArrayBufferView>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBuffer,
    eArrayBufferView,
    eReadableStream
  };
public:
  enum class Type
  {
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eReadableStream = TypeOrUninit::eReadableStream
  };

private:
  union Value
  {
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<NonNull<mozilla::dom::ReadableStream> > mReadableStream;

  };

  TypeOrUninit mType;
  Value mValue;

  MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream(const MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream&) = delete;
  MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream& operator=(const MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream&) = delete;
public:
  explicit inline MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream()
    : mType(eUninitialized)
  {
  }

  inline ~MaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ReadableStream>&
  RawSetAsReadableStream()
  {
    if (mType == eReadableStream) {
      return mValue.mReadableStream.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eReadableStream;
    return mValue.mReadableStream.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::ReadableStream>&
  SetAsReadableStream()
  {
    if (mType == eReadableStream) {
      return mValue.mReadableStream.Value();
    }
    Uninit();
    mType = eReadableStream;
    return mValue.mReadableStream.SetValue();
  }

  inline bool
  IsReadableStream() const
  {
    return mType == eReadableStream;
  }

  inline NonNull<mozilla::dom::ReadableStream>&
  GetAsReadableStream()
  {
    MOZ_RELEASE_ASSERT(IsReadableStream(), "Wrong type!");
    return mValue.mReadableStream.Value();
  }

  inline mozilla::dom::ReadableStream&
  GetAsReadableStream() const
  {
    MOZ_RELEASE_ASSERT(IsReadableStream(), "Wrong type!");
    return mValue.mReadableStream.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eReadableStream: {
        DestroyReadableStream();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToReadableStream(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToReadableStream(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyReadableStream()
  {
    MOZ_RELEASE_ASSERT(IsReadableStream(), "Wrong type!");
    mValue.mReadableStream.Destroy();
    mType = eUninitialized;
  }
};


class OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream : public AllOwningUnionBase,
                                                                                 public UnionWithTypedArraysBase
{
  friend void ImplCycleCollectionUnlink(OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream& aUnion);
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream, true, ArrayBuffer, ArrayBufferView>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eArrayBuffer,
    eArrayBufferView,
    eReadableStream
  };
public:
  enum class Type
  {
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eReadableStream = TypeOrUninit::eReadableStream
  };

private:
  union Value
  {
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<OwningNonNull<mozilla::dom::ReadableStream> > mReadableStream;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream(const OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream&) = delete;
  OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream& operator=(const OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream&) = delete;
public:
  explicit inline OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream()
    : mType(eUninitialized)
  {
  }

  OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream(OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream&& aOther);

  inline ~OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream()
  {
    Uninit();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::ReadableStream>&
  RawSetAsReadableStream();

  [[nodiscard]] OwningNonNull<mozilla::dom::ReadableStream>&
  SetAsReadableStream();

  inline bool
  IsReadableStream() const
  {
    return mType == eReadableStream;
  }

  inline OwningNonNull<mozilla::dom::ReadableStream>&
  GetAsReadableStream()
  {
    MOZ_RELEASE_ASSERT(IsReadableStream(), "Wrong type!");
    return mValue.mReadableStream.Value();
  }

  inline OwningNonNull<mozilla::dom::ReadableStream> const &
  GetAsReadableStream() const
  {
    MOZ_RELEASE_ASSERT(IsReadableStream(), "Wrong type!");
    return mValue.mReadableStream.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream&
  operator=(OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToReadableStream(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToReadableStream(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyReadableStream();
};


struct ImageDecoderInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR ColorSpaceConversion mColorSpaceConversion;
  MOZ_INIT_OUTSIDE_CTOR OwningMaybeSharedArrayBufferOrMaybeSharedArrayBufferViewOrReadableStream mData;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDesiredHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mDesiredWidth;
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mPreferAnimation;
  MOZ_INIT_OUTSIDE_CTOR Sequence<ArrayBuffer> mTransfer;
  MOZ_INIT_OUTSIDE_CTOR nsString mType;

  ImageDecoderInit();

  explicit inline ImageDecoderInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ImageDecoderInit(ImageDecoderInit&& aOther) = default;

private:
  ImageDecoderInit(const ImageDecoderInit&) = delete;
  ImageDecoderInit& operator=(const ImageDecoderInit&) = delete;

  static bool
  InitIds(JSContext* cx, ImageDecoderInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mData, "mData", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mData);
  }
};

namespace binding_detail {
struct FastImageDecoderInit : public ImageDecoderInit
{
  inline FastImageDecoderInit()
    : ImageDecoderInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace ImageDecoder_Binding {

  typedef mozilla::dom::ImageDecoder NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::ImageDecoder* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ImageDecoder,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ImageDecoder_Binding



namespace ImageTrack_Binding {

  typedef mozilla::dom::ImageTrack NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::ImageTrack* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ImageTrack,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ImageTrack_Binding



namespace ImageTrackList_Binding {

  typedef mozilla::dom::ImageTrackList NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::ImageTrackList* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::ImageTrackList,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace ImageTrackList_Binding



} // namespace mozilla::dom

#endif // DOM_IMAGEDECODERBINDING_H_
