/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apisxv1alpha1 "sigs.k8s.io/gateway-api/apisx/v1alpha1"
	applyconfigurationapisxv1alpha1 "sigs.k8s.io/gateway-api/applyconfiguration/apisx/v1alpha1"
	scheme "sigs.k8s.io/gateway-api/pkg/client/clientset/versioned/scheme"
)

// XListenerSetsGetter has a method to return a XListenerSetInterface.
// A group's client should implement this interface.
type XListenerSetsGetter interface {
	XListenerSets(namespace string) XListenerSetInterface
}

// XListenerSetInterface has methods to work with XListenerSet resources.
type XListenerSetInterface interface {
	Create(ctx context.Context, xListenerSet *apisxv1alpha1.XListenerSet, opts v1.CreateOptions) (*apisxv1alpha1.XListenerSet, error)
	Update(ctx context.Context, xListenerSet *apisxv1alpha1.XListenerSet, opts v1.UpdateOptions) (*apisxv1alpha1.XListenerSet, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, xListenerSet *apisxv1alpha1.XListenerSet, opts v1.UpdateOptions) (*apisxv1alpha1.XListenerSet, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apisxv1alpha1.XListenerSet, error)
	List(ctx context.Context, opts v1.ListOptions) (*apisxv1alpha1.XListenerSetList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apisxv1alpha1.XListenerSet, err error)
	Apply(ctx context.Context, xListenerSet *applyconfigurationapisxv1alpha1.XListenerSetApplyConfiguration, opts v1.ApplyOptions) (result *apisxv1alpha1.XListenerSet, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, xListenerSet *applyconfigurationapisxv1alpha1.XListenerSetApplyConfiguration, opts v1.ApplyOptions) (result *apisxv1alpha1.XListenerSet, err error)
	XListenerSetExpansion
}

// xListenerSets implements XListenerSetInterface
type xListenerSets struct {
	*gentype.ClientWithListAndApply[*apisxv1alpha1.XListenerSet, *apisxv1alpha1.XListenerSetList, *applyconfigurationapisxv1alpha1.XListenerSetApplyConfiguration]
}

// newXListenerSets returns a XListenerSets
func newXListenerSets(c *ExperimentalV1alpha1Client, namespace string) *xListenerSets {
	return &xListenerSets{
		gentype.NewClientWithListAndApply[*apisxv1alpha1.XListenerSet, *apisxv1alpha1.XListenerSetList, *applyconfigurationapisxv1alpha1.XListenerSetApplyConfiguration](
			"xlistenersets",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *apisxv1alpha1.XListenerSet { return &apisxv1alpha1.XListenerSet{} },
			func() *apisxv1alpha1.XListenerSetList { return &apisxv1alpha1.XListenerSetList{} },
		),
	}
}
