// Code Generated by gadget/xsdk, DO NOT EDIT

package dns

import (
	"bytes"
	"context"
	"encoding/json"
	"net/http"
)

// Group: CustomLines
// 自定义线路

func (c *Client) BatchDeleteCustomLine(ctx context.Context, data *BatchDeleteCustomLineRequest) (*BatchDeleteCustomLineResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=BatchDeleteCustomLine", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload BatchDeleteCustomLineResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) CreateCustomLine(ctx context.Context, data *CreateCustomLineRequest) (*CreateCustomLineResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=CreateCustomLine", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload CreateCustomLineResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ListCustomLines(ctx context.Context, data *ListCustomLinesRequest) (*ListCustomLinesResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListCustomLines", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Line; v != nil {
		q.Add("Line", *v)
	}
	if v := data.NameCN; v != nil {
		q.Add("NameCN", *v)
	}
	if v := data.Remark; v != nil {
		q.Add("Remark", *v)
	}
	if v := data.IPSegment; v != nil {
		q.Add("IPSegment", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.SearchMode; v != nil {
		q.Add("SearchMode", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListCustomLinesResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ListRecordDigestByLine(ctx context.Context, data *ListRecordDigestByLineRequest) (*ListRecordDigestByLineResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListRecordDigestByLine", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListRecordDigestByLineResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) UpdateCustomLine(ctx context.Context, data *UpdateCustomLineRequest) (*UpdateCustomLineResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=UpdateCustomLine", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload UpdateCustomLineResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

// Group: Others
// 其他

func (c *Client) ListLines(ctx context.Context, data *ListLinesRequest) (*ListLinesResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListLines", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Type; v != nil {
		q.Add("Type", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.Hierarchy; v != nil {
		q.Add("Hierarchy", *v)
	}
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListLinesResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ListRecordAttributes(ctx context.Context, data *ListRecordAttributesRequest) (*ListRecordAttributesResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListRecordAttributes", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListRecordAttributesResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

// Group: Records
// 解析记录管理

func (c *Client) CreateRecord(ctx context.Context, data *CreateRecordRequest) (*CreateRecordResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=CreateRecord", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload CreateRecordResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) DeleteRecord(ctx context.Context, data *DeleteRecordRequest) error {
	body, err := json.Marshal(data)
	if err != nil {
		return err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=DeleteRecord", bytes.NewReader(body))
	if err != nil {
		return err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) ListRecordSets(ctx context.Context, data *ListRecordSetsRequest) (*ListRecordSetsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListRecordSets", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Host; v != nil {
		q.Add("Host", *v)
	}
	if v := data.RecordSetID; v != nil {
		q.Add("RecordSetID", *v)
	}
	if v := data.SearchMode; v != nil {
		q.Add("SearchMode", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListRecordSetsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ListRecords(ctx context.Context, data *ListRecordsRequest) (*ListRecordsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListRecords", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.Type; v != nil {
		q.Add("Type", *v)
	}
	if v := data.SearchMode; v != nil {
		q.Add("SearchMode", *v)
	}
	if v := data.SearchOrder; v != nil {
		q.Add("SearchOrder", *v)
	}
	if v := data.Host; v != nil {
		q.Add("Host", *v)
	}
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	if v := data.Value; v != nil {
		q.Add("Value", *v)
	}
	if v := data.RecordSetID; v != nil {
		q.Add("RecordSetID", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.Line; v != nil {
		q.Add("Line", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListRecordsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ListRecordsAdvance(ctx context.Context, data *ListRecordsAdvanceRequest) (*ListRecordsAdvanceResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListRecordsAdvance", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.SearchOrder; v != nil {
		q.Add("SearchOrder", *v)
	}
	if v := data.SubPageNumber; v != nil {
		q.Add("SubPageNumber", *v)
	}
	if v := data.LastOperator; v != nil {
		q.Add("LastOperator", *v)
	}
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	if v := data.OrderKey; v != nil {
		q.Add("OrderKey", *v)
	}
	if v := data.SearchMode; v != nil {
		q.Add("SearchMode", *v)
	}
	if v := data.TTL; v != nil {
		q.Add("TTL", *v)
	}
	if v := data.GTMDomainFilter; v != nil {
		q.Add("GTMDomainFilter", *v)
	}
	if v := data.Name; v != nil {
		q.Add("Name", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.SubPageSize; v != nil {
		q.Add("SubPageSize", *v)
	}
	if v := data.Host; v != nil {
		q.Add("Host", *v)
	}
	if v := data.Line; v != nil {
		q.Add("Line", *v)
	}
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.Value; v != nil {
		q.Add("Value", *v)
	}
	if v := data.Type; v != nil {
		q.Add("Type", *v)
	}
	if v := data.Enable; v != nil {
		q.Add("Enable", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListRecordsAdvanceResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) QueryRecord(ctx context.Context, data *QueryRecordRequest) (*QueryRecordResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=QueryRecord", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Value; v != nil {
		q.Add("Value", *v)
	}
	if v := data.Line; v != nil {
		q.Add("Line", *v)
	}
	if v := data.RecordID; v != nil {
		q.Add("RecordID", *v)
	}
	if v := data.FQDN; v != nil {
		q.Add("FQDN", *v)
	}
	if v := data.PQDN; v != nil {
		q.Add("PQDN", *v)
	}
	if v := data.Type; v != nil {
		q.Add("Type", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload QueryRecordResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) SyncFullRecordsV2(ctx context.Context, data *SyncFullRecordsV2Request) (*SyncFullRecordsV2Response, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=SyncFullRecordsV2", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload SyncFullRecordsV2Response
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) UpdateRecord(ctx context.Context, data *UpdateRecordRequest) (*UpdateRecordResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=UpdateRecord", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload UpdateRecordResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) UpdateRecordSet(ctx context.Context, data *UpdateRecordSetRequest) (*UpdateRecordSetResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=UpdateRecordSet", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload UpdateRecordSetResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) UpdateRecordStatus(ctx context.Context, data *UpdateRecordStatusRequest) (*UpdateRecordStatusResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=UpdateRecordStatus", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload UpdateRecordStatusResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

// Group: Stats
// 访问量统计

func (c *Client) ListDomainStatistics(ctx context.Context, data *ListDomainStatisticsRequest) (*ListDomainStatisticsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListDomainStatistics", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Name; v != nil {
		q.Add("Name", *v)
	}
	if v := data.SearchMode; v != nil {
		q.Add("SearchMode", *v)
	}
	if v := data.Start; v != nil {
		q.Add("Start", *v)
	}
	if v := data.End; v != nil {
		q.Add("End", *v)
	}
	if v := data.Threshold; v != nil {
		q.Add("Threshold", *v)
	}
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListDomainStatisticsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ListZoneStatistics(ctx context.Context, data *ListZoneStatisticsRequest) (*ListZoneStatisticsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListZoneStatistics", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.SearchMode; v != nil {
		q.Add("SearchMode", *v)
	}
	if v := data.Name; v != nil {
		q.Add("Name", *v)
	}
	if v := data.Start; v != nil {
		q.Add("Start", *v)
	}
	if v := data.End; v != nil {
		q.Add("End", *v)
	}
	if v := data.Threshold; v != nil {
		q.Add("Threshold", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListZoneStatisticsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) QueryDomainStatistics(ctx context.Context, data *QueryDomainStatisticsRequest) (QueryDomainStatisticsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=QueryDomainStatistics", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.Name; v != nil {
		q.Add("Name", *v)
	}
	if v := data.Start; v != nil {
		q.Add("Start", *v)
	}
	if v := data.End; v != nil {
		q.Add("End", *v)
	}
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload QueryDomainStatisticsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return payload, nil
}

func (c *Client) QueryZoneStatistics(ctx context.Context, data *QueryZoneStatisticsRequest) (QueryZoneStatisticsResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=QueryZoneStatistics", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	if v := data.Start; v != nil {
		q.Add("Start", *v)
	}
	if v := data.End; v != nil {
		q.Add("End", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload QueryZoneStatisticsResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return payload, nil
}

// Group: Zones
// 域名管理

func (c *Client) CheckRetrieveZone(ctx context.Context, data *CheckRetrieveZoneRequest) (*CheckRetrieveZoneResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=CheckRetrieveZone", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload CheckRetrieveZoneResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) CreateZone(ctx context.Context, data *CreateZoneRequest) (*CreateZoneResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=CreateZone", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload CreateZoneResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) DeleteZone(ctx context.Context, data *DeleteZoneRequest) error {
	body, err := json.Marshal(data)
	if err != nil {
		return err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=DeleteZone", bytes.NewReader(body))
	if err != nil {
		return err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()

	return nil
}

func (c *Client) ListZones(ctx context.Context, data *ListZonesRequest) (*ListZonesResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListZones", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.TradeCode; v != nil {
		q.Add("TradeCode", *v)
	}
	if v := data.OrderKey; v != nil {
		q.Add("OrderKey", *v)
	}
	if v := data.SearchOrder; v != nil {
		q.Add("SearchOrder", *v)
	}
	if v := data.Remark; v != nil {
		q.Add("Remark", *v)
	}
	if v := data.Stage; v != nil {
		q.Add("Stage", *v)
	}
	if v := data.AboutToExpire; v != nil {
		q.Add("AboutToExpire", *v)
	}
	if v := data.PageSize; v != nil {
		q.Add("PageSize", *v)
	}
	if v := data.PageNumber; v != nil {
		q.Add("PageNumber", *v)
	}
	if v := data.Key; v != nil {
		q.Add("Key", *v)
	}
	if v := data.SearchMode; v != nil {
		q.Add("SearchMode", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListZonesResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) ListZonesNameServer(ctx context.Context, data *ListZonesNameServerRequest) (*ListZonesNameServerResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=ListZonesNameServer", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.ZIDs; v != nil {
		q.Add("ZIDs", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload ListZonesNameServerResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) QueryZone(ctx context.Context, data *QueryZoneRequest) (*QueryZoneResponse, error) {
	req, err := http.NewRequestWithContext(ctx, http.MethodGet, "/?Action=QueryZone", nil)
	if err != nil {
		return nil, err
	}

	q := req.URL.Query()
	if v := data.ZID; v != nil {
		q.Add("ZID", *v)
	}
	if v := data.UseAllocateNameServer; v != nil {
		q.Add("UseAllocateNameServer", *v)
	}
	req.URL.RawQuery = q.Encode()

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload QueryZoneResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) RetrieveZone(ctx context.Context, data *RetrieveZoneRequest) (*RetrieveZoneResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=RetrieveZone", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload RetrieveZoneResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}

func (c *Client) UpdateZone(ctx context.Context, data *UpdateZoneRequest) (*UpdateZoneResponse, error) {
	body, err := json.Marshal(data)
	if err != nil {
		return nil, err
	}

	req, err := http.NewRequestWithContext(ctx, http.MethodPost, "/?Action=UpdateZone", bytes.NewReader(body))
	if err != nil {
		return nil, err
	}

	resp, err := c.do(ctx, req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	var payload UpdateZoneResponse
	d := json.NewDecoder(resp.Body)
	if err := d.Decode(&payload); err != nil {
		return nil, err
	}
	return &payload, nil
}
