/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// RetryConstraintApplyConfiguration represents a declarative configuration of the RetryConstraint type for use
// with apply.
type RetryConstraintApplyConfiguration struct {
	Budget       *BudgetDetailsApplyConfiguration `json:"budget,omitempty"`
	MinRetryRate *RequestRateApplyConfiguration   `json:"minRetryRate,omitempty"`
}

// RetryConstraintApplyConfiguration constructs a declarative configuration of the RetryConstraint type for use with
// apply.
func RetryConstraint() *RetryConstraintApplyConfiguration {
	return &RetryConstraintApplyConfiguration{}
}

// WithBudget sets the Budget field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Budget field is set to the value of the last call.
func (b *RetryConstraintApplyConfiguration) WithBudget(value *BudgetDetailsApplyConfiguration) *RetryConstraintApplyConfiguration {
	b.Budget = value
	return b
}

// WithMinRetryRate sets the MinRetryRate field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinRetryRate field is set to the value of the last call.
func (b *RetryConstraintApplyConfiguration) WithMinRetryRate(value *RequestRateApplyConfiguration) *RetryConstraintApplyConfiguration {
	b.MinRetryRate = value
	return b
}
