/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_CAPTURE_UNSTABLE_V1_SERVER_PROTOCOL_H
#define TREELAND_CAPTURE_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_capture_unstable_v1 The treeland_capture_unstable_v1 protocol
 * protocol for capturing output contents or window contents
 *
 * @section page_desc_treeland_capture_unstable_v1 Description
 *
 * This protocol allows authorized application to capture output contents or window
 * contents(useful for window streaming).
 *
 * @section page_ifaces_treeland_capture_unstable_v1 Interfaces
 * - @subpage page_iface_treeland_capture_session_v1 - 
 * - @subpage page_iface_treeland_capture_frame_v1 - 
 * - @subpage page_iface_treeland_capture_context_v1 - 
 * - @subpage page_iface_treeland_capture_manager_v1 - 
 * @section page_copyright_treeland_capture_unstable_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_capture_context_v1;
struct treeland_capture_frame_v1;
struct treeland_capture_manager_v1;
struct treeland_capture_session_v1;
struct wl_buffer;
struct wl_surface;

#ifndef TREELAND_CAPTURE_SESSION_V1_INTERFACE
#define TREELAND_CAPTURE_SESSION_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_session_v1 treeland_capture_session_v1
 * @section page_iface_treeland_capture_session_v1_api API
 * See @ref iface_treeland_capture_session_v1.
 */
/**
 * @defgroup iface_treeland_capture_session_v1 The treeland_capture_session_v1 interface
 */
extern const struct wl_interface treeland_capture_session_v1_interface;
#endif
#ifndef TREELAND_CAPTURE_FRAME_V1_INTERFACE
#define TREELAND_CAPTURE_FRAME_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_frame_v1 treeland_capture_frame_v1
 * @section page_iface_treeland_capture_frame_v1_api API
 * See @ref iface_treeland_capture_frame_v1.
 */
/**
 * @defgroup iface_treeland_capture_frame_v1 The treeland_capture_frame_v1 interface
 */
extern const struct wl_interface treeland_capture_frame_v1_interface;
#endif
#ifndef TREELAND_CAPTURE_CONTEXT_V1_INTERFACE
#define TREELAND_CAPTURE_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_context_v1 treeland_capture_context_v1
 * @section page_iface_treeland_capture_context_v1_api API
 * See @ref iface_treeland_capture_context_v1.
 */
/**
 * @defgroup iface_treeland_capture_context_v1 The treeland_capture_context_v1 interface
 */
extern const struct wl_interface treeland_capture_context_v1_interface;
#endif
#ifndef TREELAND_CAPTURE_MANAGER_V1_INTERFACE
#define TREELAND_CAPTURE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_capture_manager_v1 treeland_capture_manager_v1
 * @section page_iface_treeland_capture_manager_v1_api API
 * See @ref iface_treeland_capture_manager_v1.
 */
/**
 * @defgroup iface_treeland_capture_manager_v1 The treeland_capture_manager_v1 interface
 */
extern const struct wl_interface treeland_capture_manager_v1_interface;
#endif

#ifndef TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM
#define TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM
enum treeland_capture_session_v1_cancel_reason {
	/**
	 * temporary error, source will produce more frames
	 */
	TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_TEMPORARY = 0,
	/**
	 * fatal error, source will not produce frames
	 */
	TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_PERMANENT = 1,
	/**
	 * temporary error, source will produce more frames
	 */
	TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_RESIZING = 2,
};
#endif /* TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM */

#ifndef TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM_IS_VALID
#define TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_capture_session_v1
 * Validate a treeland_capture_session_v1 cancel_reason value.
 *
 * @return true on success, false on error.
 * @ref treeland_capture_session_v1_cancel_reason
 */
static inline bool
treeland_capture_session_v1_cancel_reason_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_TEMPORARY:
		return version >= 1;
	case TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_PERMANENT:
		return version >= 1;
	case TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_RESIZING:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_CAPTURE_SESSION_V1_CANCEL_REASON_ENUM_IS_VALID */

#ifndef TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM
#define TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM
enum treeland_capture_session_v1_flags {
	/**
	 * clients should copy frame before processing
	 */
	TREELAND_CAPTURE_SESSION_V1_FLAGS_TRANSIENT = 0x1,
};
#endif /* TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM */

#ifndef TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM_IS_VALID
#define TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_capture_session_v1
 * Validate a treeland_capture_session_v1 flags value.
 *
 * @return true on success, false on error.
 * @ref treeland_capture_session_v1_flags
 */
static inline bool
treeland_capture_session_v1_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= TREELAND_CAPTURE_SESSION_V1_FLAGS_TRANSIENT;
	return (value & ~valid) == 0;
}
#endif /* TREELAND_CAPTURE_SESSION_V1_FLAGS_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_capture_session_v1
 * @struct treeland_capture_session_v1_interface
 */
struct treeland_capture_session_v1_interface {
	/**
	 * delete this object
	 *
	 * Unreferences the frame. This request must be called as soon as
	 * it's no longer valid.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * start session
	 *
	 * Start session and keeps sending frame.
	 */
	void (*start)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * Indicates current frame is done.
	 *
	 * This is the ACK to the current "ready" event. The next "frame"
	 * event will be sent only when current "ready" event is
	 * acknowledged. The timestamp should be the same as the one sent
	 * in "ready" event. If the frame has the "transient" flag, all
	 * objects sent before become invalid after this event.
	 */
	void (*frame_done)(struct wl_client *client,
			   struct wl_resource *resource,
			   uint32_t tv_sec_hi,
			   uint32_t tv_sec_lo,
			   uint32_t tv_usec);
};

#define TREELAND_CAPTURE_SESSION_V1_FRAME 0
#define TREELAND_CAPTURE_SESSION_V1_OBJECT 1
#define TREELAND_CAPTURE_SESSION_V1_READY 2
#define TREELAND_CAPTURE_SESSION_V1_CANCEL 3

/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_OBJECT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_CANCEL_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_START_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_session_v1
 */
#define TREELAND_CAPTURE_SESSION_V1_FRAME_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_session_v1
 * Sends an frame event to the client owning the resource.
 * @param resource_ The client's resource
 * @param offset_x crop offset x
 * @param offset_y crop offset y
 */
static inline void
treeland_capture_session_v1_send_frame(struct wl_resource *resource_, int32_t offset_x, int32_t offset_y, uint32_t width, uint32_t height, uint32_t buffer_flags, uint32_t flags, uint32_t format, uint32_t mod_high, uint32_t mod_low, uint32_t num_objects)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_SESSION_V1_FRAME, offset_x, offset_y, width, height, buffer_flags, flags, format, mod_high, mod_low, num_objects);
}

/**
 * @ingroup iface_treeland_capture_session_v1
 * Sends an object event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_session_v1_send_object(struct wl_resource *resource_, uint32_t index, int32_t fd, uint32_t size, uint32_t offset, uint32_t stride, uint32_t plane_index)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_SESSION_V1_OBJECT, index, fd, size, offset, stride, plane_index);
}

/**
 * @ingroup iface_treeland_capture_session_v1
 * Sends an ready event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_session_v1_send_ready(struct wl_resource *resource_, uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_nsec)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_SESSION_V1_READY, tv_sec_hi, tv_sec_lo, tv_nsec);
}

/**
 * @ingroup iface_treeland_capture_session_v1
 * Sends an cancel event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_session_v1_send_cancel(struct wl_resource *resource_, uint32_t reason)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_SESSION_V1_CANCEL, reason);
}

#ifndef TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM
#define TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM
enum treeland_capture_frame_v1_flags {
	/**
	 * contents are y-inverted
	 */
	TREELAND_CAPTURE_FRAME_V1_FLAGS_Y_INVERTED = 0x1,
};
#endif /* TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM */

#ifndef TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM_IS_VALID
#define TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_capture_frame_v1
 * Validate a treeland_capture_frame_v1 flags value.
 *
 * @return true on success, false on error.
 * @ref treeland_capture_frame_v1_flags
 */
static inline bool
treeland_capture_frame_v1_flags_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= TREELAND_CAPTURE_FRAME_V1_FLAGS_Y_INVERTED;
	return (value & ~valid) == 0;
}
#endif /* TREELAND_CAPTURE_FRAME_V1_FLAGS_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_capture_frame_v1
 * @struct treeland_capture_frame_v1_interface
 */
struct treeland_capture_frame_v1_interface {
	/**
	 * delete this object, used or not
	 *
	 * Destroys the context. This request can be sent at any time by
	 * the client.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * copy capture contents
	 *
	 * Copy capture contents to provided buffer
	 */
	void (*copy)(struct wl_client *client,
		     struct wl_resource *resource,
		     struct wl_resource *buffer);
};

#define TREELAND_CAPTURE_FRAME_V1_BUFFER 0
#define TREELAND_CAPTURE_FRAME_V1_BUFFER_DONE 1
#define TREELAND_CAPTURE_FRAME_V1_FLAGS 2
#define TREELAND_CAPTURE_FRAME_V1_READY 3
#define TREELAND_CAPTURE_FRAME_V1_FAILED 4

/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_BUFFER_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_FLAGS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_frame_v1
 */
#define TREELAND_CAPTURE_FRAME_V1_COPY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_frame_v1
 * Sends an buffer event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_frame_v1_send_buffer(struct wl_resource *resource_, uint32_t format, uint32_t width, uint32_t height, uint32_t stride)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_FRAME_V1_BUFFER, format, width, height, stride);
}

/**
 * @ingroup iface_treeland_capture_frame_v1
 * Sends an buffer_done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_frame_v1_send_buffer_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_FRAME_V1_BUFFER_DONE);
}

/**
 * @ingroup iface_treeland_capture_frame_v1
 * Sends an flags event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags frame flags
 */
static inline void
treeland_capture_frame_v1_send_flags(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_FRAME_V1_FLAGS, flags);
}

/**
 * @ingroup iface_treeland_capture_frame_v1
 * Sends an ready event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_frame_v1_send_ready(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_FRAME_V1_READY);
}

/**
 * @ingroup iface_treeland_capture_frame_v1
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_frame_v1_send_failed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_FRAME_V1_FAILED);
}

#ifndef TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM
enum treeland_capture_context_v1_source_type {
	/**
	 * output source type
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_OUTPUT = 0x1,
	/**
	 * window source type
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_WINDOW = 0x2,
	/**
	 * region source type
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_REGION = 0x4,
};
#endif /* TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM */

#ifndef TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM_IS_VALID
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_capture_context_v1
 * Validate a treeland_capture_context_v1 source_type value.
 *
 * @return true on success, false on error.
 * @ref treeland_capture_context_v1_source_type
 */
static inline bool
treeland_capture_context_v1_source_type_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_OUTPUT;
	if (version >= 1)
		valid |= TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_WINDOW;
	if (version >= 1)
		valid |= TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_REGION;
	return (value & ~valid) == 0;
}
#endif /* TREELAND_CAPTURE_CONTEXT_V1_SOURCE_TYPE_ENUM_IS_VALID */

#ifndef TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM
/**
 * @ingroup iface_treeland_capture_context_v1
 * source failure reason
 *
 */
enum treeland_capture_context_v1_source_failure {
	/**
	 * selector is occupied by other context
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_SELECTOR_BUSY = 1,
	/**
	 * User cancel this context from compositor
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_USER_CANCEL = 2,
	/**
	 * Source has been destroyed
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_SOURCE_DESTROYED = 3,
	/**
	 * other failure
	 */
	TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_OTHER = 4,
};
#endif /* TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM */

#ifndef TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM_IS_VALID
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_capture_context_v1
 * Validate a treeland_capture_context_v1 source_failure value.
 *
 * @return true on success, false on error.
 * @ref treeland_capture_context_v1_source_failure
 */
static inline bool
treeland_capture_context_v1_source_failure_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_SELECTOR_BUSY:
		return version >= 1;
	case TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_USER_CANCEL:
		return version >= 1;
	case TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_SOURCE_DESTROYED:
		return version >= 1;
	case TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_OTHER:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILURE_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_capture_context_v1
 * @struct treeland_capture_context_v1_interface
 */
struct treeland_capture_context_v1_interface {
	/**
	 * delete this object, used or not
	 *
	 * Destroys the context. This request can be sent at any time by
	 * the client.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * select source interactively
	 *
	 * Selector is provided by compositor. Client can provide source
	 * hint to hint compositor to provide certain kinds of source.
	 * @param freeze freeze compositing or not
	 * @param with_cursor whether source content contains cursor or not
	 * @param mask this mask is guaranteed to be at the top most
	 */
	void (*select_source)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t source_hint,
			      uint32_t freeze,
			      uint32_t with_cursor,
			      struct wl_resource *mask);
	/**
	 * capture one frame
	 *
	 * This event can be called just once. A second call might result
	 * in a protocol error cause we just provide transient
	 */
	void (*capture)(struct wl_client *client,
			struct wl_resource *resource,
			uint32_t frame);
	/**
	 * create a persistent session for capturing
	 *
	 * Often used by a screen recorder.
	 */
	void (*create_session)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t session);
};

#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_READY 0
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILED 1

/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_READY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_SELECT_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_CAPTURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_context_v1
 */
#define TREELAND_CAPTURE_CONTEXT_V1_CREATE_SESSION_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_capture_context_v1
 * Sends an source_ready event to the client owning the resource.
 * @param resource_ The client's resource
 * @param region_x offset x of capture region relative to mask for capture contents
 * @param region_y offset y of capture region relative to mask for capture contents
 * @param region_width width of capture region
 * @param region_height height of capture region
 * @param source_type final capture source type
 */
static inline void
treeland_capture_context_v1_send_source_ready(struct wl_resource *resource_, int32_t region_x, int32_t region_y, uint32_t region_width, uint32_t region_height, uint32_t source_type)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_CONTEXT_V1_SOURCE_READY, region_x, region_y, region_width, region_height, source_type);
}

/**
 * @ingroup iface_treeland_capture_context_v1
 * Sends an source_failed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_capture_context_v1_send_source_failed(struct wl_resource *resource_, uint32_t reason)
{
	wl_resource_post_event(resource_, TREELAND_CAPTURE_CONTEXT_V1_SOURCE_FAILED, reason);
}

/**
 * @ingroup iface_treeland_capture_manager_v1
 * @struct treeland_capture_manager_v1_interface
 */
struct treeland_capture_manager_v1_interface {
	/**
	 * destroy the capture manager
	 *
	 * Destroy the treeland_capture_manager_v1 object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * get a capture context
	 *
	 * 
	 */
	void (*get_context)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t context);
};


/**
 * @ingroup iface_treeland_capture_manager_v1
 */
#define TREELAND_CAPTURE_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_capture_manager_v1
 */
#define TREELAND_CAPTURE_MANAGER_V1_GET_CONTEXT_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
