/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_DDM_SERVER_PROTOCOL_H
#define TREELAND_DDM_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_ddm The treeland_ddm protocol
 * @section page_ifaces_treeland_ddm Interfaces
 * - @subpage page_iface_treeland_ddm - core global for treeland - ddm connection
 * @section page_copyright_treeland_ddm Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_ddm;
struct wl_callback;

#ifndef TREELAND_DDM_INTERFACE
#define TREELAND_DDM_INTERFACE
/**
 * @page page_iface_treeland_ddm treeland_ddm
 * @section page_iface_treeland_ddm_desc Description
 *
 * This object is primarily used for establish connection between
 * treeland and ddm.
 * @section page_iface_treeland_ddm_api API
 * See @ref iface_treeland_ddm.
 */
/**
 * @defgroup iface_treeland_ddm The treeland_ddm interface
 *
 * This object is primarily used for establish connection between
 * treeland and ddm.
 */
extern const struct wl_interface treeland_ddm_interface;
#endif

/**
 * @ingroup iface_treeland_ddm
 * @struct treeland_ddm_interface
 */
struct treeland_ddm_interface {
	/**
	 * send treeland to greeter mode
	 *
	 * Send treeland to Greeter mode.
	 */
	void (*switch_to_greeter)(struct wl_client *client,
				  struct wl_resource *resource);
	/**
	 * call treeland to switch lockscreen user
	 *
	 * Set lockscreen user to username. Ignore when username is
	 * "ddm".
	 */
	void (*switch_to_user)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *username);
	/**
	 * activate wayland session
	 *
	 * Activate treeland session. This will makes treeland try to
	 * take control of screen.
	 */
	void (*activate_session)(struct wl_client *client,
				 struct wl_resource *resource);
	/**
	 * deactivate wayland session
	 *
	 * Deactivate treeland session. This will release control of the
	 * screen, but not to close the current seats.
	 */
	void (*deactivate_session)(struct wl_client *client,
				   struct wl_resource *resource);
	/**
	 * start treeland rendering
	 *
	 * Enable treeland rendering. This is primarily called after
	 * disable_render to resume treeland.
	 */
	void (*enable_render)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * stop treeland rendering
	 *
	 * Disable treeland rendering. This will prevent treeland from
	 * output to DRM device.
	 */
	void (*disable_render)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t callback);
};

#define TREELAND_DDM_SWITCH_TO_VT 0
#define TREELAND_DDM_ACQUIRE_VT 1

/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_SWITCH_TO_VT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_ACQUIRE_VT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_SWITCH_TO_GREETER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_SWITCH_TO_USER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_ACTIVATE_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_DEACTIVATE_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_ENABLE_RENDER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_ddm
 */
#define TREELAND_DDM_DISABLE_RENDER_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_ddm
 * Sends an switch_to_vt event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_ddm_send_switch_to_vt(struct wl_resource *resource_, int32_t vtnr)
{
	wl_resource_post_event(resource_, TREELAND_DDM_SWITCH_TO_VT, vtnr);
}

/**
 * @ingroup iface_treeland_ddm
 * Sends an acquire_vt event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_ddm_send_acquire_vt(struct wl_resource *resource_, int32_t vtnr)
{
	wl_resource_post_event(resource_, TREELAND_DDM_ACQUIRE_VT, vtnr);
}

#ifdef  __cplusplus
}
#endif

#endif
