/*
 * DO NOT EDIT! This is a generated file.
 *
 * Qt-based wrapper declaration for VirtualBox Main API (COM) interface.
 * Generated from XIDL (XML interface definition).
 *
 * Source    : src/VBox/Main/idl/VirtualBox.xidl
 * Generator : src/VBox/Frontends/VirtualBox/src/globals/COMWrappers.xsl
 */

#ifndef __CVirtualBox_h__
#define __CVirtualBox_h__

/* Qt includes: */
#include <QList>
#include <QRect>
#include <QStringList>

/* GUI includes: */
#include "COMDefs.h"
#include "UILibraryDefs.h"

/* VirtualBox interface declarations: */
#ifndef VBOX_WITH_LESS_VIRTUALBOX_INCLUDING
# include <VBox/com/VirtualBox.h>
#else
COM_STRUCT_OR_CLASS(IVirtualBox);
#endif

#include "KPlatformArchitecture.h"
#include "KPlatformArchitecture.h"
#include "KMachineState.h"
#include "KAccessMode.h"
#include "KDeviceType.h"
#include "KDeviceType.h"
#include "KAccessMode.h"
#include "KPlatformArchitecture.h"
#include "KFirmwareType.h"
#include "KTrackedObjectState.h"


/* Forward declarations: */
class CVirtualBoxErrorInfo;
class CNATNetwork;
class CCloudNetwork;
class CHostOnlyNetwork;
class CDHCPServer;
class CDHCPConfig;
class CDHCPGlobalConfig;
class CDHCPGroupCondition;
class CDHCPGroupConfig;
class CDHCPIndividualConfig;
class CVirtualBox;
class CVFSExplorer;
class CCertificate;
class CAppliance;
class CVirtualSystemDescription;
class CUnattended;
class CGraphicsAdapter;
class CFirmwareSettings;
class CTrustedPlatformModule;
class CRecordingScreenSettings;
class CRecordingSettings;
class CPCIAddress;
class CPCIDeviceAttachment;
class CUefiVariableStore;
class CNvramStore;
class CResourceStore;
class CPlatform;
class CPlatformX86;
class CPlatformARM;
class CMachine;
class CEmulatedUSB;
class CVRDEServerInfo;
class CConsole;
class CHostNetworkInterface;
class CHostVideoInputDevice;
class CUpdateAgent;
class CHostUpdateAgent;
class CHostDrivePartition;
class CHostDrive;
class CHostX86;
class CHost;
class CCPUProfile;
class CPlatformProperties;
class CSystemProperties;
class CGuestOSType;
class CAdditionsFacility;
class CDnDBase;
class CDnDSource;
class CGuestDnDSource;
class CDnDTarget;
class CGuestDnDTarget;
class CGuestSession;
class CProcess;
class CGuestProcess;
class CDirectory;
class CGuestDirectory;
class CFile;
class CGuestFile;
class CFsInfo;
class CFsObjInfo;
class CGuestFsInfo;
class CGuestFsObjInfo;
class CGuest;
class CProgress;
class CSnapshot;
class CMediumAttachment;
class CMedium;
class CMediumFormat;
class CDataStream;
class CMediumIO;
class CToken;
class CKeyboard;
class CMousePointerShape;
class CMouse;
class CDisplaySourceBitmap;
class CFramebuffer;
class CFramebufferOverlay;
class CGuestScreenInfo;
class CDisplay;
class CNetworkAdapter;
class CSerialPort;
class CParallelPort;
class CMachineDebugger;
class CUSBDeviceFilters;
class CUSBController;
class CUSBDevice;
class CUSBDeviceFilter;
class CHostUSBDevice;
class CHostUSBDeviceFilter;
class CUSBProxyBackend;
class CAudioAdapter;
class CHostAudioDevice;
class CAudioSettings;
class CVRDEServer;
class CSharedFolder;
class CSession;
class CStorageController;
class CPerformanceMetric;
class CPerformanceCollector;
class CNATEngine;
class CExtPackPlugIn;
class CExtPackBase;
class CExtPack;
class CExtPackFile;
class CExtPackManager;
class CBandwidthGroup;
class CBandwidthControl;
class CGuestDebugControl;
class CVirtualBoxClient;
class CEventSource;
class CEventListener;
class CEvent;
class CReusableEvent;
class CMachineEvent;
class CMachineStateChangedEvent;
class CExtPackInstalledEvent;
class CExtPackUninstalledEvent;
class CMachineDataChangedEvent;
class CMediumRegisteredEvent;
class CMediumConfigChangedEvent;
class CMachineRegisteredEvent;
class CSessionStateChangedEvent;
class CGuestPropertyChangedEvent;
class CSnapshotEvent;
class CSnapshotTakenEvent;
class CSnapshotDeletedEvent;
class CSnapshotRestoredEvent;
class CSnapshotChangedEvent;
class CMousePointerShapeChangedEvent;
class CMouseCapabilityChangedEvent;
class CKeyboardLedsChangedEvent;
class CStateChangedEvent;
class CAdditionsStateChangedEvent;
class CNetworkAdapterChangedEvent;
class CAudioAdapterChangedEvent;
class CSerialPortChangedEvent;
class CParallelPortChangedEvent;
class CStorageControllerChangedEvent;
class CMediumChangedEvent;
class CClipboardModeChangedEvent;
class CClipboardFileTransferModeChangedEvent;
class CClipboardEvent;
class CClipboardErrorEvent;
class CDnDModeChangedEvent;
class CCPUChangedEvent;
class CCPUExecutionCapChangedEvent;
class CGuestKeyboardEvent;
class CGuestMouseEvent;
class CGuestMultiTouchEvent;
class CGuestSessionEvent;
class CGuestSessionStateChangedEvent;
class CGuestSessionRegisteredEvent;
class CGuestProcessEvent;
class CGuestProcessRegisteredEvent;
class CGuestProcessStateChangedEvent;
class CGuestProcessIOEvent;
class CGuestProcessInputNotifyEvent;
class CGuestProcessOutputEvent;
class CGuestDirectoryEvent;
class CGuestDirectoryRegisteredEvent;
class CGuestDirectoryStateChangedEvent;
class CGuestDirectoryReadEvent;
class CGuestFileEvent;
class CGuestFileRegisteredEvent;
class CGuestFileStateChangedEvent;
class CGuestFileIOEvent;
class CGuestFileOffsetChangedEvent;
class CGuestFileSizeChangedEvent;
class CGuestFileReadEvent;
class CGuestFileWriteEvent;
class CVRDEServerChangedEvent;
class CVRDEServerInfoChangedEvent;
class CRecordingStateChangedEvent;
class CRecordingScreenStateChangedEvent;
class CUSBControllerChangedEvent;
class CUSBDeviceStateChangedEvent;
class CSharedFolderChangedEvent;
class CRuntimeErrorEvent;
class CEventSourceChangedEvent;
class CExtraDataChangedEvent;
class CVetoEvent;
class CExtraDataCanChangeEvent;
class CCanShowWindowEvent;
class CShowWindowEvent;
class CNATRedirectEvent;
class CHostAudioDeviceChangedEvent;
class CHostPCIDevicePlugEvent;
class CVBoxSVCAvailabilityChangedEvent;
class CBandwidthGroupChangedEvent;
class CGuestMonitorChangedEvent;
class CGuestUserStateChangedEvent;
class CStorageDeviceChangedEvent;
class CNATNetworkChangedEvent;
class CNATNetworkStartStopEvent;
class CNATNetworkAlterEvent;
class CNATNetworkCreationDeletionEvent;
class CNATNetworkSettingEvent;
class CNATNetworkPortForwardEvent;
class CHostNameResolutionConfigurationChangeEvent;
class CProgressEvent;
class CProgressCreatedEvent;
class CProgressPercentageChangedEvent;
class CProgressTaskCompletedEvent;
class CCursorPositionChangedEvent;
class CGuestAdditionsStatusChangedEvent;
class CGuestMonitorInfoChangedEvent;
class CUpdateAgentEvent;
class CUpdateAgentSettingsChangedEvent;
class CUpdateAgentErrorEvent;
class CUpdateAgentAvailableEvent;
class CUpdateAgentStateChangedEvent;
class CGuestDebugControlChangedEvent;
class CMachineGroupsChangedEvent;
class CStringArray;
class CFormValue;
class CBooleanFormValue;
class CRangedIntegerFormValue;
class CRangedInteger64FormValue;
class CStringFormValue;
class CChoiceFormValue;
class CForm;
class CVirtualSystemDescriptionForm;
class CCloudNetworkGatewayInfo;
class CCloudNetworkEnvironmentInfo;
class CCloudMachine;
class CCloudClient;
class CCloudProfile;
class CCloudProvider;
class CCloudProviderManager;
class CCloudProviderListChangedEvent;
class CCloudProviderRegisteredEvent;
class CCloudProviderUninstallEvent;
class CCloudProfileRegisteredEvent;
class CCloudProfileChangedEvent;
class CLanguageChangedEvent;
class CVirtualBox;
class CVirtualBoxClient;
class CSession;
class CVirtualBoxSDS;

/* Interface forward declaration: */
COM_STRUCT_OR_CLASS(IVirtualBox);

/* Interface wrapper declaration: */
class SHARED_LIBRARY_STUFF CVirtualBox : public CInterface<IVirtualBox, COMBaseWithEI>
{
public:

    typedef CInterface<IVirtualBox, COMBaseWithEI> Base;

    /* Constructors and assignments taking CUnknown and raw iface pointer: */

    CVirtualBox();
    ~CVirtualBox();

    template<class OI, class OB> explicit CVirtualBox(const CInterface<OI, OB> & that)
    {
        attach(that.raw());
        if (SUCCEEDED(mRC))
        {
            mRC = that.lastRC();
            setErrorInfo(that.errorInfo());
        }
    }

    CVirtualBox(const CVirtualBox & that);

    template<class OI> explicit CVirtualBox(OI * aIface) { attach(aIface); }

    explicit CVirtualBox(IVirtualBox * aIface);

    template<class OI, class OB> CVirtualBox & operator=(const CInterface<OI, OB> & that)
    {
        attach(that.raw());
        if (SUCCEEDED(mRC))
        {
            mRC = that.lastRC();
            setErrorInfo(that.errorInfo());
        }
        return *this;
    }

    CVirtualBox & operator=(const CVirtualBox & that);

    template<class OI> CVirtualBox & operator=(OI * aIface)
    {
        attach(aIface);
        return *this;
    }

    CVirtualBox & operator=(IVirtualBox * aIface);

#ifdef VBOX_WITH_LESS_VIRTUALBOX_INCLUDING
const IID &getIID() const RT_OVERRIDE;
#endif

    /* Attributes (properties): */
    QString GetVersion() const;
    QString GetVersionNormalized() const;
    ULONG GetRevision() const;
    QString GetPackageType() const;
    QString GetAPIVersion() const;
    LONG64 GetAPIRevision() const;
    QString GetHomeFolder() const;
    QString GetSettingsFilePath() const;
    CHost GetHost() const;
    CSystemProperties GetSystemProperties() const;
    QVector<CMachine> GetMachines() const;
    QVector<QString> GetMachineGroups() const;
    QVector<CMedium> GetHardDisks() const;
    QVector<CMedium> GetDVDImages() const;
    QVector<CMedium> GetFloppyImages() const;
    QVector<CProgress> GetProgressOperations() const;
    QVector<CGuestOSType> GetGuestOSTypes() const;
    QVector<QString> GetGuestOSFamilies() const;
    QVector<CSharedFolder> GetSharedFolders() const;
    CPerformanceCollector GetPerformanceCollector() const;
    QVector<CDHCPServer> GetDHCPServers() const;
    QVector<CNATNetwork> GetNATNetworks() const;
    CEventSource GetEventSource() const;
    CExtPackManager GetExtensionPackManager() const;
    QVector<QString> GetInternalNetworks() const;
    QVector<CHostOnlyNetwork> GetHostOnlyNetworks() const;
    QVector<QString> GetGenericNetworkDrivers() const;
    QVector<CCloudNetwork> GetCloudNetworks() const;
    CCloudProviderManager GetCloudProviderManager() const;

    /* Methods: */
    QString ComposeMachineFilename(const QString & aName, const QString & aGroup, const QString & aCreateFlags, const QString & aBaseFolder);
    CPlatformProperties GetPlatformProperties(KPlatformArchitecture aArchitecture);
    CMachine CreateMachine(const QString & aSettingsFile, const QString & aName, KPlatformArchitecture aPlatform, const QVector<QString> & aGroups, const QString & aOsTypeId, const QString & aFlags, const QString & aCipher, const QString & aPasswordId, const QString & aPassword);
    CMachine OpenMachine(const QString & aSettingsFile, const QString & aPassword);
    void RegisterMachine(const CMachine & aMachine);
    CMachine FindMachine(const QString & aNameOrId) const;
    QVector<CMachine> GetMachinesByGroups(const QVector<QString> & aGroups);
    QVector<KMachineState> GetMachineStates(const QVector<CMachine> & aMachines);
    CAppliance CreateAppliance();
    CUnattended CreateUnattendedInstaller();
    CMedium CreateMedium(const QString & aFormat, const QString & aLocation, KAccessMode aAccessMode, KDeviceType aADeviceTypeType);
    CMedium OpenMedium(const QString & aLocation, KDeviceType aDeviceType, KAccessMode aAccessMode, BOOL aForceNewUuid);
    CGuestOSType GetGuestOSType(const QString & aId);
    QVector<QString> GetGuestOSSubtypesByFamilyId(const QString & aFamily);
    QVector<QString> GetGuestOSDescsBySubtype(const QString & aOSSubtype);
    void CreateSharedFolder(const QString & aName, const QString & aHostPath, BOOL aWritable, BOOL aAutomount, const QString & aAutoMountPoint);
    void RemoveSharedFolder(const QString & aName);
    QVector<QString> GetExtraDataKeys();
    QString GetExtraData(const QString & aKey);
    void SetExtraData(const QString & aKey, const QString & aValue);
    void SetSettingsSecret(const QString & aPassword);
    CDHCPServer CreateDHCPServer(const QString & aName);
    CDHCPServer FindDHCPServerByNetworkName(const QString & aName);
    void RemoveDHCPServer(const CDHCPServer & aServer);
    CNATNetwork CreateNATNetwork(const QString & aNetworkName);
    CNATNetwork FindNATNetworkByName(const QString & aNetworkName);
    void RemoveNATNetwork(const CNATNetwork & aNetwork);
    CHostOnlyNetwork CreateHostOnlyNetwork(const QString & aNetworkName);
    CHostOnlyNetwork FindHostOnlyNetworkByName(const QString & aNetworkName);
    CHostOnlyNetwork FindHostOnlyNetworkById(QUuid aId);
    void RemoveHostOnlyNetwork(const CHostOnlyNetwork & aNetwork);
    CCloudNetwork CreateCloudNetwork(const QString & aNetworkName);
    CCloudNetwork FindCloudNetworkByName(const QString & aNetworkName);
    void RemoveCloudNetwork(const CCloudNetwork & aNetwork);
    BOOL CheckFirmwarePresent(KPlatformArchitecture aPlatformArchitecture, KFirmwareType aFirmwareType, const QString & aVersion, QString & aUrl, QString & aFile);
    CProgress FindProgressById(QUuid aId);
    void GetTrackedObject(const QString & aTrObjId, CUnknown & aPIface, KTrackedObjectState & aState, LONG64 & aCreationTime, LONG64 & aDeletionTime);
    QVector<QString> GetTrackedObjectIds(const QString & aName);

    /* ExtraData helpers: */
    void SetExtraDataBool(const QString &strKey, bool fValue);
    bool GetExtraDataBool(const QString &strKey, bool fDef = true);
    void SetExtraDataInt(const QString &strKey, int value);
    int GetExtraDataInt(const QString &strKey, int def = 0);
    void SetExtraDataRect(const QString &strKey, const QRect &value);
    QRect GetExtraDataRect(const QString &strKey, const QRect &def = QRect());
    void SetExtraDataStringList(const QString &strKey, const QStringList &value);
    QStringList GetExtraDataStringList(const QString &strKey, QStringList def = QStringList());
    void SetExtraDataIntList(const QString &strKey, const QList<int> &value);
    QList<int> GetExtraDataIntList(const QString &strKey, QList<int> def = QList<int>());

    /* Friend wrappers: */
    friend class CUnknown;
    friend class CMachine;
    friend class CWebsessionManager;
    friend class CVirtualBoxClient;
};

/* Let QMetaType know about generated interface: */
Q_DECLARE_METATYPE(CVirtualBox);

#endif /* __CVirtualBox_h__ */

