// python wrapper for vtkRasterReprojectionFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkRasterReprojectionFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkRasterReprojectionFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkRasterReprojectionFilter_ClassNew(); }


static PyObject *
PyvtkRasterReprojectionFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkRasterReprojectionFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkRasterReprojectionFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkRasterReprojectionFilter *tempr = vtkRasterReprojectionFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRasterReprojectionFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkRasterReprojectionFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkRasterReprojectionFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkRasterReprojectionFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_SetInputProjection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInputProjection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInputProjection(temp0);
    }
    else
    {
      op->vtkRasterReprojectionFilter::SetInputProjection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetInputProjection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputProjection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetInputProjection() :
      op->vtkRasterReprojectionFilter::GetInputProjection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_SetOutputProjection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputProjection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputProjection(temp0);
    }
    else
    {
      op->vtkRasterReprojectionFilter::SetOutputProjection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetOutputProjection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputProjection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetOutputProjection() :
      op->vtkRasterReprojectionFilter::GetOutputProjection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_SetOutputDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetOutputDimensions(temp0, temp1);
    }
    else
    {
      op->vtkRasterReprojectionFilter::SetOutputDimensions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkRasterReprojectionFilter_SetOutputDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetOutputDimensions(temp0);
    }
    else
    {
      op->vtkRasterReprojectionFilter::SetOutputDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkRasterReprojectionFilter_SetOutputDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkRasterReprojectionFilter_SetOutputDimensions_s1(self, args);
    case 1:
      return PyvtkRasterReprojectionFilter_SetOutputDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOutputDimensions");
  return nullptr;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetOutputDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetOutputDimensions() :
      op->vtkRasterReprojectionFilter::GetOutputDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_SetNoDataValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNoDataValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNoDataValue(temp0);
    }
    else
    {
      op->vtkRasterReprojectionFilter::SetNoDataValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetNoDataValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNoDataValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetNoDataValue() :
      op->vtkRasterReprojectionFilter::GetNoDataValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_SetMaxError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxError(temp0);
    }
    else
    {
      op->vtkRasterReprojectionFilter::SetMaxError(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetMaxErrorMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxErrorMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxErrorMinValue() :
      op->vtkRasterReprojectionFilter::GetMaxErrorMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetMaxErrorMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxErrorMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxErrorMaxValue() :
      op->vtkRasterReprojectionFilter::GetMaxErrorMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetMaxError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxError() :
      op->vtkRasterReprojectionFilter::GetMaxError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_SetResamplingAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResamplingAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetResamplingAlgorithm(temp0);
    }
    else
    {
      op->vtkRasterReprojectionFilter::SetResamplingAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetResamplingAlgorithmMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResamplingAlgorithmMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetResamplingAlgorithmMinValue() :
      op->vtkRasterReprojectionFilter::GetResamplingAlgorithmMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkRasterReprojectionFilter_GetResamplingAlgorithmMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResamplingAlgorithmMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkRasterReprojectionFilter *op = static_cast<vtkRasterReprojectionFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetResamplingAlgorithmMaxValue() :
      op->vtkRasterReprojectionFilter::GetResamplingAlgorithmMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkRasterReprojectionFilter_Methods[] = {
  {"IsTypeOf", PyvtkRasterReprojectionFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkRasterReprojectionFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkRasterReprojectionFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkRasterReprojectionFilter\nC++: static vtkRasterReprojectionFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkRasterReprojectionFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkRasterReprojectionFilter\nC++: vtkRasterReprojectionFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkRasterReprojectionFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkRasterReprojectionFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetInputProjection", PyvtkRasterReprojectionFilter_SetInputProjection, METH_VARARGS,
   "SetInputProjection(self, _arg:str) -> None\nC++: virtual void SetInputProjection(const char *_arg)\n\nSet the map-projection string for the input image data. This\nshould *only* be used for nonstandard image inputs, when the\nMAP_PROJECTION is not embedded as field data. Can be specified\nusing any string formats supported by GDAL, such as \"well known\ntext\" (WKT) formats (GEOGS[]), or shorter \"user string\" formats,\nsuch as EPSG:3857.\n"},
  {"GetInputProjection", PyvtkRasterReprojectionFilter_GetInputProjection, METH_VARARGS,
   "GetInputProjection(self) -> str\nC++: virtual char *GetInputProjection()\n\n"},
  {"SetOutputProjection", PyvtkRasterReprojectionFilter_SetOutputProjection, METH_VARARGS,
   "SetOutputProjection(self, _arg:str) -> None\nC++: virtual void SetOutputProjection(const char *_arg)\n\nSet the map-projection string for the output image data.\n"},
  {"GetOutputProjection", PyvtkRasterReprojectionFilter_GetOutputProjection, METH_VARARGS,
   "GetOutputProjection(self) -> str\nC++: virtual char *GetOutputProjection()\n\n"},
  {"SetOutputDimensions", PyvtkRasterReprojectionFilter_SetOutputDimensions, METH_VARARGS,
   "SetOutputDimensions(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetOutputDimensions(int _arg1, int _arg2)\nSetOutputDimensions(self, _arg:(int, int)) -> None\nC++: void SetOutputDimensions(const int _arg[2])\n\nSet the width and height of the output image. It is recommended\nto leave this variable unset, in which case, the filter will use\nthe GDAL suggested dimensions to construct the output image. This\nmethod can be used to override this, and impose specific output\nimage dimensions.\n"},
  {"GetOutputDimensions", PyvtkRasterReprojectionFilter_GetOutputDimensions, METH_VARARGS,
   "GetOutputDimensions(self) -> (int, int)\nC++: virtual int *GetOutputDimensions()\n\n"},
  {"SetNoDataValue", PyvtkRasterReprojectionFilter_SetNoDataValue, METH_VARARGS,
   "SetNoDataValue(self, _arg:float) -> None\nC++: virtual void SetNoDataValue(double _arg)\n\nThe data value to use internally to represent blank points in\nGDAL datasets. By default, this will be set to the minimum value\nfor the input data type.\n"},
  {"GetNoDataValue", PyvtkRasterReprojectionFilter_GetNoDataValue, METH_VARARGS,
   "GetNoDataValue(self) -> float\nC++: virtual double GetNoDataValue()\n\n"},
  {"SetMaxError", PyvtkRasterReprojectionFilter_SetMaxError, METH_VARARGS,
   "SetMaxError(self, _arg:float) -> None\nC++: virtual void SetMaxError(double _arg)\n\nSet the maximum error, measured in input pixels, that is allowed\nin approximating the GDAL reprojection transformation. The\ndefault is 0.0, for exact calculations.\n"},
  {"GetMaxErrorMinValue", PyvtkRasterReprojectionFilter_GetMaxErrorMinValue, METH_VARARGS,
   "GetMaxErrorMinValue(self) -> float\nC++: virtual double GetMaxErrorMinValue()\n\n"},
  {"GetMaxErrorMaxValue", PyvtkRasterReprojectionFilter_GetMaxErrorMaxValue, METH_VARARGS,
   "GetMaxErrorMaxValue(self) -> float\nC++: virtual double GetMaxErrorMaxValue()\n\n"},
  {"GetMaxError", PyvtkRasterReprojectionFilter_GetMaxError, METH_VARARGS,
   "GetMaxError(self) -> float\nC++: virtual double GetMaxError()\n\n"},
  {"SetResamplingAlgorithm", PyvtkRasterReprojectionFilter_SetResamplingAlgorithm, METH_VARARGS,
   "SetResamplingAlgorithm(self, _arg:int) -> None\nC++: virtual void SetResamplingAlgorithm(int _arg)\n\nSet the pixel resampling algorithm. Choices range between 0 and\n6: 0 = Nearest Neighbor (default) 1 = Bilinear 2 = Cubic 3 =\nCubicSpline 4 = Lanczos 5 = Average 6 = Mode\n"},
  {"GetResamplingAlgorithmMinValue", PyvtkRasterReprojectionFilter_GetResamplingAlgorithmMinValue, METH_VARARGS,
   "GetResamplingAlgorithmMinValue(self) -> int\nC++: virtual int GetResamplingAlgorithmMinValue()\n\n"},
  {"GetResamplingAlgorithmMaxValue", PyvtkRasterReprojectionFilter_GetResamplingAlgorithmMaxValue, METH_VARARGS,
   "GetResamplingAlgorithmMaxValue(self) -> int\nC++: virtual int GetResamplingAlgorithmMaxValue()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkRasterReprojectionFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("input_projection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRasterReprojectionFilter_GetInputProjection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRasterReprojectionFilter_SetInputProjection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRasterReprojectionFilter_SetInputProjection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInputProjection/SetInputProjection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_projection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRasterReprojectionFilter_GetOutputProjection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRasterReprojectionFilter_SetOutputProjection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRasterReprojectionFilter_SetOutputProjection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputProjection/SetOutputProjection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRasterReprojectionFilter_GetOutputDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRasterReprojectionFilter_SetOutputDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRasterReprojectionFilter_SetOutputDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputDimensions/SetOutputDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("no_data_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRasterReprojectionFilter_GetNoDataValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRasterReprojectionFilter_SetNoDataValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRasterReprojectionFilter_SetNoDataValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNoDataValue/SetNoDataValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_error"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkRasterReprojectionFilter_GetMaxError(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRasterReprojectionFilter_SetMaxError(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRasterReprojectionFilter_SetMaxError(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxError/SetMaxError\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("resampling_algorithm"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkRasterReprojectionFilter_SetResamplingAlgorithm(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkRasterReprojectionFilter_SetResamplingAlgorithm(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetResamplingAlgorithm\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkRasterReprojectionFilter_Doc =
  "vtkRasterReprojectionFilter - Transform a VTK image data to a\ndifferent projection.\n\n"
  "Superclass: vtkImageAlgorithm\n\n"
  "Applies map reprojection to vtkUniformGrid or vtkImageData.\n"
  "Internally uses GDAL/Proj4 for the reprojection calculations.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkRasterReprojectionFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkGeovisGDAL.vtkRasterReprojectionFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkRasterReprojectionFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkRasterReprojectionFilter_StaticNew()
{
  return vtkRasterReprojectionFilter::New();
}

PyObject *PyvtkRasterReprojectionFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkRasterReprojectionFilter_Type, PyvtkRasterReprojectionFilter_Methods,
    "vtkRasterReprojectionFilter",
 &PyvtkRasterReprojectionFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkImageAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkRasterReprojectionFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkRasterReprojectionFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkRasterReprojectionFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkRasterReprojectionFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

