// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_WdgF2Basis.h"

const char *Basis_HGrad_WdgF2Basis =
"RealT uu = 1.0 - rr - ss;\n"
"RealT rs = rr * ss;\n"
"RealT tp = 1. + tt;\n"
"RealT tm = 1. - tt;\n"
"\n"
"basis[0] = -0.5 * tt * tm * uu * (1.0 - 2.0 * (rr + ss) + 3.0 * rs);\n"
"basis[1] = -0.5 * tt * tm * (rr - 2.0 * (uu * rr + rs) + 3.0 * uu * rs);\n"
"basis[2] = -0.5 * tt * tm * (ss - 2.0 * (uu * ss + rs) + 3.0 * uu * rs);\n"
"basis[3] = 0.5 * tt * tp * uu * (1.0 - 2.0 * (rr + ss) + 3.0 * rs);\n"
"basis[4] = 0.5 * tt * tp * (rr - 2.0 * (uu * rr + rs) + 3.0 * uu * rs);\n"
"basis[5] = 0.5 * tt * tp * (ss - 2.0 * (uu * ss + rs) + 3.0 * uu * rs);\n"
"basis[6] = -0.5 * tt * tm * uu * (4.0 * rr - 12.0 * rs);\n"
"basis[7] = -0.5 * tt * tm * (4.0 * rs - 12.0 * uu * rs);\n"
"basis[8] = -0.5 * tt * tm * uu * (4.0 * ss - 12.0 * rs);\n"
"basis[9] = 0.5 * tt * tp * uu * (4.0 * rr - 12.0 * rs);\n"
"basis[10] = 0.5 * tt * tp * (4.0 * rs - 12.0 * uu * rs);\n"
"basis[11] = 0.5 * tt * tp * uu * (4.0 * ss - 12.0 * rs);\n"
"basis[12] = tp * tm * uu * (1.0 - 2.0 * (rr + ss) + 3.0 * rs);\n"
"basis[13] = tp * tm * (rr - 2.0 * (uu * rr + rs) + 3.0 * uu * rs);\n"
"basis[14] = tp * tm * (ss - 2.0 * (uu * ss + rs) + 3.0 * uu * rs);\n"
"basis[15] = -0.5 * 27.0 * tt * tm * uu * rs;\n"
"basis[16] = 0.5 * 27.0 * tt * tp * uu * rs;\n"
"basis[17] = tp * tm * uu * (4.0 * rr - 12.0 * rs);\n"
"basis[18] = tp * tm * (4.0 * rs - 12.0 * uu * rs);\n"
"basis[19] = tp * tm * uu * (4.0 * ss - 12.0 * rs);\n"
"basis[20] = 27.0 * tp * tm * uu * rs;\n"
"";
