// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkCellGridShaderTessellationEvaluation.h"

const char *vtkCellGridShaderTessellationEvaluation =
"//VTK::System::Dec\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"//VTK::Camera::Dec\n"
"\n"
"/// A comma separated list of strings with one or more of the following options:\n"
"/// 1. The shape of the abstract patch which will be tessellated - isolines, triangles, quads.\n"
"/// 2. The type of spacing between tessellated vertices - cw, ccw\n"
"/// 3. The ordering of tessellated vertices that primitive generator must use - isolines, triangles, quads\n"
"/// 4. Whether points must be rendered - point_mode\n"
"layout({TessellationOptions}) in;\n"
"\n"
"// The indices of all DOFs for all cells of this shape.\n"
"uniform highp isamplerBuffer shape_conn;\n"
"// The (x,y,z) points of each DOF in the entire mesh.\n"
"uniform samplerBuffer shape_vals;\n"
"\n"
"patch in int cellIdTCSOutput;\n"
"patch in int sideIdTCSOutput;\n"
"patch in int instanceIdTCSOutput;\n"
"in vec3 pcoordTCSOutput[];\n"
"\n"
"flat out int cellIdTESOutput;\n"
"flat out int instanceIdTESOutput;\n"
"#if {UsesGeometryShaders}\n"
"smooth out vec3 patchDistanceTESOutput;\n"
"#endif\n"
"\n"
"smooth out vec3 normalVCTESOutput;\n"
"smooth out vec4 vertexVCTESOutput;\n"
"smooth out vec3 pcoordTESOutput;\n"
"\n"
"{commonDefs}\n"
"{cellEval}\n"
"{cellUtil}\n"
"\n"
"vec3 interpolate_2(in vec3 v0, in vec3 v1)\n"
"{{\n"
"  return vec3(gl_TessCoord.x) * v0 + vec3(1.0 - gl_TessCoord.x) * v1;\n"
"}}\n"
"vec4 interpolate_2(in vec4 v0, in vec4 v1)\n"
"{{\n"
"  return vec4(gl_TessCoord.x) * v0 + vec4(1.0 - gl_TessCoord.x) * v1;\n"
"}}\n"
"vec3 interpolate_3(in vec3 v0, in vec3 v1, in vec3 v2)\n"
"{{\n"
"  return vec3(gl_TessCoord.x) * v0 + vec3(gl_TessCoord.y) * v1 + vec3(gl_TessCoord.z) * v2;\n"
"}}\n"
"vec4 interpolate_3(in vec4 v0, in vec4 v1, in vec4 v2)\n"
"{{\n"
"  return vec4(gl_TessCoord.x) * v0 + vec4(gl_TessCoord.y) * v1 + vec4(gl_TessCoord.z) * v2;\n"
"}}\n"
"vec3 interpolate_4(in vec3 v0, in vec3 v1, in vec3 v2, in vec3 v3)\n"
"{{\n"
"  vec3 a = mix(v0, v1, gl_TessCoord.x);\n"
"  vec3 b = mix(v3, v2, gl_TessCoord.x);\n"
"  return mix(a, b, gl_TessCoord.y);\n"
"}}\n"
"vec4 interpolate_4(in vec4 v0, in vec4 v1, in vec4 v2, in vec4 v3)\n"
"{{\n"
"  vec4 a = mix(v0, v1, gl_TessCoord.x);\n"
"  vec4 b = mix(v3, v2, gl_TessCoord.x);\n"
"  return mix(a, b, gl_TessCoord.y);\n"
"}}\n"
"\n"
"void main()\n"
"{{\n"
"  float shapeValues[{ShapeCoeffPerCell}];\n"
"  vec3 pcoord;\n"
"  vec4 position;\n"
"  vec3 vertexNormalVC;\n"
"  float coordinateArray[{ShapeNumValPP}];\n"
"  vec3 eyeNormalMC = vec3(0.0f, 0.0f, 1.0f);\n"
"\n"
"  if ({PatchSize} == 2)\n"
"  {{\n"
"    pcoord = interpolate_2(pcoordTCSOutput[0], pcoordTCSOutput[1]);\n"
"  }}\n"
"  else if ({PatchSize} == 3)\n"
"  {{\n"
"    pcoord = interpolate_3(pcoordTCSOutput[0], pcoordTCSOutput[1], pcoordTCSOutput[2]);\n"
"  }}\n"
"  else if ({PatchSize} == 4)\n"
"  {{\n"
"    pcoord = interpolate_4(pcoordTCSOutput[0], pcoordTCSOutput[1], pcoordTCSOutput[2], pcoordTCSOutput[3]);\n"
"  }}\n"
"  shapeValuesForCell(cellIdTCSOutput, shapeValues);\n"
"  shapeEvaluateAt(pcoord, shapeValues, coordinateArray);\n"
"  if ({ShapeNumValPP} == 3)\n"
"  {{\n"
"    position.x = coordinateArray[0];\n"
"    position.y = coordinateArray[1];\n"
"    position.z = coordinateArray[2];\n"
"  }}\n"
"  else\n"
"  {{\n"
"    position.xyz = vec3(1.0); // fallback\n"
"  }}\n"
"  position.w = 1.0;\n"
"  vec3 vertexNormalMC = normalToSideAt(sideIdTCSOutput, shapeValues, pcoord, -eyeNormalMC);\n"
"\n"
"  // Normal vectors are transformed in a different way than vertices.\n"
"  // Instead of pre-multiplying with MCDCMatrix, a different matrix is used.\n"
"  // This `normalMatrix` is computed on the CPU. It must be the result of the following:\n"
"  // normalMatrix = inverse(ModelToWorld X WorldToView)\n"
"  // Read more about normal matrix at http://www.songho.ca/opengl/gl_normaltransform.html\n"
"  if ((DrawingCellsNotSides && NumPtsPerCell <= 2) || (!DrawingCellsNotSides && NumPtsPerSide <= 2))\n"
"  {{\n"
"    // for lines or vertices, the normal will always face the camera.\n"
"    vertexNormalVC = vec3(vertexNormalMC.xy, 1.0f);\n"
"  }}\n"
"  else\n"
"  {{\n"
"    vertexNormalVC = normalMatrix * vertexNormalMC;\n"
"  }}\n"
"\n"
"  // Transform the vertex by the model-to-device coordinate matrix.\n"
"  // This matrix must be the result of the following multiplication:\n"
"  // MCDCMatrix = ModelToWorld X WorldToView X ViewToDisplay\n"
"  gl_Position = MCDCMatrix * position;\n"
"  cellIdTESOutput = cellIdTCSOutput;\n"
"  instanceIdTESOutput = instanceIdTCSOutput;\n"
"  vertexVCTESOutput = MCVCMatrix * position;\n"
"  normalVCTESOutput = vertexNormalVC;\n"
"#if {UsesGeometryShaders}\n"
"  patchDistanceTESOutput = gl_TessCoord;\n"
"#endif\n"
"  pcoordTESOutput = pcoord;\n"
"}}\n"
"";
