// java wrapper for vtkScatterPlotMatrix object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkScatterPlotMatrix.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkChartMatrix_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkScatterPlotMatrix_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkScatterPlotMatrix",dType)) { return me; }
  if ((res= vtkChartMatrix_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_Update_14(JNIEnv* env, jobject obj)
{

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->Update();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScatterPlotMatrix_Paint_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetScene_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContextScene * temp0;
  temp0 = static_cast<vtkContextScene*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScene(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetAnnotationLink_17(JNIEnv* env, jobject obj)
{
  vtkAnnotationLink * temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnnotationLink();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetInput_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTable * temp0;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetColumnVisibility_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  vtkStdString temp0;
  bool   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColumnVisibility(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_InsertVisibleColumn_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  vtkStdString temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertVisibleColumn(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScatterPlotMatrix_GetColumnVisibility_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetColumnVisibilityAll_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColumnVisibilityAll(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetVisibleColumns_113(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVisibleColumns();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetVisibleColumns_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVisibleColumns(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetNumberOfBins_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfBins(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetNumberOfBins_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfBins();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetPlotMarkerStyle_117(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotMarkerStyle(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetPlotMarkerSize_118(JNIEnv* env, jobject obj,jint id0,jfloat id1)
{
  int   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlotMarkerSize(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetPlotType_119(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlotType(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetTitle_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScatterPlotMatrix_GetTitle_121(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetTitleProperties_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleProperties(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetTitleProperties_123(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleProperties();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetGridVisibility_124(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
  int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridVisibility(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScatterPlotMatrix_GetGridVisibility_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetAxisLabelVisibility_126(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
  int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelVisibility(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScatterPlotMatrix_GetAxisLabelVisibility_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLabelVisibility(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetAxisLabelProperties_128(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkTextProperty * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id1));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelProperties(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetAxisLabelProperties_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkTextProperty * temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLabelProperties(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetAxisLabelNotation_130(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelNotation(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetAxisLabelNotation_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLabelNotation(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetAxisLabelPrecision_132(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisLabelPrecision(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetAxisLabelPrecision_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisLabelPrecision(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetTooltipNotation_134(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTooltipNotation(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetTooltipPrecision_135(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTooltipPrecision(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetTooltipNotation_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTooltipNotation(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetTooltipPrecision_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTooltipPrecision(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetTooltip_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTooltipItem * temp0;
  temp0 = static_cast<vtkTooltipItem*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTooltip(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetTooltip_139(JNIEnv* env, jobject obj)
{
  vtkTooltipItem * temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTooltip();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetIndexedLabels_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexedLabels(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetIndexedLabels_141(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndexedLabels();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_UpdateSettings_142(JNIEnv* env, jobject obj)
{

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateSettings();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_UpdateChartSettings_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateChartSettings(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetSelectionMode_144(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetSelectionMode_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionMode();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScatterPlotMatrix_GetColumnName_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkStdString   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColumnName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkScatterPlotMatrix_GetRowName_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkStdString   temp20;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRowName(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_SetNumberOfFrames_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfFrames(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkScatterPlotMatrix_GetNumberOfFrames_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFrames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_ClearAnimationPath_150(JNIEnv* env, jobject obj)
{

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearAnimationPath();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetNumberOfAnimationPathElements_151(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfAnimationPathElements();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkScatterPlotMatrix_BeginAnimationPath_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindowInteractor * temp0;
  bool   temp20;
  temp0 = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BeginAnimationPath(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkScatterPlotMatrix_AdvanceAnimation_153(JNIEnv* env, jobject obj)
{

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdvanceAnimation();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkScatterPlotMatrix_GetMainChart_154(JNIEnv* env, jobject obj)
{
  vtkChart * temp20;

  vtkScatterPlotMatrix* op = static_cast<vtkScatterPlotMatrix*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMainChart();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkScatterPlotMatrix_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkScatterPlotMatrix::New());
}
