// java wrapper for vtkPerspectiveTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPerspectiveTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHomogeneousTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPerspectiveTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPerspectiveTransform",dType)) { return me; }
  if ((res= vtkHomogeneousTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPerspectiveTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPerspectiveTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPerspectiveTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPerspectiveTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Identity_14(JNIEnv* env, jobject obj)
{

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Identity();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Inverse_15(JNIEnv* env, jobject obj)
{

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_AdjustViewport_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustViewport(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_AdjustZBuffer_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustZBuffer(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Ortho_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Ortho(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Frustum_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Frustum(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Perspective_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Perspective(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Shear_111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Shear(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Stereo_112(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Stereo(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_SetupCamera_113(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetupCamera(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_SetupCamera_114(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetupCamera(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Translate_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Translate_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Translate_117(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Translate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_RotateWXYZ_118(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_RotateWXYZ_119(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_RotateWXYZ_120(JNIEnv* env, jobject obj,jdouble id0,jfloatArray id1)
{
  double   temp0;
  float temp1[3];
  temp0 = id0;
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateWXYZ(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_RotateX_121(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateX(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_RotateY_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateY(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_RotateZ_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateZ(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Scale_124(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Scale_125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Scale_126(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Scale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_SetMatrix_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_SetMatrix_128(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Concatenate_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Concatenate_130(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Concatenate_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHomogeneousTransform * temp0;
  temp0 = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Concatenate(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_PreMultiply_132(JNIEnv* env, jobject obj)
{

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreMultiply();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_PostMultiply_133(JNIEnv* env, jobject obj)
{

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->PostMultiply();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPerspectiveTransform_GetNumberOfConcatenatedTransforms_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfConcatenatedTransforms();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPerspectiveTransform_GetConcatenatedTransform_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkHomogeneousTransform * temp20;
  temp0 = id0;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConcatenatedTransform(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_SetInput_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHomogeneousTransform * temp0;
  temp0 = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPerspectiveTransform_GetInput_137(JNIEnv* env, jobject obj)
{
  vtkHomogeneousTransform * temp20;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPerspectiveTransform_GetInverseFlag_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverseFlag();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Push_139(JNIEnv* env, jobject obj)
{

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Push();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPerspectiveTransform_Pop_140(JNIEnv* env, jobject obj)
{

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Pop();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPerspectiveTransform_MakeTransform_141(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPerspectiveTransform_CircuitCheck_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractTransform * temp0;
  int   temp20;
  temp0 = static_cast<vtkAbstractTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CircuitCheck(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPerspectiveTransform_GetMTime_143(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPerspectiveTransform* op = static_cast<vtkPerspectiveTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPerspectiveTransform_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPerspectiveTransform::New());
}
