// java wrapper for vtkCamera object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCamera.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCamera_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCamera",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCamera_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCamera_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetPosition_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetPosition_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetPosition_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetFocalPoint_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetFocalPoint_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetFocalPoint_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetViewUp_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewUp(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetViewUp_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewUp(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetViewUp_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewUp();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_OrthogonalizeViewUp_113(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->OrthogonalizeViewUp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetDistance_114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetDistance_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistance();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetDirectionOfProjection_116(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirectionOfProjection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Dolly_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Dolly(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetRoll_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRoll(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetRoll_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoll();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Roll_120(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Roll(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Azimuth_121(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Azimuth(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Yaw_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Yaw(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Elevation_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Elevation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Pitch_124(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Pitch(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetParallelProjection_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParallelProjection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCamera_GetParallelProjection_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParallelProjection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_ParallelProjectionOn_127(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParallelProjectionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_ParallelProjectionOff_128(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParallelProjectionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetUseHorizontalViewAngle_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseHorizontalViewAngle(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCamera_GetUseHorizontalViewAngle_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseHorizontalViewAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseHorizontalViewAngleOn_131(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseHorizontalViewAngleOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseHorizontalViewAngleOff_132(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseHorizontalViewAngleOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetViewAngle_133(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetViewAngle_134(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetParallelScale_135(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParallelScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetParallelScale_136(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetParallelScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Zoom_137(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Zoom(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetClippingRange_138(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClippingRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetClippingRange_139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClippingRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetClippingRange_140(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClippingRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetThickness_141(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetThickness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetThickness_142(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetWindowCenter_143(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowCenter(temp0,temp1);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetWindowCenter_144(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindowCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetObliqueAngles_145(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetObliqueAngles(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_ApplyTransform_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTransform * temp0;
  temp0 = static_cast<vtkTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->ApplyTransform(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetViewPlaneNormal_147(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewPlaneNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetViewShear_148(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewShear(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetViewShear_149(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewShear(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetViewShear_150(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewShear();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetEyeAngle_151(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEyeAngle(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetEyeAngle_152(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEyeAngle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetFocalDisk_153(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalDisk(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetFocalDisk_154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalDisk();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetFocalDistance_155(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetFocalDistance_156(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetUseOffAxisProjection_157(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseOffAxisProjection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCamera_GetUseOffAxisProjection_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseOffAxisProjection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseOffAxisProjectionOn_159(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOffAxisProjectionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseOffAxisProjectionOff_160(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOffAxisProjectionOff();

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetOffAxisClippingAdjustment_161(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffAxisClippingAdjustment();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetScreenBottomLeft_162(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenBottomLeft(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetScreenBottomLeft_163(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenBottomLeft(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetScreenBottomLeft_164(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenBottomLeft();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetScreenBottomRight_165(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenBottomRight(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetScreenBottomRight_166(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenBottomRight(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetScreenBottomRight_167(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenBottomRight();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetScreenTopRight_168(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenTopRight(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetScreenTopRight_169(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScreenTopRight(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetScreenTopRight_170(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenTopRight();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetEyeSeparation_171(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEyeSeparation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetEyeSeparation_172(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEyeSeparation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetEyePosition_173(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEyePosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_GetEyePosition_174(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetEyePosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_GetStereoEyePosition_175(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetStereoEyePosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_GetEyePlaneNormal_176(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetEyePlaneNormal(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetEyeTransformMatrix_177(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEyeTransformMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetEyeTransformMatrix_178(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEyeTransformMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetEyeTransformMatrix_179(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEyeTransformMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetModelTransformMatrix_180(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelTransformMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetModelTransformMatrix_181(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelTransformMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetModelTransformMatrix_182(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelTransformMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetModelViewTransformMatrix_183(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelViewTransformMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetModelViewTransformObject_184(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelViewTransformObject();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetViewTransformMatrix_185(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewTransformMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetViewTransformObject_186(JNIEnv* env, jobject obj)
{
  vtkTransform * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewTransformObject();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetExplicitProjectionTransformMatrix_187(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExplicitProjectionTransformMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetExplicitProjectionTransformMatrix_188(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExplicitProjectionTransformMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetUseExplicitProjectionTransformMatrix_189(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseExplicitProjectionTransformMatrix(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCamera_GetUseExplicitProjectionTransformMatrix_190(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseExplicitProjectionTransformMatrix();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseExplicitProjectionTransformMatrixOn_191(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseExplicitProjectionTransformMatrixOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseExplicitProjectionTransformMatrixOff_192(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseExplicitProjectionTransformMatrixOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetExplicitAspectRatio_193(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExplicitAspectRatio(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetExplicitAspectRatio_194(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExplicitAspectRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetUseExplicitAspectRatio_195(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseExplicitAspectRatio(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCamera_GetUseExplicitAspectRatio_196(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseExplicitAspectRatio();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseExplicitAspectRatioOn_197(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseExplicitAspectRatioOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UseExplicitAspectRatioOff_198(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseExplicitAspectRatioOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetProjectionTransformMatrix_199(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  vtkMatrix4x4 * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionTransformMatrix(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetProjectionTransformObject_1100(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  vtkPerspectiveTransform * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionTransformObject(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetCompositeProjectionTransformMatrix_1101(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  vtkMatrix4x4 * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompositeProjectionTransformMatrix(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetProjectionTransformMatrix_1102(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  vtkMatrix4x4 * temp20;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionTransformMatrix(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetUserViewTransform_1103(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHomogeneousTransform * temp0;
  temp0 = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserViewTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetUserViewTransform_1104(JNIEnv* env, jobject obj)
{
  vtkHomogeneousTransform * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserViewTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetUserTransform_1105(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHomogeneousTransform * temp0;
  temp0 = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserTransform(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetUserTransform_1106(JNIEnv* env, jobject obj)
{
  vtkHomogeneousTransform * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_Render_1107(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetViewingRaysMTime_1108(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewingRaysMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_ViewingRaysModified_1109(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->ViewingRaysModified();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_GetFrustumPlanes_1110(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[24];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 24, &temp1[0]);

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetFrustumPlanes(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 24, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UpdateIdealShiftScale_1111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateIdealShiftScale(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetFocalPointShift_1112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPointShift();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetFocalPointScale_1113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPointScale();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetNearPlaneShift_1114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNearPlaneShift();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetNearPlaneScale_1115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNearPlaneScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetShiftScaleThreshold_1116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShiftScaleThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCamera_GetShiftScaleThreshold_1117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShiftScaleThreshold();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetOrientation_1118(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCamera_GetOrientationWXYZ_1119(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationWXYZ();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_ComputeViewPlaneNormal_1120(JNIEnv* env, jobject obj)
{

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeViewPlaneNormal();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetCameraLightTransformMatrix_1121(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCameraLightTransformMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_UpdateViewport_1122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderer * temp0;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateViewport(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCamera_GetStereo_1123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStereo();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetLeftEye_1124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeftEye(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCamera_GetLeftEye_1125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftEye();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_ShallowCopy_1126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCamera * temp0;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_DeepCopy_1127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCamera * temp0;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetFreezeFocalPoint_1128(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFreezeFocalPoint(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCamera_GetFreezeFocalPoint_1129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFreezeFocalPoint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetUseScissor_1130(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseScissor(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkCamera_GetUseScissor_1131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseScissor();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCamera_GetInformation_1132(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCamera_SetInformation_1133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCamera* op = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformation(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCamera_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCamera::New());
}
