// java wrapper for vtkLODActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLODActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLODActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLODActor",dType)) { return me; }
  if ((res= vtkActor_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_Render_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkMapper * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_ReleaseGraphicsResources_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_AddLODMapper_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMapper * temp0;
  temp0 = static_cast<vtkMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLODMapper(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_SetLowResFilter_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyDataAlgorithm * temp0;
  temp0 = static_cast<vtkPolyDataAlgorithm*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLowResFilter(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_SetMediumResFilter_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyDataAlgorithm * temp0;
  temp0 = static_cast<vtkPolyDataAlgorithm*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMediumResFilter(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODActor_GetLowResFilter_19(JNIEnv* env, jobject obj)
{
  vtkPolyDataAlgorithm * temp20;

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLowResFilter();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODActor_GetMediumResFilter_110(JNIEnv* env, jobject obj)
{
  vtkPolyDataAlgorithm * temp20;

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMediumResFilter();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLODActor_GetNumberOfCloudPoints_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCloudPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_SetNumberOfCloudPoints_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfCloudPoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLODActor_GetLODMappers_113(JNIEnv* env, jobject obj)
{
  vtkMapperCollection * temp20;

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLODMappers();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_Modified_114(JNIEnv* env, jobject obj)
{

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->Modified();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLODActor_ShallowCopy_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLODActor* op = static_cast<vtkLODActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLODActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLODActor::New());
}
