
/* Copyright (c) 2015-2025 Valve Corporation
 * Copyright (c) 2015-2025 LunarG, Inc.
 * Copyright (c) 2015-2017, 2019, 2021 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/*
 * This file is generated from the Khronos Vulkan XML API Registry.
 */

#include "api_dump_handwritten_functions.h"

// Autogen instance functions

template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkDestroyInstance", "instance, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyInstance<Format>(ApiDumpInstance::current(), instance, pAllocator);
        }
    }
    auto dispatch_key = get_dispatch_key(instance);
    instance_dispatch_table(instance)->DestroyInstance(instance, pAllocator);
    destroy_instance_dispatch_table(dispatch_key);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyInstance<Format>(ApiDumpInstance::current(), instance, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkEnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkEnumeratePhysicalDevices", "instance, pPhysicalDeviceCount, pPhysicalDevices", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkEnumeratePhysicalDevices<Format>(ApiDumpInstance::current(), instance, pPhysicalDeviceCount, pPhysicalDevices);
        }
    }
    VkResult result = instance_dispatch_table(instance)->EnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices);

    if (pPhysicalDeviceCount != nullptr && pPhysicalDevices != nullptr) {
        for (uint32_t i = 0; i < *pPhysicalDeviceCount; i++) {
            ApiDumpInstance::current().set_vk_instance(pPhysicalDevices[i], instance);
        }
    }
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkEnumeratePhysicalDevices<Format>(ApiDumpInstance::current(), instance, pPhysicalDeviceCount, pPhysicalDevices);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceFeatures", "physicalDevice, pFeatures", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceFeatures<Format>(ApiDumpInstance::current(), physicalDevice, pFeatures);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceFeatures(physicalDevice, pFeatures);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceFeatures<Format>(ApiDumpInstance::current(), physicalDevice, pFeatures);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceFormatProperties", "physicalDevice, format, pFormatProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceFormatProperties<Format>(ApiDumpInstance::current(), physicalDevice, format, pFormatProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceFormatProperties<Format>(ApiDumpInstance::current(), physicalDevice, format, pFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceImageFormatProperties", "physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceImageFormatProperties<Format>(ApiDumpInstance::current(), physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceImageFormatProperties<Format>(ApiDumpInstance::current(), physicalDevice, format, type, tiling, usage, flags, pImageFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceProperties", "physicalDevice, pProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceProperties<Format>(ApiDumpInstance::current(), physicalDevice, pProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceProperties(physicalDevice, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceProperties<Format>(ApiDumpInstance::current(), physicalDevice, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceQueueFamilyProperties", "physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceQueueFamilyProperties<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceQueueFamilyProperties<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceMemoryProperties", "physicalDevice, pMemoryProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceMemoryProperties<Format>(ApiDumpInstance::current(), physicalDevice, pMemoryProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceMemoryProperties<Format>(ApiDumpInstance::current(), physicalDevice, pMemoryProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSparseImageFormatProperties", "physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSparseImageFormatProperties<Format>(ApiDumpInstance::current(), physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSparseImageFormatProperties<Format>(ApiDumpInstance::current(), physicalDevice, format, type, samples, usage, tiling, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkEnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkEnumeratePhysicalDeviceGroups", "instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkEnumeratePhysicalDeviceGroups<Format>(ApiDumpInstance::current(), instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
        }
    }
    VkResult result = instance_dispatch_table(instance)->EnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkEnumeratePhysicalDeviceGroups<Format>(ApiDumpInstance::current(), instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceFeatures2", "physicalDevice, pFeatures", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceFeatures2<Format>(ApiDumpInstance::current(), physicalDevice, pFeatures);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceFeatures2(physicalDevice, pFeatures);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceFeatures2<Format>(ApiDumpInstance::current(), physicalDevice, pFeatures);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceProperties2", "physicalDevice, pProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceProperties2(physicalDevice, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceFormatProperties2", "physicalDevice, format, pFormatProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceFormatProperties2<Format>(ApiDumpInstance::current(), physicalDevice, format, pFormatProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceFormatProperties2<Format>(ApiDumpInstance::current(), physicalDevice, format, pFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceImageFormatProperties2", "physicalDevice, pImageFormatInfo, pImageFormatProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceImageFormatProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pImageFormatInfo, pImageFormatProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceImageFormatProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pImageFormatInfo, pImageFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceQueueFamilyProperties2", "physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceQueueFamilyProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceQueueFamilyProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceMemoryProperties2", "physicalDevice, pMemoryProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceMemoryProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pMemoryProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceMemoryProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pMemoryProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSparseImageFormatProperties2", "physicalDevice, pFormatInfo, pPropertyCount, pProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSparseImageFormatProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pFormatInfo, pPropertyCount, pProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSparseImageFormatProperties2<Format>(ApiDumpInstance::current(), physicalDevice, pFormatInfo, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalBufferProperties", "physicalDevice, pExternalBufferInfo, pExternalBufferProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalBufferProperties<Format>(ApiDumpInstance::current(), physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalBufferProperties<Format>(ApiDumpInstance::current(), physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalFenceProperties", "physicalDevice, pExternalFenceInfo, pExternalFenceProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalFenceProperties<Format>(ApiDumpInstance::current(), physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalFenceProperties<Format>(ApiDumpInstance::current(), physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalSemaphoreProperties", "physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalSemaphoreProperties<Format>(ApiDumpInstance::current(), physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalSemaphoreProperties<Format>(ApiDumpInstance::current(), physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceToolProperties", "physicalDevice, pToolCount, pToolProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceToolProperties<Format>(ApiDumpInstance::current(), physicalDevice, pToolCount, pToolProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceToolProperties(physicalDevice, pToolCount, pToolProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceToolProperties<Format>(ApiDumpInstance::current(), physicalDevice, pToolCount, pToolProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkDestroySurfaceKHR", "instance, surface, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroySurfaceKHR<Format>(ApiDumpInstance::current(), instance, surface, pAllocator);
        }
    }
    instance_dispatch_table(instance)->DestroySurfaceKHR(instance, surface, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroySurfaceKHR<Format>(ApiDumpInstance::current(), instance, surface, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfaceSupportKHR", "physicalDevice, queueFamilyIndex, surface, pSupported", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfaceSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, surface, pSupported);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfaceSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, surface, pSupported);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfaceCapabilitiesKHR", "physicalDevice, surface, pSurfaceCapabilities", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfaceCapabilitiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pSurfaceCapabilities);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfaceCapabilitiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pSurfaceCapabilities);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfaceFormatsKHR", "physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfaceFormatsKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfaceFormatsKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfacePresentModesKHR", "physicalDevice, surface, pPresentModeCount, pPresentModes", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfacePresentModesKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pPresentModeCount, pPresentModes);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfacePresentModesKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pPresentModeCount, pPresentModes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDevicePresentRectanglesKHR", "physicalDevice, surface, pRectCount, pRects", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDevicePresentRectanglesKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pRectCount, pRects);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDevicePresentRectanglesKHR<Format>(ApiDumpInstance::current(), physicalDevice, surface, pRectCount, pRects);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceDisplayPropertiesKHR", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceDisplayPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceDisplayPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceDisplayPlanePropertiesKHR", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceDisplayPlanePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceDisplayPlanePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetDisplayPlaneSupportedDisplaysKHR", "physicalDevice, planeIndex, pDisplayCount, pDisplays", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDisplayPlaneSupportedDisplaysKHR<Format>(ApiDumpInstance::current(), physicalDevice, planeIndex, pDisplayCount, pDisplays);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDisplayPlaneSupportedDisplaysKHR<Format>(ApiDumpInstance::current(), physicalDevice, planeIndex, pDisplayCount, pDisplays);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetDisplayModePropertiesKHR", "physicalDevice, display, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDisplayModePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, display, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDisplayModePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, display, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateDisplayModeKHR", "physicalDevice, display, pCreateInfo, pAllocator, pMode", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDisplayModeKHR<Format>(ApiDumpInstance::current(), physicalDevice, display, pCreateInfo, pAllocator, pMode);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->CreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDisplayModeKHR<Format>(ApiDumpInstance::current(), physicalDevice, display, pCreateInfo, pAllocator, pMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetDisplayPlaneCapabilitiesKHR", "physicalDevice, mode, planeIndex, pCapabilities", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDisplayPlaneCapabilitiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, mode, planeIndex, pCapabilities);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDisplayPlaneCapabilitiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, mode, planeIndex, pCapabilities);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateDisplayPlaneSurfaceKHR", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDisplayPlaneSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDisplayPlaneSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_XLIB_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateXlibSurfaceKHR", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateXlibSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateXlibSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkBool32 VKAPI_CALL vkGetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceXlibPresentationSupportKHR", "physicalDevice, queueFamilyIndex, dpy, visualID", "VkBool32");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceXlibPresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, dpy, visualID);
        }
    }
    VkBool32 result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkBool32", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceXlibPresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, dpy, visualID);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_XLIB_KHR
#if defined(VK_USE_PLATFORM_XCB_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateXcbSurfaceKHR", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateXcbSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateXcbSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkBool32 VKAPI_CALL vkGetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceXcbPresentationSupportKHR", "physicalDevice, queueFamilyIndex, connection, visual_id", "VkBool32");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceXcbPresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, connection, visual_id);
        }
    }
    VkBool32 result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkBool32", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceXcbPresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, connection, visual_id);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_XCB_KHR
#if defined(VK_USE_PLATFORM_WAYLAND_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateWaylandSurfaceKHR", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateWaylandSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateWaylandSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkBool32 VKAPI_CALL vkGetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceWaylandPresentationSupportKHR", "physicalDevice, queueFamilyIndex, display", "VkBool32");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceWaylandPresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, display);
        }
    }
    VkBool32 result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkBool32", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceWaylandPresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, display);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WAYLAND_KHR
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateAndroidSurfaceKHR", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateAndroidSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateAndroidSurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateWin32SurfaceKHR", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateWin32SurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateWin32SurfaceKHR<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkBool32 VKAPI_CALL vkGetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceWin32PresentationSupportKHR", "physicalDevice, queueFamilyIndex", "VkBool32");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceWin32PresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex);
        }
    }
    VkBool32 result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkBool32", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceWin32PresentationSupportKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileInfoKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceVideoCapabilitiesKHR", "physicalDevice, pVideoProfile, pCapabilities", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceVideoCapabilitiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pVideoProfile, pCapabilities);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceVideoCapabilitiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pVideoProfile, pCapabilities);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceVideoFormatPropertiesKHR", "physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount, pVideoFormatProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceVideoFormatPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount, pVideoFormatProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount, pVideoFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceVideoFormatPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount, pVideoFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceFeatures2KHR", "physicalDevice, pFeatures", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceFeatures2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pFeatures);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceFeatures2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pFeatures);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceProperties2KHR", "physicalDevice, pProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceProperties2KHR(physicalDevice, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceFormatProperties2KHR", "physicalDevice, format, pFormatProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceFormatProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, format, pFormatProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceFormatProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, format, pFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceImageFormatProperties2KHR", "physicalDevice, pImageFormatInfo, pImageFormatProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceImageFormatProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pImageFormatInfo, pImageFormatProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceImageFormatProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pImageFormatInfo, pImageFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceQueueFamilyProperties2KHR", "physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceQueueFamilyProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceQueueFamilyProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyPropertyCount, pQueueFamilyProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceMemoryProperties2KHR", "physicalDevice, pMemoryProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceMemoryProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pMemoryProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceMemoryProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pMemoryProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceSparseImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSparseImageFormatProperties2KHR", "physicalDevice, pFormatInfo, pPropertyCount, pProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSparseImageFormatProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pFormatInfo, pPropertyCount, pProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSparseImageFormatProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pFormatInfo, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkEnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkEnumeratePhysicalDeviceGroupsKHR", "instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkEnumeratePhysicalDeviceGroupsKHR<Format>(ApiDumpInstance::current(), instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
        }
    }
    VkResult result = instance_dispatch_table(instance)->EnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkEnumeratePhysicalDeviceGroupsKHR<Format>(ApiDumpInstance::current(), instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceExternalBufferPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalBufferPropertiesKHR", "physicalDevice, pExternalBufferInfo, pExternalBufferProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalBufferPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalBufferPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pExternalBufferInfo, pExternalBufferProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceExternalSemaphorePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR", "physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pExternalSemaphoreInfo, pExternalSemaphoreProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalFencePropertiesKHR", "physicalDevice, pExternalFenceInfo, pExternalFenceProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalFencePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalFencePropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR", "physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR", "physicalDevice, pPerformanceQueryCreateInfo, pNumPasses", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPerformanceQueryCreateInfo, pNumPasses);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo, pNumPasses);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPerformanceQueryCreateInfo, pNumPasses);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfaceCapabilities2KHR", "physicalDevice, pSurfaceInfo, pSurfaceCapabilities", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfaceCapabilities2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pSurfaceInfo, pSurfaceCapabilities);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfaceCapabilities2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pSurfaceInfo, pSurfaceCapabilities);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfaceFormats2KHR", "physicalDevice, pSurfaceInfo, pSurfaceFormatCount, pSurfaceFormats", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfaceFormats2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pSurfaceInfo, pSurfaceFormatCount, pSurfaceFormats);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount, pSurfaceFormats);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfaceFormats2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pSurfaceInfo, pSurfaceFormatCount, pSurfaceFormats);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceDisplayProperties2KHR", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceDisplayProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceDisplayProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceDisplayPlaneProperties2KHR", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceDisplayPlaneProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceDisplayPlaneProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetDisplayModeProperties2KHR", "physicalDevice, display, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDisplayModeProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, display, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDisplayModeProperties2KHR<Format>(ApiDumpInstance::current(), physicalDevice, display, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetDisplayPlaneCapabilities2KHR", "physicalDevice, pDisplayPlaneInfo, pCapabilities", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDisplayPlaneCapabilities2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pDisplayPlaneInfo, pCapabilities);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDisplayPlaneCapabilities2KHR<Format>(ApiDumpInstance::current(), physicalDevice, pDisplayPlaneInfo, pCapabilities);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceFragmentShadingRatesKHR", "physicalDevice, pFragmentShadingRateCount, pFragmentShadingRates", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceFragmentShadingRatesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pFragmentShadingRateCount, pFragmentShadingRates);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount, pFragmentShadingRates);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceFragmentShadingRatesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pFragmentShadingRateCount, pFragmentShadingRates);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* pQualityLevelInfo, VkVideoEncodeQualityLevelPropertiesKHR* pQualityLevelProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR", "physicalDevice, pQualityLevelInfo, pQualityLevelProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pQualityLevelInfo, pQualityLevelProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo, pQualityLevelProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pQualityLevelInfo, pQualityLevelProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesKHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceCalibrateableTimeDomainsKHR", "physicalDevice, pTimeDomainCount, pTimeDomains", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR<Format>(ApiDumpInstance::current(), physicalDevice, pTimeDomainCount, pTimeDomains);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceCalibrateableTimeDomainsKHR<Format>(ApiDumpInstance::current(), physicalDevice, pTimeDomainCount, pTimeDomains);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDebugReportCallbackEXT(VkInstance instance, const VkDebugReportCallbackCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugReportCallbackEXT* pCallback) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateDebugReportCallbackEXT", "instance, pCreateInfo, pAllocator, pCallback", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDebugReportCallbackEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pCallback);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDebugReportCallbackEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pCallback);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkDestroyDebugReportCallbackEXT", "instance, callback, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDebugReportCallbackEXT<Format>(ApiDumpInstance::current(), instance, callback, pAllocator);
        }
    }
    instance_dispatch_table(instance)->DestroyDebugReportCallbackEXT(instance, callback, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDebugReportCallbackEXT<Format>(ApiDumpInstance::current(), instance, callback, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags, VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location, int32_t messageCode, const char* pLayerPrefix, const char* pMessage) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkDebugReportMessageEXT", "instance, flags, objectType, object, location, messageCode, pLayerPrefix, pMessage", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDebugReportMessageEXT<Format>(ApiDumpInstance::current(), instance, flags, objectType, object, location, messageCode, pLayerPrefix, pMessage);
        }
    }
    instance_dispatch_table(instance)->DebugReportMessageEXT(instance, flags, objectType, object, location, messageCode, pLayerPrefix, pMessage);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDebugReportMessageEXT<Format>(ApiDumpInstance::current(), instance, flags, objectType, object, location, messageCode, pLayerPrefix, pMessage);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#if defined(VK_USE_PLATFORM_GGP)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateStreamDescriptorSurfaceGGP(VkInstance instance, const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateStreamDescriptorSurfaceGGP", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateStreamDescriptorSurfaceGGP<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateStreamDescriptorSurfaceGGP<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_GGP
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalImageFormatPropertiesNV", "physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalImageFormatPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalImageFormatPropertiesNV(physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalImageFormatPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_VI_NN)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateViSurfaceNN", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateViSurfaceNN<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateViSurfaceNN<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_VI_NN
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkReleaseDisplayEXT", "physicalDevice, display", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkReleaseDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, display);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->ReleaseDisplayEXT(physicalDevice, display);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkReleaseDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, display);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_XLIB_XRANDR_EXT)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkAcquireXlibDisplayEXT", "physicalDevice, dpy, display", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAcquireXlibDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, dpy, display);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->AcquireXlibDisplayEXT(physicalDevice, dpy, display);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquireXlibDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, dpy, display);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetRandROutputDisplayEXT", "physicalDevice, dpy, rrOutput, pDisplay", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetRandROutputDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, dpy, rrOutput, pDisplay);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetRandROutputDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, dpy, rrOutput, pDisplay);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_XLIB_XRANDR_EXT
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfaceCapabilities2EXT", "physicalDevice, surface, pSurfaceCapabilities", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfaceCapabilities2EXT<Format>(ApiDumpInstance::current(), physicalDevice, surface, pSurfaceCapabilities);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfaceCapabilities2EXT<Format>(ApiDumpInstance::current(), physicalDevice, surface, pSurfaceCapabilities);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_IOS_MVK)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateIOSSurfaceMVK", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateIOSSurfaceMVK<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateIOSSurfaceMVK<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_IOS_MVK
#if defined(VK_USE_PLATFORM_MACOS_MVK)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateMacOSSurfaceMVK", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateMacOSSurfaceMVK<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateMacOSSurfaceMVK<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_MACOS_MVK
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDebugUtilsMessengerEXT(VkInstance instance, const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugUtilsMessengerEXT* pMessenger) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateDebugUtilsMessengerEXT", "instance, pCreateInfo, pAllocator, pMessenger", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDebugUtilsMessengerEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pMessenger);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDebugUtilsMessengerEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pMessenger);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkDestroyDebugUtilsMessengerEXT", "instance, messenger, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDebugUtilsMessengerEXT<Format>(ApiDumpInstance::current(), instance, messenger, pAllocator);
        }
    }
    instance_dispatch_table(instance)->DestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDebugUtilsMessengerEXT<Format>(ApiDumpInstance::current(), instance, messenger, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkSubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity, VkDebugUtilsMessageTypeFlagsEXT messageTypes, const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkSubmitDebugUtilsMessageEXT", "instance, messageSeverity, messageTypes, pCallbackData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSubmitDebugUtilsMessageEXT<Format>(ApiDumpInstance::current(), instance, messageSeverity, messageTypes, pCallbackData);
        }
    }
    instance_dispatch_table(instance)->SubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSubmitDebugUtilsMessageEXT<Format>(ApiDumpInstance::current(), instance, messageSeverity, messageTypes, pCallbackData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkDeviceSize VKAPI_CALL vkGetPhysicalDeviceDescriptorSizeEXT(VkPhysicalDevice physicalDevice, VkDescriptorType descriptorType) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceDescriptorSizeEXT", "physicalDevice, descriptorType", "VkDeviceSize");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceDescriptorSizeEXT<Format>(ApiDumpInstance::current(), physicalDevice, descriptorType);
        }
    }
    VkDeviceSize result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceDescriptorSizeEXT(physicalDevice, descriptorType);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkDeviceSize", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceDescriptorSizeEXT<Format>(ApiDumpInstance::current(), physicalDevice, descriptorType);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceMultisamplePropertiesEXT", "physicalDevice, samples, pMultisampleProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceMultisamplePropertiesEXT<Format>(ApiDumpInstance::current(), physicalDevice, samples, pMultisampleProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceMultisamplePropertiesEXT<Format>(ApiDumpInstance::current(), physicalDevice, samples, pMultisampleProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceCalibrateableTimeDomainsEXT", "physicalDevice, pTimeDomainCount, pTimeDomains", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT<Format>(ApiDumpInstance::current(), physicalDevice, pTimeDomainCount, pTimeDomains);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT<Format>(ApiDumpInstance::current(), physicalDevice, pTimeDomainCount, pTimeDomains);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateImagePipeSurfaceFUCHSIA(VkInstance instance, const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateImagePipeSurfaceFUCHSIA", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateImagePipeSurfaceFUCHSIA<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateImagePipeSurfaceFUCHSIA(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateImagePipeSurfaceFUCHSIA<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_FUCHSIA
#if defined(VK_USE_PLATFORM_METAL_EXT)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateMetalSurfaceEXT", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateMetalSurfaceEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateMetalSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateMetalSurfaceEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_METAL_EXT
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceToolPropertiesEXT", "physicalDevice, pToolCount, pToolProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceToolPropertiesEXT<Format>(ApiDumpInstance::current(), physicalDevice, pToolCount, pToolProperties);
        }
    }

    static const VkPhysicalDeviceToolPropertiesEXT api_dump_layer_tool_props = {
        VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES_EXT,
        nullptr,
        "API Dump Layer",
        "2",
        VK_TOOL_PURPOSE_PROFILING_BIT_EXT | VK_TOOL_PURPOSE_TRACING_BIT_EXT,
        "The VK_LAYER_LUNARG_api_dump utility layer prints API calls, parameters, and values to the identified output stream.",
        "VK_LAYER_LUNARG_api_dump"};

    auto original_pToolProperties = pToolProperties;
    if (pToolProperties != nullptr) {
        *pToolProperties = api_dump_layer_tool_props;
        pToolProperties = ((*pToolCount > 1) ? &pToolProperties[1] : nullptr);
        (*pToolCount)--;
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceToolPropertiesEXT(physicalDevice, pToolCount, pToolProperties);
    if (original_pToolProperties != nullptr) {
        pToolProperties = original_pToolProperties;
    }

    (*pToolCount)++;
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceToolPropertiesEXT<Format>(ApiDumpInstance::current(), physicalDevice, pToolCount, pToolProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceCooperativeMatrixPropertiesNV", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceCooperativeMatrixPropertiesNV(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV", "physicalDevice, pCombinationCount, pCombinations", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV<Format>(ApiDumpInstance::current(), physicalDevice, pCombinationCount, pCombinations);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(physicalDevice, pCombinationCount, pCombinations);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV<Format>(ApiDumpInstance::current(), physicalDevice, pCombinationCount, pCombinations);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceSurfacePresentModes2EXT", "physicalDevice, pSurfaceInfo, pPresentModeCount, pPresentModes", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceSurfacePresentModes2EXT<Format>(ApiDumpInstance::current(), physicalDevice, pSurfaceInfo, pPresentModeCount, pPresentModes);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceSurfacePresentModes2EXT(physicalDevice, pSurfaceInfo, pPresentModeCount, pPresentModes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceSurfacePresentModes2EXT<Format>(ApiDumpInstance::current(), physicalDevice, pSurfaceInfo, pPresentModeCount, pPresentModes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateHeadlessSurfaceEXT", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateHeadlessSurfaceEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateHeadlessSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateHeadlessSurfaceEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkAcquireDrmDisplayEXT", "physicalDevice, drmFd, display", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAcquireDrmDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, drmFd, display);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->AcquireDrmDisplayEXT(physicalDevice, drmFd, display);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquireDrmDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, drmFd, display);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetDrmDisplayEXT", "physicalDevice, drmFd, connectorId, display", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDrmDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, drmFd, connectorId, display);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetDrmDisplayEXT(physicalDevice, drmFd, connectorId, display);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDrmDisplayEXT<Format>(ApiDumpInstance::current(), physicalDevice, drmFd, connectorId, display);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkAcquireWinrtDisplayNV", "physicalDevice, display", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAcquireWinrtDisplayNV<Format>(ApiDumpInstance::current(), physicalDevice, display);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->AcquireWinrtDisplayNV(physicalDevice, display);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquireWinrtDisplayNV<Format>(ApiDumpInstance::current(), physicalDevice, display);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetWinrtDisplayNV", "physicalDevice, deviceRelativeId, pDisplay", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetWinrtDisplayNV<Format>(ApiDumpInstance::current(), physicalDevice, deviceRelativeId, pDisplay);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetWinrtDisplayNV(physicalDevice, deviceRelativeId, pDisplay);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetWinrtDisplayNV<Format>(ApiDumpInstance::current(), physicalDevice, deviceRelativeId, pDisplay);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
#if defined(VK_USE_PLATFORM_DIRECTFB_EXT)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateDirectFBSurfaceEXT", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDirectFBSurfaceEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateDirectFBSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDirectFBSurfaceEXT<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkBool32 VKAPI_CALL vkGetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceDirectFBPresentationSupportEXT", "physicalDevice, queueFamilyIndex, dfb", "VkBool32");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceDirectFBPresentationSupportEXT<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, dfb);
        }
    }
    VkBool32 result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceDirectFBPresentationSupportEXT(physicalDevice, queueFamilyIndex, dfb);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkBool32", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceDirectFBPresentationSupportEXT<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, dfb);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_DIRECTFB_EXT
#if defined(VK_USE_PLATFORM_SCREEN_QNX)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateScreenSurfaceQNX(VkInstance instance, const VkScreenSurfaceCreateInfoQNX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateScreenSurfaceQNX", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateScreenSurfaceQNX<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateScreenSurfaceQNX(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateScreenSurfaceQNX<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkBool32 VKAPI_CALL vkGetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceScreenPresentationSupportQNX", "physicalDevice, queueFamilyIndex, window", "VkBool32");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceScreenPresentationSupportQNX<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, window);
        }
    }
    VkBool32 result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceScreenPresentationSupportQNX(physicalDevice, queueFamilyIndex, window);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkBool32", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceScreenPresentationSupportQNX<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, window);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_SCREEN_QNX
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceExternalTensorPropertiesARM(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalTensorInfoARM* pExternalTensorInfo, VkExternalTensorPropertiesARM* pExternalTensorProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceExternalTensorPropertiesARM", "physicalDevice, pExternalTensorInfo, pExternalTensorProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceExternalTensorPropertiesARM<Format>(ApiDumpInstance::current(), physicalDevice, pExternalTensorInfo, pExternalTensorProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceExternalTensorPropertiesARM(physicalDevice, pExternalTensorInfo, pExternalTensorProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceExternalTensorPropertiesARM<Format>(ApiDumpInstance::current(), physicalDevice, pExternalTensorInfo, pExternalTensorProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, const VkOpticalFlowImageFormatInfoNV* pOpticalFlowImageFormatInfo, uint32_t* pFormatCount, VkOpticalFlowImageFormatPropertiesNV* pImageFormatProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceOpticalFlowImageFormatsNV", "physicalDevice, pOpticalFlowImageFormatInfo, pFormatCount, pImageFormatProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceOpticalFlowImageFormatsNV<Format>(ApiDumpInstance::current(), physicalDevice, pOpticalFlowImageFormatInfo, pFormatCount, pImageFormatProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceOpticalFlowImageFormatsNV(physicalDevice, pOpticalFlowImageFormatInfo, pFormatCount, pImageFormatProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceOpticalFlowImageFormatsNV<Format>(ApiDumpInstance::current(), physicalDevice, pOpticalFlowImageFormatInfo, pFormatCount, pImageFormatProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceCooperativeVectorPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeVectorPropertiesNV* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceCooperativeVectorPropertiesNV", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceCooperativeVectorPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceCooperativeVectorPropertiesNV(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceCooperativeVectorPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pQueueFamilyDataGraphPropertyCount, VkQueueFamilyDataGraphPropertiesARM* pQueueFamilyDataGraphProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM", "physicalDevice, queueFamilyIndex, pQueueFamilyDataGraphPropertyCount, pQueueFamilyDataGraphProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, pQueueFamilyDataGraphPropertyCount, pQueueFamilyDataGraphProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM(physicalDevice, queueFamilyIndex, pQueueFamilyDataGraphPropertyCount, pQueueFamilyDataGraphProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceQueueFamilyDataGraphPropertiesARM<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, pQueueFamilyDataGraphPropertyCount, pQueueFamilyDataGraphProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceQueueFamilyDataGraphProcessingEngineInfoARM* pQueueFamilyDataGraphProcessingEngineInfo, VkQueueFamilyDataGraphProcessingEnginePropertiesARM* pQueueFamilyDataGraphProcessingEngineProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM", "physicalDevice, pQueueFamilyDataGraphProcessingEngineInfo, pQueueFamilyDataGraphProcessingEngineProperties", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyDataGraphProcessingEngineInfo, pQueueFamilyDataGraphProcessingEngineProperties);
        }
    }
    instance_dispatch_table(physicalDevice)->GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM(physicalDevice, pQueueFamilyDataGraphProcessingEngineInfo, pQueueFamilyDataGraphProcessingEngineProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM<Format>(ApiDumpInstance::current(), physicalDevice, pQueueFamilyDataGraphProcessingEngineInfo, pQueueFamilyDataGraphProcessingEngineProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#if defined(VK_USE_PLATFORM_OHOS)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateSurfaceOHOS(VkInstance instance, const VkSurfaceCreateInfoOHOS* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkCreateSurfaceOHOS", "instance, pCreateInfo, pAllocator, pSurface", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateSurfaceOHOS<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        }
    }
    VkResult result = instance_dispatch_table(instance)->CreateSurfaceOHOS(instance, pCreateInfo, pAllocator, pSurface);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateSurfaceOHOS<Format>(ApiDumpInstance::current(), instance, pCreateInfo, pAllocator, pSurface);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_OHOS
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixFlexibleDimensionsPropertiesNV* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV", "physicalDevice, pPropertyCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV(physicalDevice, pPropertyCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV<Format>(ApiDumpInstance::current(), physicalDevice, pPropertyCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterARM* pCounters, VkPerformanceCounterDescriptionARM* pCounterDescriptions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM", "physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
        }
    }
    VkResult result = instance_dispatch_table(physicalDevice)->EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM(physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkEnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM<Format>(ApiDumpInstance::current(), physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}

// Autogen device functions

template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyDevice", "device, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDevice<Format>(ApiDumpInstance::current(), device, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyDevice(device, pAllocator);
    destroy_device_dispatch_table(get_dispatch_key(device));
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDevice<Format>(ApiDumpInstance::current(), device, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceQueue", "device, queueFamilyIndex, queueIndex, pQueue", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceQueue<Format>(ApiDumpInstance::current(), device, queueFamilyIndex, queueIndex, pQueue);
        }
    }
    device_dispatch_table(device)->GetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceQueue<Format>(ApiDumpInstance::current(), device, queueFamilyIndex, queueIndex, pQueue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkQueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueSubmit", "queue, submitCount, pSubmits, fence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueSubmit<Format>(ApiDumpInstance::current(), queue, submitCount, pSubmits, fence);
        }
    }
    VkResult result = device_dispatch_table(queue)->QueueSubmit(queue, submitCount, pSubmits, fence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueSubmit<Format>(ApiDumpInstance::current(), queue, submitCount, pSubmits, fence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkQueueWaitIdle(VkQueue queue) {
    VkResult result = device_dispatch_table(queue)->QueueWaitIdle(queue);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkQueueWaitIdle", "queue", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueWaitIdle<Format>(ApiDumpInstance::current(), queue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkDeviceWaitIdle(VkDevice device) {
    VkResult result = device_dispatch_table(device)->DeviceWaitIdle(device);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkDeviceWaitIdle", "device", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDeviceWaitIdle<Format>(ApiDumpInstance::current(), device);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkAllocateMemory", "device, pAllocateInfo, pAllocator, pMemory", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAllocateMemory<Format>(ApiDumpInstance::current(), device, pAllocateInfo, pAllocator, pMemory);
        }
    }
    VkResult result = device_dispatch_table(device)->AllocateMemory(device, pAllocateInfo, pAllocator, pMemory);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAllocateMemory<Format>(ApiDumpInstance::current(), device, pAllocateInfo, pAllocator, pMemory);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkFreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkFreeMemory", "device, memory, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkFreeMemory<Format>(ApiDumpInstance::current(), device, memory, pAllocator);
        }
    }
    device_dispatch_table(device)->FreeMemory(device, memory, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkFreeMemory<Format>(ApiDumpInstance::current(), device, memory, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkMapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkMapMemory", "device, memory, offset, size, flags, ppData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkMapMemory<Format>(ApiDumpInstance::current(), device, memory, offset, size, flags, ppData);
        }
    }
    VkResult result = device_dispatch_table(device)->MapMemory(device, memory, offset, size, flags, ppData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkMapMemory<Format>(ApiDumpInstance::current(), device, memory, offset, size, flags, ppData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkUnmapMemory(VkDevice device, VkDeviceMemory memory) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUnmapMemory", "device, memory", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUnmapMemory<Format>(ApiDumpInstance::current(), device, memory);
        }
    }
    device_dispatch_table(device)->UnmapMemory(device, memory);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUnmapMemory<Format>(ApiDumpInstance::current(), device, memory);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkFlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkFlushMappedMemoryRanges", "device, memoryRangeCount, pMemoryRanges", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkFlushMappedMemoryRanges<Format>(ApiDumpInstance::current(), device, memoryRangeCount, pMemoryRanges);
        }
    }
    VkResult result = device_dispatch_table(device)->FlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkFlushMappedMemoryRanges<Format>(ApiDumpInstance::current(), device, memoryRangeCount, pMemoryRanges);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkInvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkInvalidateMappedMemoryRanges", "device, memoryRangeCount, pMemoryRanges", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkInvalidateMappedMemoryRanges<Format>(ApiDumpInstance::current(), device, memoryRangeCount, pMemoryRanges);
        }
    }
    VkResult result = device_dispatch_table(device)->InvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkInvalidateMappedMemoryRanges<Format>(ApiDumpInstance::current(), device, memoryRangeCount, pMemoryRanges);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceMemoryCommitment", "device, memory, pCommittedMemoryInBytes", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceMemoryCommitment<Format>(ApiDumpInstance::current(), device, memory, pCommittedMemoryInBytes);
        }
    }
    device_dispatch_table(device)->GetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceMemoryCommitment<Format>(ApiDumpInstance::current(), device, memory, pCommittedMemoryInBytes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindBufferMemory", "device, buffer, memory, memoryOffset", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindBufferMemory<Format>(ApiDumpInstance::current(), device, buffer, memory, memoryOffset);
        }
    }
    VkResult result = device_dispatch_table(device)->BindBufferMemory(device, buffer, memory, memoryOffset);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindBufferMemory<Format>(ApiDumpInstance::current(), device, buffer, memory, memoryOffset);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindImageMemory", "device, image, memory, memoryOffset", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindImageMemory<Format>(ApiDumpInstance::current(), device, image, memory, memoryOffset);
        }
    }
    VkResult result = device_dispatch_table(device)->BindImageMemory(device, image, memory, memoryOffset);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindImageMemory<Format>(ApiDumpInstance::current(), device, image, memory, memoryOffset);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferMemoryRequirements", "device, buffer, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferMemoryRequirements<Format>(ApiDumpInstance::current(), device, buffer, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetBufferMemoryRequirements(device, buffer, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferMemoryRequirements<Format>(ApiDumpInstance::current(), device, buffer, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageMemoryRequirements", "device, image, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageMemoryRequirements<Format>(ApiDumpInstance::current(), device, image, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetImageMemoryRequirements(device, image, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageMemoryRequirements<Format>(ApiDumpInstance::current(), device, image, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageSparseMemoryRequirements", "device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageSparseMemoryRequirements<Format>(ApiDumpInstance::current(), device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageSparseMemoryRequirements<Format>(ApiDumpInstance::current(), device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkQueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueBindSparse", "queue, bindInfoCount, pBindInfo, fence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueBindSparse<Format>(ApiDumpInstance::current(), queue, bindInfoCount, pBindInfo, fence);
        }
    }
    VkResult result = device_dispatch_table(queue)->QueueBindSparse(queue, bindInfoCount, pBindInfo, fence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueBindSparse<Format>(ApiDumpInstance::current(), queue, bindInfoCount, pBindInfo, fence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateFence", "device, pCreateInfo, pAllocator, pFence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateFence<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFence);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateFence(device, pCreateInfo, pAllocator, pFence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateFence<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyFence", "device, fence, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyFence<Format>(ApiDumpInstance::current(), device, fence, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyFence(device, fence, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyFence<Format>(ApiDumpInstance::current(), device, fence, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkResetFences", "device, fenceCount, pFences", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkResetFences<Format>(ApiDumpInstance::current(), device, fenceCount, pFences);
        }
    }
    VkResult result = device_dispatch_table(device)->ResetFences(device, fenceCount, pFences);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkResetFences<Format>(ApiDumpInstance::current(), device, fenceCount, pFences);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetFenceStatus(VkDevice device, VkFence fence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetFenceStatus", "device, fence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetFenceStatus<Format>(ApiDumpInstance::current(), device, fence);
        }
    }
    VkResult result = device_dispatch_table(device)->GetFenceStatus(device, fence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetFenceStatus<Format>(ApiDumpInstance::current(), device, fence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) {
    VkResult result = device_dispatch_table(device)->WaitForFences(device, fenceCount, pFences, waitAll, timeout);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkWaitForFences", "device, fenceCount, pFences, waitAll, timeout", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWaitForFences<Format>(ApiDumpInstance::current(), device, fenceCount, pFences, waitAll, timeout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateSemaphore", "device, pCreateInfo, pAllocator, pSemaphore", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateSemaphore<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSemaphore);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateSemaphore<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSemaphore);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroySemaphore", "device, semaphore, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroySemaphore<Format>(ApiDumpInstance::current(), device, semaphore, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroySemaphore(device, semaphore, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroySemaphore<Format>(ApiDumpInstance::current(), device, semaphore, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateQueryPool", "device, pCreateInfo, pAllocator, pQueryPool", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateQueryPool<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pQueryPool);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateQueryPool<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pQueryPool);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyQueryPool", "device, queryPool, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyQueryPool<Format>(ApiDumpInstance::current(), device, queryPool, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyQueryPool(device, queryPool, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyQueryPool<Format>(ApiDumpInstance::current(), device, queryPool, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) {
    VkResult result = device_dispatch_table(device)->GetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkGetQueryPoolResults", "device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetQueryPoolResults<Format>(ApiDumpInstance::current(), device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateBuffer", "device, pCreateInfo, pAllocator, pBuffer", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateBuffer<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pBuffer);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateBuffer(device, pCreateInfo, pAllocator, pBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateBuffer<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyBuffer", "device, buffer, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyBuffer<Format>(ApiDumpInstance::current(), device, buffer, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyBuffer(device, buffer, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyBuffer<Format>(ApiDumpInstance::current(), device, buffer, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateImage", "device, pCreateInfo, pAllocator, pImage", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateImage<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pImage);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateImage(device, pCreateInfo, pAllocator, pImage);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateImage<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pImage);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyImage", "device, image, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyImage<Format>(ApiDumpInstance::current(), device, image, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyImage(device, image, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyImage<Format>(ApiDumpInstance::current(), device, image, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageSubresourceLayout", "device, image, pSubresource, pLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageSubresourceLayout<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        }
    }
    device_dispatch_table(device)->GetImageSubresourceLayout(device, image, pSubresource, pLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageSubresourceLayout<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateImageView", "device, pCreateInfo, pAllocator, pView", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateImageView<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pView);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateImageView(device, pCreateInfo, pAllocator, pView);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateImageView<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pView);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyImageView", "device, imageView, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyImageView<Format>(ApiDumpInstance::current(), device, imageView, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyImageView(device, imageView, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyImageView<Format>(ApiDumpInstance::current(), device, imageView, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateCommandPool", "device, pCreateInfo, pAllocator, pCommandPool", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateCommandPool<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pCommandPool);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateCommandPool<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pCommandPool);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyCommandPool", "device, commandPool, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyCommandPool<Format>(ApiDumpInstance::current(), device, commandPool, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyCommandPool(device, commandPool, pAllocator);
    ApiDumpInstance::current().eraseCmdBufferPool(device, commandPool);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyCommandPool<Format>(ApiDumpInstance::current(), device, commandPool, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkResetCommandPool", "device, commandPool, flags", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkResetCommandPool<Format>(ApiDumpInstance::current(), device, commandPool, flags);
        }
    }
    VkResult result = device_dispatch_table(device)->ResetCommandPool(device, commandPool, flags);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkResetCommandPool<Format>(ApiDumpInstance::current(), device, commandPool, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkAllocateCommandBuffers", "device, pAllocateInfo, pCommandBuffers", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAllocateCommandBuffers<Format>(ApiDumpInstance::current(), device, pAllocateInfo, pCommandBuffers);
        }
    }
    VkResult result = device_dispatch_table(device)->AllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers);
    if (result == VK_SUCCESS)
        ApiDumpInstance::current().addCmdBuffers(
            device,
            pAllocateInfo->commandPool,
            std::vector<VkCommandBuffer>(pCommandBuffers, pCommandBuffers + pAllocateInfo->commandBufferCount),
            pAllocateInfo->level);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAllocateCommandBuffers<Format>(ApiDumpInstance::current(), device, pAllocateInfo, pCommandBuffers);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkFreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkFreeCommandBuffers", "device, commandPool, commandBufferCount, pCommandBuffers", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkFreeCommandBuffers<Format>(ApiDumpInstance::current(), device, commandPool, commandBufferCount, pCommandBuffers);
        }
    }
    device_dispatch_table(device)->FreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers);
    ApiDumpInstance::current().eraseCmdBuffers(device, commandPool, std::vector<VkCommandBuffer>(pCommandBuffers, pCommandBuffers + commandBufferCount));
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkFreeCommandBuffers<Format>(ApiDumpInstance::current(), device, commandPool, commandBufferCount, pCommandBuffers);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBeginCommandBuffer", "commandBuffer, pBeginInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBeginCommandBuffer<Format>(ApiDumpInstance::current(), commandBuffer, pBeginInfo);
        }
    }
    VkResult result = device_dispatch_table(commandBuffer)->BeginCommandBuffer(commandBuffer, pBeginInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBeginCommandBuffer<Format>(ApiDumpInstance::current(), commandBuffer, pBeginInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkEndCommandBuffer(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkEndCommandBuffer", "commandBuffer", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkEndCommandBuffer<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    VkResult result = device_dispatch_table(commandBuffer)->EndCommandBuffer(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkEndCommandBuffer<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkResetCommandBuffer", "commandBuffer, flags", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkResetCommandBuffer<Format>(ApiDumpInstance::current(), commandBuffer, flags);
        }
    }
    VkResult result = device_dispatch_table(commandBuffer)->ResetCommandBuffer(commandBuffer, flags);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkResetCommandBuffer<Format>(ApiDumpInstance::current(), commandBuffer, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyBuffer", "commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyBuffer<Format>(ApiDumpInstance::current(), commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyBuffer<Format>(ApiDumpInstance::current(), commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyImage", "commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyImage<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyImage<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyBufferToImage", "commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyBufferToImage<Format>(ApiDumpInstance::current(), commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyBufferToImage<Format>(ApiDumpInstance::current(), commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyImageToBuffer", "commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyImageToBuffer<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyImageToBuffer<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdUpdateBuffer", "commandBuffer, dstBuffer, dstOffset, dataSize, pData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdUpdateBuffer<Format>(ApiDumpInstance::current(), commandBuffer, dstBuffer, dstOffset, dataSize, pData);
        }
    }
    device_dispatch_table(commandBuffer)->CmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdUpdateBuffer<Format>(ApiDumpInstance::current(), commandBuffer, dstBuffer, dstOffset, dataSize, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdFillBuffer", "commandBuffer, dstBuffer, dstOffset, size, data", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdFillBuffer<Format>(ApiDumpInstance::current(), commandBuffer, dstBuffer, dstOffset, size, data);
        }
    }
    device_dispatch_table(commandBuffer)->CmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdFillBuffer<Format>(ApiDumpInstance::current(), commandBuffer, dstBuffer, dstOffset, size, data);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPipelineBarrier", "commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPipelineBarrier<Format>(ApiDumpInstance::current(), commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPipelineBarrier<Format>(ApiDumpInstance::current(), commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginQuery", "commandBuffer, queryPool, query, flags", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginQuery<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query, flags);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginQuery(commandBuffer, queryPool, query, flags);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginQuery<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndQuery", "commandBuffer, queryPool, query", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndQuery<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndQuery(commandBuffer, queryPool, query);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndQuery<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdResetQueryPool", "commandBuffer, queryPool, firstQuery, queryCount", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdResetQueryPool<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, firstQuery, queryCount);
        }
    }
    device_dispatch_table(commandBuffer)->CmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdResetQueryPool<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, firstQuery, queryCount);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWriteTimestamp", "commandBuffer, pipelineStage, queryPool, query", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWriteTimestamp<Format>(ApiDumpInstance::current(), commandBuffer, pipelineStage, queryPool, query);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWriteTimestamp<Format>(ApiDumpInstance::current(), commandBuffer, pipelineStage, queryPool, query);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyQueryPoolResults", "commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyQueryPoolResults<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyQueryPoolResults<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdExecuteCommands", "commandBuffer, commandBufferCount, pCommandBuffers", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdExecuteCommands<Format>(ApiDumpInstance::current(), commandBuffer, commandBufferCount, pCommandBuffers);
        }
    }
    device_dispatch_table(commandBuffer)->CmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdExecuteCommands<Format>(ApiDumpInstance::current(), commandBuffer, commandBufferCount, pCommandBuffers);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateEvent", "device, pCreateInfo, pAllocator, pEvent", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateEvent<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pEvent);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateEvent(device, pCreateInfo, pAllocator, pEvent);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateEvent<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pEvent);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyEvent", "device, event, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyEvent<Format>(ApiDumpInstance::current(), device, event, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyEvent(device, event, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyEvent<Format>(ApiDumpInstance::current(), device, event, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetEventStatus(VkDevice device, VkEvent event) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetEventStatus", "device, event", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetEventStatus<Format>(ApiDumpInstance::current(), device, event);
        }
    }
    VkResult result = device_dispatch_table(device)->GetEventStatus(device, event);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetEventStatus<Format>(ApiDumpInstance::current(), device, event);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetEvent(VkDevice device, VkEvent event) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetEvent", "device, event", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetEvent<Format>(ApiDumpInstance::current(), device, event);
        }
    }
    VkResult result = device_dispatch_table(device)->SetEvent(device, event);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetEvent<Format>(ApiDumpInstance::current(), device, event);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkResetEvent(VkDevice device, VkEvent event) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkResetEvent", "device, event", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkResetEvent<Format>(ApiDumpInstance::current(), device, event);
        }
    }
    VkResult result = device_dispatch_table(device)->ResetEvent(device, event);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkResetEvent<Format>(ApiDumpInstance::current(), device, event);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateBufferView", "device, pCreateInfo, pAllocator, pView", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateBufferView<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pView);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateBufferView(device, pCreateInfo, pAllocator, pView);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateBufferView<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pView);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyBufferView", "device, bufferView, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyBufferView<Format>(ApiDumpInstance::current(), device, bufferView, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyBufferView(device, bufferView, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyBufferView<Format>(ApiDumpInstance::current(), device, bufferView, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateShaderModule", "device, pCreateInfo, pAllocator, pShaderModule", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateShaderModule<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pShaderModule);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateShaderModule(device, pCreateInfo, pAllocator, pShaderModule);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateShaderModule<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pShaderModule);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyShaderModule", "device, shaderModule, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyShaderModule<Format>(ApiDumpInstance::current(), device, shaderModule, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyShaderModule(device, shaderModule, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyShaderModule<Format>(ApiDumpInstance::current(), device, shaderModule, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreatePipelineCache", "device, pCreateInfo, pAllocator, pPipelineCache", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreatePipelineCache<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPipelineCache);
        }
    }
    VkResult result = device_dispatch_table(device)->CreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreatePipelineCache<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPipelineCache);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyPipelineCache", "device, pipelineCache, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyPipelineCache<Format>(ApiDumpInstance::current(), device, pipelineCache, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyPipelineCache(device, pipelineCache, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyPipelineCache<Format>(ApiDumpInstance::current(), device, pipelineCache, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineCacheData", "device, pipelineCache, pDataSize, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineCacheData<Format>(ApiDumpInstance::current(), device, pipelineCache, pDataSize, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPipelineCacheData(device, pipelineCache, pDataSize, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineCacheData<Format>(ApiDumpInstance::current(), device, pipelineCache, pDataSize, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkMergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkMergePipelineCaches", "device, dstCache, srcCacheCount, pSrcCaches", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkMergePipelineCaches<Format>(ApiDumpInstance::current(), device, dstCache, srcCacheCount, pSrcCaches);
        }
    }
    VkResult result = device_dispatch_table(device)->MergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkMergePipelineCaches<Format>(ApiDumpInstance::current(), device, dstCache, srcCacheCount, pSrcCaches);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateComputePipelines", "device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateComputePipelines<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateComputePipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateComputePipelines<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyPipeline", "device, pipeline, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyPipeline<Format>(ApiDumpInstance::current(), device, pipeline, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyPipeline(device, pipeline, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyPipeline<Format>(ApiDumpInstance::current(), device, pipeline, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreatePipelineLayout", "device, pCreateInfo, pAllocator, pPipelineLayout", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreatePipelineLayout<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPipelineLayout);
        }
    }
    VkResult result = device_dispatch_table(device)->CreatePipelineLayout(device, pCreateInfo, pAllocator, pPipelineLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreatePipelineLayout<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPipelineLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyPipelineLayout", "device, pipelineLayout, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyPipelineLayout<Format>(ApiDumpInstance::current(), device, pipelineLayout, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyPipelineLayout(device, pipelineLayout, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyPipelineLayout<Format>(ApiDumpInstance::current(), device, pipelineLayout, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateSampler", "device, pCreateInfo, pAllocator, pSampler", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateSampler<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSampler);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateSampler(device, pCreateInfo, pAllocator, pSampler);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateSampler<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSampler);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroySampler", "device, sampler, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroySampler<Format>(ApiDumpInstance::current(), device, sampler, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroySampler(device, sampler, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroySampler<Format>(ApiDumpInstance::current(), device, sampler, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateDescriptorSetLayout", "device, pCreateInfo, pAllocator, pSetLayout", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDescriptorSetLayout<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSetLayout);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDescriptorSetLayout<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSetLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyDescriptorSetLayout", "device, descriptorSetLayout, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDescriptorSetLayout<Format>(ApiDumpInstance::current(), device, descriptorSetLayout, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDescriptorSetLayout<Format>(ApiDumpInstance::current(), device, descriptorSetLayout, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateDescriptorPool", "device, pCreateInfo, pAllocator, pDescriptorPool", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDescriptorPool<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pDescriptorPool);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDescriptorPool<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pDescriptorPool);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyDescriptorPool", "device, descriptorPool, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDescriptorPool<Format>(ApiDumpInstance::current(), device, descriptorPool, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyDescriptorPool(device, descriptorPool, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDescriptorPool<Format>(ApiDumpInstance::current(), device, descriptorPool, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkResetDescriptorPool", "device, descriptorPool, flags", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkResetDescriptorPool<Format>(ApiDumpInstance::current(), device, descriptorPool, flags);
        }
    }
    VkResult result = device_dispatch_table(device)->ResetDescriptorPool(device, descriptorPool, flags);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkResetDescriptorPool<Format>(ApiDumpInstance::current(), device, descriptorPool, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkAllocateDescriptorSets", "device, pAllocateInfo, pDescriptorSets", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAllocateDescriptorSets<Format>(ApiDumpInstance::current(), device, pAllocateInfo, pDescriptorSets);
        }
    }
    VkResult result = device_dispatch_table(device)->AllocateDescriptorSets(device, pAllocateInfo, pDescriptorSets);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAllocateDescriptorSets<Format>(ApiDumpInstance::current(), device, pAllocateInfo, pDescriptorSets);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkFreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkFreeDescriptorSets", "device, descriptorPool, descriptorSetCount, pDescriptorSets", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkFreeDescriptorSets<Format>(ApiDumpInstance::current(), device, descriptorPool, descriptorSetCount, pDescriptorSets);
        }
    }
    VkResult result = device_dispatch_table(device)->FreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkFreeDescriptorSets<Format>(ApiDumpInstance::current(), device, descriptorPool, descriptorSetCount, pDescriptorSets);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkUpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUpdateDescriptorSets", "device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUpdateDescriptorSets<Format>(ApiDumpInstance::current(), device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies);
        }
    }
    device_dispatch_table(device)->UpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUpdateDescriptorSets<Format>(ApiDumpInstance::current(), device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount, pDescriptorCopies);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindPipeline", "commandBuffer, pipelineBindPoint, pipeline", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindPipeline<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, pipeline);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindPipeline<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, pipeline);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindDescriptorSets", "commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindDescriptorSets<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindDescriptorSets<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdClearColorImage", "commandBuffer, image, imageLayout, pColor, rangeCount, pRanges", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdClearColorImage<Format>(ApiDumpInstance::current(), commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
        }
    }
    device_dispatch_table(commandBuffer)->CmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdClearColorImage<Format>(ApiDumpInstance::current(), commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatch", "commandBuffer, groupCountX, groupCountY, groupCountZ", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatch<Format>(ApiDumpInstance::current(), commandBuffer, groupCountX, groupCountY, groupCountZ);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatch<Format>(ApiDumpInstance::current(), commandBuffer, groupCountX, groupCountY, groupCountZ);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatchIndirect", "commandBuffer, buffer, offset", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatchIndirect<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatchIndirect(commandBuffer, buffer, offset);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatchIndirect<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetEvent", "commandBuffer, event, stageMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetEvent<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetEvent(commandBuffer, event, stageMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetEvent<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdResetEvent", "commandBuffer, event, stageMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdResetEvent<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdResetEvent(commandBuffer, event, stageMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdResetEvent<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWaitEvents", "commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWaitEvents<Format>(ApiDumpInstance::current(), commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWaitEvents<Format>(ApiDumpInstance::current(), commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushConstants", "commandBuffer, layout, stageFlags, offset, size, pValues", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushConstants<Format>(ApiDumpInstance::current(), commandBuffer, layout, stageFlags, offset, size, pValues);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushConstants<Format>(ApiDumpInstance::current(), commandBuffer, layout, stageFlags, offset, size, pValues);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateGraphicsPipelines", "device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateGraphicsPipelines<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateGraphicsPipelines(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateGraphicsPipelines<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateFramebuffer", "device, pCreateInfo, pAllocator, pFramebuffer", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateFramebuffer<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFramebuffer);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateFramebuffer<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFramebuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyFramebuffer", "device, framebuffer, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyFramebuffer<Format>(ApiDumpInstance::current(), device, framebuffer, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyFramebuffer(device, framebuffer, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyFramebuffer<Format>(ApiDumpInstance::current(), device, framebuffer, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateRenderPass", "device, pCreateInfo, pAllocator, pRenderPass", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateRenderPass<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pRenderPass);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateRenderPass<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pRenderPass);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyRenderPass", "device, renderPass, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyRenderPass<Format>(ApiDumpInstance::current(), device, renderPass, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyRenderPass(device, renderPass, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyRenderPass<Format>(ApiDumpInstance::current(), device, renderPass, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetRenderAreaGranularity", "device, renderPass, pGranularity", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetRenderAreaGranularity<Format>(ApiDumpInstance::current(), device, renderPass, pGranularity);
        }
    }
    device_dispatch_table(device)->GetRenderAreaGranularity(device, renderPass, pGranularity);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetRenderAreaGranularity<Format>(ApiDumpInstance::current(), device, renderPass, pGranularity);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetViewport", "commandBuffer, firstViewport, viewportCount, pViewports", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetViewport<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pViewports);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetViewport<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pViewports);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetScissor", "commandBuffer, firstScissor, scissorCount, pScissors", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetScissor<Format>(ApiDumpInstance::current(), commandBuffer, firstScissor, scissorCount, pScissors);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetScissor<Format>(ApiDumpInstance::current(), commandBuffer, firstScissor, scissorCount, pScissors);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLineWidth", "commandBuffer, lineWidth", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLineWidth<Format>(ApiDumpInstance::current(), commandBuffer, lineWidth);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLineWidth(commandBuffer, lineWidth);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLineWidth<Format>(ApiDumpInstance::current(), commandBuffer, lineWidth);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthBias", "commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthBias<Format>(ApiDumpInstance::current(), commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthBias<Format>(ApiDumpInstance::current(), commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetBlendConstants", "commandBuffer, blendConstants", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetBlendConstants<Format>(ApiDumpInstance::current(), commandBuffer, blendConstants);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetBlendConstants(commandBuffer, blendConstants);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetBlendConstants<Format>(ApiDumpInstance::current(), commandBuffer, blendConstants);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthBounds", "commandBuffer, minDepthBounds, maxDepthBounds", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthBounds<Format>(ApiDumpInstance::current(), commandBuffer, minDepthBounds, maxDepthBounds);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthBounds<Format>(ApiDumpInstance::current(), commandBuffer, minDepthBounds, maxDepthBounds);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetStencilCompareMask", "commandBuffer, faceMask, compareMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetStencilCompareMask<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, compareMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetStencilCompareMask(commandBuffer, faceMask, compareMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetStencilCompareMask<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, compareMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetStencilWriteMask", "commandBuffer, faceMask, writeMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetStencilWriteMask<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, writeMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetStencilWriteMask(commandBuffer, faceMask, writeMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetStencilWriteMask<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, writeMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetStencilReference", "commandBuffer, faceMask, reference", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetStencilReference<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, reference);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetStencilReference(commandBuffer, faceMask, reference);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetStencilReference<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, reference);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindIndexBuffer", "commandBuffer, buffer, offset, indexType", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindIndexBuffer<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, indexType);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindIndexBuffer(commandBuffer, buffer, offset, indexType);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindIndexBuffer<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, indexType);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindVertexBuffers", "commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindVertexBuffers<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindVertexBuffers<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDraw", "commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDraw<Format>(ApiDumpInstance::current(), commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDraw<Format>(ApiDumpInstance::current(), commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndexed", "commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndexed<Format>(ApiDumpInstance::current(), commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndexed<Format>(ApiDumpInstance::current(), commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndirect", "commandBuffer, buffer, offset, drawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndirect<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, drawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndirect<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, drawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndexedIndirect", "commandBuffer, buffer, offset, drawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndexedIndirect<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, drawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndexedIndirect<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, drawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBlitImage", "commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBlitImage<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBlitImage<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdClearDepthStencilImage", "commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdClearDepthStencilImage<Format>(ApiDumpInstance::current(), commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
        }
    }
    device_dispatch_table(commandBuffer)->CmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdClearDepthStencilImage<Format>(ApiDumpInstance::current(), commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdClearAttachments", "commandBuffer, attachmentCount, pAttachments, rectCount, pRects", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdClearAttachments<Format>(ApiDumpInstance::current(), commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
        }
    }
    device_dispatch_table(commandBuffer)->CmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdClearAttachments<Format>(ApiDumpInstance::current(), commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdResolveImage", "commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdResolveImage<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        }
    }
    device_dispatch_table(commandBuffer)->CmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdResolveImage<Format>(ApiDumpInstance::current(), commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginRenderPass", "commandBuffer, pRenderPassBegin, contents", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginRenderPass<Format>(ApiDumpInstance::current(), commandBuffer, pRenderPassBegin, contents);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginRenderPass<Format>(ApiDumpInstance::current(), commandBuffer, pRenderPassBegin, contents);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdNextSubpass", "commandBuffer, contents", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdNextSubpass<Format>(ApiDumpInstance::current(), commandBuffer, contents);
        }
    }
    device_dispatch_table(commandBuffer)->CmdNextSubpass(commandBuffer, contents);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdNextSubpass<Format>(ApiDumpInstance::current(), commandBuffer, contents);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndRenderPass(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndRenderPass", "commandBuffer", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndRenderPass<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndRenderPass(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndRenderPass<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindBufferMemory2", "device, bindInfoCount, pBindInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindBufferMemory2<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BindBufferMemory2(device, bindInfoCount, pBindInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindBufferMemory2<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindImageMemory2", "device, bindInfoCount, pBindInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindImageMemory2<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BindImageMemory2(device, bindInfoCount, pBindInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindImageMemory2<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceGroupPeerMemoryFeatures", "device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceGroupPeerMemoryFeatures<Format>(ApiDumpInstance::current(), device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
        }
    }
    device_dispatch_table(device)->GetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceGroupPeerMemoryFeatures<Format>(ApiDumpInstance::current(), device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDeviceMask", "commandBuffer, deviceMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDeviceMask<Format>(ApiDumpInstance::current(), commandBuffer, deviceMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDeviceMask(commandBuffer, deviceMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDeviceMask<Format>(ApiDumpInstance::current(), commandBuffer, deviceMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageMemoryRequirements2", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageMemoryRequirements2<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetImageMemoryRequirements2(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageMemoryRequirements2<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferMemoryRequirements2", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferMemoryRequirements2<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferMemoryRequirements2<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageSparseMemoryRequirements2", "device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageSparseMemoryRequirements2<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageSparseMemoryRequirements2<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkTrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkTrimCommandPool", "device, commandPool, flags", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkTrimCommandPool<Format>(ApiDumpInstance::current(), device, commandPool, flags);
        }
    }
    device_dispatch_table(device)->TrimCommandPool(device, commandPool, flags);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkTrimCommandPool<Format>(ApiDumpInstance::current(), device, commandPool, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceQueue2", "device, pQueueInfo, pQueue", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceQueue2<Format>(ApiDumpInstance::current(), device, pQueueInfo, pQueue);
        }
    }
    device_dispatch_table(device)->GetDeviceQueue2(device, pQueueInfo, pQueue);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceQueue2<Format>(ApiDumpInstance::current(), device, pQueueInfo, pQueue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatchBase", "commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatchBase<Format>(ApiDumpInstance::current(), commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatchBase<Format>(ApiDumpInstance::current(), commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateDescriptorUpdateTemplate", "device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDescriptorUpdateTemplate<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDescriptorUpdateTemplate<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyDescriptorUpdateTemplate", "device, descriptorUpdateTemplate, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDescriptorUpdateTemplate<Format>(ApiDumpInstance::current(), device, descriptorUpdateTemplate, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDescriptorUpdateTemplate<Format>(ApiDumpInstance::current(), device, descriptorUpdateTemplate, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkUpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUpdateDescriptorSetWithTemplate", "device, descriptorSet, descriptorUpdateTemplate, pData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUpdateDescriptorSetWithTemplate<Format>(ApiDumpInstance::current(), device, descriptorSet, descriptorUpdateTemplate, pData);
        }
    }
    device_dispatch_table(device)->UpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUpdateDescriptorSetWithTemplate<Format>(ApiDumpInstance::current(), device, descriptorSet, descriptorUpdateTemplate, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDescriptorSetLayoutSupport", "device, pCreateInfo, pSupport", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDescriptorSetLayoutSupport<Format>(ApiDumpInstance::current(), device, pCreateInfo, pSupport);
        }
    }
    device_dispatch_table(device)->GetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDescriptorSetLayoutSupport<Format>(ApiDumpInstance::current(), device, pCreateInfo, pSupport);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateSamplerYcbcrConversion", "device, pCreateInfo, pAllocator, pYcbcrConversion", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateSamplerYcbcrConversion<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pYcbcrConversion);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateSamplerYcbcrConversion<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pYcbcrConversion);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroySamplerYcbcrConversion", "device, ycbcrConversion, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroySamplerYcbcrConversion<Format>(ApiDumpInstance::current(), device, ycbcrConversion, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroySamplerYcbcrConversion<Format>(ApiDumpInstance::current(), device, ycbcrConversion, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkResetQueryPool", "device, queryPool, firstQuery, queryCount", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkResetQueryPool<Format>(ApiDumpInstance::current(), device, queryPool, firstQuery, queryCount);
        }
    }
    device_dispatch_table(device)->ResetQueryPool(device, queryPool, firstQuery, queryCount);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkResetQueryPool<Format>(ApiDumpInstance::current(), device, queryPool, firstQuery, queryCount);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSemaphoreCounterValue", "device, semaphore, pValue", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSemaphoreCounterValue<Format>(ApiDumpInstance::current(), device, semaphore, pValue);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSemaphoreCounterValue(device, semaphore, pValue);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSemaphoreCounterValue<Format>(ApiDumpInstance::current(), device, semaphore, pValue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
    VkResult result = device_dispatch_table(device)->WaitSemaphores(device, pWaitInfo, timeout);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkWaitSemaphores", "device, pWaitInfo, timeout", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWaitSemaphores<Format>(ApiDumpInstance::current(), device, pWaitInfo, timeout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSignalSemaphore", "device, pSignalInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSignalSemaphore<Format>(ApiDumpInstance::current(), device, pSignalInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->SignalSemaphore(device, pSignalInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSignalSemaphore<Format>(ApiDumpInstance::current(), device, pSignalInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkDeviceAddress VKAPI_CALL vkGetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferDeviceAddress", "device, pInfo", "VkDeviceAddress");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferDeviceAddress<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    VkDeviceAddress result = device_dispatch_table(device)->GetBufferDeviceAddress(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkDeviceAddress", result, dump_return_value_VkDeviceAddress<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferDeviceAddress<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint64_t VKAPI_CALL vkGetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferOpaqueCaptureAddress", "device, pInfo", "uint64_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferOpaqueCaptureAddress<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    uint64_t result = device_dispatch_table(device)->GetBufferOpaqueCaptureAddress(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint64_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferOpaqueCaptureAddress<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint64_t VKAPI_CALL vkGetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceMemoryOpaqueCaptureAddress", "device, pInfo", "uint64_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceMemoryOpaqueCaptureAddress<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    uint64_t result = device_dispatch_table(device)->GetDeviceMemoryOpaqueCaptureAddress(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint64_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceMemoryOpaqueCaptureAddress<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndirectCount", "commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndirectCount<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndirectCount<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndexedIndirectCount", "commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndexedIndirectCount<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndexedIndirectCount<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateRenderPass2", "device, pCreateInfo, pAllocator, pRenderPass", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateRenderPass2<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pRenderPass);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateRenderPass2<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pRenderPass);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginRenderPass2", "commandBuffer, pRenderPassBegin, pSubpassBeginInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginRenderPass2<Format>(ApiDumpInstance::current(), commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginRenderPass2<Format>(ApiDumpInstance::current(), commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdNextSubpass2", "commandBuffer, pSubpassBeginInfo, pSubpassEndInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdNextSubpass2<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdNextSubpass2<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndRenderPass2", "commandBuffer, pSubpassEndInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndRenderPass2<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassEndInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndRenderPass2(commandBuffer, pSubpassEndInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndRenderPass2<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassEndInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreatePrivateDataSlot", "device, pCreateInfo, pAllocator, pPrivateDataSlot", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreatePrivateDataSlot<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPrivateDataSlot);
        }
    }
    VkResult result = device_dispatch_table(device)->CreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreatePrivateDataSlot<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPrivateDataSlot);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyPrivateDataSlot", "device, privateDataSlot, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyPrivateDataSlot<Format>(ApiDumpInstance::current(), device, privateDataSlot, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyPrivateDataSlot(device, privateDataSlot, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyPrivateDataSlot<Format>(ApiDumpInstance::current(), device, privateDataSlot, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetPrivateData", "device, objectType, objectHandle, privateDataSlot, data", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetPrivateData<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, data);
        }
    }
    VkResult result = device_dispatch_table(device)->SetPrivateData(device, objectType, objectHandle, privateDataSlot, data);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetPrivateData<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, data);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPrivateData", "device, objectType, objectHandle, privateDataSlot, pData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPrivateData<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, pData);
        }
    }
    device_dispatch_table(device)->GetPrivateData(device, objectType, objectHandle, privateDataSlot, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPrivateData<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPipelineBarrier2(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPipelineBarrier2", "commandBuffer, pDependencyInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPipelineBarrier2<Format>(ApiDumpInstance::current(), commandBuffer, pDependencyInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPipelineBarrier2(commandBuffer, pDependencyInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPipelineBarrier2<Format>(ApiDumpInstance::current(), commandBuffer, pDependencyInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWriteTimestamp2(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWriteTimestamp2", "commandBuffer, stage, queryPool, query", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWriteTimestamp2<Format>(ApiDumpInstance::current(), commandBuffer, stage, queryPool, query);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWriteTimestamp2(commandBuffer, stage, queryPool, query);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWriteTimestamp2<Format>(ApiDumpInstance::current(), commandBuffer, stage, queryPool, query);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkQueueSubmit2(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueSubmit2", "queue, submitCount, pSubmits, fence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueSubmit2<Format>(ApiDumpInstance::current(), queue, submitCount, pSubmits, fence);
        }
    }
    VkResult result = device_dispatch_table(queue)->QueueSubmit2(queue, submitCount, pSubmits, fence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueSubmit2<Format>(ApiDumpInstance::current(), queue, submitCount, pSubmits, fence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyBuffer2", "commandBuffer, pCopyBufferInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyBuffer2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyBuffer2(commandBuffer, pCopyBufferInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyBuffer2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyImage2", "commandBuffer, pCopyImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyImage2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyImage2(commandBuffer, pCopyImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyImage2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyBufferToImage2", "commandBuffer, pCopyBufferToImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyBufferToImage2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferToImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyBufferToImage2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferToImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyImageToBuffer2", "commandBuffer, pCopyImageToBufferInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyImageToBuffer2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageToBufferInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyImageToBuffer2<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageToBufferInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceBufferMemoryRequirements", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceBufferMemoryRequirements<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceBufferMemoryRequirements<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceImageMemoryRequirements", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceImageMemoryRequirements<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceImageMemoryRequirements<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceImageSparseMemoryRequirements", "device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceImageSparseMemoryRequirements<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceImageSparseMemoryRequirements<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetEvent2(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetEvent2", "commandBuffer, event, pDependencyInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetEvent2<Format>(ApiDumpInstance::current(), commandBuffer, event, pDependencyInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetEvent2(commandBuffer, event, pDependencyInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetEvent2<Format>(ApiDumpInstance::current(), commandBuffer, event, pDependencyInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdResetEvent2(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdResetEvent2", "commandBuffer, event, stageMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdResetEvent2<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdResetEvent2(commandBuffer, event, stageMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdResetEvent2<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWaitEvents2(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWaitEvents2", "commandBuffer, eventCount, pEvents, pDependencyInfos", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWaitEvents2<Format>(ApiDumpInstance::current(), commandBuffer, eventCount, pEvents, pDependencyInfos);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWaitEvents2<Format>(ApiDumpInstance::current(), commandBuffer, eventCount, pEvents, pDependencyInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBlitImage2", "commandBuffer, pBlitImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBlitImage2<Format>(ApiDumpInstance::current(), commandBuffer, pBlitImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBlitImage2(commandBuffer, pBlitImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBlitImage2<Format>(ApiDumpInstance::current(), commandBuffer, pBlitImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdResolveImage2", "commandBuffer, pResolveImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdResolveImage2<Format>(ApiDumpInstance::current(), commandBuffer, pResolveImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdResolveImage2(commandBuffer, pResolveImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdResolveImage2<Format>(ApiDumpInstance::current(), commandBuffer, pResolveImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginRendering(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginRendering", "commandBuffer, pRenderingInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginRendering<Format>(ApiDumpInstance::current(), commandBuffer, pRenderingInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginRendering(commandBuffer, pRenderingInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginRendering<Format>(ApiDumpInstance::current(), commandBuffer, pRenderingInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndRendering(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndRendering", "commandBuffer", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndRendering<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndRendering(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndRendering<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCullMode", "commandBuffer, cullMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCullMode<Format>(ApiDumpInstance::current(), commandBuffer, cullMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCullMode(commandBuffer, cullMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCullMode<Format>(ApiDumpInstance::current(), commandBuffer, cullMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetFrontFace", "commandBuffer, frontFace", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetFrontFace<Format>(ApiDumpInstance::current(), commandBuffer, frontFace);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetFrontFace(commandBuffer, frontFace);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetFrontFace<Format>(ApiDumpInstance::current(), commandBuffer, frontFace);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPrimitiveTopology", "commandBuffer, primitiveTopology", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPrimitiveTopology<Format>(ApiDumpInstance::current(), commandBuffer, primitiveTopology);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetPrimitiveTopology(commandBuffer, primitiveTopology);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPrimitiveTopology<Format>(ApiDumpInstance::current(), commandBuffer, primitiveTopology);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetViewportWithCount", "commandBuffer, viewportCount, pViewports", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetViewportWithCount<Format>(ApiDumpInstance::current(), commandBuffer, viewportCount, pViewports);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetViewportWithCount(commandBuffer, viewportCount, pViewports);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetViewportWithCount<Format>(ApiDumpInstance::current(), commandBuffer, viewportCount, pViewports);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetScissorWithCount", "commandBuffer, scissorCount, pScissors", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetScissorWithCount<Format>(ApiDumpInstance::current(), commandBuffer, scissorCount, pScissors);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetScissorWithCount(commandBuffer, scissorCount, pScissors);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetScissorWithCount<Format>(ApiDumpInstance::current(), commandBuffer, scissorCount, pScissors);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindVertexBuffers2", "commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindVertexBuffers2<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindVertexBuffers2<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthTestEnable", "commandBuffer, depthTestEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthTestEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthTestEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthTestEnable(commandBuffer, depthTestEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthTestEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthTestEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthWriteEnable", "commandBuffer, depthWriteEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthWriteEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthWriteEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthWriteEnable(commandBuffer, depthWriteEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthWriteEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthWriteEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthCompareOp", "commandBuffer, depthCompareOp", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthCompareOp<Format>(ApiDumpInstance::current(), commandBuffer, depthCompareOp);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthCompareOp(commandBuffer, depthCompareOp);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthCompareOp<Format>(ApiDumpInstance::current(), commandBuffer, depthCompareOp);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthBoundsTestEnable", "commandBuffer, depthBoundsTestEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthBoundsTestEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthBoundsTestEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthBoundsTestEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthBoundsTestEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetStencilTestEnable", "commandBuffer, stencilTestEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetStencilTestEnable<Format>(ApiDumpInstance::current(), commandBuffer, stencilTestEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetStencilTestEnable(commandBuffer, stencilTestEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetStencilTestEnable<Format>(ApiDumpInstance::current(), commandBuffer, stencilTestEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetStencilOp", "commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetStencilOp<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetStencilOp<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRasterizerDiscardEnable", "commandBuffer, rasterizerDiscardEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRasterizerDiscardEnable<Format>(ApiDumpInstance::current(), commandBuffer, rasterizerDiscardEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRasterizerDiscardEnable<Format>(ApiDumpInstance::current(), commandBuffer, rasterizerDiscardEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthBiasEnable", "commandBuffer, depthBiasEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthBiasEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthBiasEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthBiasEnable(commandBuffer, depthBiasEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthBiasEnable<Format>(ApiDumpInstance::current(), commandBuffer, depthBiasEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPrimitiveRestartEnable", "commandBuffer, primitiveRestartEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPrimitiveRestartEnable<Format>(ApiDumpInstance::current(), commandBuffer, primitiveRestartEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPrimitiveRestartEnable<Format>(ApiDumpInstance::current(), commandBuffer, primitiveRestartEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkMapMemory2(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkMapMemory2", "device, pMemoryMapInfo, ppData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkMapMemory2<Format>(ApiDumpInstance::current(), device, pMemoryMapInfo, ppData);
        }
    }
    VkResult result = device_dispatch_table(device)->MapMemory2(device, pMemoryMapInfo, ppData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkMapMemory2<Format>(ApiDumpInstance::current(), device, pMemoryMapInfo, ppData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkUnmapMemory2(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUnmapMemory2", "device, pMemoryUnmapInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUnmapMemory2<Format>(ApiDumpInstance::current(), device, pMemoryUnmapInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->UnmapMemory2(device, pMemoryUnmapInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUnmapMemory2<Format>(ApiDumpInstance::current(), device, pMemoryUnmapInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceImageSubresourceLayout", "device, pInfo, pLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceImageSubresourceLayout<Format>(ApiDumpInstance::current(), device, pInfo, pLayout);
        }
    }
    device_dispatch_table(device)->GetDeviceImageSubresourceLayout(device, pInfo, pLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceImageSubresourceLayout<Format>(ApiDumpInstance::current(), device, pInfo, pLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageSubresourceLayout2", "device, image, pSubresource, pLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageSubresourceLayout2<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        }
    }
    device_dispatch_table(device)->GetImageSubresourceLayout2(device, image, pSubresource, pLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageSubresourceLayout2<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyMemoryToImage", "device, pCopyMemoryToImageInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyMemoryToImage<Format>(ApiDumpInstance::current(), device, pCopyMemoryToImageInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyMemoryToImage(device, pCopyMemoryToImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyMemoryToImage<Format>(ApiDumpInstance::current(), device, pCopyMemoryToImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyImageToMemory", "device, pCopyImageToMemoryInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyImageToMemory<Format>(ApiDumpInstance::current(), device, pCopyImageToMemoryInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyImageToMemory(device, pCopyImageToMemoryInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyImageToMemory<Format>(ApiDumpInstance::current(), device, pCopyImageToMemoryInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyImageToImage(VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyImageToImage", "device, pCopyImageToImageInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyImageToImage<Format>(ApiDumpInstance::current(), device, pCopyImageToImageInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyImageToImage(device, pCopyImageToImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyImageToImage<Format>(ApiDumpInstance::current(), device, pCopyImageToImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkTransitionImageLayout(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkTransitionImageLayout", "device, transitionCount, pTransitions", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkTransitionImageLayout<Format>(ApiDumpInstance::current(), device, transitionCount, pTransitions);
        }
    }
    VkResult result = device_dispatch_table(device)->TransitionImageLayout(device, transitionCount, pTransitions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkTransitionImageLayout<Format>(ApiDumpInstance::current(), device, transitionCount, pTransitions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSet", "commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSet<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSet<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSetWithTemplate", "commandBuffer, descriptorUpdateTemplate, layout, set, pData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSetWithTemplate<Format>(ApiDumpInstance::current(), commandBuffer, descriptorUpdateTemplate, layout, set, pData);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSetWithTemplate<Format>(ApiDumpInstance::current(), commandBuffer, descriptorUpdateTemplate, layout, set, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindDescriptorSets2(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindDescriptorSets2", "commandBuffer, pBindDescriptorSetsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindDescriptorSets2<Format>(ApiDumpInstance::current(), commandBuffer, pBindDescriptorSetsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindDescriptorSets2<Format>(ApiDumpInstance::current(), commandBuffer, pBindDescriptorSetsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushConstants2", "commandBuffer, pPushConstantsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushConstants2<Format>(ApiDumpInstance::current(), commandBuffer, pPushConstantsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushConstants2(commandBuffer, pPushConstantsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushConstants2<Format>(ApiDumpInstance::current(), commandBuffer, pPushConstantsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSet2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSet2", "commandBuffer, pPushDescriptorSetInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSet2<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSet2<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSetWithTemplate2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSetWithTemplate2", "commandBuffer, pPushDescriptorSetWithTemplateInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSetWithTemplate2<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetWithTemplateInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSetWithTemplate2<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetWithTemplateInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLineStipple", "commandBuffer, lineStippleFactor, lineStipplePattern", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLineStipple<Format>(ApiDumpInstance::current(), commandBuffer, lineStippleFactor, lineStipplePattern);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLineStipple<Format>(ApiDumpInstance::current(), commandBuffer, lineStippleFactor, lineStipplePattern);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindIndexBuffer2", "commandBuffer, buffer, offset, size, indexType", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindIndexBuffer2<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, size, indexType);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindIndexBuffer2<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, size, indexType);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetRenderingAreaGranularity", "device, pRenderingAreaInfo, pGranularity", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetRenderingAreaGranularity<Format>(ApiDumpInstance::current(), device, pRenderingAreaInfo, pGranularity);
        }
    }
    device_dispatch_table(device)->GetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetRenderingAreaGranularity<Format>(ApiDumpInstance::current(), device, pRenderingAreaInfo, pGranularity);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRenderingAttachmentLocations", "commandBuffer, pLocationInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRenderingAttachmentLocations<Format>(ApiDumpInstance::current(), commandBuffer, pLocationInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRenderingAttachmentLocations<Format>(ApiDumpInstance::current(), commandBuffer, pLocationInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRenderingInputAttachmentIndices(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRenderingInputAttachmentIndices", "commandBuffer, pInputAttachmentIndexInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRenderingInputAttachmentIndices<Format>(ApiDumpInstance::current(), commandBuffer, pInputAttachmentIndexInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRenderingInputAttachmentIndices<Format>(ApiDumpInstance::current(), commandBuffer, pInputAttachmentIndexInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateSwapchainKHR", "device, pCreateInfo, pAllocator, pSwapchain", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateSwapchainKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSwapchain);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateSwapchainKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSwapchain);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroySwapchainKHR", "device, swapchain, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroySwapchainKHR<Format>(ApiDumpInstance::current(), device, swapchain, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroySwapchainKHR(device, swapchain, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroySwapchainKHR<Format>(ApiDumpInstance::current(), device, swapchain, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSwapchainImagesKHR", "device, swapchain, pSwapchainImageCount, pSwapchainImages", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSwapchainImagesKHR<Format>(ApiDumpInstance::current(), device, swapchain, pSwapchainImageCount, pSwapchainImages);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSwapchainImagesKHR<Format>(ApiDumpInstance::current(), device, swapchain, pSwapchainImageCount, pSwapchainImages);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) {
    VkResult result = device_dispatch_table(device)->AcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkAcquireNextImageKHR", "device, swapchain, timeout, semaphore, fence, pImageIndex", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquireNextImageKHR<Format>(ApiDumpInstance::current(), device, swapchain, timeout, semaphore, fence, pImageIndex);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkQueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) {
    VkResult result = device_dispatch_table(queue)->QueuePresentKHR(queue, pPresentInfo);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkQueuePresentKHR", "queue, pPresentInfo", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueuePresentKHR<Format>(ApiDumpInstance::current(), queue, pPresentInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    ApiDumpInstance::current().nextFrame();
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceGroupPresentCapabilitiesKHR", "device, pDeviceGroupPresentCapabilities", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceGroupPresentCapabilitiesKHR<Format>(ApiDumpInstance::current(), device, pDeviceGroupPresentCapabilities);
        }
    }
    VkResult result = device_dispatch_table(device)->GetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceGroupPresentCapabilitiesKHR<Format>(ApiDumpInstance::current(), device, pDeviceGroupPresentCapabilities);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceGroupSurfacePresentModesKHR", "device, surface, pModes", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceGroupSurfacePresentModesKHR<Format>(ApiDumpInstance::current(), device, surface, pModes);
        }
    }
    VkResult result = device_dispatch_table(device)->GetDeviceGroupSurfacePresentModesKHR(device, surface, pModes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceGroupSurfacePresentModesKHR<Format>(ApiDumpInstance::current(), device, surface, pModes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkAcquireNextImage2KHR", "device, pAcquireInfo, pImageIndex", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAcquireNextImage2KHR<Format>(ApiDumpInstance::current(), device, pAcquireInfo, pImageIndex);
        }
    }
    VkResult result = device_dispatch_table(device)->AcquireNextImage2KHR(device, pAcquireInfo, pImageIndex);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquireNextImage2KHR<Format>(ApiDumpInstance::current(), device, pAcquireInfo, pImageIndex);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateSharedSwapchainsKHR", "device, swapchainCount, pCreateInfos, pAllocator, pSwapchains", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateSharedSwapchainsKHR<Format>(ApiDumpInstance::current(), device, swapchainCount, pCreateInfos, pAllocator, pSwapchains);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateSharedSwapchainsKHR<Format>(ApiDumpInstance::current(), device, swapchainCount, pCreateInfos, pAllocator, pSwapchains);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateVideoSessionKHR", "device, pCreateInfo, pAllocator, pVideoSession", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateVideoSessionKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pVideoSession);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateVideoSessionKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pVideoSession);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyVideoSessionKHR", "device, videoSession, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyVideoSessionKHR<Format>(ApiDumpInstance::current(), device, videoSession, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyVideoSessionKHR(device, videoSession, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyVideoSessionKHR<Format>(ApiDumpInstance::current(), device, videoSession, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetVideoSessionMemoryRequirementsKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t* pMemoryRequirementsCount, VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetVideoSessionMemoryRequirementsKHR", "device, videoSession, pMemoryRequirementsCount, pMemoryRequirements", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetVideoSessionMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, videoSession, pMemoryRequirementsCount, pMemoryRequirements);
        }
    }
    VkResult result = device_dispatch_table(device)->GetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetVideoSessionMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, videoSession, pMemoryRequirementsCount, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindVideoSessionMemoryKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t bindSessionMemoryInfoCount, const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindVideoSessionMemoryKHR", "device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindVideoSessionMemoryKHR<Format>(ApiDumpInstance::current(), device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindVideoSessionMemoryKHR<Format>(ApiDumpInstance::current(), device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateVideoSessionParametersKHR(VkDevice device, const VkVideoSessionParametersCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionParametersKHR* pVideoSessionParameters) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateVideoSessionParametersKHR", "device, pCreateInfo, pAllocator, pVideoSessionParameters", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pVideoSessionParameters);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pVideoSessionParameters);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkUpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUpdateVideoSessionParametersKHR", "device, videoSessionParameters, pUpdateInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUpdateVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, videoSessionParameters, pUpdateInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->UpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUpdateVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, videoSessionParameters, pUpdateInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyVideoSessionParametersKHR", "device, videoSessionParameters, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, videoSessionParameters, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, videoSessionParameters, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginVideoCodingKHR", "commandBuffer, pBeginInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginVideoCodingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pBeginInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginVideoCodingKHR(commandBuffer, pBeginInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginVideoCodingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pBeginInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndVideoCodingKHR", "commandBuffer, pEndCodingInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndVideoCodingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pEndCodingInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndVideoCodingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pEndCodingInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdControlVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoCodingControlInfoKHR* pCodingControlInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdControlVideoCodingKHR", "commandBuffer, pCodingControlInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdControlVideoCodingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pCodingControlInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdControlVideoCodingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pCodingControlInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDecodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDecodeVideoKHR", "commandBuffer, pDecodeInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDecodeVideoKHR<Format>(ApiDumpInstance::current(), commandBuffer, pDecodeInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDecodeVideoKHR(commandBuffer, pDecodeInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDecodeVideoKHR<Format>(ApiDumpInstance::current(), commandBuffer, pDecodeInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginRenderingKHR(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginRenderingKHR", "commandBuffer, pRenderingInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginRenderingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pRenderingInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginRenderingKHR(commandBuffer, pRenderingInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginRenderingKHR<Format>(ApiDumpInstance::current(), commandBuffer, pRenderingInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndRenderingKHR(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndRenderingKHR", "commandBuffer", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndRenderingKHR<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndRenderingKHR(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndRenderingKHR<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceGroupPeerMemoryFeaturesKHR", "device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceGroupPeerMemoryFeaturesKHR<Format>(ApiDumpInstance::current(), device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
        }
    }
    device_dispatch_table(device)->GetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceGroupPeerMemoryFeaturesKHR<Format>(ApiDumpInstance::current(), device, heapIndex, localDeviceIndex, remoteDeviceIndex, pPeerMemoryFeatures);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDeviceMaskKHR", "commandBuffer, deviceMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDeviceMaskKHR<Format>(ApiDumpInstance::current(), commandBuffer, deviceMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDeviceMaskKHR(commandBuffer, deviceMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDeviceMaskKHR<Format>(ApiDumpInstance::current(), commandBuffer, deviceMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatchBaseKHR", "commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatchBaseKHR<Format>(ApiDumpInstance::current(), commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatchBaseKHR<Format>(ApiDumpInstance::current(), commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkTrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkTrimCommandPoolKHR", "device, commandPool, flags", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkTrimCommandPoolKHR<Format>(ApiDumpInstance::current(), device, commandPool, flags);
        }
    }
    device_dispatch_table(device)->TrimCommandPoolKHR(device, commandPool, flags);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkTrimCommandPoolKHR<Format>(ApiDumpInstance::current(), device, commandPool, flags);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryWin32HandleKHR", "device, pGetWin32HandleInfo, pHandle", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pGetWin32HandleInfo, pHandle);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pGetWin32HandleInfo, pHandle);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryWin32HandlePropertiesKHR", "device, handleType, handle, pMemoryWin32HandleProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryWin32HandlePropertiesKHR<Format>(ApiDumpInstance::current(), device, handleType, handle, pMemoryWin32HandleProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryWin32HandlePropertiesKHR<Format>(ApiDumpInstance::current(), device, handleType, handle, pMemoryWin32HandleProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryFdKHR", "device, pGetFdInfo, pFd", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryFdKHR<Format>(ApiDumpInstance::current(), device, pGetFdInfo, pFd);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryFdKHR(device, pGetFdInfo, pFd);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryFdKHR<Format>(ApiDumpInstance::current(), device, pGetFdInfo, pFd);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryFdPropertiesKHR", "device, handleType, fd, pMemoryFdProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryFdPropertiesKHR<Format>(ApiDumpInstance::current(), device, handleType, fd, pMemoryFdProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryFdPropertiesKHR<Format>(ApiDumpInstance::current(), device, handleType, fd, pMemoryFdProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkImportSemaphoreWin32HandleKHR", "device, pImportSemaphoreWin32HandleInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkImportSemaphoreWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pImportSemaphoreWin32HandleInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->ImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkImportSemaphoreWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pImportSemaphoreWin32HandleInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSemaphoreWin32HandleKHR", "device, pGetWin32HandleInfo, pHandle", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSemaphoreWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pGetWin32HandleInfo, pHandle);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSemaphoreWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pGetWin32HandleInfo, pHandle);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkImportSemaphoreFdKHR", "device, pImportSemaphoreFdInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkImportSemaphoreFdKHR<Format>(ApiDumpInstance::current(), device, pImportSemaphoreFdInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->ImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkImportSemaphoreFdKHR<Format>(ApiDumpInstance::current(), device, pImportSemaphoreFdInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSemaphoreFdKHR", "device, pGetFdInfo, pFd", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSemaphoreFdKHR<Format>(ApiDumpInstance::current(), device, pGetFdInfo, pFd);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSemaphoreFdKHR(device, pGetFdInfo, pFd);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSemaphoreFdKHR<Format>(ApiDumpInstance::current(), device, pGetFdInfo, pFd);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSetKHR", "commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSetKHR<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSetKHR<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount, pDescriptorWrites);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSetWithTemplateKHR", "commandBuffer, descriptorUpdateTemplate, layout, set, pData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSetWithTemplateKHR<Format>(ApiDumpInstance::current(), commandBuffer, descriptorUpdateTemplate, layout, set, pData);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSetWithTemplateKHR<Format>(ApiDumpInstance::current(), commandBuffer, descriptorUpdateTemplate, layout, set, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateDescriptorUpdateTemplateKHR", "device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDescriptorUpdateTemplateKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDescriptorUpdateTemplateKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyDescriptorUpdateTemplateKHR", "device, descriptorUpdateTemplate, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDescriptorUpdateTemplateKHR<Format>(ApiDumpInstance::current(), device, descriptorUpdateTemplate, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDescriptorUpdateTemplateKHR<Format>(ApiDumpInstance::current(), device, descriptorUpdateTemplate, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkUpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUpdateDescriptorSetWithTemplateKHR", "device, descriptorSet, descriptorUpdateTemplate, pData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUpdateDescriptorSetWithTemplateKHR<Format>(ApiDumpInstance::current(), device, descriptorSet, descriptorUpdateTemplate, pData);
        }
    }
    device_dispatch_table(device)->UpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUpdateDescriptorSetWithTemplateKHR<Format>(ApiDumpInstance::current(), device, descriptorSet, descriptorUpdateTemplate, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateRenderPass2KHR", "device, pCreateInfo, pAllocator, pRenderPass", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateRenderPass2KHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pRenderPass);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateRenderPass2KHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pRenderPass);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginRenderPass2KHR", "commandBuffer, pRenderPassBegin, pSubpassBeginInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginRenderPass2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginRenderPass2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdNextSubpass2KHR", "commandBuffer, pSubpassBeginInfo, pSubpassEndInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdNextSubpass2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdNextSubpass2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndRenderPass2KHR", "commandBuffer, pSubpassEndInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndRenderPass2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassEndInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndRenderPass2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pSubpassEndInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSwapchainStatusKHR", "device, swapchain", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSwapchainStatusKHR<Format>(ApiDumpInstance::current(), device, swapchain);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSwapchainStatusKHR(device, swapchain);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSwapchainStatusKHR<Format>(ApiDumpInstance::current(), device, swapchain);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkImportFenceWin32HandleKHR", "device, pImportFenceWin32HandleInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkImportFenceWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pImportFenceWin32HandleInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->ImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkImportFenceWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pImportFenceWin32HandleInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetFenceWin32HandleKHR", "device, pGetWin32HandleInfo, pHandle", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetFenceWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pGetWin32HandleInfo, pHandle);
        }
    }
    VkResult result = device_dispatch_table(device)->GetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetFenceWin32HandleKHR<Format>(ApiDumpInstance::current(), device, pGetWin32HandleInfo, pHandle);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkImportFenceFdKHR", "device, pImportFenceFdInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkImportFenceFdKHR<Format>(ApiDumpInstance::current(), device, pImportFenceFdInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->ImportFenceFdKHR(device, pImportFenceFdInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkImportFenceFdKHR<Format>(ApiDumpInstance::current(), device, pImportFenceFdInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetFenceFdKHR", "device, pGetFdInfo, pFd", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetFenceFdKHR<Format>(ApiDumpInstance::current(), device, pGetFdInfo, pFd);
        }
    }
    VkResult result = device_dispatch_table(device)->GetFenceFdKHR(device, pGetFdInfo, pFd);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetFenceFdKHR<Format>(ApiDumpInstance::current(), device, pGetFdInfo, pFd);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkAcquireProfilingLockKHR", "device, pInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAcquireProfilingLockKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->AcquireProfilingLockKHR(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquireProfilingLockKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkReleaseProfilingLockKHR(VkDevice device) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkReleaseProfilingLockKHR", "device", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkReleaseProfilingLockKHR<Format>(ApiDumpInstance::current(), device);
        }
    }
    device_dispatch_table(device)->ReleaseProfilingLockKHR(device);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkReleaseProfilingLockKHR<Format>(ApiDumpInstance::current(), device);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageMemoryRequirements2KHR", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageMemoryRequirements2KHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageMemoryRequirements2KHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferMemoryRequirements2KHR", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferMemoryRequirements2KHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferMemoryRequirements2KHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageSparseMemoryRequirements2KHR", "device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageSparseMemoryRequirements2KHR<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageSparseMemoryRequirements2KHR<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateSamplerYcbcrConversionKHR", "device, pCreateInfo, pAllocator, pYcbcrConversion", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateSamplerYcbcrConversionKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pYcbcrConversion);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateSamplerYcbcrConversionKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pYcbcrConversion);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroySamplerYcbcrConversionKHR", "device, ycbcrConversion, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroySamplerYcbcrConversionKHR<Format>(ApiDumpInstance::current(), device, ycbcrConversion, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroySamplerYcbcrConversionKHR<Format>(ApiDumpInstance::current(), device, ycbcrConversion, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindBufferMemory2KHR", "device, bindInfoCount, pBindInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindBufferMemory2KHR<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BindBufferMemory2KHR(device, bindInfoCount, pBindInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindBufferMemory2KHR<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindImageMemory2KHR", "device, bindInfoCount, pBindInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindImageMemory2KHR<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BindImageMemory2KHR(device, bindInfoCount, pBindInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindImageMemory2KHR<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDescriptorSetLayoutSupportKHR", "device, pCreateInfo, pSupport", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDescriptorSetLayoutSupportKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pSupport);
        }
    }
    device_dispatch_table(device)->GetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDescriptorSetLayoutSupportKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pSupport);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndirectCountKHR", "commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndirectCountKHR<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndirectCountKHR<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndexedIndirectCountKHR", "commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndexedIndirectCountKHR<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndexedIndirectCountKHR<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSemaphoreCounterValueKHR", "device, semaphore, pValue", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSemaphoreCounterValueKHR<Format>(ApiDumpInstance::current(), device, semaphore, pValue);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSemaphoreCounterValueKHR(device, semaphore, pValue);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSemaphoreCounterValueKHR<Format>(ApiDumpInstance::current(), device, semaphore, pValue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
    VkResult result = device_dispatch_table(device)->WaitSemaphoresKHR(device, pWaitInfo, timeout);
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    dump_function_head(ApiDumpInstance::current(), "vkWaitSemaphoresKHR", "device, pWaitInfo, timeout", "VkResult");
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWaitSemaphoresKHR<Format>(ApiDumpInstance::current(), device, pWaitInfo, timeout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSignalSemaphoreKHR", "device, pSignalInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSignalSemaphoreKHR<Format>(ApiDumpInstance::current(), device, pSignalInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->SignalSemaphoreKHR(device, pSignalInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSignalSemaphoreKHR<Format>(ApiDumpInstance::current(), device, pSignalInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetFragmentShadingRateKHR(VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize, const VkFragmentShadingRateCombinerOpKHR combinerOps[2]) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetFragmentShadingRateKHR", "commandBuffer, pFragmentSize, combinerOps", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetFragmentShadingRateKHR<Format>(ApiDumpInstance::current(), commandBuffer, pFragmentSize, combinerOps);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetFragmentShadingRateKHR<Format>(ApiDumpInstance::current(), commandBuffer, pFragmentSize, combinerOps);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRenderingAttachmentLocationsKHR(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRenderingAttachmentLocationsKHR", "commandBuffer, pLocationInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRenderingAttachmentLocationsKHR<Format>(ApiDumpInstance::current(), commandBuffer, pLocationInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRenderingAttachmentLocationsKHR<Format>(ApiDumpInstance::current(), commandBuffer, pLocationInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRenderingInputAttachmentIndicesKHR(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRenderingInputAttachmentIndicesKHR", "commandBuffer, pInputAttachmentIndexInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRenderingInputAttachmentIndicesKHR<Format>(ApiDumpInstance::current(), commandBuffer, pInputAttachmentIndexInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRenderingInputAttachmentIndicesKHR<Format>(ApiDumpInstance::current(), commandBuffer, pInputAttachmentIndexInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWaitForPresentKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkWaitForPresentKHR", "device, swapchain, presentId, timeout", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkWaitForPresentKHR<Format>(ApiDumpInstance::current(), device, swapchain, presentId, timeout);
        }
    }
    VkResult result = device_dispatch_table(device)->WaitForPresentKHR(device, swapchain, presentId, timeout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWaitForPresentKHR<Format>(ApiDumpInstance::current(), device, swapchain, presentId, timeout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkDeviceAddress VKAPI_CALL vkGetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferDeviceAddressKHR", "device, pInfo", "VkDeviceAddress");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferDeviceAddressKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    VkDeviceAddress result = device_dispatch_table(device)->GetBufferDeviceAddressKHR(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkDeviceAddress", result, dump_return_value_VkDeviceAddress<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferDeviceAddressKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint64_t VKAPI_CALL vkGetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferOpaqueCaptureAddressKHR", "device, pInfo", "uint64_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferOpaqueCaptureAddressKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    uint64_t result = device_dispatch_table(device)->GetBufferOpaqueCaptureAddressKHR(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint64_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferOpaqueCaptureAddressKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint64_t VKAPI_CALL vkGetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceMemoryOpaqueCaptureAddressKHR", "device, pInfo", "uint64_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceMemoryOpaqueCaptureAddressKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    uint64_t result = device_dispatch_table(device)->GetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint64_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceMemoryOpaqueCaptureAddressKHR<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateDeferredOperationKHR", "device, pAllocator, pDeferredOperation", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateDeferredOperationKHR<Format>(ApiDumpInstance::current(), device, pAllocator, pDeferredOperation);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateDeferredOperationKHR(device, pAllocator, pDeferredOperation);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateDeferredOperationKHR<Format>(ApiDumpInstance::current(), device, pAllocator, pDeferredOperation);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyDeferredOperationKHR", "device, operation, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyDeferredOperationKHR<Format>(ApiDumpInstance::current(), device, operation, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyDeferredOperationKHR(device, operation, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyDeferredOperationKHR<Format>(ApiDumpInstance::current(), device, operation, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint32_t VKAPI_CALL vkGetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeferredOperationMaxConcurrencyKHR", "device, operation", "uint32_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeferredOperationMaxConcurrencyKHR<Format>(ApiDumpInstance::current(), device, operation);
        }
    }
    uint32_t result = device_dispatch_table(device)->GetDeferredOperationMaxConcurrencyKHR(device, operation);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint32_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeferredOperationMaxConcurrencyKHR<Format>(ApiDumpInstance::current(), device, operation);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeferredOperationResultKHR", "device, operation", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeferredOperationResultKHR<Format>(ApiDumpInstance::current(), device, operation);
        }
    }
    VkResult result = device_dispatch_table(device)->GetDeferredOperationResultKHR(device, operation);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeferredOperationResultKHR<Format>(ApiDumpInstance::current(), device, operation);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkDeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDeferredOperationJoinKHR", "device, operation", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDeferredOperationJoinKHR<Format>(ApiDumpInstance::current(), device, operation);
        }
    }
    VkResult result = device_dispatch_table(device)->DeferredOperationJoinKHR(device, operation);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDeferredOperationJoinKHR<Format>(ApiDumpInstance::current(), device, operation);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPipelineExecutablePropertiesKHR(VkDevice device, const VkPipelineInfoKHR* pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineExecutablePropertiesKHR", "device, pPipelineInfo, pExecutableCount, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineExecutablePropertiesKHR<Format>(ApiDumpInstance::current(), device, pPipelineInfo, pExecutableCount, pProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineExecutablePropertiesKHR<Format>(ApiDumpInstance::current(), device, pPipelineInfo, pExecutableCount, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPipelineExecutableStatisticsKHR(VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineExecutableStatisticsKHR", "device, pExecutableInfo, pStatisticCount, pStatistics", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineExecutableStatisticsKHR<Format>(ApiDumpInstance::current(), device, pExecutableInfo, pStatisticCount, pStatistics);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineExecutableStatisticsKHR<Format>(ApiDumpInstance::current(), device, pExecutableInfo, pStatisticCount, pStatistics);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPipelineExecutableInternalRepresentationsKHR(VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineExecutableInternalRepresentationsKHR", "device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineExecutableInternalRepresentationsKHR<Format>(ApiDumpInstance::current(), device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPipelineExecutableInternalRepresentationsKHR(device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineExecutableInternalRepresentationsKHR<Format>(ApiDumpInstance::current(), device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkMapMemory2KHR(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkMapMemory2KHR", "device, pMemoryMapInfo, ppData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkMapMemory2KHR<Format>(ApiDumpInstance::current(), device, pMemoryMapInfo, ppData);
        }
    }
    VkResult result = device_dispatch_table(device)->MapMemory2KHR(device, pMemoryMapInfo, ppData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkMapMemory2KHR<Format>(ApiDumpInstance::current(), device, pMemoryMapInfo, ppData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkUnmapMemory2KHR(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUnmapMemory2KHR", "device, pMemoryUnmapInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUnmapMemory2KHR<Format>(ApiDumpInstance::current(), device, pMemoryUnmapInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->UnmapMemory2KHR(device, pMemoryUnmapInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUnmapMemory2KHR<Format>(ApiDumpInstance::current(), device, pMemoryUnmapInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetEncodedVideoSessionParametersKHR(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo, VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetEncodedVideoSessionParametersKHR", "device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetEncodedVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetEncodedVideoSessionParametersKHR<Format>(ApiDumpInstance::current(), device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEncodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEncodeVideoKHR", "commandBuffer, pEncodeInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEncodeVideoKHR<Format>(ApiDumpInstance::current(), commandBuffer, pEncodeInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEncodeVideoKHR(commandBuffer, pEncodeInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEncodeVideoKHR<Format>(ApiDumpInstance::current(), commandBuffer, pEncodeInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetEvent2KHR(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetEvent2KHR", "commandBuffer, event, pDependencyInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetEvent2KHR<Format>(ApiDumpInstance::current(), commandBuffer, event, pDependencyInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetEvent2KHR(commandBuffer, event, pDependencyInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetEvent2KHR<Format>(ApiDumpInstance::current(), commandBuffer, event, pDependencyInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdResetEvent2KHR(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdResetEvent2KHR", "commandBuffer, event, stageMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdResetEvent2KHR<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdResetEvent2KHR(commandBuffer, event, stageMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdResetEvent2KHR<Format>(ApiDumpInstance::current(), commandBuffer, event, stageMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWaitEvents2KHR(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, const VkDependencyInfo* pDependencyInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWaitEvents2KHR", "commandBuffer, eventCount, pEvents, pDependencyInfos", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWaitEvents2KHR<Format>(ApiDumpInstance::current(), commandBuffer, eventCount, pEvents, pDependencyInfos);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWaitEvents2KHR<Format>(ApiDumpInstance::current(), commandBuffer, eventCount, pEvents, pDependencyInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPipelineBarrier2KHR(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPipelineBarrier2KHR", "commandBuffer, pDependencyInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPipelineBarrier2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pDependencyInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPipelineBarrier2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pDependencyInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWriteTimestamp2KHR(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool, uint32_t query) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWriteTimestamp2KHR", "commandBuffer, stage, queryPool, query", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWriteTimestamp2KHR<Format>(ApiDumpInstance::current(), commandBuffer, stage, queryPool, query);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWriteTimestamp2KHR<Format>(ApiDumpInstance::current(), commandBuffer, stage, queryPool, query);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkQueueSubmit2KHR(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueSubmit2KHR", "queue, submitCount, pSubmits, fence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueSubmit2KHR<Format>(ApiDumpInstance::current(), queue, submitCount, pSubmits, fence);
        }
    }
    VkResult result = device_dispatch_table(queue)->QueueSubmit2KHR(queue, submitCount, pSubmits, fence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueSubmit2KHR<Format>(ApiDumpInstance::current(), queue, submitCount, pSubmits, fence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyBuffer2KHR", "commandBuffer, pCopyBufferInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyBuffer2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyBuffer2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyImage2KHR(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyImage2KHR", "commandBuffer, pCopyImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyImage2KHR(commandBuffer, pCopyImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyBufferToImage2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyBufferToImage2KHR", "commandBuffer, pCopyBufferToImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyBufferToImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferToImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyBufferToImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyBufferToImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyImageToBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyImageToBuffer2KHR", "commandBuffer, pCopyImageToBufferInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyImageToBuffer2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageToBufferInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyImageToBuffer2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyImageToBufferInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBlitImage2KHR(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBlitImage2KHR", "commandBuffer, pBlitImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBlitImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pBlitImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBlitImage2KHR(commandBuffer, pBlitImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBlitImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pBlitImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdResolveImage2KHR(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdResolveImage2KHR", "commandBuffer, pResolveImageInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdResolveImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pResolveImageInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdResolveImage2KHR(commandBuffer, pResolveImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdResolveImage2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pResolveImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdTraceRaysIndirect2KHR", "commandBuffer, indirectDeviceAddress", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdTraceRaysIndirect2KHR<Format>(ApiDumpInstance::current(), commandBuffer, indirectDeviceAddress);
        }
    }
    device_dispatch_table(commandBuffer)->CmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdTraceRaysIndirect2KHR<Format>(ApiDumpInstance::current(), commandBuffer, indirectDeviceAddress);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceBufferMemoryRequirementsKHR", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceBufferMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceBufferMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceImageMemoryRequirementsKHR", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceImageMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceImageMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceImageSparseMemoryRequirementsKHR", "device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceImageSparseMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceImageSparseMemoryRequirementsKHR<Format>(ApiDumpInstance::current(), device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindIndexBuffer2KHR", "commandBuffer, buffer, offset, size, indexType", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindIndexBuffer2KHR<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, size, indexType);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindIndexBuffer2KHR<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, size, indexType);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetRenderingAreaGranularityKHR", "device, pRenderingAreaInfo, pGranularity", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetRenderingAreaGranularityKHR<Format>(ApiDumpInstance::current(), device, pRenderingAreaInfo, pGranularity);
        }
    }
    device_dispatch_table(device)->GetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetRenderingAreaGranularityKHR<Format>(ApiDumpInstance::current(), device, pRenderingAreaInfo, pGranularity);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceImageSubresourceLayoutKHR(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceImageSubresourceLayoutKHR", "device, pInfo, pLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceImageSubresourceLayoutKHR<Format>(ApiDumpInstance::current(), device, pInfo, pLayout);
        }
    }
    device_dispatch_table(device)->GetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceImageSubresourceLayoutKHR<Format>(ApiDumpInstance::current(), device, pInfo, pLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageSubresourceLayout2KHR(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageSubresourceLayout2KHR", "device, image, pSubresource, pLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageSubresourceLayout2KHR<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        }
    }
    device_dispatch_table(device)->GetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageSubresourceLayout2KHR<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWaitForPresent2KHR(VkDevice device, VkSwapchainKHR swapchain, const VkPresentWait2InfoKHR* pPresentWait2Info) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkWaitForPresent2KHR", "device, swapchain, pPresentWait2Info", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkWaitForPresent2KHR<Format>(ApiDumpInstance::current(), device, swapchain, pPresentWait2Info);
        }
    }
    VkResult result = device_dispatch_table(device)->WaitForPresent2KHR(device, swapchain, pPresentWait2Info);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWaitForPresent2KHR<Format>(ApiDumpInstance::current(), device, swapchain, pPresentWait2Info);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreatePipelineBinariesKHR(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineBinaryHandlesInfoKHR* pBinaries) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreatePipelineBinariesKHR", "device, pCreateInfo, pAllocator, pBinaries", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreatePipelineBinariesKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pBinaries);
        }
    }
    VkResult result = device_dispatch_table(device)->CreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreatePipelineBinariesKHR<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pBinaries);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyPipelineBinaryKHR(VkDevice device, VkPipelineBinaryKHR pipelineBinary, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyPipelineBinaryKHR", "device, pipelineBinary, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyPipelineBinaryKHR<Format>(ApiDumpInstance::current(), device, pipelineBinary, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyPipelineBinaryKHR<Format>(ApiDumpInstance::current(), device, pipelineBinary, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPipelineKeyKHR(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo, VkPipelineBinaryKeyKHR* pPipelineKey) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineKeyKHR", "device, pPipelineCreateInfo, pPipelineKey", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineKeyKHR<Format>(ApiDumpInstance::current(), device, pPipelineCreateInfo, pPipelineKey);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineKeyKHR<Format>(ApiDumpInstance::current(), device, pPipelineCreateInfo, pPipelineKey);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPipelineBinaryDataKHR(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo, VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize, void* pPipelineBinaryData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineBinaryDataKHR", "device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize, pPipelineBinaryData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineBinaryDataKHR<Format>(ApiDumpInstance::current(), device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize, pPipelineBinaryData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize, pPipelineBinaryData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineBinaryDataKHR<Format>(ApiDumpInstance::current(), device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize, pPipelineBinaryData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkReleaseCapturedPipelineDataKHR(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkReleaseCapturedPipelineDataKHR", "device, pInfo, pAllocator", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkReleaseCapturedPipelineDataKHR<Format>(ApiDumpInstance::current(), device, pInfo, pAllocator);
        }
    }
    VkResult result = device_dispatch_table(device)->ReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkReleaseCapturedPipelineDataKHR<Format>(ApiDumpInstance::current(), device, pInfo, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkReleaseSwapchainImagesKHR(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkReleaseSwapchainImagesKHR", "device, pReleaseInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkReleaseSwapchainImagesKHR<Format>(ApiDumpInstance::current(), device, pReleaseInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->ReleaseSwapchainImagesKHR(device, pReleaseInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkReleaseSwapchainImagesKHR<Format>(ApiDumpInstance::current(), device, pReleaseInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLineStippleKHR", "commandBuffer, lineStippleFactor, lineStipplePattern", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLineStippleKHR<Format>(ApiDumpInstance::current(), commandBuffer, lineStippleFactor, lineStipplePattern);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLineStippleKHR<Format>(ApiDumpInstance::current(), commandBuffer, lineStippleFactor, lineStipplePattern);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetCalibratedTimestampsKHR", "device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetCalibratedTimestampsKHR<Format>(ApiDumpInstance::current(), device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
        }
    }
    VkResult result = device_dispatch_table(device)->GetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetCalibratedTimestampsKHR<Format>(ApiDumpInstance::current(), device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindDescriptorSets2KHR(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindDescriptorSets2KHR", "commandBuffer, pBindDescriptorSetsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindDescriptorSets2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pBindDescriptorSetsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindDescriptorSets2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pBindDescriptorSetsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushConstants2KHR(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushConstants2KHR", "commandBuffer, pPushConstantsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushConstants2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pPushConstantsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushConstants2KHR(commandBuffer, pPushConstantsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushConstants2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pPushConstantsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSet2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo* pPushDescriptorSetInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSet2KHR", "commandBuffer, pPushDescriptorSetInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSet2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSet2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDescriptorSetWithTemplate2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDescriptorSetWithTemplate2KHR", "commandBuffer, pPushDescriptorSetWithTemplateInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDescriptorSetWithTemplate2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetWithTemplateInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDescriptorSetWithTemplate2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pPushDescriptorSetWithTemplateInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDescriptorBufferOffsets2EXT(VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDescriptorBufferOffsets2EXT", "commandBuffer, pSetDescriptorBufferOffsetsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDescriptorBufferOffsets2EXT<Format>(ApiDumpInstance::current(), commandBuffer, pSetDescriptorBufferOffsetsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDescriptorBufferOffsets2EXT<Format>(ApiDumpInstance::current(), commandBuffer, pSetDescriptorBufferOffsetsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindDescriptorBufferEmbeddedSamplers2EXT(VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindDescriptorBufferEmbeddedSamplers2EXT", "commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT<Format>(ApiDumpInstance::current(), commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindDescriptorBufferEmbeddedSamplers2EXT<Format>(ApiDumpInstance::current(), commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyMemoryIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryIndirectInfoKHR* pCopyMemoryIndirectInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyMemoryIndirectKHR", "commandBuffer, pCopyMemoryIndirectInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyMemoryIndirectKHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyMemoryIndirectInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyMemoryIndirectKHR(commandBuffer, pCopyMemoryIndirectInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyMemoryIndirectKHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyMemoryIndirectInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyMemoryToImageIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToImageIndirectInfoKHR* pCopyMemoryToImageIndirectInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyMemoryToImageIndirectKHR", "commandBuffer, pCopyMemoryToImageIndirectInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyMemoryToImageIndirectKHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyMemoryToImageIndirectInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyMemoryToImageIndirectKHR(commandBuffer, pCopyMemoryToImageIndirectInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyMemoryToImageIndirectKHR<Format>(ApiDumpInstance::current(), commandBuffer, pCopyMemoryToImageIndirectInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndRendering2KHR(VkCommandBuffer commandBuffer, const VkRenderingEndInfoKHR* pRenderingEndInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndRendering2KHR", "commandBuffer, pRenderingEndInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndRendering2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pRenderingEndInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndRendering2KHR(commandBuffer, pRenderingEndInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndRendering2KHR<Format>(ApiDumpInstance::current(), commandBuffer, pRenderingEndInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkDebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDebugMarkerSetObjectTagEXT", "device, pTagInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDebugMarkerSetObjectTagEXT<Format>(ApiDumpInstance::current(), device, pTagInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->DebugMarkerSetObjectTagEXT(device, pTagInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDebugMarkerSetObjectTagEXT<Format>(ApiDumpInstance::current(), device, pTagInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkDebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    ApiDumpInstance::current().update_object_name_map(pNameInfo);

    dump_function_head(ApiDumpInstance::current(), "vkDebugMarkerSetObjectNameEXT", "device, pNameInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDebugMarkerSetObjectNameEXT<Format>(ApiDumpInstance::current(), device, pNameInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->DebugMarkerSetObjectNameEXT(device, pNameInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDebugMarkerSetObjectNameEXT<Format>(ApiDumpInstance::current(), device, pNameInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDebugMarkerBeginEXT", "commandBuffer, pMarkerInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDebugMarkerBeginEXT<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDebugMarkerBeginEXT<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDebugMarkerEndEXT", "commandBuffer", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDebugMarkerEndEXT<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDebugMarkerEndEXT(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDebugMarkerEndEXT<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDebugMarkerInsertEXT", "commandBuffer, pMarkerInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDebugMarkerInsertEXT<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDebugMarkerInsertEXT<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindTransformFeedbackBuffersEXT", "commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindTransformFeedbackBuffersEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindTransformFeedbackBuffersEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginTransformFeedbackEXT", "commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginTransformFeedbackEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginTransformFeedbackEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndTransformFeedbackEXT", "commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndTransformFeedbackEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndTransformFeedbackEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginQueryIndexedEXT", "commandBuffer, queryPool, query, flags, index", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginQueryIndexedEXT<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query, flags, index);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginQueryIndexedEXT<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query, flags, index);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndQueryIndexedEXT", "commandBuffer, queryPool, query, index", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndQueryIndexedEXT<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query, index);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndQueryIndexedEXT<Format>(ApiDumpInstance::current(), commandBuffer, queryPool, query, index);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndirectByteCountEXT", "commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndirectByteCountEXT<Format>(ApiDumpInstance::current(), commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndirectByteCountEXT<Format>(ApiDumpInstance::current(), commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateCuModuleNVX(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateCuModuleNVX", "device, pCreateInfo, pAllocator, pModule", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateCuModuleNVX<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pModule);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateCuModuleNVX<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pModule);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateCuFunctionNVX(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateCuFunctionNVX", "device, pCreateInfo, pAllocator, pFunction", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateCuFunctionNVX<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFunction);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateCuFunctionNVX<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFunction);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyCuModuleNVX(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyCuModuleNVX", "device, module, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyCuModuleNVX<Format>(ApiDumpInstance::current(), device, module, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyCuModuleNVX(device, module, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyCuModuleNVX<Format>(ApiDumpInstance::current(), device, module, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyCuFunctionNVX(VkDevice device, VkCuFunctionNVX function, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyCuFunctionNVX", "device, function, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyCuFunctionNVX<Format>(ApiDumpInstance::current(), device, function, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyCuFunctionNVX(device, function, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyCuFunctionNVX<Format>(ApiDumpInstance::current(), device, function, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCuLaunchKernelNVX(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCuLaunchKernelNVX", "commandBuffer, pLaunchInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCuLaunchKernelNVX<Format>(ApiDumpInstance::current(), commandBuffer, pLaunchInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCuLaunchKernelNVX<Format>(ApiDumpInstance::current(), commandBuffer, pLaunchInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint32_t VKAPI_CALL vkGetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageViewHandleNVX", "device, pInfo", "uint32_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageViewHandleNVX<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    uint32_t result = device_dispatch_table(device)->GetImageViewHandleNVX(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint32_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageViewHandleNVX<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint64_t VKAPI_CALL vkGetImageViewHandle64NVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageViewHandle64NVX", "device, pInfo", "uint64_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageViewHandle64NVX<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    uint64_t result = device_dispatch_table(device)->GetImageViewHandle64NVX(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint64_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageViewHandle64NVX<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageViewAddressNVX", "device, imageView, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageViewAddressNVX<Format>(ApiDumpInstance::current(), device, imageView, pProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetImageViewAddressNVX(device, imageView, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageViewAddressNVX<Format>(ApiDumpInstance::current(), device, imageView, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR uint64_t VKAPI_CALL vkGetDeviceCombinedImageSamplerIndexNVX(VkDevice device, uint64_t imageViewIndex, uint64_t samplerIndex) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceCombinedImageSamplerIndexNVX", "device, imageViewIndex, samplerIndex", "uint64_t");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceCombinedImageSamplerIndexNVX<Format>(ApiDumpInstance::current(), device, imageViewIndex, samplerIndex);
        }
    }
    uint64_t result = device_dispatch_table(device)->GetDeviceCombinedImageSamplerIndexNVX(device, imageViewIndex, samplerIndex);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "uint64_t", result);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceCombinedImageSamplerIndexNVX<Format>(ApiDumpInstance::current(), device, imageViewIndex, samplerIndex);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndirectCountAMD", "commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndirectCountAMD<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndirectCountAMD<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawIndexedIndirectCountAMD", "commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawIndexedIndirectCountAMD<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawIndexedIndirectCountAMD<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetShaderInfoAMD", "device, pipeline, shaderStage, infoType, pInfoSize, pInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetShaderInfoAMD<Format>(ApiDumpInstance::current(), device, pipeline, shaderStage, infoType, pInfoSize, pInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->GetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetShaderInfoAMD<Format>(ApiDumpInstance::current(), device, pipeline, shaderStage, infoType, pInfoSize, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryWin32HandleNV", "device, memory, handleType, pHandle", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryWin32HandleNV<Format>(ApiDumpInstance::current(), device, memory, handleType, pHandle);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryWin32HandleNV(device, memory, handleType, pHandle);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryWin32HandleNV<Format>(ApiDumpInstance::current(), device, memory, handleType, pHandle);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginConditionalRenderingEXT", "commandBuffer, pConditionalRenderingBegin", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginConditionalRenderingEXT<Format>(ApiDumpInstance::current(), commandBuffer, pConditionalRenderingBegin);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginConditionalRenderingEXT<Format>(ApiDumpInstance::current(), commandBuffer, pConditionalRenderingBegin);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndConditionalRenderingEXT", "commandBuffer", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndConditionalRenderingEXT<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndConditionalRenderingEXT(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndConditionalRenderingEXT<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetViewportWScalingNV", "commandBuffer, firstViewport, viewportCount, pViewportWScalings", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetViewportWScalingNV<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pViewportWScalings);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetViewportWScalingNV<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pViewportWScalings);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkDisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDisplayPowerControlEXT", "device, display, pDisplayPowerInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDisplayPowerControlEXT<Format>(ApiDumpInstance::current(), device, display, pDisplayPowerInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->DisplayPowerControlEXT(device, display, pDisplayPowerInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDisplayPowerControlEXT<Format>(ApiDumpInstance::current(), device, display, pDisplayPowerInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkRegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkRegisterDeviceEventEXT", "device, pDeviceEventInfo, pAllocator, pFence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkRegisterDeviceEventEXT<Format>(ApiDumpInstance::current(), device, pDeviceEventInfo, pAllocator, pFence);
        }
    }
    VkResult result = device_dispatch_table(device)->RegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkRegisterDeviceEventEXT<Format>(ApiDumpInstance::current(), device, pDeviceEventInfo, pAllocator, pFence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkRegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkRegisterDisplayEventEXT", "device, display, pDisplayEventInfo, pAllocator, pFence", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkRegisterDisplayEventEXT<Format>(ApiDumpInstance::current(), device, display, pDisplayEventInfo, pAllocator, pFence);
        }
    }
    VkResult result = device_dispatch_table(device)->RegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkRegisterDisplayEventEXT<Format>(ApiDumpInstance::current(), device, display, pDisplayEventInfo, pAllocator, pFence);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSwapchainCounterEXT", "device, swapchain, counter, pCounterValue", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSwapchainCounterEXT<Format>(ApiDumpInstance::current(), device, swapchain, counter, pCounterValue);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSwapchainCounterEXT(device, swapchain, counter, pCounterValue);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSwapchainCounterEXT<Format>(ApiDumpInstance::current(), device, swapchain, counter, pCounterValue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetRefreshCycleDurationGOOGLE", "device, swapchain, pDisplayTimingProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetRefreshCycleDurationGOOGLE<Format>(ApiDumpInstance::current(), device, swapchain, pDisplayTimingProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetRefreshCycleDurationGOOGLE<Format>(ApiDumpInstance::current(), device, swapchain, pDisplayTimingProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPastPresentationTimingGOOGLE", "device, swapchain, pPresentationTimingCount, pPresentationTimings", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPastPresentationTimingGOOGLE<Format>(ApiDumpInstance::current(), device, swapchain, pPresentationTimingCount, pPresentationTimings);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPastPresentationTimingGOOGLE<Format>(ApiDumpInstance::current(), device, swapchain, pPresentationTimingCount, pPresentationTimings);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDiscardRectangleEXT", "commandBuffer, firstDiscardRectangle, discardRectangleCount, pDiscardRectangles", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDiscardRectangleEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstDiscardRectangle, discardRectangleCount, pDiscardRectangles);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount, pDiscardRectangles);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDiscardRectangleEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstDiscardRectangle, discardRectangleCount, pDiscardRectangles);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDiscardRectangleEnableEXT", "commandBuffer, discardRectangleEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDiscardRectangleEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, discardRectangleEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDiscardRectangleEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, discardRectangleEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDiscardRectangleModeEXT", "commandBuffer, discardRectangleMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDiscardRectangleModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, discardRectangleMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDiscardRectangleModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, discardRectangleMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkSetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetHdrMetadataEXT", "device, swapchainCount, pSwapchains, pMetadata", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetHdrMetadataEXT<Format>(ApiDumpInstance::current(), device, swapchainCount, pSwapchains, pMetadata);
        }
    }
    device_dispatch_table(device)->SetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetHdrMetadataEXT<Format>(ApiDumpInstance::current(), device, swapchainCount, pSwapchains, pMetadata);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());
    ApiDumpInstance::current().update_object_name_map(pNameInfo);

    dump_function_head(ApiDumpInstance::current(), "vkSetDebugUtilsObjectNameEXT", "device, pNameInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetDebugUtilsObjectNameEXT<Format>(ApiDumpInstance::current(), device, pNameInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->SetDebugUtilsObjectNameEXT(device, pNameInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetDebugUtilsObjectNameEXT<Format>(ApiDumpInstance::current(), device, pNameInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetDebugUtilsObjectTagEXT", "device, pTagInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetDebugUtilsObjectTagEXT<Format>(ApiDumpInstance::current(), device, pTagInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->SetDebugUtilsObjectTagEXT(device, pTagInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetDebugUtilsObjectTagEXT<Format>(ApiDumpInstance::current(), device, pTagInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkQueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueBeginDebugUtilsLabelEXT", "queue, pLabelInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueBeginDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), queue, pLabelInfo);
        }
    }
    device_dispatch_table(queue)->QueueBeginDebugUtilsLabelEXT(queue, pLabelInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueBeginDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), queue, pLabelInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkQueueEndDebugUtilsLabelEXT(VkQueue queue) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueEndDebugUtilsLabelEXT", "queue", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueEndDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), queue);
        }
    }
    device_dispatch_table(queue)->QueueEndDebugUtilsLabelEXT(queue);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueEndDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), queue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkQueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueInsertDebugUtilsLabelEXT", "queue, pLabelInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueInsertDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), queue, pLabelInfo);
        }
    }
    device_dispatch_table(queue)->QueueInsertDebugUtilsLabelEXT(queue, pLabelInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueInsertDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), queue, pLabelInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginDebugUtilsLabelEXT", "commandBuffer, pLabelInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), commandBuffer, pLabelInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), commandBuffer, pLabelInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndDebugUtilsLabelEXT", "commandBuffer", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndDebugUtilsLabelEXT(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdInsertDebugUtilsLabelEXT", "commandBuffer, pLabelInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdInsertDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), commandBuffer, pLabelInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdInsertDebugUtilsLabelEXT<Format>(ApiDumpInstance::current(), commandBuffer, pLabelInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#if defined(VK_USE_PLATFORM_ANDROID_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetAndroidHardwareBufferPropertiesANDROID", "device, buffer, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetAndroidHardwareBufferPropertiesANDROID<Format>(ApiDumpInstance::current(), device, buffer, pProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetAndroidHardwareBufferPropertiesANDROID<Format>(ApiDumpInstance::current(), device, buffer, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryAndroidHardwareBufferANDROID", "device, pInfo, pBuffer", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryAndroidHardwareBufferANDROID<Format>(ApiDumpInstance::current(), device, pInfo, pBuffer);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryAndroidHardwareBufferANDROID<Format>(ApiDumpInstance::current(), device, pInfo, pBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR
#if defined(VK_ENABLE_BETA_EXTENSIONS)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateExecutionGraphPipelinesAMDX(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkExecutionGraphPipelineCreateInfoAMDX* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateExecutionGraphPipelinesAMDX", "device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateExecutionGraphPipelinesAMDX<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateExecutionGraphPipelinesAMDX<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetExecutionGraphPipelineScratchSizeAMDX(VkDevice device, VkPipeline executionGraph, VkExecutionGraphPipelineScratchSizeAMDX* pSizeInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetExecutionGraphPipelineScratchSizeAMDX", "device, executionGraph, pSizeInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetExecutionGraphPipelineScratchSizeAMDX<Format>(ApiDumpInstance::current(), device, executionGraph, pSizeInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->GetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetExecutionGraphPipelineScratchSizeAMDX<Format>(ApiDumpInstance::current(), device, executionGraph, pSizeInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, VkPipeline executionGraph, const VkPipelineShaderStageNodeCreateInfoAMDX* pNodeInfo, uint32_t* pNodeIndex) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetExecutionGraphPipelineNodeIndexAMDX", "device, executionGraph, pNodeInfo, pNodeIndex", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetExecutionGraphPipelineNodeIndexAMDX<Format>(ApiDumpInstance::current(), device, executionGraph, pNodeInfo, pNodeIndex);
        }
    }
    VkResult result = device_dispatch_table(device)->GetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetExecutionGraphPipelineNodeIndexAMDX<Format>(ApiDumpInstance::current(), device, executionGraph, pNodeInfo, pNodeIndex);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdInitializeGraphScratchMemoryAMDX(VkCommandBuffer commandBuffer, VkPipeline executionGraph, VkDeviceAddress scratch, VkDeviceSize scratchSize) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdInitializeGraphScratchMemoryAMDX", "commandBuffer, executionGraph, scratch, scratchSize", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdInitializeGraphScratchMemoryAMDX<Format>(ApiDumpInstance::current(), commandBuffer, executionGraph, scratch, scratchSize);
        }
    }
    device_dispatch_table(commandBuffer)->CmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdInitializeGraphScratchMemoryAMDX<Format>(ApiDumpInstance::current(), commandBuffer, executionGraph, scratch, scratchSize);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatchGraphAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch, VkDeviceSize scratchSize, const VkDispatchGraphCountInfoAMDX* pCountInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatchGraphAMDX", "commandBuffer, scratch, scratchSize, pCountInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatchGraphAMDX<Format>(ApiDumpInstance::current(), commandBuffer, scratch, scratchSize, pCountInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatchGraphAMDX<Format>(ApiDumpInstance::current(), commandBuffer, scratch, scratchSize, pCountInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatchGraphIndirectAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch, VkDeviceSize scratchSize, const VkDispatchGraphCountInfoAMDX* pCountInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatchGraphIndirectAMDX", "commandBuffer, scratch, scratchSize, pCountInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatchGraphIndirectAMDX<Format>(ApiDumpInstance::current(), commandBuffer, scratch, scratchSize, pCountInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatchGraphIndirectAMDX<Format>(ApiDumpInstance::current(), commandBuffer, scratch, scratchSize, pCountInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatchGraphIndirectCountAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch, VkDeviceSize scratchSize, VkDeviceAddress countInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatchGraphIndirectCountAMDX", "commandBuffer, scratch, scratchSize, countInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatchGraphIndirectCountAMDX<Format>(ApiDumpInstance::current(), commandBuffer, scratch, scratchSize, countInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatchGraphIndirectCountAMDX<Format>(ApiDumpInstance::current(), commandBuffer, scratch, scratchSize, countInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#endif  // VK_ENABLE_BETA_EXTENSIONS
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWriteSamplerDescriptorsEXT(VkDevice device, uint32_t samplerCount, const VkSamplerCreateInfo* pSamplers, const VkHostAddressRangeEXT* pDescriptors) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkWriteSamplerDescriptorsEXT", "device, samplerCount, pSamplers, pDescriptors", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkWriteSamplerDescriptorsEXT<Format>(ApiDumpInstance::current(), device, samplerCount, pSamplers, pDescriptors);
        }
    }
    VkResult result = device_dispatch_table(device)->WriteSamplerDescriptorsEXT(device, samplerCount, pSamplers, pDescriptors);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWriteSamplerDescriptorsEXT<Format>(ApiDumpInstance::current(), device, samplerCount, pSamplers, pDescriptors);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWriteResourceDescriptorsEXT(VkDevice device, uint32_t resourceCount, const VkResourceDescriptorInfoEXT* pResources, const VkHostAddressRangeEXT* pDescriptors) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkWriteResourceDescriptorsEXT", "device, resourceCount, pResources, pDescriptors", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkWriteResourceDescriptorsEXT<Format>(ApiDumpInstance::current(), device, resourceCount, pResources, pDescriptors);
        }
    }
    VkResult result = device_dispatch_table(device)->WriteResourceDescriptorsEXT(device, resourceCount, pResources, pDescriptors);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWriteResourceDescriptorsEXT<Format>(ApiDumpInstance::current(), device, resourceCount, pResources, pDescriptors);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindSamplerHeapEXT(VkCommandBuffer commandBuffer, const VkBindHeapInfoEXT* pBindInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindSamplerHeapEXT", "commandBuffer, pBindInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindSamplerHeapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pBindInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindSamplerHeapEXT(commandBuffer, pBindInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindSamplerHeapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pBindInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindResourceHeapEXT(VkCommandBuffer commandBuffer, const VkBindHeapInfoEXT* pBindInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindResourceHeapEXT", "commandBuffer, pBindInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindResourceHeapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pBindInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindResourceHeapEXT(commandBuffer, pBindInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindResourceHeapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pBindInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPushDataEXT(VkCommandBuffer commandBuffer, const VkPushDataInfoEXT* pPushDataInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPushDataEXT", "commandBuffer, pPushDataInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPushDataEXT<Format>(ApiDumpInstance::current(), commandBuffer, pPushDataInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPushDataEXT(commandBuffer, pPushDataInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPushDataEXT<Format>(ApiDumpInstance::current(), commandBuffer, pPushDataInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetImageOpaqueCaptureDataEXT(VkDevice device, uint32_t imageCount, const VkImage* pImages, VkHostAddressRangeEXT* pDatas) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageOpaqueCaptureDataEXT", "device, imageCount, pImages, pDatas", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageOpaqueCaptureDataEXT<Format>(ApiDumpInstance::current(), device, imageCount, pImages, pDatas);
        }
    }
    VkResult result = device_dispatch_table(device)->GetImageOpaqueCaptureDataEXT(device, imageCount, pImages, pDatas);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageOpaqueCaptureDataEXT<Format>(ApiDumpInstance::current(), device, imageCount, pImages, pDatas);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkRegisterCustomBorderColorEXT(VkDevice device, const VkSamplerCustomBorderColorCreateInfoEXT* pBorderColor, VkBool32 requestIndex, uint32_t* pIndex) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkRegisterCustomBorderColorEXT", "device, pBorderColor, requestIndex, pIndex", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkRegisterCustomBorderColorEXT<Format>(ApiDumpInstance::current(), device, pBorderColor, requestIndex, pIndex);
        }
    }
    VkResult result = device_dispatch_table(device)->RegisterCustomBorderColorEXT(device, pBorderColor, requestIndex, pIndex);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkRegisterCustomBorderColorEXT<Format>(ApiDumpInstance::current(), device, pBorderColor, requestIndex, pIndex);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkUnregisterCustomBorderColorEXT(VkDevice device, uint32_t index) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUnregisterCustomBorderColorEXT", "device, index", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUnregisterCustomBorderColorEXT<Format>(ApiDumpInstance::current(), device, index);
        }
    }
    device_dispatch_table(device)->UnregisterCustomBorderColorEXT(device, index);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUnregisterCustomBorderColorEXT<Format>(ApiDumpInstance::current(), device, index);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetTensorOpaqueCaptureDataARM(VkDevice device, uint32_t tensorCount, const VkTensorARM* pTensors, VkHostAddressRangeEXT* pDatas) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetTensorOpaqueCaptureDataARM", "device, tensorCount, pTensors, pDatas", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetTensorOpaqueCaptureDataARM<Format>(ApiDumpInstance::current(), device, tensorCount, pTensors, pDatas);
        }
    }
    VkResult result = device_dispatch_table(device)->GetTensorOpaqueCaptureDataARM(device, tensorCount, pTensors, pDatas);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetTensorOpaqueCaptureDataARM<Format>(ApiDumpInstance::current(), device, tensorCount, pTensors, pDatas);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetSampleLocationsEXT", "commandBuffer, pSampleLocationsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetSampleLocationsEXT<Format>(ApiDumpInstance::current(), commandBuffer, pSampleLocationsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetSampleLocationsEXT<Format>(ApiDumpInstance::current(), commandBuffer, pSampleLocationsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageDrmFormatModifierPropertiesEXT", "device, image, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageDrmFormatModifierPropertiesEXT<Format>(ApiDumpInstance::current(), device, image, pProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetImageDrmFormatModifierPropertiesEXT(device, image, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageDrmFormatModifierPropertiesEXT<Format>(ApiDumpInstance::current(), device, image, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateValidationCacheEXT", "device, pCreateInfo, pAllocator, pValidationCache", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateValidationCacheEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pValidationCache);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateValidationCacheEXT(device, pCreateInfo, pAllocator, pValidationCache);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateValidationCacheEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pValidationCache);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyValidationCacheEXT", "device, validationCache, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyValidationCacheEXT<Format>(ApiDumpInstance::current(), device, validationCache, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyValidationCacheEXT(device, validationCache, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyValidationCacheEXT<Format>(ApiDumpInstance::current(), device, validationCache, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkMergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkMergeValidationCachesEXT", "device, dstCache, srcCacheCount, pSrcCaches", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkMergeValidationCachesEXT<Format>(ApiDumpInstance::current(), device, dstCache, srcCacheCount, pSrcCaches);
        }
    }
    VkResult result = device_dispatch_table(device)->MergeValidationCachesEXT(device, dstCache, srcCacheCount, pSrcCaches);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkMergeValidationCachesEXT<Format>(ApiDumpInstance::current(), device, dstCache, srcCacheCount, pSrcCaches);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetValidationCacheDataEXT", "device, validationCache, pDataSize, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetValidationCacheDataEXT<Format>(ApiDumpInstance::current(), device, validationCache, pDataSize, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetValidationCacheDataEXT(device, validationCache, pDataSize, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetValidationCacheDataEXT<Format>(ApiDumpInstance::current(), device, validationCache, pDataSize, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindShadingRateImageNV", "commandBuffer, imageView, imageLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindShadingRateImageNV<Format>(ApiDumpInstance::current(), commandBuffer, imageView, imageLayout);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindShadingRateImageNV<Format>(ApiDumpInstance::current(), commandBuffer, imageView, imageLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetViewportShadingRatePaletteNV", "commandBuffer, firstViewport, viewportCount, pShadingRatePalettes", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetViewportShadingRatePaletteNV<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pShadingRatePalettes);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetViewportShadingRatePaletteNV<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pShadingRatePalettes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCoarseSampleOrderNV", "commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCoarseSampleOrderNV<Format>(ApiDumpInstance::current(), commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCoarseSampleOrderNV<Format>(ApiDumpInstance::current(), commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateAccelerationStructureNV", "device, pCreateInfo, pAllocator, pAccelerationStructure", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateAccelerationStructureNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pAccelerationStructure);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateAccelerationStructureNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pAccelerationStructure);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyAccelerationStructureNV", "device, accelerationStructure, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyAccelerationStructureNV<Format>(ApiDumpInstance::current(), device, accelerationStructure, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyAccelerationStructureNV(device, accelerationStructure, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyAccelerationStructureNV<Format>(ApiDumpInstance::current(), device, accelerationStructure, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetAccelerationStructureMemoryRequirementsNV", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetAccelerationStructureMemoryRequirementsNV<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetAccelerationStructureMemoryRequirementsNV<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindAccelerationStructureMemoryNV", "device, bindInfoCount, pBindInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindAccelerationStructureMemoryNV<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindAccelerationStructureMemoryNV<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBuildAccelerationStructureNV", "commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src, scratch, scratchOffset", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBuildAccelerationStructureNV<Format>(ApiDumpInstance::current(), commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src, scratch, scratchOffset);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src, scratch, scratchOffset);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBuildAccelerationStructureNV<Format>(ApiDumpInstance::current(), commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src, scratch, scratchOffset);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyAccelerationStructureNV", "commandBuffer, dst, src, mode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyAccelerationStructureNV<Format>(ApiDumpInstance::current(), commandBuffer, dst, src, mode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyAccelerationStructureNV<Format>(ApiDumpInstance::current(), commandBuffer, dst, src, mode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdTraceRaysNV", "commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride, width, height, depth", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdTraceRaysNV<Format>(ApiDumpInstance::current(), commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride, width, height, depth);
        }
    }
    device_dispatch_table(commandBuffer)->CmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride, width, height, depth);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdTraceRaysNV<Format>(ApiDumpInstance::current(), commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride, width, height, depth);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateRayTracingPipelinesNV", "device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateRayTracingPipelinesNV<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateRayTracingPipelinesNV(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateRayTracingPipelinesNV<Format>(ApiDumpInstance::current(), device, pipelineCache, createInfoCount, pCreateInfos, pAllocator, pPipelines);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetRayTracingShaderGroupHandlesKHR", "device, pipeline, firstGroup, groupCount, dataSize, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetRayTracingShaderGroupHandlesKHR<Format>(ApiDumpInstance::current(), device, pipeline, firstGroup, groupCount, dataSize, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetRayTracingShaderGroupHandlesKHR<Format>(ApiDumpInstance::current(), device, pipeline, firstGroup, groupCount, dataSize, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetRayTracingShaderGroupHandlesNV", "device, pipeline, firstGroup, groupCount, dataSize, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetRayTracingShaderGroupHandlesNV<Format>(ApiDumpInstance::current(), device, pipeline, firstGroup, groupCount, dataSize, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetRayTracingShaderGroupHandlesNV<Format>(ApiDumpInstance::current(), device, pipeline, firstGroup, groupCount, dataSize, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetAccelerationStructureHandleNV", "device, accelerationStructure, dataSize, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetAccelerationStructureHandleNV<Format>(ApiDumpInstance::current(), device, accelerationStructure, dataSize, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetAccelerationStructureHandleNV<Format>(ApiDumpInstance::current(), device, accelerationStructure, dataSize, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWriteAccelerationStructuresPropertiesNV", "commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWriteAccelerationStructuresPropertiesNV<Format>(ApiDumpInstance::current(), commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWriteAccelerationStructuresPropertiesNV(commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWriteAccelerationStructuresPropertiesNV<Format>(ApiDumpInstance::current(), commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCompileDeferredNV", "device, pipeline, shader", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCompileDeferredNV<Format>(ApiDumpInstance::current(), device, pipeline, shader);
        }
    }
    VkResult result = device_dispatch_table(device)->CompileDeferredNV(device, pipeline, shader);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCompileDeferredNV<Format>(ApiDumpInstance::current(), device, pipeline, shader);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryHostPointerPropertiesEXT", "device, handleType, pHostPointer, pMemoryHostPointerProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryHostPointerPropertiesEXT<Format>(ApiDumpInstance::current(), device, handleType, pHostPointer, pMemoryHostPointerProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryHostPointerPropertiesEXT<Format>(ApiDumpInstance::current(), device, handleType, pHostPointer, pMemoryHostPointerProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWriteBufferMarkerAMD", "commandBuffer, pipelineStage, dstBuffer, dstOffset, marker", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWriteBufferMarkerAMD<Format>(ApiDumpInstance::current(), commandBuffer, pipelineStage, dstBuffer, dstOffset, marker);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWriteBufferMarkerAMD<Format>(ApiDumpInstance::current(), commandBuffer, pipelineStage, dstBuffer, dstOffset, marker);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWriteBufferMarker2AMD(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWriteBufferMarker2AMD", "commandBuffer, stage, dstBuffer, dstOffset, marker", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWriteBufferMarker2AMD<Format>(ApiDumpInstance::current(), commandBuffer, stage, dstBuffer, dstOffset, marker);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWriteBufferMarker2AMD<Format>(ApiDumpInstance::current(), commandBuffer, stage, dstBuffer, dstOffset, marker);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetCalibratedTimestampsEXT", "device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetCalibratedTimestampsEXT<Format>(ApiDumpInstance::current(), device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
        }
    }
    VkResult result = device_dispatch_table(device)->GetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetCalibratedTimestampsEXT<Format>(ApiDumpInstance::current(), device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawMeshTasksNV", "commandBuffer, taskCount, firstTask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawMeshTasksNV<Format>(ApiDumpInstance::current(), commandBuffer, taskCount, firstTask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawMeshTasksNV<Format>(ApiDumpInstance::current(), commandBuffer, taskCount, firstTask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawMeshTasksIndirectNV", "commandBuffer, buffer, offset, drawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawMeshTasksIndirectNV<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, drawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawMeshTasksIndirectNV<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, drawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawMeshTasksIndirectCountNV", "commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawMeshTasksIndirectCountNV<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawMeshTasksIndirectCountNV<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetExclusiveScissorEnableNV", "commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissorEnables", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetExclusiveScissorEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissorEnables);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissorEnables);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetExclusiveScissorEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissorEnables);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetExclusiveScissorNV", "commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissors", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetExclusiveScissorNV<Format>(ApiDumpInstance::current(), commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissors);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissors);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetExclusiveScissorNV<Format>(ApiDumpInstance::current(), commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissors);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCheckpointNV", "commandBuffer, pCheckpointMarker", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCheckpointNV<Format>(ApiDumpInstance::current(), commandBuffer, pCheckpointMarker);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCheckpointNV(commandBuffer, pCheckpointMarker);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCheckpointNV<Format>(ApiDumpInstance::current(), commandBuffer, pCheckpointMarker);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetQueueCheckpointDataNV", "queue, pCheckpointDataCount, pCheckpointData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetQueueCheckpointDataNV<Format>(ApiDumpInstance::current(), queue, pCheckpointDataCount, pCheckpointData);
        }
    }
    device_dispatch_table(queue)->GetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetQueueCheckpointDataNV<Format>(ApiDumpInstance::current(), queue, pCheckpointDataCount, pCheckpointData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointData2NV* pCheckpointData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetQueueCheckpointData2NV", "queue, pCheckpointDataCount, pCheckpointData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetQueueCheckpointData2NV<Format>(ApiDumpInstance::current(), queue, pCheckpointDataCount, pCheckpointData);
        }
    }
    device_dispatch_table(queue)->GetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetQueueCheckpointData2NV<Format>(ApiDumpInstance::current(), queue, pCheckpointDataCount, pCheckpointData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetSwapchainPresentTimingQueueSizeEXT(VkDevice device, VkSwapchainKHR swapchain, uint32_t size) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetSwapchainPresentTimingQueueSizeEXT", "device, swapchain, size", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetSwapchainPresentTimingQueueSizeEXT<Format>(ApiDumpInstance::current(), device, swapchain, size);
        }
    }
    VkResult result = device_dispatch_table(device)->SetSwapchainPresentTimingQueueSizeEXT(device, swapchain, size);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetSwapchainPresentTimingQueueSizeEXT<Format>(ApiDumpInstance::current(), device, swapchain, size);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSwapchainTimingPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimingPropertiesEXT* pSwapchainTimingProperties, uint64_t* pSwapchainTimingPropertiesCounter) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSwapchainTimingPropertiesEXT", "device, swapchain, pSwapchainTimingProperties, pSwapchainTimingPropertiesCounter", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSwapchainTimingPropertiesEXT<Format>(ApiDumpInstance::current(), device, swapchain, pSwapchainTimingProperties, pSwapchainTimingPropertiesCounter);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSwapchainTimingPropertiesEXT(device, swapchain, pSwapchainTimingProperties, pSwapchainTimingPropertiesCounter);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSwapchainTimingPropertiesEXT<Format>(ApiDumpInstance::current(), device, swapchain, pSwapchainTimingProperties, pSwapchainTimingPropertiesCounter);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSwapchainTimeDomainPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimeDomainPropertiesEXT* pSwapchainTimeDomainProperties, uint64_t* pTimeDomainsCounter) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSwapchainTimeDomainPropertiesEXT", "device, swapchain, pSwapchainTimeDomainProperties, pTimeDomainsCounter", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSwapchainTimeDomainPropertiesEXT<Format>(ApiDumpInstance::current(), device, swapchain, pSwapchainTimeDomainProperties, pTimeDomainsCounter);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSwapchainTimeDomainPropertiesEXT(device, swapchain, pSwapchainTimeDomainProperties, pTimeDomainsCounter);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSwapchainTimeDomainPropertiesEXT<Format>(ApiDumpInstance::current(), device, swapchain, pSwapchainTimeDomainProperties, pTimeDomainsCounter);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPastPresentationTimingEXT(VkDevice device, const VkPastPresentationTimingInfoEXT* pPastPresentationTimingInfo, VkPastPresentationTimingPropertiesEXT* pPastPresentationTimingProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPastPresentationTimingEXT", "device, pPastPresentationTimingInfo, pPastPresentationTimingProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPastPresentationTimingEXT<Format>(ApiDumpInstance::current(), device, pPastPresentationTimingInfo, pPastPresentationTimingProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPastPresentationTimingEXT(device, pPastPresentationTimingInfo, pPastPresentationTimingProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPastPresentationTimingEXT<Format>(ApiDumpInstance::current(), device, pPastPresentationTimingInfo, pPastPresentationTimingProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkInitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkInitializePerformanceApiINTEL", "device, pInitializeInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkInitializePerformanceApiINTEL<Format>(ApiDumpInstance::current(), device, pInitializeInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->InitializePerformanceApiINTEL(device, pInitializeInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkInitializePerformanceApiINTEL<Format>(ApiDumpInstance::current(), device, pInitializeInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkUninitializePerformanceApiINTEL(VkDevice device) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkUninitializePerformanceApiINTEL", "device", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkUninitializePerformanceApiINTEL<Format>(ApiDumpInstance::current(), device);
        }
    }
    device_dispatch_table(device)->UninitializePerformanceApiINTEL(device);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkUninitializePerformanceApiINTEL<Format>(ApiDumpInstance::current(), device);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPerformanceMarkerINTEL", "commandBuffer, pMarkerInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPerformanceMarkerINTEL<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        }
    }
    VkResult result = device_dispatch_table(commandBuffer)->CmdSetPerformanceMarkerINTEL(commandBuffer, pMarkerInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPerformanceMarkerINTEL<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPerformanceStreamMarkerINTEL", "commandBuffer, pMarkerInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPerformanceStreamMarkerINTEL<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        }
    }
    VkResult result = device_dispatch_table(commandBuffer)->CmdSetPerformanceStreamMarkerINTEL(commandBuffer, pMarkerInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPerformanceStreamMarkerINTEL<Format>(ApiDumpInstance::current(), commandBuffer, pMarkerInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPerformanceOverrideINTEL", "commandBuffer, pOverrideInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPerformanceOverrideINTEL<Format>(ApiDumpInstance::current(), commandBuffer, pOverrideInfo);
        }
    }
    VkResult result = device_dispatch_table(commandBuffer)->CmdSetPerformanceOverrideINTEL(commandBuffer, pOverrideInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPerformanceOverrideINTEL<Format>(ApiDumpInstance::current(), commandBuffer, pOverrideInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkAcquirePerformanceConfigurationINTEL", "device, pAcquireInfo, pConfiguration", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAcquirePerformanceConfigurationINTEL<Format>(ApiDumpInstance::current(), device, pAcquireInfo, pConfiguration);
        }
    }
    VkResult result = device_dispatch_table(device)->AcquirePerformanceConfigurationINTEL(device, pAcquireInfo, pConfiguration);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquirePerformanceConfigurationINTEL<Format>(ApiDumpInstance::current(), device, pAcquireInfo, pConfiguration);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkReleasePerformanceConfigurationINTEL", "device, configuration", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkReleasePerformanceConfigurationINTEL<Format>(ApiDumpInstance::current(), device, configuration);
        }
    }
    VkResult result = device_dispatch_table(device)->ReleasePerformanceConfigurationINTEL(device, configuration);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkReleasePerformanceConfigurationINTEL<Format>(ApiDumpInstance::current(), device, configuration);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkQueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkQueueSetPerformanceConfigurationINTEL", "queue, configuration", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkQueueSetPerformanceConfigurationINTEL<Format>(ApiDumpInstance::current(), queue, configuration);
        }
    }
    VkResult result = device_dispatch_table(queue)->QueueSetPerformanceConfigurationINTEL(queue, configuration);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkQueueSetPerformanceConfigurationINTEL<Format>(ApiDumpInstance::current(), queue, configuration);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPerformanceParameterINTEL", "device, parameter, pValue", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPerformanceParameterINTEL<Format>(ApiDumpInstance::current(), device, parameter, pValue);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPerformanceParameterINTEL(device, parameter, pValue);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPerformanceParameterINTEL<Format>(ApiDumpInstance::current(), device, parameter, pValue);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkSetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetLocalDimmingAMD", "device, swapChain, localDimmingEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetLocalDimmingAMD<Format>(ApiDumpInstance::current(), device, swapChain, localDimmingEnable);
        }
    }
    device_dispatch_table(device)->SetLocalDimmingAMD(device, swapChain, localDimmingEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetLocalDimmingAMD<Format>(ApiDumpInstance::current(), device, swapChain, localDimmingEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkDeviceAddress VKAPI_CALL vkGetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferDeviceAddressEXT", "device, pInfo", "VkDeviceAddress");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferDeviceAddressEXT<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    VkDeviceAddress result = device_dispatch_table(device)->GetBufferDeviceAddressEXT(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkDeviceAddress", result, dump_return_value_VkDeviceAddress<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferDeviceAddressEXT<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_WIN32_KHR)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkAcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkAcquireFullScreenExclusiveModeEXT", "device, swapchain", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkAcquireFullScreenExclusiveModeEXT<Format>(ApiDumpInstance::current(), device, swapchain);
        }
    }
    VkResult result = device_dispatch_table(device)->AcquireFullScreenExclusiveModeEXT(device, swapchain);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkAcquireFullScreenExclusiveModeEXT<Format>(ApiDumpInstance::current(), device, swapchain);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkReleaseFullScreenExclusiveModeEXT", "device, swapchain", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkReleaseFullScreenExclusiveModeEXT<Format>(ApiDumpInstance::current(), device, swapchain);
        }
    }
    VkResult result = device_dispatch_table(device)->ReleaseFullScreenExclusiveModeEXT(device, swapchain);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkReleaseFullScreenExclusiveModeEXT<Format>(ApiDumpInstance::current(), device, swapchain);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceGroupSurfacePresentModes2EXT", "device, pSurfaceInfo, pModes", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceGroupSurfacePresentModes2EXT<Format>(ApiDumpInstance::current(), device, pSurfaceInfo, pModes);
        }
    }
    VkResult result = device_dispatch_table(device)->GetDeviceGroupSurfacePresentModes2EXT(device, pSurfaceInfo, pModes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceGroupSurfacePresentModes2EXT<Format>(ApiDumpInstance::current(), device, pSurfaceInfo, pModes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLineStippleEXT", "commandBuffer, lineStippleFactor, lineStipplePattern", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLineStippleEXT<Format>(ApiDumpInstance::current(), commandBuffer, lineStippleFactor, lineStipplePattern);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLineStippleEXT(commandBuffer, lineStippleFactor, lineStipplePattern);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLineStippleEXT<Format>(ApiDumpInstance::current(), commandBuffer, lineStippleFactor, lineStipplePattern);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkResetQueryPoolEXT", "device, queryPool, firstQuery, queryCount", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkResetQueryPoolEXT<Format>(ApiDumpInstance::current(), device, queryPool, firstQuery, queryCount);
        }
    }
    device_dispatch_table(device)->ResetQueryPoolEXT(device, queryPool, firstQuery, queryCount);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkResetQueryPoolEXT<Format>(ApiDumpInstance::current(), device, queryPool, firstQuery, queryCount);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCullModeEXT", "commandBuffer, cullMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCullModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, cullMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCullModeEXT(commandBuffer, cullMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCullModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, cullMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetFrontFaceEXT", "commandBuffer, frontFace", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetFrontFaceEXT<Format>(ApiDumpInstance::current(), commandBuffer, frontFace);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetFrontFaceEXT(commandBuffer, frontFace);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetFrontFaceEXT<Format>(ApiDumpInstance::current(), commandBuffer, frontFace);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPrimitiveTopologyEXT", "commandBuffer, primitiveTopology", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPrimitiveTopologyEXT<Format>(ApiDumpInstance::current(), commandBuffer, primitiveTopology);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetPrimitiveTopologyEXT(commandBuffer, primitiveTopology);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPrimitiveTopologyEXT<Format>(ApiDumpInstance::current(), commandBuffer, primitiveTopology);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetViewportWithCountEXT", "commandBuffer, viewportCount, pViewports", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetViewportWithCountEXT<Format>(ApiDumpInstance::current(), commandBuffer, viewportCount, pViewports);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetViewportWithCountEXT(commandBuffer, viewportCount, pViewports);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetViewportWithCountEXT<Format>(ApiDumpInstance::current(), commandBuffer, viewportCount, pViewports);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetScissorWithCountEXT", "commandBuffer, scissorCount, pScissors", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetScissorWithCountEXT<Format>(ApiDumpInstance::current(), commandBuffer, scissorCount, pScissors);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetScissorWithCountEXT(commandBuffer, scissorCount, pScissors);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetScissorWithCountEXT<Format>(ApiDumpInstance::current(), commandBuffer, scissorCount, pScissors);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindVertexBuffers2EXT", "commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindVertexBuffers2EXT<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindVertexBuffers2EXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindVertexBuffers2EXT<Format>(ApiDumpInstance::current(), commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthTestEnableEXT", "commandBuffer, depthTestEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthTestEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthTestEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthTestEnableEXT(commandBuffer, depthTestEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthTestEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthTestEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthWriteEnableEXT", "commandBuffer, depthWriteEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthWriteEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthWriteEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthWriteEnableEXT(commandBuffer, depthWriteEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthWriteEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthWriteEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthCompareOpEXT", "commandBuffer, depthCompareOp", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthCompareOpEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthCompareOp);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthCompareOpEXT(commandBuffer, depthCompareOp);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthCompareOpEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthCompareOp);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthBoundsTestEnableEXT", "commandBuffer, depthBoundsTestEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthBoundsTestEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthBoundsTestEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthBoundsTestEnableEXT(commandBuffer, depthBoundsTestEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthBoundsTestEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthBoundsTestEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetStencilTestEnableEXT", "commandBuffer, stencilTestEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetStencilTestEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, stencilTestEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetStencilTestEnableEXT(commandBuffer, stencilTestEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetStencilTestEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, stencilTestEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetStencilOpEXT", "commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetStencilOpEXT<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetStencilOpEXT(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetStencilOpEXT<Format>(ApiDumpInstance::current(), commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyMemoryToImageEXT(VkDevice device, const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyMemoryToImageEXT", "device, pCopyMemoryToImageInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyMemoryToImageEXT<Format>(ApiDumpInstance::current(), device, pCopyMemoryToImageInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyMemoryToImageEXT(device, pCopyMemoryToImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyMemoryToImageEXT<Format>(ApiDumpInstance::current(), device, pCopyMemoryToImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyImageToMemoryEXT(VkDevice device, const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyImageToMemoryEXT", "device, pCopyImageToMemoryInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyImageToMemoryEXT<Format>(ApiDumpInstance::current(), device, pCopyImageToMemoryInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyImageToMemoryEXT(device, pCopyImageToMemoryInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyImageToMemoryEXT<Format>(ApiDumpInstance::current(), device, pCopyImageToMemoryInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyImageToImageEXT(VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyImageToImageEXT", "device, pCopyImageToImageInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyImageToImageEXT<Format>(ApiDumpInstance::current(), device, pCopyImageToImageInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyImageToImageEXT(device, pCopyImageToImageInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyImageToImageEXT<Format>(ApiDumpInstance::current(), device, pCopyImageToImageInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkTransitionImageLayoutEXT(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo* pTransitions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkTransitionImageLayoutEXT", "device, transitionCount, pTransitions", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkTransitionImageLayoutEXT<Format>(ApiDumpInstance::current(), device, transitionCount, pTransitions);
        }
    }
    VkResult result = device_dispatch_table(device)->TransitionImageLayoutEXT(device, transitionCount, pTransitions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkTransitionImageLayoutEXT<Format>(ApiDumpInstance::current(), device, transitionCount, pTransitions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetImageSubresourceLayout2EXT(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageSubresourceLayout2EXT", "device, image, pSubresource, pLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageSubresourceLayout2EXT<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        }
    }
    device_dispatch_table(device)->GetImageSubresourceLayout2EXT(device, image, pSubresource, pLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageSubresourceLayout2EXT<Format>(ApiDumpInstance::current(), device, image, pSubresource, pLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkReleaseSwapchainImagesEXT(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkReleaseSwapchainImagesEXT", "device, pReleaseInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkReleaseSwapchainImagesEXT<Format>(ApiDumpInstance::current(), device, pReleaseInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->ReleaseSwapchainImagesEXT(device, pReleaseInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkReleaseSwapchainImagesEXT<Format>(ApiDumpInstance::current(), device, pReleaseInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetGeneratedCommandsMemoryRequirementsNV", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetGeneratedCommandsMemoryRequirementsNV<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetGeneratedCommandsMemoryRequirementsNV(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetGeneratedCommandsMemoryRequirementsNV<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdPreprocessGeneratedCommandsNV", "commandBuffer, pGeneratedCommandsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdPreprocessGeneratedCommandsNV<Format>(ApiDumpInstance::current(), commandBuffer, pGeneratedCommandsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdPreprocessGeneratedCommandsNV(commandBuffer, pGeneratedCommandsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdPreprocessGeneratedCommandsNV<Format>(ApiDumpInstance::current(), commandBuffer, pGeneratedCommandsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdExecuteGeneratedCommandsNV", "commandBuffer, isPreprocessed, pGeneratedCommandsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdExecuteGeneratedCommandsNV<Format>(ApiDumpInstance::current(), commandBuffer, isPreprocessed, pGeneratedCommandsInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdExecuteGeneratedCommandsNV(commandBuffer, isPreprocessed, pGeneratedCommandsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdExecuteGeneratedCommandsNV<Format>(ApiDumpInstance::current(), commandBuffer, isPreprocessed, pGeneratedCommandsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindPipelineShaderGroupNV", "commandBuffer, pipelineBindPoint, pipeline, groupIndex", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindPipelineShaderGroupNV<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, pipeline, groupIndex);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindPipelineShaderGroupNV(commandBuffer, pipelineBindPoint, pipeline, groupIndex);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindPipelineShaderGroupNV<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, pipeline, groupIndex);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateIndirectCommandsLayoutNV", "device, pCreateInfo, pAllocator, pIndirectCommandsLayout", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateIndirectCommandsLayoutNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pIndirectCommandsLayout);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateIndirectCommandsLayoutNV(device, pCreateInfo, pAllocator, pIndirectCommandsLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateIndirectCommandsLayoutNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pIndirectCommandsLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyIndirectCommandsLayoutNV", "device, indirectCommandsLayout, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyIndirectCommandsLayoutNV<Format>(ApiDumpInstance::current(), device, indirectCommandsLayout, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyIndirectCommandsLayoutNV(device, indirectCommandsLayout, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyIndirectCommandsLayoutNV<Format>(ApiDumpInstance::current(), device, indirectCommandsLayout, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthBias2EXT(VkCommandBuffer commandBuffer, const VkDepthBiasInfoEXT* pDepthBiasInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthBias2EXT", "commandBuffer, pDepthBiasInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthBias2EXT<Format>(ApiDumpInstance::current(), commandBuffer, pDepthBiasInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthBias2EXT(commandBuffer, pDepthBiasInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthBias2EXT<Format>(ApiDumpInstance::current(), commandBuffer, pDepthBiasInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreatePrivateDataSlotEXT(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreatePrivateDataSlotEXT", "device, pCreateInfo, pAllocator, pPrivateDataSlot", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreatePrivateDataSlotEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPrivateDataSlot);
        }
    }
    VkResult result = device_dispatch_table(device)->CreatePrivateDataSlotEXT(device, pCreateInfo, pAllocator, pPrivateDataSlot);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreatePrivateDataSlotEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pPrivateDataSlot);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyPrivateDataSlotEXT(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyPrivateDataSlotEXT", "device, privateDataSlot, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyPrivateDataSlotEXT<Format>(ApiDumpInstance::current(), device, privateDataSlot, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyPrivateDataSlotEXT(device, privateDataSlot, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyPrivateDataSlotEXT<Format>(ApiDumpInstance::current(), device, privateDataSlot, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetPrivateDataEXT", "device, objectType, objectHandle, privateDataSlot, data", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetPrivateDataEXT<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, data);
        }
    }
    VkResult result = device_dispatch_table(device)->SetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, data);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetPrivateDataEXT<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, data);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPrivateDataEXT", "device, objectType, objectHandle, privateDataSlot, pData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPrivateDataEXT<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, pData);
        }
    }
    device_dispatch_table(device)->GetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPrivateDataEXT<Format>(ApiDumpInstance::current(), device, objectType, objectHandle, privateDataSlot, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#if defined(VK_ENABLE_BETA_EXTENSIONS)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateCudaModuleNV(VkDevice device, const VkCudaModuleCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCudaModuleNV* pModule) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateCudaModuleNV", "device, pCreateInfo, pAllocator, pModule", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateCudaModuleNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pModule);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateCudaModuleNV(device, pCreateInfo, pAllocator, pModule);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateCudaModuleNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pModule);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetCudaModuleCacheNV(VkDevice device, VkCudaModuleNV module, size_t* pCacheSize, void* pCacheData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetCudaModuleCacheNV", "device, module, pCacheSize, pCacheData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetCudaModuleCacheNV<Format>(ApiDumpInstance::current(), device, module, pCacheSize, pCacheData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetCudaModuleCacheNV(device, module, pCacheSize, pCacheData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetCudaModuleCacheNV<Format>(ApiDumpInstance::current(), device, module, pCacheSize, pCacheData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateCudaFunctionNV(VkDevice device, const VkCudaFunctionCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCudaFunctionNV* pFunction) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateCudaFunctionNV", "device, pCreateInfo, pAllocator, pFunction", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateCudaFunctionNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFunction);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateCudaFunctionNV(device, pCreateInfo, pAllocator, pFunction);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateCudaFunctionNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pFunction);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyCudaModuleNV(VkDevice device, VkCudaModuleNV module, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyCudaModuleNV", "device, module, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyCudaModuleNV<Format>(ApiDumpInstance::current(), device, module, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyCudaModuleNV(device, module, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyCudaModuleNV<Format>(ApiDumpInstance::current(), device, module, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyCudaFunctionNV(VkDevice device, VkCudaFunctionNV function, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyCudaFunctionNV", "device, function, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyCudaFunctionNV<Format>(ApiDumpInstance::current(), device, function, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyCudaFunctionNV(device, function, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyCudaFunctionNV<Format>(ApiDumpInstance::current(), device, function, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCudaLaunchKernelNV(VkCommandBuffer commandBuffer, const VkCudaLaunchInfoNV* pLaunchInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCudaLaunchKernelNV", "commandBuffer, pLaunchInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCudaLaunchKernelNV<Format>(ApiDumpInstance::current(), commandBuffer, pLaunchInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCudaLaunchKernelNV(commandBuffer, pLaunchInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCudaLaunchKernelNV<Format>(ApiDumpInstance::current(), commandBuffer, pLaunchInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#endif  // VK_ENABLE_BETA_EXTENSIONS
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDispatchTileQCOM(VkCommandBuffer commandBuffer, const VkDispatchTileInfoQCOM* pDispatchTileInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDispatchTileQCOM", "commandBuffer, pDispatchTileInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDispatchTileQCOM<Format>(ApiDumpInstance::current(), commandBuffer, pDispatchTileInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDispatchTileQCOM(commandBuffer, pDispatchTileInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDispatchTileQCOM<Format>(ApiDumpInstance::current(), commandBuffer, pDispatchTileInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBeginPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileBeginInfoQCOM* pPerTileBeginInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBeginPerTileExecutionQCOM", "commandBuffer, pPerTileBeginInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBeginPerTileExecutionQCOM<Format>(ApiDumpInstance::current(), commandBuffer, pPerTileBeginInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBeginPerTileExecutionQCOM(commandBuffer, pPerTileBeginInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBeginPerTileExecutionQCOM<Format>(ApiDumpInstance::current(), commandBuffer, pPerTileBeginInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdEndPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileEndInfoQCOM* pPerTileEndInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdEndPerTileExecutionQCOM", "commandBuffer, pPerTileEndInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdEndPerTileExecutionQCOM<Format>(ApiDumpInstance::current(), commandBuffer, pPerTileEndInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdEndPerTileExecutionQCOM(commandBuffer, pPerTileEndInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdEndPerTileExecutionQCOM<Format>(ApiDumpInstance::current(), commandBuffer, pPerTileEndInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#if defined(VK_USE_PLATFORM_METAL_EXT)
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkExportMetalObjectsEXT(VkDevice device, VkExportMetalObjectsInfoEXT* pMetalObjectsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkExportMetalObjectsEXT", "device, pMetalObjectsInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkExportMetalObjectsEXT<Format>(ApiDumpInstance::current(), device, pMetalObjectsInfo);
        }
    }
    device_dispatch_table(device)->ExportMetalObjectsEXT(device, pMetalObjectsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkExportMetalObjectsEXT<Format>(ApiDumpInstance::current(), device, pMetalObjectsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#endif  // VK_USE_PLATFORM_METAL_EXT
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDescriptorSetLayoutSizeEXT(VkDevice device, VkDescriptorSetLayout layout, VkDeviceSize* pLayoutSizeInBytes) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDescriptorSetLayoutSizeEXT", "device, layout, pLayoutSizeInBytes", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDescriptorSetLayoutSizeEXT<Format>(ApiDumpInstance::current(), device, layout, pLayoutSizeInBytes);
        }
    }
    device_dispatch_table(device)->GetDescriptorSetLayoutSizeEXT(device, layout, pLayoutSizeInBytes);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDescriptorSetLayoutSizeEXT<Format>(ApiDumpInstance::current(), device, layout, pLayoutSizeInBytes);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDescriptorSetLayoutBindingOffsetEXT(VkDevice device, VkDescriptorSetLayout layout, uint32_t binding, VkDeviceSize* pOffset) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDescriptorSetLayoutBindingOffsetEXT", "device, layout, binding, pOffset", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDescriptorSetLayoutBindingOffsetEXT<Format>(ApiDumpInstance::current(), device, layout, binding, pOffset);
        }
    }
    device_dispatch_table(device)->GetDescriptorSetLayoutBindingOffsetEXT(device, layout, binding, pOffset);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDescriptorSetLayoutBindingOffsetEXT<Format>(ApiDumpInstance::current(), device, layout, binding, pOffset);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDescriptorEXT(VkDevice device, const VkDescriptorGetInfoEXT* pDescriptorInfo, size_t dataSize, void* pDescriptor) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDescriptorEXT", "device, pDescriptorInfo, dataSize, pDescriptor", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDescriptorEXT<Format>(ApiDumpInstance::current(), device, pDescriptorInfo, dataSize, pDescriptor);
        }
    }
    device_dispatch_table(device)->GetDescriptorEXT(device, pDescriptorInfo, dataSize, pDescriptor);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDescriptorEXT<Format>(ApiDumpInstance::current(), device, pDescriptorInfo, dataSize, pDescriptor);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindDescriptorBuffersEXT(VkCommandBuffer commandBuffer, uint32_t bufferCount, const VkDescriptorBufferBindingInfoEXT* pBindingInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindDescriptorBuffersEXT", "commandBuffer, bufferCount, pBindingInfos", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindDescriptorBuffersEXT<Format>(ApiDumpInstance::current(), commandBuffer, bufferCount, pBindingInfos);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindDescriptorBuffersEXT(commandBuffer, bufferCount, pBindingInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindDescriptorBuffersEXT<Format>(ApiDumpInstance::current(), commandBuffer, bufferCount, pBindingInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDescriptorBufferOffsetsEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t setCount, const uint32_t* pBufferIndices, const VkDeviceSize* pOffsets) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDescriptorBufferOffsetsEXT", "commandBuffer, pipelineBindPoint, layout, firstSet, setCount, pBufferIndices, pOffsets", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDescriptorBufferOffsetsEXT<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, firstSet, setCount, pBufferIndices, pOffsets);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDescriptorBufferOffsetsEXT(commandBuffer, pipelineBindPoint, layout, firstSet, setCount, pBufferIndices, pOffsets);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDescriptorBufferOffsetsEXT<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, firstSet, setCount, pBufferIndices, pOffsets);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindDescriptorBufferEmbeddedSamplersEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindDescriptorBufferEmbeddedSamplersEXT", "commandBuffer, pipelineBindPoint, layout, set", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindDescriptorBufferEmbeddedSamplersEXT<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, set);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindDescriptorBufferEmbeddedSamplersEXT(commandBuffer, pipelineBindPoint, layout, set);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindDescriptorBufferEmbeddedSamplersEXT<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, layout, set);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetBufferOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkBufferCaptureDescriptorDataInfoEXT* pInfo, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferOpaqueCaptureDescriptorDataEXT", "device, pInfo, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetBufferOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetImageOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageCaptureDescriptorDataInfoEXT* pInfo, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageOpaqueCaptureDescriptorDataEXT", "device, pInfo, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetImageOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetImageViewOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageViewCaptureDescriptorDataInfoEXT* pInfo, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetImageViewOpaqueCaptureDescriptorDataEXT", "device, pInfo, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetImageViewOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetImageViewOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetImageViewOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSamplerOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkSamplerCaptureDescriptorDataInfoEXT* pInfo, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSamplerOpaqueCaptureDescriptorDataEXT", "device, pInfo, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSamplerOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSamplerOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSamplerOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkAccelerationStructureCaptureDescriptorDataInfoEXT* pInfo, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT", "device, pInfo, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetFragmentShadingRateEnumNV(VkCommandBuffer commandBuffer, VkFragmentShadingRateNV shadingRate, const VkFragmentShadingRateCombinerOpKHR combinerOps[2]) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetFragmentShadingRateEnumNV", "commandBuffer, shadingRate, combinerOps", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetFragmentShadingRateEnumNV<Format>(ApiDumpInstance::current(), commandBuffer, shadingRate, combinerOps);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetFragmentShadingRateEnumNV(commandBuffer, shadingRate, combinerOps);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetFragmentShadingRateEnumNV<Format>(ApiDumpInstance::current(), commandBuffer, shadingRate, combinerOps);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDeviceFaultInfoEXT(VkDevice device, VkDeviceFaultCountsEXT* pFaultCounts, VkDeviceFaultInfoEXT* pFaultInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceFaultInfoEXT", "device, pFaultCounts, pFaultInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceFaultInfoEXT<Format>(ApiDumpInstance::current(), device, pFaultCounts, pFaultInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->GetDeviceFaultInfoEXT(device, pFaultCounts, pFaultInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceFaultInfoEXT<Format>(ApiDumpInstance::current(), device, pFaultCounts, pFaultInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetVertexInputEXT", "commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetVertexInputEXT<Format>(ApiDumpInstance::current(), commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetVertexInputEXT(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetVertexInputEXT<Format>(ApiDumpInstance::current(), commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions, vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
#if defined(VK_USE_PLATFORM_FUCHSIA)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryZirconHandleFUCHSIA", "device, pGetZirconHandleInfo, pZirconHandle", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryZirconHandleFUCHSIA<Format>(ApiDumpInstance::current(), device, pGetZirconHandleInfo, pZirconHandle);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryZirconHandleFUCHSIA<Format>(ApiDumpInstance::current(), device, pGetZirconHandleInfo, pZirconHandle);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryZirconHandlePropertiesFUCHSIA", "device, handleType, zirconHandle, pMemoryZirconHandleProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryZirconHandlePropertiesFUCHSIA<Format>(ApiDumpInstance::current(), device, handleType, zirconHandle, pMemoryZirconHandleProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryZirconHandlePropertiesFUCHSIA(device, handleType, zirconHandle, pMemoryZirconHandleProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryZirconHandlePropertiesFUCHSIA<Format>(ApiDumpInstance::current(), device, handleType, zirconHandle, pMemoryZirconHandleProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkImportSemaphoreZirconHandleFUCHSIA", "device, pImportSemaphoreZirconHandleInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkImportSemaphoreZirconHandleFUCHSIA<Format>(ApiDumpInstance::current(), device, pImportSemaphoreZirconHandleInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->ImportSemaphoreZirconHandleFUCHSIA(device, pImportSemaphoreZirconHandleInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkImportSemaphoreZirconHandleFUCHSIA<Format>(ApiDumpInstance::current(), device, pImportSemaphoreZirconHandleInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetSemaphoreZirconHandleFUCHSIA", "device, pGetZirconHandleInfo, pZirconHandle", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetSemaphoreZirconHandleFUCHSIA<Format>(ApiDumpInstance::current(), device, pGetZirconHandleInfo, pZirconHandle);
        }
    }
    VkResult result = device_dispatch_table(device)->GetSemaphoreZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetSemaphoreZirconHandleFUCHSIA<Format>(ApiDumpInstance::current(), device, pGetZirconHandleInfo, pZirconHandle);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateBufferCollectionFUCHSIA(VkDevice device, const VkBufferCollectionCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferCollectionFUCHSIA* pCollection) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateBufferCollectionFUCHSIA", "device, pCreateInfo, pAllocator, pCollection", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateBufferCollectionFUCHSIA<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pCollection);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateBufferCollectionFUCHSIA(device, pCreateInfo, pAllocator, pCollection);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateBufferCollectionFUCHSIA<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pCollection);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetBufferCollectionImageConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkImageConstraintsInfoFUCHSIA* pImageConstraintsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetBufferCollectionImageConstraintsFUCHSIA", "device, collection, pImageConstraintsInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetBufferCollectionImageConstraintsFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pImageConstraintsInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->SetBufferCollectionImageConstraintsFUCHSIA(device, collection, pImageConstraintsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetBufferCollectionImageConstraintsFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pImageConstraintsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkSetBufferCollectionBufferConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkBufferConstraintsInfoFUCHSIA* pBufferConstraintsInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetBufferCollectionBufferConstraintsFUCHSIA", "device, collection, pBufferConstraintsInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetBufferCollectionBufferConstraintsFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pBufferConstraintsInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->SetBufferCollectionBufferConstraintsFUCHSIA(device, collection, pBufferConstraintsInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetBufferCollectionBufferConstraintsFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pBufferConstraintsInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyBufferCollectionFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyBufferCollectionFUCHSIA", "device, collection, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyBufferCollectionFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyBufferCollectionFUCHSIA(device, collection, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyBufferCollectionFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetBufferCollectionPropertiesFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, VkBufferCollectionPropertiesFUCHSIA* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetBufferCollectionPropertiesFUCHSIA", "device, collection, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetBufferCollectionPropertiesFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetBufferCollectionPropertiesFUCHSIA(device, collection, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetBufferCollectionPropertiesFUCHSIA<Format>(ApiDumpInstance::current(), device, collection, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_FUCHSIA
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI", "device, renderpass, pMaxWorkgroupSize", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI<Format>(ApiDumpInstance::current(), device, renderpass, pMaxWorkgroupSize);
        }
    }
    VkResult result = device_dispatch_table(device)->GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(device, renderpass, pMaxWorkgroupSize);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI<Format>(ApiDumpInstance::current(), device, renderpass, pMaxWorkgroupSize);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSubpassShadingHUAWEI", "commandBuffer", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSubpassShadingHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSubpassShadingHUAWEI(commandBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSubpassShadingHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBindInvocationMaskHUAWEI", "commandBuffer, imageView, imageLayout", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBindInvocationMaskHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer, imageView, imageLayout);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBindInvocationMaskHUAWEI(commandBuffer, imageView, imageLayout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBindInvocationMaskHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer, imageView, imageLayout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryRemoteAddressNV", "device, pMemoryGetRemoteAddressInfo, pAddress", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryRemoteAddressNV<Format>(ApiDumpInstance::current(), device, pMemoryGetRemoteAddressInfo, pAddress);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryRemoteAddressNV(device, pMemoryGetRemoteAddressInfo, pAddress);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryRemoteAddressNV<Format>(ApiDumpInstance::current(), device, pMemoryGetRemoteAddressInfo, pAddress);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetPipelinePropertiesEXT(VkDevice device, const VkPipelineInfoEXT* pPipelineInfo, VkBaseOutStructure* pPipelineProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelinePropertiesEXT", "device, pPipelineInfo, pPipelineProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelinePropertiesEXT<Format>(ApiDumpInstance::current(), device, pPipelineInfo, pPipelineProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetPipelinePropertiesEXT(device, pPipelineInfo, pPipelineProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelinePropertiesEXT<Format>(ApiDumpInstance::current(), device, pPipelineInfo, pPipelineProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPatchControlPointsEXT", "commandBuffer, patchControlPoints", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPatchControlPointsEXT<Format>(ApiDumpInstance::current(), commandBuffer, patchControlPoints);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetPatchControlPointsEXT(commandBuffer, patchControlPoints);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPatchControlPointsEXT<Format>(ApiDumpInstance::current(), commandBuffer, patchControlPoints);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRasterizerDiscardEnableEXT", "commandBuffer, rasterizerDiscardEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRasterizerDiscardEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, rasterizerDiscardEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRasterizerDiscardEnableEXT(commandBuffer, rasterizerDiscardEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRasterizerDiscardEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, rasterizerDiscardEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthBiasEnableEXT", "commandBuffer, depthBiasEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthBiasEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthBiasEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthBiasEnableEXT(commandBuffer, depthBiasEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthBiasEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthBiasEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLogicOpEXT", "commandBuffer, logicOp", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLogicOpEXT<Format>(ApiDumpInstance::current(), commandBuffer, logicOp);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLogicOpEXT(commandBuffer, logicOp);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLogicOpEXT<Format>(ApiDumpInstance::current(), commandBuffer, logicOp);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPrimitiveRestartEnableEXT", "commandBuffer, primitiveRestartEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPrimitiveRestartEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, primitiveRestartEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetPrimitiveRestartEnableEXT(commandBuffer, primitiveRestartEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPrimitiveRestartEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, primitiveRestartEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetColorWriteEnableEXT(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkBool32* pColorWriteEnables) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetColorWriteEnableEXT", "commandBuffer, attachmentCount, pColorWriteEnables", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetColorWriteEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, attachmentCount, pColorWriteEnables);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetColorWriteEnableEXT(commandBuffer, attachmentCount, pColorWriteEnables);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetColorWriteEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, attachmentCount, pColorWriteEnables);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawMultiEXT", "commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawMultiEXT<Format>(ApiDumpInstance::current(), commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawMultiEXT(commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawMultiEXT<Format>(ApiDumpInstance::current(), commandBuffer, drawCount, pVertexInfo, instanceCount, firstInstance, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawMultiIndexedEXT", "commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawMultiIndexedEXT<Format>(ApiDumpInstance::current(), commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawMultiIndexedEXT(commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawMultiIndexedEXT<Format>(ApiDumpInstance::current(), commandBuffer, drawCount, pIndexInfo, instanceCount, firstInstance, stride, pVertexOffset);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateMicromapEXT(VkDevice device, const VkMicromapCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkMicromapEXT* pMicromap) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateMicromapEXT", "device, pCreateInfo, pAllocator, pMicromap", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateMicromapEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pMicromap);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateMicromapEXT(device, pCreateInfo, pAllocator, pMicromap);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateMicromapEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pMicromap);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyMicromapEXT(VkDevice device, VkMicromapEXT micromap, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyMicromapEXT", "device, micromap, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyMicromapEXT<Format>(ApiDumpInstance::current(), device, micromap, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyMicromapEXT(device, micromap, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyMicromapEXT<Format>(ApiDumpInstance::current(), device, micromap, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdBuildMicromapsEXT(VkCommandBuffer commandBuffer, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdBuildMicromapsEXT", "commandBuffer, infoCount, pInfos", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdBuildMicromapsEXT<Format>(ApiDumpInstance::current(), commandBuffer, infoCount, pInfos);
        }
    }
    device_dispatch_table(commandBuffer)->CmdBuildMicromapsEXT(commandBuffer, infoCount, pInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdBuildMicromapsEXT<Format>(ApiDumpInstance::current(), commandBuffer, infoCount, pInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBuildMicromapsEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBuildMicromapsEXT", "device, deferredOperation, infoCount, pInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBuildMicromapsEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, infoCount, pInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BuildMicromapsEXT(device, deferredOperation, infoCount, pInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBuildMicromapsEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, infoCount, pInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapInfoEXT* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyMicromapEXT", "device, deferredOperation, pInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyMicromapEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, pInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyMicromapEXT(device, deferredOperation, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyMicromapEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyMicromapToMemoryEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapToMemoryInfoEXT* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyMicromapToMemoryEXT", "device, deferredOperation, pInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyMicromapToMemoryEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, pInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyMicromapToMemoryEXT(device, deferredOperation, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyMicromapToMemoryEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCopyMemoryToMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToMicromapInfoEXT* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCopyMemoryToMicromapEXT", "device, deferredOperation, pInfo", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCopyMemoryToMicromapEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, pInfo);
        }
    }
    VkResult result = device_dispatch_table(device)->CopyMemoryToMicromapEXT(device, deferredOperation, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCopyMemoryToMicromapEXT<Format>(ApiDumpInstance::current(), device, deferredOperation, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkWriteMicromapsPropertiesEXT(VkDevice device, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType queryType, size_t dataSize, void* pData, size_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkWriteMicromapsPropertiesEXT", "device, micromapCount, pMicromaps, queryType, dataSize, pData, stride", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkWriteMicromapsPropertiesEXT<Format>(ApiDumpInstance::current(), device, micromapCount, pMicromaps, queryType, dataSize, pData, stride);
        }
    }
    VkResult result = device_dispatch_table(device)->WriteMicromapsPropertiesEXT(device, micromapCount, pMicromaps, queryType, dataSize, pData, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkWriteMicromapsPropertiesEXT<Format>(ApiDumpInstance::current(), device, micromapCount, pMicromaps, queryType, dataSize, pData, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapInfoEXT* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyMicromapEXT", "commandBuffer, pInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyMicromapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyMicromapEXT(commandBuffer, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyMicromapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyMicromapToMemoryEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapToMemoryInfoEXT* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyMicromapToMemoryEXT", "commandBuffer, pInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyMicromapToMemoryEXT<Format>(ApiDumpInstance::current(), commandBuffer, pInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyMicromapToMemoryEXT(commandBuffer, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyMicromapToMemoryEXT<Format>(ApiDumpInstance::current(), commandBuffer, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyMemoryToMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMemoryToMicromapInfoEXT* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyMemoryToMicromapEXT", "commandBuffer, pInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyMemoryToMicromapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyMemoryToMicromapEXT(commandBuffer, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyMemoryToMicromapEXT<Format>(ApiDumpInstance::current(), commandBuffer, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdWriteMicromapsPropertiesEXT(VkCommandBuffer commandBuffer, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdWriteMicromapsPropertiesEXT", "commandBuffer, micromapCount, pMicromaps, queryType, queryPool, firstQuery", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdWriteMicromapsPropertiesEXT<Format>(ApiDumpInstance::current(), commandBuffer, micromapCount, pMicromaps, queryType, queryPool, firstQuery);
        }
    }
    device_dispatch_table(commandBuffer)->CmdWriteMicromapsPropertiesEXT(commandBuffer, micromapCount, pMicromaps, queryType, queryPool, firstQuery);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdWriteMicromapsPropertiesEXT<Format>(ApiDumpInstance::current(), commandBuffer, micromapCount, pMicromaps, queryType, queryPool, firstQuery);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceMicromapCompatibilityEXT(VkDevice device, const VkMicromapVersionInfoEXT* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceMicromapCompatibilityEXT", "device, pVersionInfo, pCompatibility", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceMicromapCompatibilityEXT<Format>(ApiDumpInstance::current(), device, pVersionInfo, pCompatibility);
        }
    }
    device_dispatch_table(device)->GetDeviceMicromapCompatibilityEXT(device, pVersionInfo, pCompatibility);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceMicromapCompatibilityEXT<Format>(ApiDumpInstance::current(), device, pVersionInfo, pCompatibility);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetMicromapBuildSizesEXT(VkDevice device, VkAccelerationStructureBuildTypeKHR buildType, const VkMicromapBuildInfoEXT* pBuildInfo, VkMicromapBuildSizesInfoEXT* pSizeInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMicromapBuildSizesEXT", "device, buildType, pBuildInfo, pSizeInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMicromapBuildSizesEXT<Format>(ApiDumpInstance::current(), device, buildType, pBuildInfo, pSizeInfo);
        }
    }
    device_dispatch_table(device)->GetMicromapBuildSizesEXT(device, buildType, pBuildInfo, pSizeInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMicromapBuildSizesEXT<Format>(ApiDumpInstance::current(), device, buildType, pBuildInfo, pSizeInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawClusterHUAWEI(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawClusterHUAWEI", "commandBuffer, groupCountX, groupCountY, groupCountZ", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawClusterHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer, groupCountX, groupCountY, groupCountZ);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawClusterHUAWEI(commandBuffer, groupCountX, groupCountY, groupCountZ);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawClusterHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer, groupCountX, groupCountY, groupCountZ);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDrawClusterIndirectHUAWEI(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDrawClusterIndirectHUAWEI", "commandBuffer, buffer, offset", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDrawClusterIndirectHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDrawClusterIndirectHUAWEI(commandBuffer, buffer, offset);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDrawClusterIndirectHUAWEI<Format>(ApiDumpInstance::current(), commandBuffer, buffer, offset);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkSetDeviceMemoryPriorityEXT(VkDevice device, VkDeviceMemory memory, float priority) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkSetDeviceMemoryPriorityEXT", "device, memory, priority", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkSetDeviceMemoryPriorityEXT<Format>(ApiDumpInstance::current(), device, memory, priority);
        }
    }
    device_dispatch_table(device)->SetDeviceMemoryPriorityEXT(device, memory, priority);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkSetDeviceMemoryPriorityEXT<Format>(ApiDumpInstance::current(), device, memory, priority);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDescriptorSetLayoutHostMappingInfoVALVE(VkDevice device, const VkDescriptorSetBindingReferenceVALVE* pBindingReference, VkDescriptorSetLayoutHostMappingInfoVALVE* pHostMapping) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDescriptorSetLayoutHostMappingInfoVALVE", "device, pBindingReference, pHostMapping", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDescriptorSetLayoutHostMappingInfoVALVE<Format>(ApiDumpInstance::current(), device, pBindingReference, pHostMapping);
        }
    }
    device_dispatch_table(device)->GetDescriptorSetLayoutHostMappingInfoVALVE(device, pBindingReference, pHostMapping);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDescriptorSetLayoutHostMappingInfoVALVE<Format>(ApiDumpInstance::current(), device, pBindingReference, pHostMapping);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDescriptorSetHostMappingVALVE(VkDevice device, VkDescriptorSet descriptorSet, void** ppData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDescriptorSetHostMappingVALVE", "device, descriptorSet, ppData", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDescriptorSetHostMappingVALVE<Format>(ApiDumpInstance::current(), device, descriptorSet, ppData);
        }
    }
    device_dispatch_table(device)->GetDescriptorSetHostMappingVALVE(device, descriptorSet, ppData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDescriptorSetHostMappingVALVE<Format>(ApiDumpInstance::current(), device, descriptorSet, ppData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyMemoryIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyMemoryIndirectNV", "commandBuffer, copyBufferAddress, copyCount, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyMemoryIndirectNV<Format>(ApiDumpInstance::current(), commandBuffer, copyBufferAddress, copyCount, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyMemoryIndirectNV(commandBuffer, copyBufferAddress, copyCount, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyMemoryIndirectNV<Format>(ApiDumpInstance::current(), commandBuffer, copyBufferAddress, copyCount, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyMemoryToImageIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyMemoryToImageIndirectNV", "commandBuffer, copyBufferAddress, copyCount, stride, dstImage, dstImageLayout, pImageSubresources", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyMemoryToImageIndirectNV<Format>(ApiDumpInstance::current(), commandBuffer, copyBufferAddress, copyCount, stride, dstImage, dstImageLayout, pImageSubresources);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyMemoryToImageIndirectNV(commandBuffer, copyBufferAddress, copyCount, stride, dstImage, dstImageLayout, pImageSubresources);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyMemoryToImageIndirectNV<Format>(ApiDumpInstance::current(), commandBuffer, copyBufferAddress, copyCount, stride, dstImage, dstImageLayout, pImageSubresources);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDecompressMemoryNV(VkCommandBuffer commandBuffer, uint32_t decompressRegionCount, const VkDecompressMemoryRegionNV* pDecompressMemoryRegions) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDecompressMemoryNV", "commandBuffer, decompressRegionCount, pDecompressMemoryRegions", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDecompressMemoryNV<Format>(ApiDumpInstance::current(), commandBuffer, decompressRegionCount, pDecompressMemoryRegions);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDecompressMemoryNV(commandBuffer, decompressRegionCount, pDecompressMemoryRegions);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDecompressMemoryNV<Format>(ApiDumpInstance::current(), commandBuffer, decompressRegionCount, pDecompressMemoryRegions);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdDecompressMemoryIndirectCountNV(VkCommandBuffer commandBuffer, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t stride) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdDecompressMemoryIndirectCountNV", "commandBuffer, indirectCommandsAddress, indirectCommandsCountAddress, stride", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdDecompressMemoryIndirectCountNV<Format>(ApiDumpInstance::current(), commandBuffer, indirectCommandsAddress, indirectCommandsCountAddress, stride);
        }
    }
    device_dispatch_table(commandBuffer)->CmdDecompressMemoryIndirectCountNV(commandBuffer, indirectCommandsAddress, indirectCommandsCountAddress, stride);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdDecompressMemoryIndirectCountNV<Format>(ApiDumpInstance::current(), commandBuffer, indirectCommandsAddress, indirectCommandsCountAddress, stride);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetPipelineIndirectMemoryRequirementsNV(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineIndirectMemoryRequirementsNV", "device, pCreateInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineIndirectMemoryRequirementsNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetPipelineIndirectMemoryRequirementsNV(device, pCreateInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineIndirectMemoryRequirementsNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdUpdatePipelineIndirectBufferNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdUpdatePipelineIndirectBufferNV", "commandBuffer, pipelineBindPoint, pipeline", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdUpdatePipelineIndirectBufferNV<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, pipeline);
        }
    }
    device_dispatch_table(commandBuffer)->CmdUpdatePipelineIndirectBufferNV(commandBuffer, pipelineBindPoint, pipeline);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdUpdatePipelineIndirectBufferNV<Format>(ApiDumpInstance::current(), commandBuffer, pipelineBindPoint, pipeline);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkDeviceAddress VKAPI_CALL vkGetPipelineIndirectDeviceAddressNV(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetPipelineIndirectDeviceAddressNV", "device, pInfo", "VkDeviceAddress");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetPipelineIndirectDeviceAddressNV<Format>(ApiDumpInstance::current(), device, pInfo);
        }
    }
    VkDeviceAddress result = device_dispatch_table(device)->GetPipelineIndirectDeviceAddressNV(device, pInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkDeviceAddress", result, dump_return_value_VkDeviceAddress<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetPipelineIndirectDeviceAddressNV<Format>(ApiDumpInstance::current(), device, pInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#if defined(VK_USE_PLATFORM_OHOS)
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetNativeBufferPropertiesOHOS(VkDevice device, const struct OH_NativeBuffer* buffer, VkNativeBufferPropertiesOHOS* pProperties) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetNativeBufferPropertiesOHOS", "device, buffer, pProperties", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetNativeBufferPropertiesOHOS<Format>(ApiDumpInstance::current(), device, buffer, pProperties);
        }
    }
    VkResult result = device_dispatch_table(device)->GetNativeBufferPropertiesOHOS(device, buffer, pProperties);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetNativeBufferPropertiesOHOS<Format>(ApiDumpInstance::current(), device, buffer, pProperties);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetMemoryNativeBufferOHOS(VkDevice device, const VkMemoryGetNativeBufferInfoOHOS* pInfo, struct OH_NativeBuffer** pBuffer) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetMemoryNativeBufferOHOS", "device, pInfo, pBuffer", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetMemoryNativeBufferOHOS<Format>(ApiDumpInstance::current(), device, pInfo, pBuffer);
        }
    }
    VkResult result = device_dispatch_table(device)->GetMemoryNativeBufferOHOS(device, pInfo, pBuffer);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetMemoryNativeBufferOHOS<Format>(ApiDumpInstance::current(), device, pInfo, pBuffer);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
#endif  // VK_USE_PLATFORM_OHOS
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthClampEnableEXT", "commandBuffer, depthClampEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthClampEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthClampEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthClampEnableEXT(commandBuffer, depthClampEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthClampEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthClampEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetPolygonModeEXT", "commandBuffer, polygonMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetPolygonModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, polygonMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetPolygonModeEXT(commandBuffer, polygonMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetPolygonModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, polygonMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits rasterizationSamples) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRasterizationSamplesEXT", "commandBuffer, rasterizationSamples", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRasterizationSamplesEXT<Format>(ApiDumpInstance::current(), commandBuffer, rasterizationSamples);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRasterizationSamplesEXT(commandBuffer, rasterizationSamples);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRasterizationSamplesEXT<Format>(ApiDumpInstance::current(), commandBuffer, rasterizationSamples);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits samples, const VkSampleMask* pSampleMask) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetSampleMaskEXT", "commandBuffer, samples, pSampleMask", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetSampleMaskEXT<Format>(ApiDumpInstance::current(), commandBuffer, samples, pSampleMask);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetSampleMaskEXT(commandBuffer, samples, pSampleMask);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetSampleMaskEXT<Format>(ApiDumpInstance::current(), commandBuffer, samples, pSampleMask);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetAlphaToCoverageEnableEXT", "commandBuffer, alphaToCoverageEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetAlphaToCoverageEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, alphaToCoverageEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetAlphaToCoverageEnableEXT(commandBuffer, alphaToCoverageEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetAlphaToCoverageEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, alphaToCoverageEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetAlphaToOneEnableEXT", "commandBuffer, alphaToOneEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetAlphaToOneEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, alphaToOneEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetAlphaToOneEnableEXT(commandBuffer, alphaToOneEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetAlphaToOneEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, alphaToOneEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLogicOpEnableEXT", "commandBuffer, logicOpEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLogicOpEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, logicOpEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLogicOpEnableEXT(commandBuffer, logicOpEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLogicOpEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, logicOpEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetColorBlendEnableEXT", "commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetColorBlendEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetColorBlendEnableEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetColorBlendEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorBlendEnables);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetColorBlendEquationEXT", "commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetColorBlendEquationEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetColorBlendEquationEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetColorBlendEquationEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorBlendEquations);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetColorWriteMaskEXT", "commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetColorWriteMaskEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetColorWriteMaskEXT(commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetColorWriteMaskEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorWriteMasks);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetTessellationDomainOriginEXT", "commandBuffer, domainOrigin", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetTessellationDomainOriginEXT<Format>(ApiDumpInstance::current(), commandBuffer, domainOrigin);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetTessellationDomainOriginEXT(commandBuffer, domainOrigin);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetTessellationDomainOriginEXT<Format>(ApiDumpInstance::current(), commandBuffer, domainOrigin);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, uint32_t rasterizationStream) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRasterizationStreamEXT", "commandBuffer, rasterizationStream", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRasterizationStreamEXT<Format>(ApiDumpInstance::current(), commandBuffer, rasterizationStream);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRasterizationStreamEXT(commandBuffer, rasterizationStream);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRasterizationStreamEXT<Format>(ApiDumpInstance::current(), commandBuffer, rasterizationStream);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetConservativeRasterizationModeEXT", "commandBuffer, conservativeRasterizationMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetConservativeRasterizationModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, conservativeRasterizationMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetConservativeRasterizationModeEXT(commandBuffer, conservativeRasterizationMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetConservativeRasterizationModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, conservativeRasterizationMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetExtraPrimitiveOverestimationSizeEXT(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetExtraPrimitiveOverestimationSizeEXT", "commandBuffer, extraPrimitiveOverestimationSize", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetExtraPrimitiveOverestimationSizeEXT<Format>(ApiDumpInstance::current(), commandBuffer, extraPrimitiveOverestimationSize);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetExtraPrimitiveOverestimationSizeEXT(commandBuffer, extraPrimitiveOverestimationSize);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetExtraPrimitiveOverestimationSizeEXT<Format>(ApiDumpInstance::current(), commandBuffer, extraPrimitiveOverestimationSize);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthClipEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthClipEnableEXT", "commandBuffer, depthClipEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthClipEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthClipEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthClipEnableEXT(commandBuffer, depthClipEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthClipEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, depthClipEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetSampleLocationsEnableEXT(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetSampleLocationsEnableEXT", "commandBuffer, sampleLocationsEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetSampleLocationsEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, sampleLocationsEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetSampleLocationsEnableEXT(commandBuffer, sampleLocationsEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetSampleLocationsEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, sampleLocationsEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetColorBlendAdvancedEXT", "commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetColorBlendAdvancedEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetColorBlendAdvancedEXT(commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetColorBlendAdvancedEXT<Format>(ApiDumpInstance::current(), commandBuffer, firstAttachment, attachmentCount, pColorBlendAdvanced);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetProvokingVertexModeEXT(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetProvokingVertexModeEXT", "commandBuffer, provokingVertexMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetProvokingVertexModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, provokingVertexMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetProvokingVertexModeEXT(commandBuffer, provokingVertexMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetProvokingVertexModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, provokingVertexMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLineRasterizationModeEXT(VkCommandBuffer commandBuffer, VkLineRasterizationModeEXT lineRasterizationMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLineRasterizationModeEXT", "commandBuffer, lineRasterizationMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLineRasterizationModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, lineRasterizationMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLineRasterizationModeEXT(commandBuffer, lineRasterizationMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLineRasterizationModeEXT<Format>(ApiDumpInstance::current(), commandBuffer, lineRasterizationMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetLineStippleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetLineStippleEnableEXT", "commandBuffer, stippledLineEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetLineStippleEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, stippledLineEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetLineStippleEnableEXT(commandBuffer, stippledLineEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetLineStippleEnableEXT<Format>(ApiDumpInstance::current(), commandBuffer, stippledLineEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetDepthClipNegativeOneToOneEXT(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetDepthClipNegativeOneToOneEXT", "commandBuffer, negativeOneToOne", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetDepthClipNegativeOneToOneEXT<Format>(ApiDumpInstance::current(), commandBuffer, negativeOneToOne);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetDepthClipNegativeOneToOneEXT(commandBuffer, negativeOneToOne);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetDepthClipNegativeOneToOneEXT<Format>(ApiDumpInstance::current(), commandBuffer, negativeOneToOne);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetViewportWScalingEnableNV(VkCommandBuffer commandBuffer, VkBool32 viewportWScalingEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetViewportWScalingEnableNV", "commandBuffer, viewportWScalingEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetViewportWScalingEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, viewportWScalingEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetViewportWScalingEnableNV(commandBuffer, viewportWScalingEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetViewportWScalingEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, viewportWScalingEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetViewportSwizzleNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportSwizzleNV* pViewportSwizzles) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetViewportSwizzleNV", "commandBuffer, firstViewport, viewportCount, pViewportSwizzles", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetViewportSwizzleNV<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pViewportSwizzles);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetViewportSwizzleNV(commandBuffer, firstViewport, viewportCount, pViewportSwizzles);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetViewportSwizzleNV<Format>(ApiDumpInstance::current(), commandBuffer, firstViewport, viewportCount, pViewportSwizzles);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCoverageToColorEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageToColorEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCoverageToColorEnableNV", "commandBuffer, coverageToColorEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCoverageToColorEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageToColorEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCoverageToColorEnableNV(commandBuffer, coverageToColorEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCoverageToColorEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageToColorEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCoverageToColorLocationNV(VkCommandBuffer commandBuffer, uint32_t coverageToColorLocation) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCoverageToColorLocationNV", "commandBuffer, coverageToColorLocation", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCoverageToColorLocationNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageToColorLocation);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCoverageToColorLocationNV(commandBuffer, coverageToColorLocation);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCoverageToColorLocationNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageToColorLocation);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCoverageModulationModeNV(VkCommandBuffer commandBuffer, VkCoverageModulationModeNV coverageModulationMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCoverageModulationModeNV", "commandBuffer, coverageModulationMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCoverageModulationModeNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageModulationMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCoverageModulationModeNV(commandBuffer, coverageModulationMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCoverageModulationModeNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageModulationMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCoverageModulationTableEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageModulationTableEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCoverageModulationTableEnableNV", "commandBuffer, coverageModulationTableEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCoverageModulationTableEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageModulationTableEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCoverageModulationTableEnableNV(commandBuffer, coverageModulationTableEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCoverageModulationTableEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageModulationTableEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, uint32_t coverageModulationTableCount, const float* pCoverageModulationTable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCoverageModulationTableNV", "commandBuffer, coverageModulationTableCount, pCoverageModulationTable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCoverageModulationTableNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageModulationTableCount, pCoverageModulationTable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCoverageModulationTableNV(commandBuffer, coverageModulationTableCount, pCoverageModulationTable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCoverageModulationTableNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageModulationTableCount, pCoverageModulationTable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetShadingRateImageEnableNV(VkCommandBuffer commandBuffer, VkBool32 shadingRateImageEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetShadingRateImageEnableNV", "commandBuffer, shadingRateImageEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetShadingRateImageEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, shadingRateImageEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetShadingRateImageEnableNV(commandBuffer, shadingRateImageEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetShadingRateImageEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, shadingRateImageEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetRepresentativeFragmentTestEnableNV(VkCommandBuffer commandBuffer, VkBool32 representativeFragmentTestEnable) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetRepresentativeFragmentTestEnableNV", "commandBuffer, representativeFragmentTestEnable", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetRepresentativeFragmentTestEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, representativeFragmentTestEnable);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetRepresentativeFragmentTestEnableNV(commandBuffer, representativeFragmentTestEnable);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetRepresentativeFragmentTestEnableNV<Format>(ApiDumpInstance::current(), commandBuffer, representativeFragmentTestEnable);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdSetCoverageReductionModeNV(VkCommandBuffer commandBuffer, VkCoverageReductionModeNV coverageReductionMode) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdSetCoverageReductionModeNV", "commandBuffer, coverageReductionMode", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdSetCoverageReductionModeNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageReductionMode);
        }
    }
    device_dispatch_table(commandBuffer)->CmdSetCoverageReductionModeNV(commandBuffer, coverageReductionMode);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdSetCoverageReductionModeNV<Format>(ApiDumpInstance::current(), commandBuffer, coverageReductionMode);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateTensorARM(VkDevice device, const VkTensorCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorARM* pTensor) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateTensorARM", "device, pCreateInfo, pAllocator, pTensor", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateTensorARM<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pTensor);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateTensorARM(device, pCreateInfo, pAllocator, pTensor);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateTensorARM<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pTensor);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyTensorARM(VkDevice device, VkTensorARM tensor, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyTensorARM", "device, tensor, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyTensorARM<Format>(ApiDumpInstance::current(), device, tensor, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyTensorARM(device, tensor, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyTensorARM<Format>(ApiDumpInstance::current(), device, tensor, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateTensorViewARM(VkDevice device, const VkTensorViewCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorViewARM* pView) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateTensorViewARM", "device, pCreateInfo, pAllocator, pView", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateTensorViewARM<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pView);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateTensorViewARM(device, pCreateInfo, pAllocator, pView);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateTensorViewARM<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pView);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyTensorViewARM(VkDevice device, VkTensorViewARM tensorView, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyTensorViewARM", "device, tensorView, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyTensorViewARM<Format>(ApiDumpInstance::current(), device, tensorView, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyTensorViewARM(device, tensorView, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyTensorViewARM<Format>(ApiDumpInstance::current(), device, tensorView, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetTensorMemoryRequirementsARM(VkDevice device, const VkTensorMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetTensorMemoryRequirementsARM", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetTensorMemoryRequirementsARM<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetTensorMemoryRequirementsARM(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetTensorMemoryRequirementsARM<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindTensorMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindTensorMemoryInfoARM* pBindInfos) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindTensorMemoryARM", "device, bindInfoCount, pBindInfos", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindTensorMemoryARM<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        }
    }
    VkResult result = device_dispatch_table(device)->BindTensorMemoryARM(device, bindInfoCount, pBindInfos);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindTensorMemoryARM<Format>(ApiDumpInstance::current(), device, bindInfoCount, pBindInfos);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetDeviceTensorMemoryRequirementsARM(VkDevice device, const VkDeviceTensorMemoryRequirementsARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetDeviceTensorMemoryRequirementsARM", "device, pInfo, pMemoryRequirements", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetDeviceTensorMemoryRequirementsARM<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        }
    }
    device_dispatch_table(device)->GetDeviceTensorMemoryRequirementsARM(device, pInfo, pMemoryRequirements);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetDeviceTensorMemoryRequirementsARM<Format>(ApiDumpInstance::current(), device, pInfo, pMemoryRequirements);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdCopyTensorARM(VkCommandBuffer commandBuffer, const VkCopyTensorInfoARM* pCopyTensorInfo) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCmdCopyTensorARM", "commandBuffer, pCopyTensorInfo", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCmdCopyTensorARM<Format>(ApiDumpInstance::current(), commandBuffer, pCopyTensorInfo);
        }
    }
    device_dispatch_table(commandBuffer)->CmdCopyTensorARM(commandBuffer, pCopyTensorInfo);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCmdCopyTensorARM<Format>(ApiDumpInstance::current(), commandBuffer, pCopyTensorInfo);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetTensorOpaqueCaptureDescriptorDataARM(VkDevice device, const VkTensorCaptureDescriptorDataInfoARM* pInfo, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetTensorOpaqueCaptureDescriptorDataARM", "device, pInfo, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetTensorOpaqueCaptureDescriptorDataARM<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetTensorOpaqueCaptureDescriptorDataARM(device, pInfo, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetTensorOpaqueCaptureDescriptorDataARM<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkGetTensorViewOpaqueCaptureDescriptorDataARM(VkDevice device, const VkTensorViewCaptureDescriptorDataInfoARM* pInfo, void* pData) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetTensorViewOpaqueCaptureDescriptorDataARM", "device, pInfo, pData", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetTensorViewOpaqueCaptureDescriptorDataARM<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        }
    }
    VkResult result = device_dispatch_table(device)->GetTensorViewOpaqueCaptureDescriptorDataARM(device, pInfo, pData);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetTensorViewOpaqueCaptureDescriptorDataARM<Format>(ApiDumpInstance::current(), device, pInfo, pData);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetShaderModuleIdentifierEXT(VkDevice device, VkShaderModule shaderModule, VkShaderModuleIdentifierEXT* pIdentifier) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetShaderModuleIdentifierEXT", "device, shaderModule, pIdentifier", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetShaderModuleIdentifierEXT<Format>(ApiDumpInstance::current(), device, shaderModule, pIdentifier);
        }
    }
    device_dispatch_table(device)->GetShaderModuleIdentifierEXT(device, shaderModule, pIdentifier);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetShaderModuleIdentifierEXT<Format>(ApiDumpInstance::current(), device, shaderModule, pIdentifier);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkGetShaderModuleCreateInfoIdentifierEXT(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, VkShaderModuleIdentifierEXT* pIdentifier) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkGetShaderModuleCreateInfoIdentifierEXT", "device, pCreateInfo, pIdentifier", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkGetShaderModuleCreateInfoIdentifierEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pIdentifier);
        }
    }
    device_dispatch_table(device)->GetShaderModuleCreateInfoIdentifierEXT(device, pCreateInfo, pIdentifier);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkGetShaderModuleCreateInfoIdentifierEXT<Format>(ApiDumpInstance::current(), device, pCreateInfo, pIdentifier);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkCreateOpticalFlowSessionNV(VkDevice device, const VkOpticalFlowSessionCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkOpticalFlowSessionNV* pSession) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkCreateOpticalFlowSessionNV", "device, pCreateInfo, pAllocator, pSession", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkCreateOpticalFlowSessionNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSession);
        }
    }
    VkResult result = device_dispatch_table(device)->CreateOpticalFlowSessionNV(device, pCreateInfo, pAllocator, pSession);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkCreateOpticalFlowSessionNV<Format>(ApiDumpInstance::current(), device, pCreateInfo, pAllocator, pSession);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkDestroyOpticalFlowSessionNV(VkDevice device, VkOpticalFlowSessionNV session, const VkAllocationCallbacks* pAllocator) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkDestroyOpticalFlowSessionNV", "device, session, pAllocator", "void");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkDestroyOpticalFlowSessionNV<Format>(ApiDumpInstance::current(), device, session, pAllocator);
        }
    }
    device_dispatch_table(device)->DestroyOpticalFlowSessionNV(device, session, pAllocator);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkDestroyOpticalFlowSessionNV<Format>(ApiDumpInstance::current(), device, session, pAllocator);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
}
template <ApiDumpFormat Format>
VKAPI_ATTR VkResult VKAPI_CALL vkBindOpticalFlowSessionImageNV(VkDevice device, VkOpticalFlowSessionNV session, VkOpticalFlowSessionBindingPointNV bindingPoint, VkImageView view, VkImageLayout layout) {
    std::lock_guard<std::mutex> lg(ApiDumpInstance::current().outputMutex());

    dump_function_head(ApiDumpInstance::current(), "vkBindOpticalFlowSessionImageNV", "device, session, bindingPoint, view, layout", "VkResult");
    if constexpr (Format == ApiDumpFormat::Text) {
        if (ApiDumpInstance::current().settings().shouldPreDump() && ApiDumpInstance::current().shouldDumpOutput()) {
            dump_before_pre_dump_formatting<Format>(ApiDumpInstance::current().settings());
            dump_params_vkBindOpticalFlowSessionImageNV<Format>(ApiDumpInstance::current(), device, session, bindingPoint, view, layout);
        }
    }
    VkResult result = device_dispatch_table(device)->BindOpticalFlowSessionImageNV(device, session, bindingPoint, view, layout);
    if (ApiDumpInstance::current().shouldDumpOutput()) {
        dump_return_value<Format>(ApiDumpInstance::current().settings(), "VkResult", result, dump_return_value_VkResult<Format>);
        dump_pre_function_formatting<Format>(ApiDumpInstance::current().settings());
        dump_params_vkBindOpticalFlowSessionImageNV<Format>(ApiDumpInstance::current(), device, session, bindingPoint, view, layout);
        dump_post_function_formatting<Format>(ApiDumpInstance::current().settings());
        flush(ApiDumpInstance::current().settings());
    }
    return result;
}
template <ApiDumpFormat Format>
VKAPI_ATTR void VKAPI_CALL vkCmdOpticalFlowExecuteNV