/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPublicKeyCredentialCreationOptions.h"

#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>

#if ENABLE(WEB_AUTHN)
#include "JSAttestationConveyancePreference.h"
#include "JSAuthenticationExtensionsClientInputs.h"
#include "JSAuthenticatorSelectionCriteria.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSPublicKeyCredentialDescriptor.h"
#include "JSPublicKeyCredentialParameters.h"
#include "JSPublicKeyCredentialRpEntity.h"
#include "JSPublicKeyCredentialUserEntity.h"
#include <JavaScriptCore/JSArray.h>
#include <wtf/Variant.h>
#endif



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PublicKeyCredentialCreationOptions>> convertDictionary<PublicKeyCredentialCreationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PublicKeyCredentialCreationOptions result;
#if ENABLE(WEB_AUTHN)
    JSValue attestationValue;
    if (isNullOrUndefined)
        attestationValue = jsUndefined();
    else {
        attestationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attestation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto attestationConversionResult = convertOptionalWithDefault<IDLEnumeration<AttestationConveyancePreference>>(lexicalGlobalObject, attestationValue, [&]() -> ConversionResult<IDLEnumeration<AttestationConveyancePreference>> { return Converter<IDLEnumeration<AttestationConveyancePreference>>::ReturnType { AttestationConveyancePreference::None }; });
    if (attestationConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.attestation = attestationConversionResult.releaseReturnValue();
#endif
#if ENABLE(WEB_AUTHN)
    JSValue authenticatorSelectionValue;
    if (isNullOrUndefined)
        authenticatorSelectionValue = jsUndefined();
    else {
        authenticatorSelectionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "authenticatorSelection"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!authenticatorSelectionValue.isUndefined()) {
        auto authenticatorSelectionConversionResult = convert<IDLDictionary<AuthenticatorSelectionCriteria>>(lexicalGlobalObject, authenticatorSelectionValue);
        if (authenticatorSelectionConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.authenticatorSelection = authenticatorSelectionConversionResult.releaseReturnValue();
    }
#endif
#if ENABLE(WEB_AUTHN)
    JSValue challengeValue;
    if (isNullOrUndefined)
        challengeValue = jsUndefined();
    else {
        challengeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "challenge"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (challengeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "challenge"_s, "PublicKeyCredentialCreationOptions"_s, "(ArrayBufferView or ArrayBuffer)"_s);
        return ConversionResultException { };
    }
    auto challengeConversionResult = convert<IDLBufferSource>(lexicalGlobalObject, challengeValue);
    if (challengeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.challenge = challengeConversionResult.releaseReturnValue();
#endif
#if ENABLE(WEB_AUTHN)
    JSValue excludeCredentialsValue;
    if (isNullOrUndefined)
        excludeCredentialsValue = jsUndefined();
    else {
        excludeCredentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "excludeCredentials"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto excludeCredentialsConversionResult = convertOptionalWithDefault<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>(lexicalGlobalObject, excludeCredentialsValue, [&]() -> ConversionResult<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>> { return Converter<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>::ReturnType { }; });
    if (excludeCredentialsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.excludeCredentials = excludeCredentialsConversionResult.releaseReturnValue();
#endif
#if ENABLE(WEB_AUTHN)
    JSValue extensionsValue;
    if (isNullOrUndefined)
        extensionsValue = jsUndefined();
    else {
        extensionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "extensions"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!extensionsValue.isUndefined()) {
        auto extensionsConversionResult = convert<IDLDictionary<AuthenticationExtensionsClientInputs>>(lexicalGlobalObject, extensionsValue);
        if (extensionsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.extensions = extensionsConversionResult.releaseReturnValue();
    }
#endif
#if ENABLE(WEB_AUTHN)
    JSValue pubKeyCredParamsValue;
    if (isNullOrUndefined)
        pubKeyCredParamsValue = jsUndefined();
    else {
        pubKeyCredParamsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pubKeyCredParams"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (pubKeyCredParamsValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "pubKeyCredParams"_s, "PublicKeyCredentialCreationOptions"_s, "sequence"_s);
        return ConversionResultException { };
    }
    auto pubKeyCredParamsConversionResult = convert<IDLSequence<IDLDictionary<PublicKeyCredentialParameters>>>(lexicalGlobalObject, pubKeyCredParamsValue);
    if (pubKeyCredParamsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.pubKeyCredParams = pubKeyCredParamsConversionResult.releaseReturnValue();
#endif
#if ENABLE(WEB_AUTHN)
    JSValue rpValue;
    if (isNullOrUndefined)
        rpValue = jsUndefined();
    else {
        rpValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (rpValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "rp"_s, "PublicKeyCredentialCreationOptions"_s, "PublicKeyCredentialRpEntity"_s);
        return ConversionResultException { };
    }
    auto rpConversionResult = convert<IDLDictionary<PublicKeyCredentialRpEntity>>(lexicalGlobalObject, rpValue);
    if (rpConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.rp = rpConversionResult.releaseReturnValue();
#endif
#if ENABLE(WEB_AUTHN)
    JSValue timeoutValue;
    if (isNullOrUndefined)
        timeoutValue = jsUndefined();
    else {
        timeoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timeout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timeoutValue.isUndefined()) {
        auto timeoutConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, timeoutValue);
        if (timeoutConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timeout = timeoutConversionResult.releaseReturnValue();
    }
#endif
#if ENABLE(WEB_AUTHN)
    JSValue userValue;
    if (isNullOrUndefined)
        userValue = jsUndefined();
    else {
        userValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "user"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (userValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "user"_s, "PublicKeyCredentialCreationOptions"_s, "PublicKeyCredentialUserEntity"_s);
        return ConversionResultException { };
    }
    auto userConversionResult = convert<IDLDictionary<PublicKeyCredentialUserEntity>>(lexicalGlobalObject, userValue);
    if (userConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.user = userConversionResult.releaseReturnValue();
#endif
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const PublicKeyCredentialCreationOptions& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

#if ENABLE(WEB_AUTHN)
    auto attestationValue = toJS<IDLEnumeration<AttestationConveyancePreference>>(lexicalGlobalObject, throwScope, dictionary.attestation);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "attestation"_s), attestationValue);
#endif
#if ENABLE(WEB_AUTHN)
    if (!IDLDictionary<AuthenticatorSelectionCriteria>::isNullValue(dictionary.authenticatorSelection)) {
        auto authenticatorSelectionValue = toJS<IDLDictionary<AuthenticatorSelectionCriteria>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<AuthenticatorSelectionCriteria>::extractValueFromNullable(dictionary.authenticatorSelection));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "authenticatorSelection"_s), authenticatorSelectionValue);
    }
#endif
#if ENABLE(WEB_AUTHN)
    auto challengeValue = toJS<IDLBufferSource>(lexicalGlobalObject, throwScope, dictionary.challenge);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "challenge"_s), challengeValue);
#endif
#if ENABLE(WEB_AUTHN)
    auto excludeCredentialsValue = toJS<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>(lexicalGlobalObject, globalObject, throwScope, dictionary.excludeCredentials);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "excludeCredentials"_s), excludeCredentialsValue);
#endif
#if ENABLE(WEB_AUTHN)
    if (!IDLDictionary<AuthenticationExtensionsClientInputs>::isNullValue(dictionary.extensions)) {
        auto extensionsValue = toJS<IDLDictionary<AuthenticationExtensionsClientInputs>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<AuthenticationExtensionsClientInputs>::extractValueFromNullable(dictionary.extensions));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "extensions"_s), extensionsValue);
    }
#endif
#if ENABLE(WEB_AUTHN)
    auto pubKeyCredParamsValue = toJS<IDLSequence<IDLDictionary<PublicKeyCredentialParameters>>>(lexicalGlobalObject, globalObject, throwScope, dictionary.pubKeyCredParams);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "pubKeyCredParams"_s), pubKeyCredParamsValue);
#endif
#if ENABLE(WEB_AUTHN)
    auto rpValue = toJS<IDLDictionary<PublicKeyCredentialRpEntity>>(lexicalGlobalObject, globalObject, throwScope, dictionary.rp);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "rp"_s), rpValue);
#endif
#if ENABLE(WEB_AUTHN)
    if (!IDLUnsignedLong::isNullValue(dictionary.timeout)) {
        auto timeoutValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, IDLUnsignedLong::extractValueFromNullable(dictionary.timeout));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timeout"_s), timeoutValue);
    }
#endif
#if ENABLE(WEB_AUTHN)
    auto userValue = toJS<IDLDictionary<PublicKeyCredentialUserEntity>>(lexicalGlobalObject, globalObject, throwScope, dictionary.user);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "user"_s), userValue);
#endif
    UNUSED_PARAM(dictionary);
    UNUSED_VARIABLE(throwScope);

    return result;
}

} // namespace WebCore

