/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTConservativeDepth.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSEXTConservativeDepthPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTConservativeDepthPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTConservativeDepthPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTConservativeDepthPrototype>(vm)) JSEXTConservativeDepthPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTConservativeDepthPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTConservativeDepthPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTConservativeDepthPrototype, JSEXTConservativeDepthPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSEXTConservativeDepthPrototype::s_info = { "EXTConservativeDepth"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTConservativeDepthPrototype) };

void JSEXTConservativeDepthPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTConservativeDepth::s_info = { "EXTConservativeDepth"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTConservativeDepth) };

JSEXTConservativeDepth::JSEXTConservativeDepth(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTConservativeDepth>&& impl)
    : JSDOMWrapper<EXTConservativeDepth>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTConservativeDepth>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTConservativeDepth::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTConservativeDepthPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTConservativeDepthPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTConservativeDepth::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTConservativeDepth>(vm, globalObject);
}

void JSEXTConservativeDepth::destroy(JSC::JSCell* cell)
{
    JSEXTConservativeDepth* thisObject = static_cast<JSEXTConservativeDepth*>(cell);
    thisObject->JSEXTConservativeDepth::~JSEXTConservativeDepth();
}

JSC::GCClient::IsoSubspace* JSEXTConservativeDepth::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTConservativeDepth, UseCustomHeapCellType::No>(vm, "JSEXTConservativeDepth"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTConservativeDepth.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTConservativeDepth = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTConservativeDepth.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTConservativeDepth = std::forward<decltype(space)>(space); }
    );
}

void JSEXTConservativeDepth::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTConservativeDepth*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTConservativeDepthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTConservativeDepth = jsCast<JSEXTConservativeDepth*>(handle.slot()->asCell());
    auto& owner = jsEXTConservativeDepth->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTConservativeDepth"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTConservativeDepthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTConservativeDepth = static_cast<JSEXTConservativeDepth*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTConservativeDepth->protectedWrapped().ptr(), jsEXTConservativeDepth);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTConservativeDepth@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20EXTConservativeDepthE[]; }
#endif
template<std::same_as<EXTConservativeDepth> T>
static inline void verifyVTable(EXTConservativeDepth* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTConservativeDepth@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20EXTConservativeDepthE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTConservativeDepth has subclasses. If EXTConservativeDepth has subclasses that get passed
        // to toJS() we currently require EXTConservativeDepth you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTConservativeDepth>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTConservativeDepth>(impl.ptr());
#endif
    return createWrapper<EXTConservativeDepth>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTConservativeDepth& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTConservativeDepth* JSEXTConservativeDepth::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTConservativeDepth*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
