/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTDisjointTimerQueryWebGL2.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebGLQuery.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXT);

class JSEXTDisjointTimerQueryWebGL2Prototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTDisjointTimerQueryWebGL2Prototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTDisjointTimerQueryWebGL2Prototype* ptr = new (NotNull, JSC::allocateCell<JSEXTDisjointTimerQueryWebGL2Prototype>(vm)) JSEXTDisjointTimerQueryWebGL2Prototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDisjointTimerQueryWebGL2Prototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTDisjointTimerQueryWebGL2Prototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTDisjointTimerQueryWebGL2Prototype, JSEXTDisjointTimerQueryWebGL2Prototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSEXTDisjointTimerQueryWebGL2PrototypeTableValues {
    HashTableValue { "queryCounterEXT"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXT, 2 } },
    HashTableValue { "QUERY_COUNTER_BITS_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8864 } },
    HashTableValue { "TIME_ELAPSED_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88BF } },
    HashTableValue { "TIMESTAMP_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8E28 } },
    HashTableValue { "GPU_DISJOINT_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8FBB } },
};

const ClassInfo JSEXTDisjointTimerQueryWebGL2Prototype::s_info = { "EXTDisjointTimerQueryWebGL2"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDisjointTimerQueryWebGL2Prototype) };

void JSEXTDisjointTimerQueryWebGL2Prototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTDisjointTimerQueryWebGL2::info(), JSEXTDisjointTimerQueryWebGL2PrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTDisjointTimerQueryWebGL2::s_info = { "EXTDisjointTimerQueryWebGL2"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTDisjointTimerQueryWebGL2) };

JSEXTDisjointTimerQueryWebGL2::JSEXTDisjointTimerQueryWebGL2(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTDisjointTimerQueryWebGL2>&& impl)
    : JSDOMWrapper<EXTDisjointTimerQueryWebGL2>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTDisjointTimerQueryWebGL2>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTDisjointTimerQueryWebGL2::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTDisjointTimerQueryWebGL2Prototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTDisjointTimerQueryWebGL2Prototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTDisjointTimerQueryWebGL2::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTDisjointTimerQueryWebGL2>(vm, globalObject);
}

void JSEXTDisjointTimerQueryWebGL2::destroy(JSC::JSCell* cell)
{
    JSEXTDisjointTimerQueryWebGL2* thisObject = static_cast<JSEXTDisjointTimerQueryWebGL2*>(cell);
    thisObject->JSEXTDisjointTimerQueryWebGL2::~JSEXTDisjointTimerQueryWebGL2();
}

static inline JSC::EncodedJSValue jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXTBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSEXTDisjointTimerQueryWebGL2>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto queryConversionResult = convert<IDLInterface<WebGLQuery>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "query"_s, "EXTDisjointTimerQueryWebGL2"_s, "queryCounterEXT"_s, "WebGLQuery"_s); });
    if (queryConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto targetConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (targetConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.queryCounterEXT(*queryConversionResult.releaseReturnValue(), targetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXT, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSEXTDisjointTimerQueryWebGL2>::call<jsEXTDisjointTimerQueryWebGL2PrototypeFunction_queryCounterEXTBody>(*lexicalGlobalObject, *callFrame, "queryCounterEXT");
}

JSC::GCClient::IsoSubspace* JSEXTDisjointTimerQueryWebGL2::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTDisjointTimerQueryWebGL2, UseCustomHeapCellType::No>(vm, "JSEXTDisjointTimerQueryWebGL2"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTDisjointTimerQueryWebGL2.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTDisjointTimerQueryWebGL2 = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTDisjointTimerQueryWebGL2.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTDisjointTimerQueryWebGL2 = std::forward<decltype(space)>(space); }
    );
}

void JSEXTDisjointTimerQueryWebGL2::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTDisjointTimerQueryWebGL2*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTDisjointTimerQueryWebGL2Owner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTDisjointTimerQueryWebGL2 = jsCast<JSEXTDisjointTimerQueryWebGL2*>(handle.slot()->asCell());
    auto& owner = jsEXTDisjointTimerQueryWebGL2->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTDisjointTimerQueryWebGL2"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTDisjointTimerQueryWebGL2Owner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTDisjointTimerQueryWebGL2 = static_cast<JSEXTDisjointTimerQueryWebGL2*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTDisjointTimerQueryWebGL2->protectedWrapped().ptr(), jsEXTDisjointTimerQueryWebGL2);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTDisjointTimerQueryWebGL2@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27EXTDisjointTimerQueryWebGL2E[]; }
#endif
template<std::same_as<EXTDisjointTimerQueryWebGL2> T>
static inline void verifyVTable(EXTDisjointTimerQueryWebGL2* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTDisjointTimerQueryWebGL2@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore27EXTDisjointTimerQueryWebGL2E[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTDisjointTimerQueryWebGL2 has subclasses. If EXTDisjointTimerQueryWebGL2 has subclasses that get passed
        // to toJS() we currently require EXTDisjointTimerQueryWebGL2 you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTDisjointTimerQueryWebGL2>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTDisjointTimerQueryWebGL2>(impl.ptr());
#endif
    return createWrapper<EXTDisjointTimerQueryWebGL2>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTDisjointTimerQueryWebGL2& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTDisjointTimerQueryWebGL2* JSEXTDisjointTimerQueryWebGL2::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTDisjointTimerQueryWebGL2*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
