// generated by Fast Light User Interface Designer (fluid) version 1.0404

#include "ADnoteUI.h"
// ADNoteUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014-2024, Will Godfrey, Kristian Amlie

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code.


#include "MasterUI.h"
#include "Misc/SynthHelper.h"
    using synth::getDetune;
#include "Misc/FormatFuncs.h"
    using func::asString;
#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }

void ADvoiceUI::cb_voiceonbutton_i(Fl_Check_Button2* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::enableVoice, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADvoiceUI::cb_voiceonbutton(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->user_data()))->cb_voiceonbutton_i(o,v);
}

void ADvoiceUI::cb_ModFreqEn_i(Fl_Check_Button2* o, void*) {
  //
                      if (o->value() == 0)
                          voiceFMfreqenvgroup->deactivate();
                      else
                          voiceFMfreqenvgroup->activate();
                      o->redraw();
                      send_data(0, ADDVOICE::control::enableModulatorFrequencyEnvelope, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModFreqEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModFreqEn_i(o,v);
}

void ADvoiceUI::cb_ModCoarseDetune_i(Fl_Counter* o, void*) {
  //
                      send_data(0, ADDVOICE::control::modulatorCoarseDetune, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModCoarseDetune(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModCoarseDetune_i(o,v);
}

void ADvoiceUI::cb_ModOctave_i(Fl_Counter* o, void*) {
  //
                      send_data(0, ADDVOICE::control::modulatorOctave, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModOctave(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModOctave_i(o,v);
}

void ADvoiceUI::cb_ModDetune_i(mwheel_slider_rev* o, void*) {
  //
                      o->selection_color(setSlider(o->value(),0));
                      send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::modulatorDetuneFrequency, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModDetune(mwheel_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModDetune_i(o,v);
}

void ADvoiceUI::cb_ModDetuneType_i(Fl_Choice* o, void*) {
  //
                      send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::modulatorDetuneType, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModDetuneType(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModDetuneType_i(o,v);
}

void ADvoiceUI::cb_fmdetunevalueoutput_i(Fl_Value_Output* o, void*) {
  //
                      o->value(getDetune((ModDetuneType->value() < 1) ? (collect_readData(synth, 0, ADDSYNTH::detuneType, npart, kititem, PART::engine::addSynth)) : (ModDetuneType->value()), 0, ModDetune->value()+8192));
      ;
}
void ADvoiceUI::cb_fmdetunevalueoutput(Fl_Value_Output* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_fmdetunevalueoutput_i(o,v);
}

void ADvoiceUI::cb_Mod440_i(Fl_Check_Button2* o, void*) {
  //
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::modulatorFrequencyAs440Hz, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_Mod440(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_Mod440_i(o,v);
}

void ADvoiceUI::cb_detuneFromBaseOsc_i(Fl_Check_Button2* o, void*) {
  //
                      send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::modulatorDetuneFromBaseOsc, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_detuneFromBaseOsc(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_detuneFromBaseOsc_i(o,v);
}

void ADvoiceUI::cb_ModVolume_i(mwheel_val_slider_rev* o, void*) {
  //
                      o->selection_color(setSlider(o->value(),90));
                      send_data(0, ADDVOICE::control::modulatorAmplitude, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModVolume(mwheel_val_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModVolume_i(o,v);
}

void ADvoiceUI::cb_ModVsense_i(mwheel_val_slider_rev* o, void*) {
  //
                      o->selection_color(setSlider(o->value(),64));
                      send_data(0, ADDVOICE::control::modulatorVelocitySense, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModVsense(mwheel_val_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModVsense_i(o,v);
}

void ADvoiceUI::cb_ModAmpEn_i(Fl_Check_Button2* o, void*) {
  //
                      if (o->value() == 0)
                          voiceFMampenvgroup->deactivate();
                      else
                          voiceFMampenvgroup->activate();
                      o->redraw();
                      send_data(0, ADDVOICE::control::enableModulatorAmplitudeEnvelope, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModAmpEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModAmpEn_i(o,v);
}

void ADvoiceUI::cb_ModFdamp_i(mwheel_val_slider_rev* o, void*) {
  //
                      o->selection_color(setSlider(o->value(),0));
                      send_data(0, ADDVOICE::control::modulatorHFdamping, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModFdamp(mwheel_val_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModFdamp_i(o,v);
}

void ADvoiceUI::cb_ExtModOsc_i(Fl_Choice* o, void*) {
  //
                      send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::modulatorOscillatorSource, o->value() - 1, TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ExtModOsc(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ExtModOsc_i(o,v);
}

void ADvoiceUI::cb_changeFMoscilbutton_i(Fl_Button*, void*) {
  //
                      if (oscedit)
                          delete oscedit;
                      lastWaveW = 0;
                      int nv = nvoice;
                      int extMod = ExtModOsc->value() - 1;
                      if (extMod >= 0)
                          nv = extMod;
                      oscedit = new OscilEditor(pars->VoicePar[nv].POscilFM, modOscDisplay, NULL, NULL, synth, npart, kititem, nvoice + PART::engine::addMod1);
                      if ((Fl::event_button() == 3))
                          synth->getGuiMaster()->partui->adnoteui->ADnoteVoice->hide();
                      ;
}
void ADvoiceUI::cb_changeFMoscilbutton(Fl_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_changeFMoscilbutton_i(o,v);
}

void ADvoiceUI::cb_ModPhase_i(mwheel_slider_rev* o, void*) {
  //
                      o->selection_color(setSlider(o->value(),0));
                      send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::modulatorOscillatorPhase, o->value(), TOPLEVEL::type::Integer);
                      ;
}
void ADvoiceUI::cb_ModPhase(mwheel_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_ModPhase_i(o,v);
}

void ADvoiceUI::cb_modvoicelabel_i(Fl_Box*, void*) {
  //
                      update_modvoicelabel();
                      ;
}
void ADvoiceUI::cb_modvoicelabel(Fl_Box* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_modvoicelabel_i(o,v);
}

void ADvoiceUI::cb_ExtMod_i(Fl_Choice* o, void*) {
  //
                    send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::externalModulator, o->value() - 1, TOPLEVEL::type::Integer);
                    ;
}
void ADvoiceUI::cb_ExtMod(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_ExtMod_i(o,v);
}

void ADvoiceUI::cb_ModType_i(Fl_Choice* o, void*) {
  //
                  if (o->value() == 0)
                      voiceFMparametersgroup->deactivate();
                  else
                      voiceFMparametersgroup->activate();
                  o->redraw();
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::modulatorType, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_ModType(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_ModType_i(o,v);
}

void ADvoiceUI::cb_FreqEn_i(Fl_Check_Button2* o, void*) {
  //
                    if (o->value() == 0)
                        voicefreqenvgroup->deactivate();
                    else
                        voicefreqenvgroup->activate();
                    o->redraw();
                    send_data(0, ADDVOICE::control::enableFrequencyEnvelope, o->value(), TOPLEVEL::type::Integer);
                    ;
}
void ADvoiceUI::cb_FreqEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_FreqEn_i(o,v);
}

void ADvoiceUI::cb_FreqLfoEn_i(Fl_Check_Button2* o, void*) {
  //
              bool enab = _SYS_::F2B(o->value());
              if (enab)
              {
                  voicefreqlfogroup->activate();
                  synth->getGuiMaster()->partui->adnoteui->voicelistitem[nvoice]->voicelistvibratto->activate();
              }
              else
              {
                  voicefreqlfogroup->deactivate();
                  synth->getGuiMaster()->partui->adnoteui->voicelistitem[nvoice]->voicelistvibratto->deactivate();
              }
              o->redraw();

              send_data(0, ADDVOICE::control::enableFrequencyLFO, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADvoiceUI::cb_FreqLfoEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_FreqLfoEn_i(o,v);
}

void ADvoiceUI::cb_Octave_i(Fl_Counter* o, void*) {
  //
                    send_data(0, ADDVOICE::control::octave, o->value(), TOPLEVEL::type::Integer);
                    ;
}
void ADvoiceUI::cb_Octave(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Octave_i(o,v);
}

void ADvoiceUI::cb_CoarseDetune_i(Fl_Counter* o, void*) {
  //
                    send_data(0, ADDVOICE::control::coarseDetune, o->value(), TOPLEVEL::type::Integer);
                    ;
}
void ADvoiceUI::cb_CoarseDetune(Fl_Counter* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_CoarseDetune_i(o,v);
}

void ADvoiceUI::cb_FreqDetunetype_i(Fl_Choice* o, void*) {
  //
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::detuneType, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_FreqDetunetype(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_FreqDetunetype_i(o,v);
}

void ADvoiceUI::cb_Detune_i(mwheel_slider_rev* o, void*) {
  //
                  int detune = lrint(o->value());
                  o->selection_color(setSlider(o->value(),0));
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::detuneFrequency, detune, TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_Detune(mwheel_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Detune_i(o,v);
}

void ADvoiceUI::cb_detunevalueoutput_i(Fl_Value_Output* o, void*) {
  //
                  o->value(getDetune((FreqDetunetype->value()<1)?(collect_readData(synth, 0, ADDSYNTH::detuneType, npart, kititem, PART::engine::addSynth)) : (FreqDetunetype->value()),0,Detune->value()+8192)*collect_readData(synth, 0, ADDSYNTH::control::bandwidthMultiplier, npart, kititem, PART::engine::addSynth));
                  ;
}
void ADvoiceUI::cb_detunevalueoutput(Fl_Value_Output* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detunevalueoutput_i(o,v);
}

void ADvoiceUI::cb_bend_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),88));
                  send_data(0, ADDVOICE::control::pitchBendAdjustment, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_bend(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_bend_i(o,v);
}

void ADvoiceUI::cb_Freq440_i(Fl_Check_Button2* o, void*) {
  //
                    int x = lrint(o->value());
                    if (x == 0 && Mod440->value() == 0)
                        fixedfreqetdial->deactivate();
                    else
                        fixedfreqetdial->activate();
                    send_data(0, ADDVOICE::control::baseFrequencyAs440Hz, o->value(), TOPLEVEL::type::Integer);
                    ;
}
void ADvoiceUI::cb_Freq440(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Freq440_i(o,v);
}

void ADvoiceUI::cb_fixedfreqetdial_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),0));
                  send_data(0, ADDVOICE::control::equalTemperVariation, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_fixedfreqetdial(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_fixedfreqetdial_i(o,v);
}

void ADvoiceUI::cb_offset_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),64));
                  send_data(0, ADDVOICE::control::pitchBendOffset, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_offset(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_offset_i(o,v);
}

void ADvoiceUI::cb_UseOsc_i(Fl_Choice* o, void*) {
  //
                      send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::voiceOscillatorSource, o->value() - 1, TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_UseOsc(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_UseOsc_i(o,v);
}

void ADvoiceUI::cb_changevoiceoscilbutton_i(Fl_Button*, void*) {
  //
                      if (oscedit)
                          delete oscedit;
                      lastWaveW = 0;
                      int nv = nvoice;
                      if (UseOsc->value() > 0)
                          nv = UseOsc->value() - 1;
                      oscedit = new OscilEditor(pars->VoicePar[nv].POscil, oscDisplay, NULL, NULL, synth, npart, kititem, nvoice + PART::engine::addVoice1);
                      if ((Fl::event_button() == 3))
                          synth->getGuiMaster()->partui->adnoteui->ADnoteVoice->hide();
                      ;
}
void ADvoiceUI::cb_changevoiceoscilbutton(Fl_Button* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_changevoiceoscilbutton_i(o,v);
}

void ADvoiceUI::cb_VoiceOscPhase_i(mwheel_slider_rev* o, void*) {
  //
                  o->selection_color(setSlider(o->value(),0));
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::voiceOscillatorPhase, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_VoiceOscPhase(mwheel_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_VoiceOscPhase_i(o,v);
}

void ADvoiceUI::cb_osclabel_i(Fl_Box*, void*) {
  //
          update_osclabels();
          ;
}
void ADvoiceUI::cb_osclabel(Fl_Box* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_osclabel_i(o,v);
}

void ADvoiceUI::cb_ResonanceEn_i(Fl_Check_Button2* o, void*) {
  //
                  bool enab = _SYS_::F2B(o->value());

                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::enableResonance, enab, TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_ResonanceEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_ResonanceEn_i(o,v);
}

void ADvoiceUI::cb_unisonsize_i(WidgetSpinner* o, void*) {
  //
                  send_data(0, ADDVOICE::control::unisonSize, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_unisonsize(WidgetSpinner* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_unisonsize_i(o,v);
}

void ADvoiceUI::cb_UnisonStereo_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),64));
                  send_data(0, ADDVOICE::control::unisonStereoSpread, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_UnisonStereo(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_UnisonStereo_i(o,v);
}

void ADvoiceUI::cb_UnisonVib_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),64));
                  send_data(0, ADDVOICE::control::unisonVibratoDepth, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_UnisonVib(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_UnisonVib_i(o,v);
}

void ADvoiceUI::cb_UnisonInvert_i(Fl_Choice* o, void*) {
  //
                  send_data(0, ADDVOICE::control::unisonPhaseInvert, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_UnisonInvert(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_UnisonInvert_i(o,v);
}

void ADvoiceUI::cb_UnisonFreqSpread_i(mwheel_slider_rev* o, void*) {
  //
                    o->selection_color(setSlider(o->value(),60));
                    unisonspreadoutput->do_callback();
                    send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::unisonFrequencySpread, o->value(), TOPLEVEL::type::Integer);
                    ;
}
void ADvoiceUI::cb_UnisonFreqSpread(mwheel_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_UnisonFreqSpread_i(o,v);
}

void ADvoiceUI::cb_unisonspreadoutput_i(Fl_Value_Output* o, void*) {
  //
                  o->value(collect_readData(synth, 0, ADDVOICE::control::unisonSpreadCents, npart, kititem, PART::engine::addVoice1 + nvoice));
                  ;
}
void ADvoiceUI::cb_unisonspreadoutput(Fl_Value_Output* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_unisonspreadoutput_i(o,v);
}

void ADvoiceUI::cb_UnisonVspeed_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),64));
                  send_data(0, ADDVOICE::control::unisonVibratoSpeed, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_UnisonVspeed(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_UnisonVspeed_i(o,v);
}

void ADvoiceUI::cb_UnisonPhRnd_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),127));
                  send_data(0, ADDVOICE::control::unisonPhaseRandomise, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_UnisonPhRnd(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_UnisonPhRnd_i(o,v);
}

void ADvoiceUI::cb_UnisonEn_i(Fl_Check_Button2* o, void*) {
  //
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::enableUnison, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_UnisonEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_UnisonEn_i(o,v);
}

void ADvoiceUI::cb_voicevolume_i(WidgetPDial* o, void*) {
  //
                  int vol = lrint(o->value());
                  o->selection_color(setKnob(vol,100));

                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::volume, vol, TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_voicevolume(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_voicevolume_i(o,v);
}

void ADvoiceUI::cb_voicevsns_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),127));

                  send_data(0, ADDVOICE::control::velocitySense, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_voicevsns(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_voicevsns_i(o,v);
}

void ADvoiceUI::cb_voicepan_i(WidgetPDial* o, void*) {
  //
                  int pan = lrint(o->value());
                  o->selection_color(setKnob(pan,64));

                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::panning, pan, TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_voicepan(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_voicepan_i(o,v);
}

void ADvoiceUI::cb_voicewidth_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),63));

                  send_data(0, ADDVOICE::control::randomWidth, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_voicewidth(WidgetPDial* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_voicewidth_i(o,v);
}

void ADvoiceUI::cb_voicerandompan_i(Fl_Check_Button2* o, void*) {
  //
                  int tmp = o->value();
                  if (tmp == 0)
                      voicewidth->deactivate();
                  else
                      voicewidth->activate();

                  send_data(0, ADDVOICE::control::enableRandomPan, tmp, TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_voicerandompan(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_voicerandompan_i(o,v);
}

void ADvoiceUI::cb_AmpEnvEn_i(Fl_Check_Button2* o, void*) {
  //
                  if (o->value() == 0)
                      voiceampenvgroup->deactivate();
                  else
                      voiceampenvgroup->activate();
                  o->redraw();

                  send_data(0, ADDVOICE::control::enableAmplitudeEnvelope, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_AmpEnvEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_AmpEnvEn_i(o,v);
}

void ADvoiceUI::cb_AmpLfoEn_i(Fl_Check_Button2* o, void*) {
  //
                  if (o->value() == 0)
                      voiceamplfogroup->deactivate();
                  else
                      voiceamplfogroup->activate();
                  o->redraw();

                  send_data(0, ADDVOICE::control::enableAmplitudeLFO, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_AmpLfoEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_AmpLfoEn_i(o,v);
}

void ADvoiceUI::cb_VolumeMinus_i(Fl_Check_Button2* o, void*) {
  //

          send_data(0, ADDVOICE::control::invertPhase, o->value(), TOPLEVEL::type::Integer);
          ;
}
void ADvoiceUI::cb_VolumeMinus(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_VolumeMinus_i(o,v);
}

void ADvoiceUI::cb_FilterEnvEn_i(Fl_Check_Button2* o, void*) {
  //
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::enableFilterEnvelope, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_FilterEnvEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_FilterEnvEn_i(o,v);
}

void ADvoiceUI::cb_FilterLfoEn_i(Fl_Check_Button2* o, void*) {
  //
                  send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::enableFilterLFO, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_FilterLfoEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_FilterLfoEn_i(o,v);
}

void ADvoiceUI::cb_Delay_i(mwheel_slider_rev* o, void*) {
  //
                  o->selection_color(setSlider(o->value(),0));

                  send_data(0, ADDVOICE::control::delay, o->value(), TOPLEVEL::type::Integer);
                  ;
}
void ADvoiceUI::cb_Delay(mwheel_slider_rev* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_Delay_i(o,v);
}

void ADvoiceUI::cb_bypassfiltercheckbutton_i(Fl_Check_Button2* o, void*) {
  //

          send_data(0, ADDVOICE::control::bypassGlobalFilter, o->value(), TOPLEVEL::type::Integer);
          ;
}
void ADvoiceUI::cb_bypassfiltercheckbutton(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->user_data()))->cb_bypassfiltercheckbutton_i(o,v);
}

void ADvoiceUI::cb_FilterEn_i(Fl_Check_Button2* o, void*) {
  //
                bypassfiltercheckbutton->redraw();

                send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::enableFilter, o->value(), TOPLEVEL::type::Integer);
                ;
}
void ADvoiceUI::cb_FilterEn(Fl_Check_Button2* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->user_data()))->cb_FilterEn_i(o,v);
}

void ADvoiceUI::cb_ExtOsc_i(Fl_Choice* o, void*) {
  //
                    if (nvoice == 0)
                        o->deactivate();
                    if (o->value() != 0)
                    {
                        oscGroup->deactivate();
                        SoundType->deactivate();
                    }
                    else
                    {
                        oscGroup->activate();
                        SoundType->activate();
                    }
                    send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::soundType, 0, TOPLEVEL::type::Integer);
                    send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::externalOscillator, o->value() - 1, TOPLEVEL::type::Integer);
                    ;
}
void ADvoiceUI::cb_ExtOsc(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_ExtOsc_i(o,v);
}

void ADvoiceUI::cb_SoundType_i(Fl_Choice* o, void*) {
  //
                int x = int(o->value());
                send_data(TOPLEVEL::action::forceUpdate, ADDVOICE::control::soundType, x, TOPLEVEL::type::Integer);
                ;
}
void ADvoiceUI::cb_SoundType(Fl_Choice* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->parent()->user_data()))->cb_SoundType_i(o,v);
}

void ADvoiceUI::cb_noiselabel_i(Fl_Box*, void*) {
  //
                  update_osclabels();
                  ;
}
void ADvoiceUI::cb_noiselabel(Fl_Box* o, void* v) {
  ((ADvoiceUI*)(o->parent()->parent()->user_data()))->cb_noiselabel_i(o,v);
}

Fl_Group* ADvoiceUI::make_window() {
  { ADnoteVoiceParameters = new Fl_Group(0, 0, 805, 615, "Voice");
    ADnoteVoiceParameters->box(FL_NO_BOX);
    ADnoteVoiceParameters->color(FL_BACKGROUND_COLOR);
    ADnoteVoiceParameters->selection_color(FL_BACKGROUND_COLOR);
    ADnoteVoiceParameters->labeltype(FL_NO_LABEL);
    ADnoteVoiceParameters->labelfont(0);
    ADnoteVoiceParameters->labelsize(14);
    ADnoteVoiceParameters->labelcolor(FL_FOREGROUND_COLOR);
    ADnoteVoiceParameters->user_data((void*)(this));
    ADnoteVoiceParameters->align(Fl_Align(FL_ALIGN_TOP));
    ADnoteVoiceParameters->when(FL_WHEN_RELEASE);
    { Fl_Box* o = new Fl_Box(10, 69, 275, 66);
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_CYAN);
      o->labelcolor((Fl_Color)64);
    } // Fl_Box* o
    { Fl_Check_Button2* o = voiceonbutton = new Fl_Check_Button2(12, 41, 50, 20, "On");
      voiceonbutton->box(FL_NO_BOX);
      voiceonbutton->down_box(FL_DOWN_BOX);
      voiceonbutton->color(FL_BACKGROUND2_COLOR);
      voiceonbutton->selection_color((Fl_Color)64);
      voiceonbutton->labeltype(FL_NORMAL_LABEL);
      voiceonbutton->labelfont(3);
      voiceonbutton->labelsize(14);
      voiceonbutton->labelcolor((Fl_Color)226);
      voiceonbutton->callback((Fl_Callback*)cb_voiceonbutton);
      voiceonbutton->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      voiceonbutton->when(FL_WHEN_RELEASE);
      o->value(collect_readData(synth,0,ADDVOICE::control::enableVoice, npart, kititem, PART::engine::addVoice1 + nvoice));
    } // Fl_Check_Button2* voiceonbutton
    { Fl_Group* o = voiceparametersgroup = new Fl_Group(0, 0, 805, 615);
      voiceparametersgroup->box(FL_THIN_UP_FRAME);
      voiceparametersgroup->color((Fl_Color)48);
      { voicemodegroup = new Fl_Group(0, 0, 805, 615);
        { voiceFMparametersgroup = new Fl_Group(575, 5, 230, 565, "MODULATOR");
          voiceFMparametersgroup->box(FL_THIN_UP_FRAME);
          voiceFMparametersgroup->color((Fl_Color)48);
          voiceFMparametersgroup->labelfont(1);
          voiceFMparametersgroup->labelsize(12);
          voiceFMparametersgroup->labelcolor((Fl_Color)64);
          voiceFMparametersgroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { modfrequency = new Fl_Group(580, 204, 220, 161, "Mod FREQUENCY");
            modfrequency->box(FL_THIN_UP_FRAME);
            modfrequency->labelfont(1);
            modfrequency->labelsize(11);
            modfrequency->labelcolor((Fl_Color)64);
            modfrequency->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
            { EnvelopeUI* o = voiceFMfreqenvgroup = new EnvelopeUI(585, 290, 210, 70, "Yoshimi : AddSynth Modulator - Frequency Envelope");
              voiceFMfreqenvgroup->box(FL_FLAT_BOX);
              voiceFMfreqenvgroup->color((Fl_Color)51);
              voiceFMfreqenvgroup->selection_color(FL_BACKGROUND_COLOR);
              voiceFMfreqenvgroup->labeltype(FL_NORMAL_LABEL);
              voiceFMfreqenvgroup->labelfont(0);
              voiceFMfreqenvgroup->labelsize(14);
              voiceFMfreqenvgroup->labelcolor(FL_FOREGROUND_COLOR);
              voiceFMfreqenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
              voiceFMfreqenvgroup->when(FL_WHEN_RELEASE);
              o->init(pars->VoicePar[nvoice].FMFreqEnvelope, npart, kititem, nvoice + PART::engine::addMod1, 1);
              if(collect_readData(synth,0,ADDVOICE::control::enableModulatorFrequencyEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice) == 0) o->deactivate();
              voiceFMfreqenvgroup->end();
            } // EnvelopeUI* voiceFMfreqenvgroup
            { Fl_Check_Button2* o = ModFreqEn = new Fl_Check_Button2(590, 295, 38, 14, "On");
              ModFreqEn->tooltip("Enable Frequency Envelope");
              ModFreqEn->box(FL_NO_BOX);
              ModFreqEn->down_box(FL_DOWN_BOX);
              ModFreqEn->color(FL_BACKGROUND2_COLOR);
              ModFreqEn->selection_color((Fl_Color)64);
              ModFreqEn->labeltype(FL_NORMAL_LABEL);
              ModFreqEn->labelfont(3);
              ModFreqEn->labelsize(10);
              ModFreqEn->labelcolor((Fl_Color)226);
              ModFreqEn->callback((Fl_Callback*)cb_ModFreqEn);
              ModFreqEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
              ModFreqEn->when(FL_WHEN_RELEASE);
              o->value(collect_readData(synth,0,ADDVOICE::control::enableModulatorFrequencyEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice));
            } // Fl_Check_Button2* ModFreqEn
            { Fl_Counter* o = ModCoarseDetune = new Fl_Counter(723, 270, 73, 13, "Coarse Det.");
              ModCoarseDetune->tooltip("Coarse Detune");
              ModCoarseDetune->selection_color((Fl_Color)64);
              ModCoarseDetune->labelsize(10);
              ModCoarseDetune->labelcolor((Fl_Color)64);
              ModCoarseDetune->minimum(-64);
              ModCoarseDetune->maximum(63);
              ModCoarseDetune->step(1);
              ModCoarseDetune->textfont(1);
              ModCoarseDetune->textsize(11);
              ModCoarseDetune->textcolor((Fl_Color)64);
              ModCoarseDetune->callback((Fl_Callback*)cb_ModCoarseDetune);
              ModCoarseDetune->align(Fl_Align(FL_ALIGN_TOP));
              int k = int(collect_readData(synth,0,ADDVOICE::control::modulatorCoarseDetune, npart, kititem, PART::engine::addVoice1 + nvoice)) % 1024;
              if (k >= 512) k-= 1024;
              o->value(k);
              o->lstep(10);
            } // Fl_Counter* ModCoarseDetune
            { modoctavetext = new Fl_Text_Display(669, 270, 50, 11, "Octave");
              modoctavetext->box(FL_NO_BOX);
              modoctavetext->labelfont(3);
              modoctavetext->labelsize(10);
              modoctavetext->labelcolor((Fl_Color)226);
            } // Fl_Text_Display* modoctavetext
            { Fl_Counter* o = ModOctave = new Fl_Counter(665, 270, 54, 13);
              ModOctave->tooltip("Octave");
              ModOctave->type(1);
              ModOctave->selection_color(FL_BACKGROUND_COLOR);
              ModOctave->labelfont(3);
              ModOctave->labelsize(10);
              ModOctave->minimum(-8);
              ModOctave->maximum(7);
              ModOctave->step(1);
              ModOctave->textfont(1);
              ModOctave->textsize(11);
              ModOctave->textcolor((Fl_Color)64);
              ModOctave->callback((Fl_Callback*)cb_ModOctave);
              ModOctave->align(Fl_Align(FL_ALIGN_TOP));
              int k = int(collect_readData(synth,0,ADDVOICE::control::modulatorOctave, npart, kititem, PART::engine::addVoice1 + nvoice));
              if (k >= 8) k -= 16;
              o->value(k);
            } // Fl_Counter* ModOctave
            { mwheel_slider_rev* o = ModDetune = new mwheel_slider_rev(623, 239, 168, 13);
              ModDetune->tooltip("Fine Detune (cents)");
              ModDetune->type(5);
              ModDetune->box(FL_THIN_DOWN_BOX);
              ModDetune->color(FL_BACKGROUND_COLOR);
              ModDetune->selection_color(FL_BACKGROUND_COLOR);
              ModDetune->labeltype(FL_NORMAL_LABEL);
              ModDetune->labelfont(0);
              ModDetune->labelsize(14);
              ModDetune->labelcolor((Fl_Color)64);
              ModDetune->minimum(-8192);
              ModDetune->maximum(8191);
              ModDetune->step(1);
              ModDetune->callback((Fl_Callback*)cb_ModDetune);
              ModDetune->align(Fl_Align(FL_ALIGN_BOTTOM));
              ModDetune->when(FL_WHEN_CHANGED);
              o->value(collect_readData(synth,0,ADDVOICE::control::modulatorDetuneFrequency, npart, kititem, PART::engine::addVoice1 + nvoice));
              o->selection_color(setSlider(o->value(),0));
            } // mwheel_slider_rev* ModDetune
            { Fl_Choice* o = ModDetuneType = new Fl_Choice(585, 270, 75, 13, "Detune Type");
              ModDetuneType->down_box(FL_BORDER_BOX);
              ModDetuneType->selection_color(FL_BACKGROUND_COLOR);
              ModDetuneType->labelsize(10);
              ModDetuneType->labelcolor((Fl_Color)64);
              ModDetuneType->textfont(1);
              ModDetuneType->textsize(10);
              ModDetuneType->textcolor((Fl_Color)64);
              ModDetuneType->callback((Fl_Callback*)cb_ModDetuneType);
              ModDetuneType->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->add("Default");o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
              o->value(collect_readData(synth,0,ADDVOICE::control::modulatorDetuneType, npart, kititem, PART::engine::addVoice1 + nvoice));
            } // Fl_Choice* ModDetuneType
            { Fl_Value_Output* o = fmdetunevalueoutput = new Fl_Value_Output(587, 239, 36, 13, "Detune");
              fmdetunevalueoutput->box(FL_THIN_DOWN_BOX);
              fmdetunevalueoutput->labelsize(10);
              fmdetunevalueoutput->labelcolor((Fl_Color)64);
              fmdetunevalueoutput->minimum(-5000);
              fmdetunevalueoutput->maximum(5000);
              fmdetunevalueoutput->textfont(1);
              fmdetunevalueoutput->textsize(10);
              fmdetunevalueoutput->textcolor((Fl_Color)64);
              fmdetunevalueoutput->callback((Fl_Callback*)cb_fmdetunevalueoutput);
              fmdetunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
              o->step(0.01, 1);
              o->value(getDetune((ModDetuneType->value() < 1) ? (collect_readData(synth, 0, ADDSYNTH::detuneType, npart, kititem, PART::engine::addSynth)) : (ModDetuneType->value()), 0, ModDetune->value()+8192));
            } // Fl_Value_Output* fmdetunevalueoutput
            { Fl_Check_Button2* o = Mod440 = new Fl_Check_Button2(726, 220, 55, 15, "440Hz");
              Mod440->tooltip("Set the modulator base frequency to 440Hz");
              Mod440->box(FL_NO_BOX);
              Mod440->down_box(FL_DOWN_BOX);
              Mod440->color(FL_BACKGROUND_COLOR);
              Mod440->selection_color((Fl_Color)64);
              Mod440->labeltype(FL_NORMAL_LABEL);
              Mod440->labelfont(1);
              Mod440->labelsize(11);
              Mod440->labelcolor((Fl_Color)64);
              Mod440->callback((Fl_Callback*)cb_Mod440);
              Mod440->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
              Mod440->when(FL_WHEN_RELEASE);
              o->value(collect_readData(synth,0,ADDVOICE::control::modulatorFrequencyAs440Hz, npart, kititem, PART::engine::addVoice1 + nvoice));
            } // Fl_Check_Button2* Mod440
            { Fl_Check_Button2* o = detuneFromBaseOsc = new Fl_Check_Button2(630, 220, 95, 15, "Follow voice");
              detuneFromBaseOsc->tooltip("Apply all detuning in the voice oscillator to the modulator as well.");
              detuneFromBaseOsc->box(FL_NO_BOX);
              detuneFromBaseOsc->down_box(FL_DOWN_BOX);
              detuneFromBaseOsc->color(FL_BACKGROUND_COLOR);
              detuneFromBaseOsc->selection_color((Fl_Color)64);
              detuneFromBaseOsc->labeltype(FL_NORMAL_LABEL);
              detuneFromBaseOsc->labelfont(0);
              detuneFromBaseOsc->labelsize(11);
              detuneFromBaseOsc->labelcolor((Fl_Color)64);
              detuneFromBaseOsc->callback((Fl_Callback*)cb_detuneFromBaseOsc);
              detuneFromBaseOsc->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
              detuneFromBaseOsc->when(FL_WHEN_RELEASE);
              o->value(collect_readData(synth,0,ADDVOICE::control::modulatorDetuneFromBaseOsc, npart, kititem, PART::engine::addVoice1 + nvoice));
              if (Mod440->value() != 0) o->deactivate();
            } // Fl_Check_Button2* detuneFromBaseOsc
            modfrequency->end();
          } // Fl_Group* modfrequency
          { Modampgrp = new Fl_Group(580, 55, 220, 149, "Mod AMPLITUDE");
            Modampgrp->box(FL_THIN_UP_FRAME);
            Modampgrp->labelfont(1);
            Modampgrp->labelsize(11);
            Modampgrp->labelcolor((Fl_Color)64);
            Modampgrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
            { mwheel_val_slider_rev* o = ModVolume = new mwheel_val_slider_rev(585, 70, 160, 15, "Vol");
              ModVolume->tooltip("Volume");
              ModVolume->type(5);
              ModVolume->box(FL_THIN_DOWN_BOX);
              ModVolume->color(FL_BACKGROUND_COLOR);
              ModVolume->selection_color(FL_BACKGROUND_COLOR);
              ModVolume->labeltype(FL_NORMAL_LABEL);
              ModVolume->labelfont(0);
              ModVolume->labelsize(11);
              ModVolume->labelcolor(FL_FOREGROUND_COLOR);
              ModVolume->maximum(127);
              ModVolume->step(1);
              ModVolume->callback((Fl_Callback*)cb_ModVolume);
              ModVolume->align(Fl_Align(FL_ALIGN_RIGHT));
              ModVolume->when(FL_WHEN_CHANGED);
              o->value(collect_readData(synth,0,ADDVOICE::control::modulatorAmplitude, npart, kititem, PART::engine::addVoice1 + nvoice));
              o->selection_color(setSlider(o->value(),90));
            } // mwheel_val_slider_rev* ModVolume
            { mwheel_val_slider_rev* o = ModVsense = new mwheel_val_slider_rev(585, 90, 160, 15, "V.Sns");
              ModVsense->tooltip("Velocity Sensing Function - rightmost/max to disable)");
              ModVsense->type(5);
              ModVsense->box(FL_THIN_DOWN_BOX);
              ModVsense->color(FL_BACKGROUND_COLOR);
              ModVsense->selection_color(FL_BACKGROUND_COLOR);
              ModVsense->labeltype(FL_NORMAL_LABEL);
              ModVsense->labelfont(0);
              ModVsense->labelsize(11);
              ModVsense->labelcolor(FL_FOREGROUND_COLOR);
              ModVsense->maximum(127);
              ModVsense->step(1);
              ModVsense->callback((Fl_Callback*)cb_ModVsense);
              ModVsense->align(Fl_Align(FL_ALIGN_RIGHT));
              ModVsense->when(FL_WHEN_CHANGED);
              o->value(collect_readData(synth,0,ADDVOICE::control::modulatorVelocitySense, npart, kititem, PART::engine::addVoice1 + nvoice));
              o->selection_color(setSlider(o->value(),64));
            } // mwheel_val_slider_rev* ModVsense
            { EnvelopeUI* o = voiceFMampenvgroup = new EnvelopeUI(585, 129, 210, 70, "Yoshimi : AddSynth Modulator - Amplitude Envelope");
              voiceFMampenvgroup->box(FL_FLAT_BOX);
              voiceFMampenvgroup->color((Fl_Color)51);
              voiceFMampenvgroup->selection_color(FL_BACKGROUND_COLOR);
              voiceFMampenvgroup->labeltype(FL_NORMAL_LABEL);
              voiceFMampenvgroup->labelfont(0);
              voiceFMampenvgroup->labelsize(14);
              voiceFMampenvgroup->labelcolor(FL_FOREGROUND_COLOR);
              voiceFMampenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
              voiceFMampenvgroup->when(FL_WHEN_RELEASE);
              o->init(pars->VoicePar[nvoice].FMAmpEnvelope, npart, kititem, nvoice + PART::engine::addMod1, 0);
              if (collect_readData(synth,0,ADDVOICE::control::enableModulatorAmplitudeEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice) == 0)  o->deactivate();
              voiceFMampenvgroup->end();
            } // EnvelopeUI* voiceFMampenvgroup
            { Fl_Check_Button2* o = ModAmpEn = new Fl_Check_Button2(590, 134, 38, 14, "On");
              ModAmpEn->tooltip("Enable Amplitude Envelope");
              ModAmpEn->box(FL_NO_BOX);
              ModAmpEn->down_box(FL_DOWN_BOX);
              ModAmpEn->color(FL_BACKGROUND2_COLOR);
              ModAmpEn->selection_color((Fl_Color)64);
              ModAmpEn->labeltype(FL_NORMAL_LABEL);
              ModAmpEn->labelfont(3);
              ModAmpEn->labelsize(10);
              ModAmpEn->labelcolor((Fl_Color)226);
              ModAmpEn->callback((Fl_Callback*)cb_ModAmpEn);
              ModAmpEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
              ModAmpEn->when(FL_WHEN_RELEASE);
              o->value(collect_readData(synth,0,ADDVOICE::control::enableModulatorAmplitudeEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice));
            } // Fl_Check_Button2* ModAmpEn
            { mwheel_val_slider_rev* o = ModFdamp = new mwheel_val_slider_rev(585, 110, 160, 15, "F.Damp");
              ModFdamp->tooltip("Modulator Damp at Higher frequency");
              ModFdamp->type(5);
              ModFdamp->box(FL_THIN_DOWN_BOX);
              ModFdamp->color(FL_BACKGROUND_COLOR);
              ModFdamp->selection_color(FL_BACKGROUND_COLOR);
              ModFdamp->labeltype(FL_NORMAL_LABEL);
              ModFdamp->labelfont(0);
              ModFdamp->labelsize(11);
              ModFdamp->labelcolor(FL_FOREGROUND_COLOR);
              ModFdamp->minimum(-64);
              ModFdamp->maximum(63);
              ModFdamp->step(1);
              ModFdamp->callback((Fl_Callback*)cb_ModFdamp);
              ModFdamp->align(Fl_Align(FL_ALIGN_RIGHT));
              ModFdamp->when(FL_WHEN_CHANGED);
              o->value(collect_readData(synth,0,ADDVOICE::control::modulatorHFdamping, npart, kititem, PART::engine::addVoice1 + nvoice));
              o->selection_color(setSlider(o->value(),0));
            } // mwheel_val_slider_rev* ModFdamp
            Modampgrp->end();
          } // Fl_Group* Modampgrp
          { modOscDisplay = new Fl_Group(580, 365, 220, 200);
            modOscDisplay->labelcolor((Fl_Color)64);
            { modoscil = new Fl_Group(580, 365, 220, 200, "                       ");
              modoscil->box(FL_THIN_UP_FRAME);
              modoscil->labelfont(1);
              modoscil->labelsize(11);
              modoscil->labelcolor((Fl_Color)64);
              modoscil->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
              { ModLocalOsc = new Fl_Text_Display(598, 385, 95, 2, "Local Oscillator");
                ModLocalOsc->box(FL_NO_BOX);
                ModLocalOsc->labelfont(1);
                ModLocalOsc->labelsize(12);
                ModLocalOsc->labelcolor((Fl_Color)64);
              } // Fl_Text_Display* ModLocalOsc
              { Fl_Choice* o = ExtModOsc = new Fl_Choice(607, 402, 75, 14, "Use");
                ExtModOsc->tooltip("Use an earlier oscillator for this modulator. Only the base oscillator is use"
"d, not other voice parameters.");
                ExtModOsc->down_box(FL_BORDER_BOX);
                ExtModOsc->selection_color(FL_BACKGROUND_COLOR);
                ExtModOsc->labelsize(10);
                ExtModOsc->labelcolor((Fl_Color)64);
                ExtModOsc->textfont(1);
                ExtModOsc->textsize(10);
                ExtModOsc->textcolor((Fl_Color)64);
                ExtModOsc->callback((Fl_Callback*)cb_ExtModOsc);
                ExtModOsc->align(Fl_Align(FL_ALIGN_TOP));
                o->add("Internal");
                char tmp[50]; for (int i = 0; i < nvoice; ++i) {sprintf(tmp, "Mod.%2d", i + 1); o->add(tmp);};
                o->value(collect_readData(synth,0,ADDVOICE::control::modulatorOscillatorSource, npart, kititem, PART::engine::addVoice1 + nvoice) + 1);
              } // Fl_Choice* ExtModOsc
              { Fl_Button* o = changeFMoscilbutton = new Fl_Button(712, 370, 72, 18, "Waveform");
                changeFMoscilbutton->box(FL_GTK_THIN_UP_BOX);
                changeFMoscilbutton->color((Fl_Color)198);
                changeFMoscilbutton->labelfont(1);
                changeFMoscilbutton->labelsize(10);
                changeFMoscilbutton->labelcolor((Fl_Color)64);
                changeFMoscilbutton->callback((Fl_Callback*)cb_changeFMoscilbutton);
                if (ExtModOsc->value() > 0) o->labelcolor(alt_warn_tex);
              } // Fl_Button* changeFMoscilbutton
              { mwheel_slider_rev* o = ModPhase = new mwheel_slider_rev(708, 402, 80, 14, "Phase");
                ModPhase->tooltip("Phase offset");
                ModPhase->type(5);
                ModPhase->box(FL_THIN_DOWN_BOX);
                ModPhase->color(FL_BACKGROUND_COLOR);
                ModPhase->selection_color(FL_BACKGROUND_COLOR);
                ModPhase->labeltype(FL_NORMAL_LABEL);
                ModPhase->labelfont(0);
                ModPhase->labelsize(10);
                ModPhase->labelcolor((Fl_Color)64);
                ModPhase->minimum(-64);
                ModPhase->maximum(63);
                ModPhase->step(1);
                ModPhase->callback((Fl_Callback*)cb_ModPhase);
                ModPhase->align(Fl_Align(FL_ALIGN_TOP));
                ModPhase->when(FL_WHEN_CHANGED);
                o->value(collect_readData(synth,0,ADDVOICE::control::modulatorOscillatorPhase, npart, kititem, PART::engine::addVoice1 + nvoice));
                o->setValueType(VC_PhaseOffset); o->useCustomTip(true);
                o->selection_color(setSlider(o->value(),0));
              } // mwheel_slider_rev* ModPhase
              { Fl_Group* o = fmoscil = new Fl_Group(580, 425, 220, 140);
                fmoscil->box(FL_THIN_DOWN_BOX);
                fmoscil->color((Fl_Color)57);
                fmoscil->labelcolor((Fl_Color)179);
                oscFM = new Oscilloscope(o->x(),o->y(),o->w(),o->h(), 125,"");
                update_fmoscil();
                fmoscil->end();
              } // Fl_Group* fmoscil
              modoscil->end();
            } // Fl_Group* modoscil
            { modvoicelabel = new Fl_Box(600, 470, 190, 65, "Voice");
              modvoicelabel->labelfont(1);
              modvoicelabel->labelsize(40);
              modvoicelabel->labelcolor(FL_BACKGROUND2_COLOR);
              modvoicelabel->callback((Fl_Callback*)cb_modvoicelabel);
              update_modvoicelabel();
            } // Fl_Box* modvoicelabel
            modOscDisplay->end();
          } // Fl_Group* modOscDisplay
          { Fl_Choice* o = ExtMod = new Fl_Choice(692, 32, 104, 17, "Source");
            ExtMod->tooltip("Use an earlier voice as modulator. All parameters from the imported voice rem"
"ain in effect, except for volume, panning, base frequency and pitch bend scali"
"ng factor. The voice is also converted to mono. Parameters in the current voic"
"e will then tweak the modulator further.");
            ExtMod->down_box(FL_BORDER_BOX);
            ExtMod->selection_color(FL_BACKGROUND_COLOR);
            ExtMod->labelsize(11);
            ExtMod->labelcolor((Fl_Color)64);
            ExtMod->textfont(1);
            ExtMod->textcolor((Fl_Color)64);
            ExtMod->callback((Fl_Callback*)cb_ExtMod);
            ExtMod->align(Fl_Align(FL_ALIGN_TOP_RIGHT));
            o->add("Local");
            char tmp[50]; for (int i = 0; i < nvoice; ++i) {sprintf(tmp, "Voice %2d", i + 1); o->add(tmp);};
            o->value(collect_readData(synth,0,ADDVOICE::control::externalModulator, npart, kititem, PART::engine::addVoice1 + nvoice) + 1);
            if (lrint(o->value())) {modoscil->deactivate();}
          } // Fl_Choice* ExtMod
          voiceFMparametersgroup->end();
        } // Fl_Group* voiceFMparametersgroup
        { modtypetext = new Fl_Text_Display(572, 32, 50, 8, "Type:");
          modtypetext->box(FL_NO_BOX);
          modtypetext->selection_color(FL_BACKGROUND_COLOR);
          modtypetext->labelfont(3);
          modtypetext->labelsize(11);
          modtypetext->labelcolor((Fl_Color)226);
        } // Fl_Text_Display* modtypetext
        { Fl_Choice* o = ModType = new Fl_Choice(580, 32, 90, 17);
          ModType->box(FL_NO_BOX);
          ModType->down_box(FL_BORDER_BOX);
          ModType->selection_color(FL_BACKGROUND_COLOR);
          ModType->labelfont(3);
          ModType->labelsize(11);
          ModType->textfont(1);
          ModType->textsize(11);
          ModType->textcolor((Fl_Color)64);
          ModType->callback((Fl_Callback*)cb_ModType);
          ModType->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("Off");o->add("Morph");o->add("Ring");o->add("PM");o->add("FM");o->add("PWM");
          o->value(collect_readData(synth,0,ADDVOICE::control::modulatorType, npart, kititem, PART::engine::addVoice1 + nvoice));
          if (o->value() == 0) voiceFMparametersgroup->deactivate();
        } // Fl_Choice* ModType
        { freqencygrp = new Fl_Group(5, 280, 570, 120, "FREQUENCY");
          freqencygrp->box(FL_THIN_UP_FRAME);
          freqencygrp->labelfont(1);
          freqencygrp->labelsize(12);
          freqencygrp->labelcolor((Fl_Color)64);
          freqencygrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { EnvelopeUI* o = voicefreqenvgroup = new EnvelopeUI(9, 325, 205, 70, "Yoshimi : AddSynth Voice - Frequency Envelope");
            voicefreqenvgroup->box(FL_FLAT_BOX);
            voicefreqenvgroup->color((Fl_Color)51);
            voicefreqenvgroup->selection_color(FL_BACKGROUND_COLOR);
            voicefreqenvgroup->labeltype(FL_NORMAL_LABEL);
            voicefreqenvgroup->labelfont(0);
            voicefreqenvgroup->labelsize(14);
            voicefreqenvgroup->labelcolor(FL_FOREGROUND_COLOR);
            voicefreqenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            voicefreqenvgroup->when(FL_WHEN_RELEASE);
            o->init(pars->VoicePar[nvoice].FreqEnvelope, npart, kititem, nvoice + PART::engine::addVoice1, 1);
            if (collect_readData(synth,0,ADDVOICE::control::enableFrequencyEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice)==0) o->deactivate();
            voicefreqenvgroup->end();
          } // EnvelopeUI* voicefreqenvgroup
          { Fl_Check_Button2* o = FreqEn = new Fl_Check_Button2(14, 330, 38, 14, "On");
            FreqEn->tooltip("Enable Frequency Envelope");
            FreqEn->box(FL_NO_BOX);
            FreqEn->down_box(FL_DOWN_BOX);
            FreqEn->color(FL_BACKGROUND_COLOR);
            FreqEn->selection_color((Fl_Color)64);
            FreqEn->labeltype(FL_NORMAL_LABEL);
            FreqEn->labelfont(3);
            FreqEn->labelsize(10);
            FreqEn->labelcolor((Fl_Color)226);
            FreqEn->callback((Fl_Callback*)cb_FreqEn);
            FreqEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
            FreqEn->when(FL_WHEN_RELEASE);
            o->value(collect_readData(synth,0,ADDVOICE::control::enableFrequencyEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice));
          } // Fl_Check_Button2* FreqEn
          { LFOUI* o = voicefreqlfogroup = new LFOUI(215, 325, 275, 70, "Frequency LFO     ");
            voicefreqlfogroup->box(FL_FLAT_BOX);
            voicefreqlfogroup->color(FL_DARK1);
            voicefreqlfogroup->selection_color(FL_BACKGROUND_COLOR);
            voicefreqlfogroup->labeltype(FL_NORMAL_LABEL);
            voicefreqlfogroup->labelfont(0);
            voicefreqlfogroup->labelsize(14);
            voicefreqlfogroup->labelcolor(FL_FOREGROUND_COLOR);
            voicefreqlfogroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            voicefreqlfogroup->when(FL_WHEN_RELEASE);
            o->init(synth, npart, kititem, PART::engine::addVoice1 + nvoice, TOPLEVEL::insertType::frequency);
            if (collect_readData(synth,0,ADDVOICE::control::enableFrequencyLFO, npart, kititem, PART::engine::addVoice1 + nvoice)==0) o->deactivate();
            voicefreqlfogroup->end();
          } // LFOUI* voicefreqlfogroup
          { Fl_Check_Button2* o = FreqLfoEn = new Fl_Check_Button2(220, 330, 38, 14, "On");
            FreqLfoEn->tooltip("Enable Frequency LFO");
            FreqLfoEn->box(FL_NO_BOX);
            FreqLfoEn->down_box(FL_DOWN_BOX);
            FreqLfoEn->color(FL_BACKGROUND_COLOR);
            FreqLfoEn->selection_color((Fl_Color)64);
            FreqLfoEn->labeltype(FL_NORMAL_LABEL);
            FreqLfoEn->labelfont(3);
            FreqLfoEn->labelsize(10);
            FreqLfoEn->labelcolor((Fl_Color)226);
            FreqLfoEn->callback((Fl_Callback*)cb_FreqLfoEn);
            FreqLfoEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
            FreqLfoEn->when(FL_WHEN_RELEASE);
            o->value(collect_readData(synth,0,ADDVOICE::control::enableFrequencyLFO, npart, kititem, PART::engine::addVoice1 + nvoice));
          } // Fl_Check_Button2* FreqLfoEn
          { voiceoctavetext = new Fl_Text_Display(507, 306, 50, 11, "Octave");
            voiceoctavetext->box(FL_NO_BOX);
            voiceoctavetext->labelfont(3);
            voiceoctavetext->labelsize(10);
            voiceoctavetext->labelcolor((Fl_Color)226);
          } // Fl_Text_Display* voiceoctavetext
          { Fl_Counter* o = Octave = new Fl_Counter(504, 306, 58, 13);
            Octave->tooltip("Octave");
            Octave->type(1);
            Octave->selection_color(FL_BACKGROUND_COLOR);
            Octave->labelfont(3);
            Octave->labelsize(10);
            Octave->minimum(-8);
            Octave->maximum(7);
            Octave->step(1);
            Octave->value(4);
            Octave->textfont(1);
            Octave->textsize(11);
            Octave->textcolor((Fl_Color)64);
            Octave->callback((Fl_Callback*)cb_Octave);
            Octave->align(Fl_Align(FL_ALIGN_TOP));
            int k = int(collect_readData(synth,0,ADDVOICE::control::octave, npart, kititem, PART::engine::addVoice1 + nvoice));
            if (k >= 8) k -= 16;
            o->value(k);
          } // Fl_Counter* Octave
          { Fl_Counter* o = CoarseDetune = new Fl_Counter(493, 375, 78, 13, "Coarse Det.");
            CoarseDetune->tooltip("Coarse Detune");
            CoarseDetune->selection_color((Fl_Color)64);
            CoarseDetune->labelsize(10);
            CoarseDetune->labelcolor((Fl_Color)64);
            CoarseDetune->minimum(-64);
            CoarseDetune->maximum(63);
            CoarseDetune->step(1);
            CoarseDetune->textfont(1);
            CoarseDetune->textsize(11);
            CoarseDetune->textcolor((Fl_Color)64);
            CoarseDetune->callback((Fl_Callback*)cb_CoarseDetune);
            CoarseDetune->align(Fl_Align(FL_ALIGN_TOP));
            int k = collect_readData(synth,0,ADDVOICE::control::coarseDetune, npart, kititem, PART::engine::addVoice1 + nvoice);
            o->value(k);
            o->lstep(10);
          } // Fl_Counter* CoarseDetune
          { Fl_Choice* o = FreqDetunetype = new Fl_Choice(495, 340, 75, 13, "Detune Type");
            FreqDetunetype->down_box(FL_BORDER_BOX);
            FreqDetunetype->selection_color((Fl_Color)64);
            FreqDetunetype->labelsize(10);
            FreqDetunetype->labelcolor((Fl_Color)64);
            FreqDetunetype->textfont(1);
            FreqDetunetype->textsize(10);
            FreqDetunetype->textcolor((Fl_Color)64);
            FreqDetunetype->callback((Fl_Callback*)cb_FreqDetunetype);
            FreqDetunetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("Default");o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
            o->value(collect_readData(synth, 0, ADDVOICE::control::detuneType, npart, kititem, PART::engine::addVoice1 + nvoice));
          } // Fl_Choice* FreqDetunetype
          { mwheel_slider_rev* o = Detune = new mwheel_slider_rev(62, 306, 428, 14);
            Detune->tooltip("Fine Detune (cents)");
            Detune->type(5);
            Detune->box(FL_THIN_DOWN_BOX);
            Detune->color(FL_BACKGROUND_COLOR);
            Detune->selection_color(FL_BACKGROUND_COLOR);
            Detune->labeltype(FL_NORMAL_LABEL);
            Detune->labelfont(0);
            Detune->labelsize(14);
            Detune->labelcolor(FL_FOREGROUND_COLOR);
            Detune->minimum(-8192);
            Detune->maximum(8191);
            Detune->step(1);
            Detune->callback((Fl_Callback*)cb_Detune);
            Detune->align(Fl_Align(FL_ALIGN_BOTTOM));
            Detune->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::detuneFrequency, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->selection_color(setSlider(o->value(),0));
          } // mwheel_slider_rev* Detune
          { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(9, 306, 53, 14, "Detune");
            detunevalueoutput->box(FL_THIN_DOWN_BOX);
            detunevalueoutput->labelsize(10);
            detunevalueoutput->labelcolor((Fl_Color)64);
            detunevalueoutput->minimum(-5000);
            detunevalueoutput->maximum(5000);
            detunevalueoutput->step(0.01);
            detunevalueoutput->textfont(1);
            detunevalueoutput->textsize(10);
            detunevalueoutput->textcolor((Fl_Color)64);
            detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput);
            detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->step(0.01, 1);
            o->value(getDetune((FreqDetunetype->value()<1)?(collect_readData(synth, 0, ADDSYNTH::detuneType, npart, kititem, PART::engine::addSynth)) : (FreqDetunetype->value()),0,Detune->value()+8192)*collect_readData(synth, 0, ADDSYNTH::control::bandwidthMultiplier, npart, kititem, PART::engine::addSynth));
          } // Fl_Value_Output* detunevalueoutput
          { WidgetPDial* o = bend = new WidgetPDial(70, 284, 20, 20, "Bend");
            bend->tooltip("Pitch bend scaling for this voice");
            bend->box(FL_ROUND_UP_BOX);
            bend->color(FL_BACKGROUND_COLOR);
            bend->selection_color(FL_INACTIVE_COLOR);
            bend->labeltype(FL_NORMAL_LABEL);
            bend->labelfont(0);
            bend->labelsize(10);
            bend->labelcolor((Fl_Color)64);
            bend->maximum(127);
            bend->step(1);
            bend->callback((Fl_Callback*)cb_bend);
            bend->align(Fl_Align(FL_ALIGN_RIGHT));
            bend->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::pitchBendAdjustment, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->setValueType(VC_PitchBend);
            o->selection_color(setKnob(o->value(),88));
          } // WidgetPDial* bend
          { Fl_Check_Button2* o = Freq440 = new Fl_Check_Button2(400, 286, 55, 15, "440Hz");
            Freq440->tooltip("Set the voice base frequency to 440Hz");
            Freq440->box(FL_NO_BOX);
            Freq440->down_box(FL_DOWN_BOX);
            Freq440->color(FL_BACKGROUND_COLOR);
            Freq440->selection_color((Fl_Color)64);
            Freq440->labeltype(FL_NORMAL_LABEL);
            Freq440->labelfont(1);
            Freq440->labelsize(11);
            Freq440->labelcolor((Fl_Color)64);
            Freq440->callback((Fl_Callback*)cb_Freq440);
            Freq440->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
            Freq440->when(FL_WHEN_RELEASE);
            o->value(collect_readData(synth,0,ADDVOICE::control::baseFrequencyAs440Hz, npart, kititem, PART::engine::addVoice1 + nvoice));
          } // Fl_Check_Button2* Freq440
          { WidgetPDial* o = fixedfreqetdial = new WidgetPDial(460, 284, 20, 20, "Eq.T.");
            fixedfreqetdial->tooltip("How the frequency varies according to the keyboard (leftmost for fixed freque"
"ncy)");
            fixedfreqetdial->box(FL_ROUND_UP_BOX);
            fixedfreqetdial->color(FL_BACKGROUND_COLOR);
            fixedfreqetdial->selection_color(FL_INACTIVE_COLOR);
            fixedfreqetdial->labeltype(FL_NORMAL_LABEL);
            fixedfreqetdial->labelfont(0);
            fixedfreqetdial->labelsize(10);
            fixedfreqetdial->labelcolor((Fl_Color)64);
            fixedfreqetdial->maximum(127);
            fixedfreqetdial->step(1);
            fixedfreqetdial->callback((Fl_Callback*)cb_fixedfreqetdial);
            fixedfreqetdial->align(Fl_Align(FL_ALIGN_RIGHT));
            fixedfreqetdial->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth,0,ADDVOICE::control::equalTemperVariation, npart, kititem, PART::engine::addVoice1 + nvoice));
            if (Freq440->value() ==0) o->deactivate();
            o->setValueType(VC_FixedFreqET);
            o->selection_color(setKnob(o->value(),0));
          } // WidgetPDial* fixedfreqetdial
          { WidgetPDial* o = offset = new WidgetPDial(130, 284, 20, 20, "Offset");
            offset->tooltip("Offset of the frequency in Hz.");
            offset->box(FL_ROUND_UP_BOX);
            offset->color(FL_BACKGROUND_COLOR);
            offset->selection_color(FL_INACTIVE_COLOR);
            offset->labeltype(FL_NORMAL_LABEL);
            offset->labelfont(0);
            offset->labelsize(10);
            offset->labelcolor((Fl_Color)64);
            offset->maximum(127);
            offset->step(1);
            offset->callback((Fl_Callback*)cb_offset);
            offset->align(Fl_Align(FL_ALIGN_RIGHT));
            offset->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::pitchBendOffset, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->setValueType(VC_FreqOffsetHz);
            o->selection_color(setKnob(o->value(),64));
          } // WidgetPDial* offset
          freqencygrp->end();
        } // Fl_Group* freqencygrp
        { oscDisplay = new Fl_Group(5, 462, 570, 145);
          { Fl_Group* o = oscGroup = new Fl_Group(5, 462, 570, 145);
            oscGroup->labelfont(1);
            oscGroup->labelsize(13);
            oscGroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
            { oscParamBox = new Fl_Group(5, 478, 80, 128, "Local\nOscillator");
              oscParamBox->box(FL_THIN_UP_FRAME);
              oscParamBox->labelfont(1);
              oscParamBox->labelsize(12);
              oscParamBox->labelcolor((Fl_Color)64);
              oscParamBox->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
              { Fl_Choice* o = UseOsc = new Fl_Choice(9, 526, 72, 18, "Use");
                UseOsc->tooltip("Use an earlier oscillator for this voice. Only the base oscillator is used, n"
"ot other voice parameters.");
                UseOsc->down_box(FL_BORDER_BOX);
                UseOsc->selection_color(FL_BACKGROUND_COLOR);
                UseOsc->labelsize(10);
                UseOsc->labelcolor((Fl_Color)64);
                UseOsc->textfont(1);
                UseOsc->textsize(10);
                UseOsc->textcolor((Fl_Color)64);
                UseOsc->callback((Fl_Callback*)cb_UseOsc);
                UseOsc->align(Fl_Align(FL_ALIGN_TOP));
                o->add("Internal");
                char tmp[50]; for (int i = 0; i < nvoice; ++i) {sprintf(tmp, "Osc. %2d", i + 1); o->add(tmp);};
                o->value(collect_readData(synth, 0, ADDVOICE::control::voiceOscillatorSource, npart, kititem, PART::engine::addVoice1 + nvoice) + 1);
              } // Fl_Choice* UseOsc
              { Fl_Button* o = changevoiceoscilbutton = new Fl_Button(9, 548, 72, 22, "Waveform");
                changevoiceoscilbutton->box(FL_GTK_THIN_UP_BOX);
                changevoiceoscilbutton->color((Fl_Color)198);
                changevoiceoscilbutton->labelfont(1);
                changevoiceoscilbutton->labelsize(11);
                changevoiceoscilbutton->labelcolor((Fl_Color)64);
                changevoiceoscilbutton->callback((Fl_Callback*)cb_changevoiceoscilbutton);
                if (UseOsc->value() > 0) o->labelcolor(alt_warn_tex);
              } // Fl_Button* changevoiceoscilbutton
              { mwheel_slider_rev* o = VoiceOscPhase = new mwheel_slider_rev(9, 586, 72, 16, "Phase");
                VoiceOscPhase->tooltip("Phase offset");
                VoiceOscPhase->type(5);
                VoiceOscPhase->box(FL_THIN_DOWN_BOX);
                VoiceOscPhase->color(FL_BACKGROUND_COLOR);
                VoiceOscPhase->selection_color(FL_BACKGROUND_COLOR);
                VoiceOscPhase->labeltype(FL_NORMAL_LABEL);
                VoiceOscPhase->labelfont(0);
                VoiceOscPhase->labelsize(10);
                VoiceOscPhase->labelcolor((Fl_Color)64);
                VoiceOscPhase->minimum(-64);
                VoiceOscPhase->maximum(63);
                VoiceOscPhase->step(1);
                VoiceOscPhase->callback((Fl_Callback*)cb_VoiceOscPhase);
                VoiceOscPhase->align(Fl_Align(FL_ALIGN_TOP));
                VoiceOscPhase->when(FL_WHEN_CHANGED);
                o->value(collect_readData(synth, 0, ADDVOICE::control::voiceOscillatorPhase, npart, kititem, PART::engine::addVoice1 + nvoice));
                o->setValueType(VC_PhaseOffset); o->useCustomTip(true);
                o->selection_color(setSlider(o->value(),0));
              } // mwheel_slider_rev* VoiceOscPhase
              oscParamBox->end();
            } // Fl_Group* oscParamBox
            { Fl_Group* o = voiceoscil = new Fl_Group(88, 462, 485, 145);
              voiceoscil->box(FL_THIN_DOWN_BOX);
              voiceoscil->color((Fl_Color)57);
              voiceoscil->labelcolor(FL_BACKGROUND_COLOR);
              osc = new Oscilloscope(o->x(),o->y(),o->w(),o->h(), 130, "");
              update_voiceoscil();
              voiceoscil->end();
            } // Fl_Group* voiceoscil
            if (collect_readData(synth, 0, ADDVOICE::control::externalOscillator, npart, kititem, PART::engine::addVoice1 + nvoice) >= 0) o->deactivate();
            oscGroup->end();
          } // Fl_Group* oscGroup
          { osclabel = new Fl_Box(135, 502, 400, 65, "Osc");
            osclabel->labelfont(1);
            osclabel->labelsize(50);
            osclabel->labelcolor(FL_BACKGROUND2_COLOR);
            osclabel->callback((Fl_Callback*)cb_osclabel);
          } // Fl_Box* osclabel
          oscDisplay->end();
        } // Fl_Group* oscDisplay
        { Fl_Box* o = new Fl_Box(205, 35, 85, 33);
          o->box(FL_THIN_UP_FRAME);
        } // Fl_Box* o
        { Fl_Check_Button2* o = ResonanceEn = new Fl_Check_Button2(238, 49, 17, 19, "Resonance");
          ResonanceEn->tooltip("Resonance On/Off");
          ResonanceEn->box(FL_NO_BOX);
          ResonanceEn->down_box(FL_DOWN_BOX);
          ResonanceEn->color(FL_BACKGROUND_COLOR);
          ResonanceEn->selection_color((Fl_Color)64);
          ResonanceEn->labeltype(FL_NORMAL_LABEL);
          ResonanceEn->labelfont(0);
          ResonanceEn->labelsize(12);
          ResonanceEn->labelcolor((Fl_Color)64);
          ResonanceEn->callback((Fl_Callback*)cb_ResonanceEn);
          ResonanceEn->align(Fl_Align(FL_ALIGN_TOP));
          ResonanceEn->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth, 0, ADDVOICE::control::enableResonance, npart, kititem, PART::engine::addVoice1 + nvoice));
        } // Fl_Check_Button2* ResonanceEn
        { Fl_Group* o = unisongroup = new Fl_Group(88, 402, 484, 56);
          unisongroup->box(FL_PLASTIC_UP_BOX);
          unisongroup->color(FL_CYAN);
          unisongroup->deactivate();
          { WidgetSpinner* o = unisonsize = new WidgetSpinner(98, 434, 40, 16, "Size");
            unisonsize->tooltip("Number of unison sub-voices");
            unisonsize->box(FL_THIN_UP_BOX);
            unisonsize->color((Fl_Color)29);
            unisonsize->selection_color(FL_BACKGROUND_COLOR);
            unisonsize->labeltype(FL_NORMAL_LABEL);
            unisonsize->labelfont(0);
            unisonsize->labelsize(10);
            unisonsize->labelcolor(FL_FOREGROUND_COLOR);
            unisonsize->minimum(2);
            unisonsize->maximum(50);
            unisonsize->value(2);
            unisonsize->textsize(11);
            unisonsize->textcolor((Fl_Color)64);
            unisonsize->callback((Fl_Callback*)cb_unisonsize);
            unisonsize->align(Fl_Align(FL_ALIGN_TOP));
            unisonsize->when(FL_WHEN_RELEASE);
            int tmp = collect_readData(synth, 0, ADDVOICE::control::unisonSize, npart, kititem, PART::engine::addVoice1 + nvoice);
            if (tmp < 2) tmp = 2;
            o->value(tmp);
          } // WidgetSpinner* unisonsize
          { WidgetPDial* o = UnisonStereo = new WidgetPDial(356, 422, 28, 28, "Stereo");
            UnisonStereo->tooltip("Stereo Spread");
            UnisonStereo->box(FL_ROUND_UP_BOX);
            UnisonStereo->color(FL_BACKGROUND_COLOR);
            UnisonStereo->selection_color(FL_INACTIVE_COLOR);
            UnisonStereo->labeltype(FL_NORMAL_LABEL);
            UnisonStereo->labelfont(0);
            UnisonStereo->labelsize(10);
            UnisonStereo->labelcolor((Fl_Color)64);
            UnisonStereo->maximum(127);
            UnisonStereo->step(1);
            UnisonStereo->callback((Fl_Callback*)cb_UnisonStereo);
            UnisonStereo->align(Fl_Align(FL_ALIGN_TOP));
            UnisonStereo->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::unisonStereoSpread, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->selection_color(setKnob(o->value(),64));
          } // WidgetPDial* UnisonStereo
          { WidgetPDial* o = UnisonVib = new WidgetPDial(396, 422, 28, 28, "Vib.");
            UnisonVib->tooltip("Vibratto");
            UnisonVib->box(FL_ROUND_UP_BOX);
            UnisonVib->color(FL_BACKGROUND_COLOR);
            UnisonVib->selection_color(FL_INACTIVE_COLOR);
            UnisonVib->labeltype(FL_NORMAL_LABEL);
            UnisonVib->labelfont(0);
            UnisonVib->labelsize(10);
            UnisonVib->labelcolor((Fl_Color)64);
            UnisonVib->maximum(127);
            UnisonVib->step(1);
            UnisonVib->callback((Fl_Callback*)cb_UnisonVib);
            UnisonVib->align(Fl_Align(FL_ALIGN_TOP));
            UnisonVib->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::unisonVibratoDepth, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->selection_color(setKnob(o->value(),64));
          } // WidgetPDial* UnisonVib
          { Fl_Choice* o = UnisonInvert = new Fl_Choice(484, 426, 78, 18, "Invert");
            UnisonInvert->tooltip("Phase Invert");
            UnisonInvert->down_box(FL_BORDER_BOX);
            UnisonInvert->selection_color((Fl_Color)64);
            UnisonInvert->labelsize(10);
            UnisonInvert->labelcolor((Fl_Color)64);
            UnisonInvert->textfont(1);
            UnisonInvert->textsize(11);
            UnisonInvert->textcolor((Fl_Color)64);
            UnisonInvert->callback((Fl_Callback*)cb_UnisonInvert);
            UnisonInvert->align(Fl_Align(FL_ALIGN_TOP));
            o->add("None");o->add("Random");o->add("50%");o->add("33%");o->add("25%");o->add("20%");
            o->value(collect_readData(synth, 0, ADDVOICE::control::unisonPhaseInvert, npart, kititem, PART::engine::addVoice1 + nvoice));
          } // Fl_Choice* UnisonInvert
          { mwheel_slider_rev* o = UnisonFreqSpread = new mwheel_slider_rev(181, 434, 120, 16, "Frequency Spread");
            UnisonFreqSpread->tooltip("Frequency Spread of the Unison");
            UnisonFreqSpread->type(5);
            UnisonFreqSpread->box(FL_THIN_DOWN_BOX);
            UnisonFreqSpread->color(FL_BACKGROUND_COLOR);
            UnisonFreqSpread->selection_color(FL_BACKGROUND_COLOR);
            UnisonFreqSpread->labeltype(FL_NORMAL_LABEL);
            UnisonFreqSpread->labelfont(0);
            UnisonFreqSpread->labelsize(10);
            UnisonFreqSpread->labelcolor((Fl_Color)64);
            UnisonFreqSpread->maximum(127);
            UnisonFreqSpread->step(1);
            UnisonFreqSpread->value(64);
            UnisonFreqSpread->callback((Fl_Callback*)cb_UnisonFreqSpread);
            UnisonFreqSpread->align(Fl_Align(FL_ALIGN_TOP));
            UnisonFreqSpread->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::unisonFrequencySpread, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->selection_color(setSlider(o->value(),60));
          } // mwheel_slider_rev* UnisonFreqSpread
          { Fl_Value_Output* o = unisonspreadoutput = new Fl_Value_Output(145, 434, 38, 16, "(cents)");
            unisonspreadoutput->box(FL_THIN_DOWN_BOX);
            unisonspreadoutput->labelsize(10);
            unisonspreadoutput->labelcolor((Fl_Color)64);
            unisonspreadoutput->maximum(1000);
            unisonspreadoutput->textsize(10);
            unisonspreadoutput->textcolor((Fl_Color)64);
            unisonspreadoutput->callback((Fl_Callback*)cb_unisonspreadoutput);
            unisonspreadoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->step(0.1, 1);
            o->value(collect_readData(synth, 0, ADDVOICE::control::unisonSpreadCents, npart, kititem, PART::engine::addVoice1 + nvoice));
          } // Fl_Value_Output* unisonspreadoutput
          { WidgetPDial* o = UnisonVspeed = new WidgetPDial(436, 422, 28, 28, "V.speed");
            UnisonVspeed->tooltip("Vibratto Average Speed");
            UnisonVspeed->box(FL_ROUND_UP_BOX);
            UnisonVspeed->color(FL_BACKGROUND_COLOR);
            UnisonVspeed->selection_color(FL_INACTIVE_COLOR);
            UnisonVspeed->labeltype(FL_NORMAL_LABEL);
            UnisonVspeed->labelfont(0);
            UnisonVspeed->labelsize(10);
            UnisonVspeed->labelcolor((Fl_Color)64);
            UnisonVspeed->maximum(127);
            UnisonVspeed->step(1);
            UnisonVspeed->callback((Fl_Callback*)cb_UnisonVspeed);
            UnisonVspeed->align(Fl_Align(FL_ALIGN_TOP));
            UnisonVspeed->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::unisonVibratoSpeed, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->selection_color(setKnob(o->value(),64));
          } // WidgetPDial* UnisonVspeed
          { WidgetPDial* o = UnisonPhRnd = new WidgetPDial(316, 422, 28, 28, "Ph.rnd");
            UnisonPhRnd->tooltip("Phase randomness");
            UnisonPhRnd->box(FL_ROUND_UP_BOX);
            UnisonPhRnd->color(FL_BACKGROUND_COLOR);
            UnisonPhRnd->selection_color(FL_INACTIVE_COLOR);
            UnisonPhRnd->labeltype(FL_NORMAL_LABEL);
            UnisonPhRnd->labelfont(0);
            UnisonPhRnd->labelsize(10);
            UnisonPhRnd->labelcolor((Fl_Color)64);
            UnisonPhRnd->maximum(127);
            UnisonPhRnd->step(1);
            UnisonPhRnd->callback((Fl_Callback*)cb_UnisonPhRnd);
            UnisonPhRnd->align(Fl_Align(FL_ALIGN_TOP));
            UnisonPhRnd->when(FL_WHEN_CHANGED);
            o->value(collect_readData(synth, 0, ADDVOICE::control::unisonPhaseRandomise, npart, kititem, PART::engine::addVoice1 + nvoice));
            o->selection_color(setKnob(o->value(),127));
          } // WidgetPDial* UnisonPhRnd
          { unisName = new Fl_Box(186, 402, 73, 25, "UNISON");
            unisName->labelfont(1);
            unisName->labelsize(12);
            unisName->labelcolor((Fl_Color)64);
          } // Fl_Box* unisName
          int tmp = collect_readData(synth, 0, ADDVOICE::control::unisonSize, npart, kititem, PART::engine::addVoice1 + nvoice); if (tmp > 1) o->activate();
          unisongroup->end();
        } // Fl_Group* unisongroup
        { Fl_Check_Button2* o = UnisonEn = new Fl_Check_Button2(94, 408, 38, 14, "On");
          UnisonEn->box(FL_NO_BOX);
          UnisonEn->down_box(FL_DOWN_BOX);
          UnisonEn->color(FL_BACKGROUND_COLOR);
          UnisonEn->selection_color((Fl_Color)64);
          UnisonEn->labeltype(FL_NORMAL_LABEL);
          UnisonEn->labelfont(3);
          UnisonEn->labelsize(10);
          UnisonEn->labelcolor((Fl_Color)226);
          UnisonEn->callback((Fl_Callback*)cb_UnisonEn);
          UnisonEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          UnisonEn->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth, 0, ADDVOICE::control::enableUnison, npart, kititem, PART::engine::addVoice1 + nvoice) > 1);
        } // Fl_Check_Button2* UnisonEn
        voicemodegroup->end();
      } // Fl_Group* voicemodegroup
      { amplitudegroup = new Fl_Group(5, 68, 285, 212);
        amplitudegroup->box(FL_UP_FRAME);
        amplitudegroup->labelfont(1);
        amplitudegroup->labelsize(12);
        amplitudegroup->labelcolor((Fl_Color)64);
        amplitudegroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { WidgetPDial* o = voicevolume = new WidgetPDial(30, 86, 33, 33, "Volume");
          voicevolume->tooltip("Volume");
          voicevolume->box(FL_ROUND_UP_BOX);
          voicevolume->color(FL_BACKGROUND_COLOR);
          voicevolume->selection_color(FL_INACTIVE_COLOR);
          voicevolume->labeltype(FL_NORMAL_LABEL);
          voicevolume->labelfont(0);
          voicevolume->labelsize(10);
          voicevolume->labelcolor((Fl_Color)64);
          voicevolume->maximum(127);
          voicevolume->step(1);
          voicevolume->callback((Fl_Callback*)cb_voicevolume);
          voicevolume->align(Fl_Align(FL_ALIGN_BOTTOM));
          voicevolume->when(FL_WHEN_CHANGED);
          o->setValueType(VC_ADDVoiceVolume);
          o->value(collect_readData(synth,0,ADDVOICE::control::volume, npart, kititem, PART::engine::addVoice1 + nvoice));
          o->selection_color(setKnob(o->value(),100));
        } // WidgetPDial* voicevolume
        { WidgetPDial* o = voicevsns = new WidgetPDial(86, 87, 33, 33, "Vel Sens");
          voicevsns->tooltip("Velocity Sensing Function - rightmost/max disables)");
          voicevsns->box(FL_ROUND_UP_BOX);
          voicevsns->color(FL_BACKGROUND_COLOR);
          voicevsns->selection_color(FL_INACTIVE_COLOR);
          voicevsns->labeltype(FL_NORMAL_LABEL);
          voicevsns->labelfont(0);
          voicevsns->labelsize(10);
          voicevsns->labelcolor((Fl_Color)64);
          voicevsns->maximum(127);
          voicevsns->step(1);
          voicevsns->callback((Fl_Callback*)cb_voicevsns);
          voicevsns->align(Fl_Align(FL_ALIGN_BOTTOM));
          voicevsns->when(FL_WHEN_CHANGED);
          o->value(collect_readData(synth,0,ADDVOICE::control::velocitySense, npart, kititem, PART::engine::addVoice1 + nvoice));
          o->setValueType(VC_AmpVelocitySense);
          o->selection_color(setKnob(o->value(),127));
        } // WidgetPDial* voicevsns
        { WidgetPDial* o = voicepan = new WidgetPDial(160, 86, 33, 33, "Pan");
          voicepan->tooltip("Voice panning");
          voicepan->box(FL_ROUND_UP_BOX);
          voicepan->color(FL_BACKGROUND_COLOR);
          voicepan->selection_color(FL_INACTIVE_COLOR);
          voicepan->labeltype(FL_NORMAL_LABEL);
          voicepan->labelfont(0);
          voicepan->labelsize(10);
          voicepan->labelcolor((Fl_Color)64);
          voicepan->maximum(127);
          voicepan->step(1);
          voicepan->callback((Fl_Callback*)cb_voicepan);
          voicepan->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
          voicepan->when(FL_WHEN_CHANGED);
          o->setValueType(VC_PanningStd);
          o->value(collect_readData(synth,0,ADDVOICE::control::panning, npart, kititem, PART::engine::addVoice1 + nvoice));
          o->selection_color(setKnob(o->value(),64));
        } // WidgetPDial* voicepan
        { WidgetPDial* o = voicewidth = new WidgetPDial(235, 86, 33, 33, "Width");
          voicewidth->tooltip("Voice random width");
          voicewidth->box(FL_ROUND_UP_BOX);
          voicewidth->color(FL_BACKGROUND_COLOR);
          voicewidth->selection_color(FL_INACTIVE_COLOR);
          voicewidth->labeltype(FL_NORMAL_LABEL);
          voicewidth->labelfont(0);
          voicewidth->labelsize(10);
          voicewidth->labelcolor((Fl_Color)64);
          voicewidth->maximum(63);
          voicewidth->step(1);
          voicewidth->value(63);
          voicewidth->callback((Fl_Callback*)cb_voicewidth);
          voicewidth->align(Fl_Align(FL_ALIGN_BOTTOM));
          voicewidth->when(FL_WHEN_CHANGED);
          o->setValueType(VC_PanningRandom);
          o->value(collect_readData(synth,0,ADDVOICE::control::randomWidth, npart, kititem, PART::engine::addVoice1 + nvoice));
          o->selection_color(setKnob(o->value(),63));
        } // WidgetPDial* voicewidth
        { Fl_Check_Button2* o = voicerandompan = new Fl_Check_Button2(205, 94, 15, 15, "Rand");
          voicerandompan->tooltip("Enable random panning");
          voicerandompan->box(FL_NO_BOX);
          voicerandompan->down_box(FL_DOWN_BOX);
          voicerandompan->color((Fl_Color)48);
          voicerandompan->selection_color((Fl_Color)64);
          voicerandompan->labeltype(FL_NORMAL_LABEL);
          voicerandompan->labelfont(0);
          voicerandompan->labelsize(11);
          voicerandompan->labelcolor((Fl_Color)64);
          voicerandompan->callback((Fl_Callback*)cb_voicerandompan);
          voicerandompan->align(Fl_Align(FL_ALIGN_TOP));
          voicerandompan->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth,0,ADDVOICE::control::enableRandomPan, npart, kititem, PART::engine::addVoice1 + nvoice));
          if (o->value() == 0) voicewidth->deactivate(); else voicewidth->activate();
        } // Fl_Check_Button2* voicerandompan
        { EnvelopeUI* o = voiceampenvgroup = new EnvelopeUI(10, 135, 275, 70, "Yoshimi : AddSynth Voice - Amplitude Envelope");
          voiceampenvgroup->box(FL_FLAT_BOX);
          voiceampenvgroup->color((Fl_Color)51);
          voiceampenvgroup->selection_color(FL_BACKGROUND_COLOR);
          voiceampenvgroup->labeltype(FL_NORMAL_LABEL);
          voiceampenvgroup->labelfont(0);
          voiceampenvgroup->labelsize(14);
          voiceampenvgroup->labelcolor(FL_FOREGROUND_COLOR);
          voiceampenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voiceampenvgroup->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].AmpEnvelope, npart, kititem, nvoice + PART::engine::addVoice1, 0);
          if (collect_readData(synth,0,ADDVOICE::control::enableAmplitudeEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice) == 0) o->deactivate();
          voiceampenvgroup->end();
        } // EnvelopeUI* voiceampenvgroup
        { Fl_Check_Button2* o = AmpEnvEn = new Fl_Check_Button2(14, 139, 38, 14, "On");
          AmpEnvEn->tooltip("Enable Amplitude Envelope");
          AmpEnvEn->box(FL_NO_BOX);
          AmpEnvEn->down_box(FL_DOWN_BOX);
          AmpEnvEn->color(FL_BACKGROUND2_COLOR);
          AmpEnvEn->selection_color((Fl_Color)64);
          AmpEnvEn->labeltype(FL_NORMAL_LABEL);
          AmpEnvEn->labelfont(3);
          AmpEnvEn->labelsize(10);
          AmpEnvEn->labelcolor((Fl_Color)226);
          AmpEnvEn->callback((Fl_Callback*)cb_AmpEnvEn);
          AmpEnvEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          AmpEnvEn->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth,0,ADDVOICE::control::enableAmplitudeEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice));
        } // Fl_Check_Button2* AmpEnvEn
        { LFOUI* o = voiceamplfogroup = new LFOUI(10, 205, 275, 70, "Amplitude LFO     ");
          voiceamplfogroup->box(FL_FLAT_BOX);
          voiceamplfogroup->color(FL_DARK1);
          voiceamplfogroup->selection_color(FL_BACKGROUND_COLOR);
          voiceamplfogroup->labeltype(FL_NORMAL_LABEL);
          voiceamplfogroup->labelfont(0);
          voiceamplfogroup->labelsize(14);
          voiceamplfogroup->labelcolor(FL_FOREGROUND_COLOR);
          voiceamplfogroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voiceamplfogroup->when(FL_WHEN_RELEASE);
          o->init(synth, npart, kititem, PART::engine::addVoice1 + nvoice, TOPLEVEL::insertType::amplitude);
          if (collect_readData(synth,0,ADDVOICE::control::enableAmplitudeLFO, npart, kititem, PART::engine::addVoice1 + nvoice) == 0) o->deactivate();
          voiceamplfogroup->end();
        } // LFOUI* voiceamplfogroup
        { Fl_Check_Button2* o = AmpLfoEn = new Fl_Check_Button2(14, 210, 38, 14, "On");
          AmpLfoEn->tooltip("Enable Amplitude LFO");
          AmpLfoEn->box(FL_NO_BOX);
          AmpLfoEn->down_box(FL_DOWN_BOX);
          AmpLfoEn->color(FL_BACKGROUND2_COLOR);
          AmpLfoEn->selection_color((Fl_Color)64);
          AmpLfoEn->labeltype(FL_NORMAL_LABEL);
          AmpLfoEn->labelfont(3);
          AmpLfoEn->labelsize(10);
          AmpLfoEn->labelcolor((Fl_Color)226);
          AmpLfoEn->callback((Fl_Callback*)cb_AmpLfoEn);
          AmpLfoEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          AmpLfoEn->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth,0,ADDVOICE::control::enableAmplitudeLFO, npart, kititem, PART::engine::addVoice1 + nvoice));
        } // Fl_Check_Button2* AmpLfoEn
        { Fl_Check_Button2* o = VolumeMinus = new Fl_Check_Button2(12, 75, 50, 10, "Minus");
          VolumeMinus->tooltip("Reverse phase relative to other voices");
          VolumeMinus->box(FL_NO_BOX);
          VolumeMinus->down_box(FL_DOWN_BOX);
          VolumeMinus->color(FL_BACKGROUND_COLOR);
          VolumeMinus->selection_color((Fl_Color)64);
          VolumeMinus->labeltype(FL_NORMAL_LABEL);
          VolumeMinus->labelfont(0);
          VolumeMinus->labelsize(12);
          VolumeMinus->labelcolor((Fl_Color)64);
          VolumeMinus->callback((Fl_Callback*)cb_VolumeMinus);
          VolumeMinus->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          VolumeMinus->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth,0,ADDVOICE::control::invertPhase, npart, kititem, PART::engine::addVoice1 + nvoice));
        } // Fl_Check_Button2* VolumeMinus
        { Fl_Box* o = new Fl_Box(140, 88, 4, 40);
          o->box(FL_THIN_DOWN_FRAME);
        } // Fl_Box* o
        { ampVoiceLabel = new Fl_Box(128, 72, 35, 17, "AMPLITUDE");
          ampVoiceLabel->labelfont(1);
          ampVoiceLabel->labelsize(10);
          ampVoiceLabel->labelcolor((Fl_Color)64);
        } // Fl_Box* ampVoiceLabel
        amplitudegroup->end();
      } // Fl_Group* amplitudegroup
      { Fl_Group* o = voicefiltergroup = new Fl_Group(290, 35, 285, 245, "FILTER      ");
        voicefiltergroup->box(FL_UP_FRAME);
        voicefiltergroup->labelfont(1);
        voicefiltergroup->labelsize(12);
        voicefiltergroup->labelcolor((Fl_Color)64);
        voicefiltergroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { FilterUI* o = voicefilter = new FilterUI(295, 60, 275, 75, "ADsynth Voice - Filter");
          voicefilter->box(FL_FLAT_BOX);
          voicefilter->color(FL_LIGHT1);
          voicefilter->selection_color(FL_BACKGROUND_COLOR);
          voicefilter->labeltype(FL_NORMAL_LABEL);
          voicefilter->labelfont(0);
          voicefilter->labelsize(14);
          voicefilter->labelcolor(FL_FOREGROUND_COLOR);
          voicefilter->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voicefilter->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].VoiceFilter,&pars->VoicePar[nvoice].PFilterVelocityScale, &pars->VoicePar[nvoice].PFilterVelocityScaleFunction, npart, kititem, PART::engine::addVoice1 + nvoice);
          voicefilter->end();
        } // FilterUI* voicefilter
        { EnvelopeUI* o = voicefilterenvgroup = new EnvelopeUI(295, 135, 275, 70, "Yoshimi : AddSynth Voice - Filter Envelope");
          voicefilterenvgroup->box(FL_FLAT_BOX);
          voicefilterenvgroup->color((Fl_Color)51);
          voicefilterenvgroup->selection_color(FL_BACKGROUND_COLOR);
          voicefilterenvgroup->labeltype(FL_NORMAL_LABEL);
          voicefilterenvgroup->labelfont(0);
          voicefilterenvgroup->labelsize(14);
          voicefilterenvgroup->labelcolor(FL_FOREGROUND_COLOR);
          voicefilterenvgroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voicefilterenvgroup->when(FL_WHEN_RELEASE);
          o->init(pars->VoicePar[nvoice].FilterEnvelope, npart, kititem, nvoice + PART::engine::addVoice1, 2);
          if (collect_readData(synth, 0, ADDVOICE::control::enableFilterEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice)==0) o->deactivate();
          voicefilterenvgroup->end();
        } // EnvelopeUI* voicefilterenvgroup
        { Fl_Check_Button2* o = FilterEnvEn = new Fl_Check_Button2(300, 140, 38, 14, "On");
          FilterEnvEn->tooltip("Enable Filter Envelope");
          FilterEnvEn->box(FL_NO_BOX);
          FilterEnvEn->down_box(FL_DOWN_BOX);
          FilterEnvEn->color(FL_BACKGROUND2_COLOR);
          FilterEnvEn->selection_color((Fl_Color)64);
          FilterEnvEn->labeltype(FL_NORMAL_LABEL);
          FilterEnvEn->labelfont(3);
          FilterEnvEn->labelsize(10);
          FilterEnvEn->labelcolor((Fl_Color)226);
          FilterEnvEn->callback((Fl_Callback*)cb_FilterEnvEn);
          FilterEnvEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          FilterEnvEn->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth, 0, ADDVOICE::control::enableFilterEnvelope, npart, kititem, PART::engine::addVoice1 + nvoice));
        } // Fl_Check_Button2* FilterEnvEn
        { LFOUI* o = voicefilterlfogroup = new LFOUI(295, 205, 275, 70, "Filter LFO     ");
          voicefilterlfogroup->box(FL_FLAT_BOX);
          voicefilterlfogroup->color(FL_DARK1);
          voicefilterlfogroup->selection_color(FL_BACKGROUND_COLOR);
          voicefilterlfogroup->labeltype(FL_NORMAL_LABEL);
          voicefilterlfogroup->labelfont(0);
          voicefilterlfogroup->labelsize(14);
          voicefilterlfogroup->labelcolor(FL_FOREGROUND_COLOR);
          voicefilterlfogroup->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
          voicefilterlfogroup->when(FL_WHEN_RELEASE);
          o->init(synth, npart, kititem, PART::engine::addVoice1 + nvoice, TOPLEVEL::insertType::filter);
          if (collect_readData(synth, 0, ADDVOICE::control::enableFilterLFO, npart, kititem, PART::engine::addVoice1 + nvoice)==0) o->deactivate();
          voicefilterlfogroup->end();
        } // LFOUI* voicefilterlfogroup
        { Fl_Check_Button2* o = FilterLfoEn = new Fl_Check_Button2(300, 210, 38, 14, "On");
          FilterLfoEn->tooltip("Enable Filter LFO");
          FilterLfoEn->box(FL_NO_BOX);
          FilterLfoEn->down_box(FL_DOWN_BOX);
          FilterLfoEn->color(FL_BACKGROUND2_COLOR);
          FilterLfoEn->selection_color((Fl_Color)64);
          FilterLfoEn->labeltype(FL_NORMAL_LABEL);
          FilterLfoEn->labelfont(3);
          FilterLfoEn->labelsize(10);
          FilterLfoEn->labelcolor((Fl_Color)226);
          FilterLfoEn->callback((Fl_Callback*)cb_FilterLfoEn);
          FilterLfoEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
          FilterLfoEn->when(FL_WHEN_RELEASE);
          o->value(collect_readData(synth, 0, ADDVOICE::control::enableFilterLFO, npart, kititem, PART::engine::addVoice1 + nvoice));
        } // Fl_Check_Button2* FilterLfoEn
        if (collect_readData(synth, 0, ADDVOICE::control::enableFilter, npart, kititem, PART::engine::addVoice1 + nvoice) == 0) o->deactivate();
        voicefiltergroup->end();
      } // Fl_Group* voicefiltergroup
      { Fl_Box* o = new Fl_Box(5, 35, 64, 33);
        o->box(FL_THIN_UP_FRAME);
      } // Fl_Box* o
      { Fl_Group* o = new Fl_Group(69, 35, 136, 33);
        o->box(FL_THIN_UP_FRAME);
        { mwheel_slider_rev* o = Delay = new mwheel_slider_rev(76, 50, 124, 12, "Delay");
          Delay->tooltip("Time before the voice activates");
          Delay->type(5);
          Delay->box(FL_THIN_DOWN_BOX);
          Delay->color(FL_BACKGROUND_COLOR);
          Delay->selection_color(FL_BACKGROUND_COLOR);
          Delay->labeltype(FL_NORMAL_LABEL);
          Delay->labelfont(0);
          Delay->labelsize(11);
          Delay->labelcolor((Fl_Color)64);
          Delay->maximum(127);
          Delay->step(1);
          Delay->textcolor((Fl_Color)64);
          Delay->callback((Fl_Callback*)cb_Delay);
          Delay->align(Fl_Align(FL_ALIGN_TOP));
          Delay->when(FL_WHEN_CHANGED);
          o->value(collect_readData(synth,0,ADDVOICE::control::delay, npart, kititem, PART::engine::addVoice1 + nvoice));
          o->setValueType(VC_ADDVoiceDelay);o->useCustomTip(true);
          o->selection_color(setSlider(o->value(),0));
        } // mwheel_slider_rev* Delay
        o->end();
      } // Fl_Group* o
      { Fl_Check_Button2* o = bypassfiltercheckbutton = new Fl_Check_Button2(450, 41, 14, 14, "Bypass Global");
        bypassfiltercheckbutton->box(FL_NO_BOX);
        bypassfiltercheckbutton->down_box(FL_DOWN_BOX);
        bypassfiltercheckbutton->color(FL_BACKGROUND_COLOR);
        bypassfiltercheckbutton->selection_color((Fl_Color)64);
        bypassfiltercheckbutton->labeltype(FL_NORMAL_LABEL);
        bypassfiltercheckbutton->labelfont(0);
        bypassfiltercheckbutton->labelsize(12);
        bypassfiltercheckbutton->labelcolor((Fl_Color)64);
        bypassfiltercheckbutton->callback((Fl_Callback*)cb_bypassfiltercheckbutton);
        bypassfiltercheckbutton->align(Fl_Align(FL_ALIGN_RIGHT));
        bypassfiltercheckbutton->when(FL_WHEN_RELEASE);
        o->value(collect_readData(synth,0,ADDVOICE::control::bypassGlobalFilter, npart, kititem, PART::engine::addVoice1 + nvoice));
      } // Fl_Check_Button2* bypassfiltercheckbutton
      { Fl_Check_Button2* o = FilterEn = new Fl_Check_Button2(294, 41, 38, 14, "On");
        FilterEn->tooltip("Enable Filter");
        FilterEn->box(FL_NO_BOX);
        FilterEn->down_box(FL_DOWN_BOX);
        FilterEn->color(FL_BACKGROUND_COLOR);
        FilterEn->selection_color((Fl_Color)64);
        FilterEn->labeltype(FL_NORMAL_LABEL);
        FilterEn->labelfont(3);
        FilterEn->labelsize(10);
        FilterEn->labelcolor((Fl_Color)226);
        FilterEn->callback((Fl_Callback*)cb_FilterEn);
        FilterEn->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        FilterEn->when(FL_WHEN_RELEASE);
        o->value(collect_readData(synth,0,ADDVOICE::control::enableFilter, npart, kititem, PART::engine::addVoice1 + nvoice));
      } // Fl_Check_Button2* FilterEn
      { extvoicegroup = new Fl_Group(5, 400, 80, 76, "Voice");
        extvoicegroup->box(FL_THIN_UP_FRAME);
        extvoicegroup->labelfont(1);
        extvoicegroup->labelsize(12);
        extvoicegroup->labelcolor(FL_BACKGROUND_COLOR);
        extvoicegroup->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
        { Fl_Choice* o = ExtOsc = new Fl_Choice(8, 430, 74, 18, "Source");
          ExtOsc->tooltip("Use an earlier voice as input to this voice. All parameters from the imported"
" voice remain in effect, except for volume, panning, base frequency and pitch "
"bend scaling factor. The voice is also converted to mono. Parameters in the cu"
"rrent voice will then tweak the signal further.");
          ExtOsc->down_box(FL_BORDER_BOX);
          ExtOsc->selection_color(FL_BACKGROUND_COLOR);
          ExtOsc->labelsize(10);
          ExtOsc->labelcolor((Fl_Color)64);
          ExtOsc->textfont(1);
          ExtOsc->textsize(10);
          ExtOsc->textcolor((Fl_Color)64);
          ExtOsc->callback((Fl_Callback*)cb_ExtOsc);
          ExtOsc->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("Local");
          char tmp[50]; for (int i = 0; i < nvoice; ++i) {sprintf(tmp, "Voice %2d", i + 1); o->add(tmp);};
          o->value(collect_readData(synth,0,ADDVOICE::control::externalOscillator, npart, kititem, PART::engine::addVoice1 + nvoice) + 1);
          if (nvoice == 0) o->deactivate();
        } // Fl_Choice* ExtOsc
        { Fl_Choice* o = SoundType = new Fl_Choice(8, 454, 74, 18);
          SoundType->tooltip("Oscillator Type (sound/noise)");
          SoundType->down_box(FL_BORDER_BOX);
          SoundType->selection_color(FL_BACKGROUND_COLOR);
          SoundType->labelsize(10);
          SoundType->labelcolor((Fl_Color)64);
          SoundType->textfont(1);
          SoundType->textsize(10);
          SoundType->textcolor((Fl_Color)64);
          SoundType->callback((Fl_Callback*)cb_SoundType);
          SoundType->when(FL_WHEN_RELEASE_ALWAYS);
          o->add("Sound");o->add("Whit Ns");o->add("Pink Ns");o->add("Spot Ns");
          o->value(collect_readData(synth,0,ADDVOICE::control::soundType,npart,kititem,PART::engine::addVoice1 + nvoice));
          if (o->value()!=0) voicemodegroup->deactivate();
          if (ExtOsc->value() > 0) o->deactivate();
        } // Fl_Choice* SoundType
        extvoicegroup->end();
      } // Fl_Group* extvoicegroup
      { noiselabel = new Fl_Box(130, 500, 400, 65, "Noise");
        noiselabel->labelfont(1);
        noiselabel->labelsize(50);
        noiselabel->labelcolor(FL_BACKGROUND2_COLOR);
        noiselabel->callback((Fl_Callback*)cb_noiselabel);
        update_osclabels();
      } // Fl_Box* noiselabel
      if (voiceonbutton->value() == 0) o->deactivate();
      voiceparametersgroup->end();
    } // Fl_Group* voiceparametersgroup
    { Vname = new Fl_Group(476, 10, 63, 16, "VOICE");
      Vname->labelfont(1);
      Vname->labelcolor((Fl_Color)64);
      Vname->align(Fl_Align(FL_ALIGN_CENTER));
      Vname->end();
    } // Fl_Group* Vname
    ADnoteVoiceParameters->resizable(ADnoteVoiceParameters);
    ADnoteVoiceParameters->end();
  } // Fl_Group* ADnoteVoiceParameters
  return ADnoteVoiceParameters;
}

ADvoiceUI::ADvoiceUI(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  //
          nvoice = 0;
          pars = NULL;
          oscedit = NULL;
          lastWaveW = 0;
          ;
}

void ADvoiceUI::send_data(int action, int control, float value, int type) {
  //
      type |= TOPLEVEL::type::Write;
      collect_writeData(synth, value, action, type, control, npart, kititem, nvoice + PART::engine::addVoice1);
      ;
}

void ADvoiceUI::returns_update(CommandBlock *getData) {
  //
      float value = getData->data.value;
      unsigned char control = getData->data.control;
      unsigned char voice = getData->data.engine;
      //std::cout << "voice " << int(voice) << "   nvoice " << int(nvoice) << std::endl;
      if (voice >= PART::engine::addMod1)
          voice -= PART::engine::addMod1;
      else if (voice >= PART::engine::addVoice1)
          voice -= PART::engine::addVoice1;
      int tmp;
      bool val_bool = _SYS_::F2B(value);
      if (control != ADDVOICE::control::enableVoice &&  voice != nvoice)
          return;

      switch(control)
      {
          case ADDVOICE::control::volume:
              voicevolume->value(value);
              voicevolume->selection_color(setKnob(value,100));
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicevolume->value(value);
                  synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicevolume->selection_color(setSlider(value,100));
              break;

          case ADDVOICE::control::velocitySense:
              voicevsns->value(value);
              voicevsns->selection_color(setKnob(value,127));
              break;

          case ADDVOICE::control::panning:
              voicepan->value(value);
              voicepan->selection_color(setKnob(value,64));
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicepanning->value(value);
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicepanning->selection_color(setKnob(value,64));
              break;

          case ADDVOICE::control::enableRandomPan:
              voicerandompan->value(val_bool);
              if (val_bool)
                  voicewidth->activate();
              else
                  voicewidth->deactivate();
              break;

          case ADDVOICE::control::randomWidth:
              voicewidth->value(value);
              voicewidth->selection_color(setKnob(value,63));
              break;

          case ADDVOICE::control::invertPhase:
              VolumeMinus->value(val_bool);
              break;

          case ADDVOICE::control::enableAmplitudeEnvelope:
              AmpEnvEn->value(val_bool);
              if (val_bool == 0)
                      voiceampenvgroup->deactivate();
                  else
                      voiceampenvgroup->activate();
              break;

          case ADDVOICE::control::enableAmplitudeLFO:
              AmpLfoEn->value(val_bool);
              if (val_bool == 0)
                      voiceamplfogroup->deactivate();
                  else
                      voiceamplfogroup->activate();
              break;

          case ADDVOICE::control::modulatorType:
              ModType->value((int)value);
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->update_modlabel();
              if (value == 0)
                      voiceFMparametersgroup->deactivate();
                  else
                      voiceFMparametersgroup->activate();
              break;

          case ADDVOICE::control::externalModulator:
              tmp = (int) value;
              ExtMod->value(tmp + 1);
              if (tmp >= 0)
              {
                  modoscil->deactivate();
              }
              else
              {
                  modoscil->activate();
              }
              voiceFMparametersgroup->redraw();
              update_fmoscil();
              oscFM->redraw();
              modoscil->redraw();
              modvoicelabel->do_callback();
              break;

          case ADDVOICE::control::detuneFrequency:
              if (voice == nvoice)
              {
                  Detune->value(value);
                  Detune->selection_color(setSlider(value,0));
                  detunevalueoutput->do_callback();
              }
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicedetune->value(value);
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicedetune->selection_color(setSlider(value,0));
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->detunevalueoutput->do_callback();
              break;

          case ADDVOICE::control::equalTemperVariation:
              fixedfreqetdial->value(value);
              fixedfreqetdial->selection_color(setKnob(value,0));
              break;

          case ADDVOICE::control::baseFrequencyAs440Hz:
              Freq440->value(val_bool);
              if (value == 0 && Mod440->value() == 0)
                  fixedfreqetdial->deactivate();
              else
                  fixedfreqetdial->activate();
              break;

          case ADDVOICE::control::octave:
              Octave->value((int) value);
              break;

          case ADDVOICE::control::detuneType:
              FreqDetunetype->value((int) value);
              detunevalueoutput->do_callback();
              break;

          case ADDVOICE::control::coarseDetune:
              CoarseDetune->value((int) value);
              break;

          case ADDVOICE::control::pitchBendAdjustment:
              bend->value(value);
              bend->selection_color(setKnob(value,88));
              break;

          case ADDVOICE::control::pitchBendOffset:
              offset->value(value);
              offset->selection_color(setKnob(value,64));
              break;

          case ADDVOICE::control::enableFrequencyEnvelope:
              FreqEn->value(val_bool);
              if (val_bool == 0)
                  voicefreqenvgroup->deactivate();
              else
                  voicefreqenvgroup->activate();
              break;

          case ADDVOICE::control::enableFrequencyLFO:
              FreqLfoEn->value(val_bool);
               if (val_bool == 0)
                   voicefreqlfogroup->deactivate();
               else
                   voicefreqlfogroup->activate();
              break;

          case ADDVOICE::control::unisonFrequencySpread:
              UnisonFreqSpread->value(value);
              UnisonFreqSpread->selection_color(setSlider(value,60));
              unisonspreadoutput->do_callback();
              break;

          case ADDVOICE::control::unisonPhaseRandomise:
              UnisonPhRnd->value(value);
              UnisonPhRnd->selection_color(setKnob(value,127));
              break;

          case ADDVOICE::control::unisonStereoSpread:
              UnisonStereo->value(value);
              UnisonStereo->selection_color(setKnob(value,64));
              break;

          case ADDVOICE::control::unisonVibratoDepth:
              UnisonVib->value(value);
              UnisonVib->selection_color(setKnob(value,64));
              break;

          case ADDVOICE::control::unisonVibratoSpeed:
              UnisonVspeed->value(value);
              UnisonVspeed->selection_color(setKnob(value,64));
              break;

          case ADDVOICE::control::unisonSize:
              {
                  tmp = int(value);
                  unisonsize->value(tmp);
                  unisongroup->redraw();
                  UnisonEn->redraw();
              }
              break;

          case ADDVOICE::control::unisonPhaseInvert:
              UnisonInvert->value(value);
              break;

          case ADDVOICE::control::enableUnison:
              UnisonEn->value(val_bool);
              if (val_bool == 0)
              {
                  unisonsize->value(2);
                  unisongroup->deactivate();
              }
              else
              {
                  unisongroup->activate();
                  unisongroup->redraw();
                  UnisonEn->redraw();
              }
              break;

          case ADDVOICE::control::enableFilter:
              FilterEn->value(val_bool);
              if (val_bool)
                    voicefiltergroup->activate();
                else
                    voicefiltergroup->deactivate();
                bypassfiltercheckbutton->redraw(); // yes it's needed!
              break;

          case ADDVOICE::control::bypassGlobalFilter:
              bypassfiltercheckbutton->value(val_bool);
              break;
          case ADDVOICE::control::enableFilterEnvelope:
              FilterEnvEn->value(val_bool);
              if (val_bool)
                  voicefilterenvgroup->activate();
              else
                  voicefilterenvgroup->deactivate();
              FilterEnvEn->redraw(); // yes it's needed!
              break;

          case ADDVOICE::control::enableFilterLFO:
              FilterLfoEn->value(val_bool);
              if (val_bool)
                  voicefilterlfogroup->activate();
              else
                  voicefilterlfogroup->deactivate();
              FilterLfoEn->redraw(); // yes it's needed!
              break;

          case ADDVOICE::control::modulatorAmplitude:
              ModVolume->value(value);
              ModVolume->selection_color(setSlider(ModVolume->value(),90));
              break;

          case ADDVOICE::control::modulatorVelocitySense:
              ModVsense->value(value);
              ModVsense->selection_color(setSlider(ModVsense->value(),64));
              break;

          case ADDVOICE::control::modulatorHFdamping:
              ModFdamp->value(value);
              ModFdamp->selection_color(setSlider(ModFdamp->value(),0));
              break;

          case ADDVOICE::control::enableModulatorAmplitudeEnvelope:
              ModAmpEn->value(val_bool);
              if (val_bool)
                  voiceFMampenvgroup->activate();
              else
                  voiceFMampenvgroup->deactivate();
              break;

          case ADDVOICE::control::modulatorDetuneFrequency:
              ModDetune->value(value);
              ModDetune->selection_color(setSlider(value,0));
              fmdetunevalueoutput->do_callback();
              break;

          case ADDVOICE::control::modulatorDetuneFromBaseOsc:
              detuneFromBaseOsc->value(value);
              break;


          case ADDVOICE::control::modulatorFrequencyAs440Hz:
              tmp = (val_bool);
              Mod440->value(tmp);
              if (tmp == 0 && lrint(Freq440->value() == 0))
                  fixedfreqetdial->deactivate();
              else
                  fixedfreqetdial->activate();
              if (tmp != 0)
                  detuneFromBaseOsc->deactivate();
              else
                  detuneFromBaseOsc->activate();
              break;
          case ADDVOICE::control::modulatorOctave:
              ModOctave->value((int) value);
              break;

          case ADDVOICE::control::modulatorDetuneType:
              ModDetuneType->value((int) value);
              fmdetunevalueoutput->do_callback();
              break;

          case ADDVOICE::control::modulatorCoarseDetune:
              ModCoarseDetune->value((int) value);
              break;

          case ADDVOICE::control::enableModulatorFrequencyEnvelope:
              ModFreqEn->value(val_bool);
              if (val_bool == 0)
                  voiceFMfreqenvgroup->deactivate();
              else
                  voiceFMfreqenvgroup->activate();
              break;

          case ADDVOICE::control::modulatorOscillatorPhase:
              ModPhase->value(value);
              oscFM->phase = 64 - lrint(value);
              ModPhase->selection_color(setSlider(ModPhase->value(),0));
              update_fmoscil();
              oscFM->redraw();
              modoscil->redraw();
              modvoicelabel->do_callback();
              break;

          case ADDVOICE::control::modulatorOscillatorSource:
              tmp = int(value);
              ExtModOsc->value(tmp + 1);
              if (tmp < 0)
              {
                  tmp = voice;
                  changeFMoscilbutton->labelcolor(gen_text);
              }
              else
                  changeFMoscilbutton->labelcolor(alt_warn_tex);
              update_fmoscil();
              voiceFMparametersgroup->redraw();
              oscFM->redraw();
              modoscil->redraw();
              modvoicelabel->do_callback();
              break;

          case ADDVOICE::control::delay:
              Delay->value(value);
              Delay->selection_color(setSlider(Delay->value(),0));
              break;

          case ADDVOICE::control::enableVoice:
              tmp = (val_bool);
              voiceonbutton->value(tmp);
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voiceenabled->value(tmp);
              synth->getGuiMaster()->partui->adnoteui->setVoiceTabs(voice, false);
              synth->getGuiMaster()->partui->adnoteui->setTabColour(voice);
              if (tmp)
              {
                  nvoice = voice;
                  voiceparametersgroup->activate();
                  synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicelistitemgroup->activate();
              }
              else
              {
                  voiceparametersgroup->deactivate();
                  synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voicelistitemgroup->deactivate();
              }
              voiceonbutton->redraw();
              synth->getGuiMaster()->partui->adnoteui->voiceTabBar->redraw();
              break;

          case ADDVOICE::control::enableResonance:
              tmp = (val_bool);
              if (voice == nvoice)
                  ResonanceEn->value(tmp);
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[voice]->voiceresonanceenabled->value(tmp);
              break;

          case ADDVOICE::control::voiceOscillatorPhase:
              tmp = (int)value;
              VoiceOscPhase->value(tmp);
              osc->phase = 64 - tmp;
              VoiceOscPhase->selection_color(setSlider(VoiceOscPhase->value(),0));
              update_voiceoscil();
              voiceoscil->redraw();
              osclabel->redraw();
              break;

          case ADDVOICE::control::voiceOscillatorSource:
              tmp = int(value);
              UseOsc->value(tmp + 1);
              if (tmp < 0)
              {
                  tmp = voice;
                  changevoiceoscilbutton->labelcolor(gen_text);
              }
              else
                  changevoiceoscilbutton->labelcolor(alt_warn_tex);
              changevoiceoscilbutton->redraw();
              update_voiceoscil();
              voiceoscil->redraw();
              update_osclabels();
              break;

          case ADDVOICE::control::soundType:
              tmp = lrint(value);
              SoundType->value(tmp);
              if (tmp)
                  voicemodegroup->deactivate();
              else
                  voicemodegroup->activate();
              update_voiceoscil();
              update_osclabels();
              synth->getGuiMaster()->partui->adnoteui->voicelistitem[nvoice]->refreshlist(nvoice);
              break;

          case ADDVOICE::control::externalOscillator:
              tmp = int(value);
              ExtOsc->value(tmp + 1);
              update_voiceoscil();
              update_osclabels();
              voiceoscil->redraw();
              break;
      }
      ;
}

void ADvoiceUI::paste() {
  //
          if (oscedit->osceditUI->visible())
          {
              oscedit->refresh();
          }
          ;
}

void ADvoiceUI::update_osclabels() {
  //
          int soundType = SoundType->value();
          char useOsc = UseOsc->value();
          char extOsc = ExtOsc->value();
      if (extOsc > 0)
      {
          char str[15];
          snprintf(str, sizeof(str), "Voice %d", extOsc);
          osclabel->copy_label(str);
          osclabel->labelcolor(ext_voice);
          osclabel->show();
          noiselabel->hide();
      }
      else if (soundType == 0 && useOsc > 0)
      {
          char str[15];
          snprintf(str, sizeof(str), "Osc. %d", useOsc);
          osclabel->copy_label(str);
          osclabel->labelcolor(ext_osc);
          osclabel->show();
          noiselabel->hide();
      }
      else if (soundType == 1)
      {
          noiselabel->copy_label("White Noise");
          noiselabel->labelcolor(7);
          noiselabel->show();
          osclabel->hide();
      }
      else if (soundType == 2)
      {
          noiselabel->copy_label("Pink Noise");
          noiselabel->labelcolor(5);
          noiselabel->show();
          osclabel->hide();
      }
      else if (soundType == 3)
      {
          noiselabel->copy_label("Spot Noise");
          noiselabel->labelcolor(6);
          noiselabel->show();
          osclabel->hide();
      }
      else
      {
          noiselabel->hide();
          osclabel->hide();
      }
       ;
}

void ADvoiceUI::update_modvoicelabel() {
  //
          int fmVoice = collect_readData(synth,0,ADDVOICE::control::externalModulator, npart, kititem, PART::engine::addVoice1 + nvoice);
          int fmExtOsc = collect_readData(synth,0,ADDVOICE::control::modulatorOscillatorSource, npart, kititem, PART::engine::addVoice1 + nvoice);
          if (fmVoice >= 0)
          {
              char str[15];
              snprintf(str, sizeof(str), "Voice %d",char(fmVoice) + 1);
              modvoicelabel->copy_label(str);
              modvoicelabel->labelcolor(ext_voice);
              modvoicelabel->show();
          }
          else if (fmExtOsc >= 0)
          {
              char str[15];
              snprintf(str, sizeof(str), "Mod. %d", char(fmExtOsc) + 1);
              modvoicelabel->copy_label(str);
              modvoicelabel->labelcolor(ext_osc);
              modvoicelabel->show();
          }
          else
          {
              modvoicelabel->hide();
          }
      ;
}

void ADvoiceUI::update_voiceoscil() {
  // updating
          int nvs = nvoice;
          int nvp = nvoice;

          voiceOscUpdate(synth, npart, kititem, nvoice, nvs, nvp);

          // we still need 'pars->' here :(
          oscil->changeParams(pars->VoicePar[nvs].POscil);

          osc->init(oscil,0,64-collect_readData(synth,0,ADDVOICE::control::voiceOscillatorPhase, npart, kititem, PART::engine::addVoice1 + nvoice),synth);

          if (collect_readData(synth,0,ADDVOICE::control::externalOscillator, npart, kititem, PART::engine::addVoice1 + nvoice) >= 0
              || collect_readData(synth,0,ADDVOICE::control::soundType, npart, kititem, PART::engine::addVoice1 + nvoice) > 0)

              voiceoscil->deactivate();
          else
              voiceoscil->activate();

          ;
}

void ADvoiceUI::update_fmoscil() {
  //
          int nv=nvoice;
          int fmVoice = collect_readData(synth,0,ADDVOICE::control::externalModulator, npart, kititem, PART::engine::addVoice1 + nvoice);
          int fmExtOsc = collect_readData(synth,0,ADDVOICE::control::modulatorOscillatorSource, npart, kititem, PART::engine::addVoice1 + nvoice);
          if (fmVoice >= 0)
          {
              nv = fmVoice;
              while (collect_readData(synth,0,ADDVOICE::control::externalOscillator, npart, kititem, PART::engine::addVoice1 + nv) >= 0)
              {
                  nv = collect_readData(synth,0,ADDVOICE::control::externalOscillator, npart, kititem, PART::engine::addVoice1 + nv);
              }
              oscilFM->changeParams(pars->VoicePar[nv].POscil);
              oscFM->init(oscilFM,0,pars->VoicePar[nv].Poscilphase, synth);
          }
          else
          {
              if (fmExtOsc >= 0)
              {
                  nv = fmExtOsc;
              }
              oscilFM->changeParams(pars->VoicePar[nv].POscilFM);
              oscFM->init(oscilFM,0,pars->VoicePar[nvoice].PFMoscilphase, synth);
  	}
  	;
}

void ADvoiceUI::voiceRtext(float dScale) {
  //
      if (oscedit)
      {
          if (oscedit->osceditUI->visible() && lastWaveW != oscedit->osceditUI->w())
          {
              lastWaveW = oscedit->osceditUI->w();
              oscedit->waveRtext();
          }
      }
      voiceampenvgroup->wincheck();
      voicefilterenvgroup->wincheck();
      voicefreqenvgroup->wincheck();

      voiceFMampenvgroup->wincheck();
      voiceFMfreqenvgroup->wincheck();

      if (!ADnoteVoiceParameters->visible())
          return;

      if (dScale == lastdScale)
          return;

      voiceamplfogroup->lfoRtext(dScale);
      voiceampenvgroup->envRtext(dScale);

      voicefilterlfogroup->lfoRtext(dScale);
      voicefilterenvgroup->envRtext(dScale);

      voicefreqlfogroup->lfoRtext(dScale);
      voicefreqenvgroup->envRtext(dScale);

      voicefilter->filterRtext(dScale);

      lastdScale = dScale;

      int size = int(10 * dScale);
      int size11 = int(11 * dScale);
      int size12 = int(12 * dScale);
      int size14 = int(14 * dScale);

      voiceonbutton->labelsize(size14);
      Vname->labelsize(size14);

      ResonanceEn->labelsize(size11);
      ampVoiceLabel->labelsize(size);
      voicevolume->labelsize(size);
      voicevsns->labelsize(size);
      voicepan->labelsize(size);
      voicewidth->labelsize(size);
      voicerandompan->labelsize(size11);
      AmpEnvEn->labelsize(size);
      AmpLfoEn->labelsize(size);
      VolumeMinus->labelsize(size);

      voicefiltergroup->labelsize(size12);
      FilterEnvEn->labelsize(size);
      FilterLfoEn->labelsize(size);

      Delay->labelsize(size11);
      bypassfiltercheckbutton->labelsize(size12);
      FilterEn->labelsize(size);

      freqencygrp->labelsize(size12);
      FreqEn->labelsize(size);
      FreqLfoEn->labelsize(size);
      voiceoctavetext->labelsize(size);
          Octave->textsize(size11);
      CoarseDetune->labelsize(size);
         CoarseDetune->textsize(size11);
      detunevalueoutput->labelsize(size);
          detunevalueoutput->textsize(size);
      FreqDetunetype->labelsize(size);
          FreqDetunetype->textsize(size11);
      bend->labelsize(size);
      Freq440->labelsize(size11);
      fixedfreqetdial->labelsize(size);
      offset->labelsize(size);

      unisonsize->labelsize(size);
          unisonsize->textsize(size11);
      UnisonStereo->labelsize(size);
      UnisonVib->labelsize(size);
      UnisonFreqSpread->labelsize(size);
      unisonspreadoutput->labelsize(size);
          unisonspreadoutput->textsize(size11);
      UnisonVspeed->labelsize(size);
      UnisonPhRnd->labelsize(size);
      UnisonInvert->labelsize(size);
          UnisonInvert->textsize(size11);
      UnisonEn->labelsize(size);
      unisName->labelsize(size12);

      extvoicegroup->labelsize(size12);
      ExtOsc->labelsize(size);
          ExtOsc->textsize(size);
      SoundType->labelsize(size);
          SoundType->textsize(size);

      oscParamBox->labelsize(size12);
      UseOsc->labelsize(size);
          UseOsc->textsize(size);
      changevoiceoscilbutton->labelsize(size);
      VoiceOscPhase->labelsize(size);

      noiselabel->labelsize(int(50 * dScale));
      osclabel->labelsize(int(50 * dScale));

      voiceFMparametersgroup->labelsize(size12);
      voiceFMampenvgroup->envRtext(dScale);
      voiceFMfreqenvgroup->envRtext(dScale);

      ExtMod->labelsize(size11);
          ExtMod->textsize(size14);

      Modampgrp->labelsize(size11);
      ModVolume->labelsize(size11);
          ModVolume->textsize(size);
      ModVsense->labelsize(size11);
          ModVsense->textsize(size);
      ModFdamp->labelsize(size11);
          ModFdamp->textsize(size);
      ModAmpEn->labelsize(size);

      modfrequency->labelsize(size11);
      ModCoarseDetune->labelsize(size);
          ModCoarseDetune->textsize(size);
      modoctavetext->labelsize(size);
          ModOctave->textsize(size);
      fmdetunevalueoutput->labelsize(size);
          fmdetunevalueoutput->textsize(size);
      detuneFromBaseOsc->labelsize(size11);
      Mod440->labelsize(size11);
      ModDetuneType->labelsize(size);
          ModDetuneType->textsize(size11);

      ModFreqEn->labelsize(size);

      modtypetext->labelsize(size11);
          ModType->textsize(size14);

      ModLocalOsc->labelsize(size12);
      changeFMoscilbutton->labelsize(size);
      ModPhase->labelsize(size);
      ExtModOsc->labelsize(size);
          ExtModOsc->textsize(size);

      modvoicelabel->labelsize(int(40 * dScale));

      ADnoteVoiceParameters->redraw();
}

void ADvoiceUI::voicetheme() {
  //
          if (oscedit)
          {
              if (oscedit->osceditUI->visible())
              {
                  oscedit->waveRtext();
              }
          }

          voiceampenvgroup->theme();
          voicefreqenvgroup->theme();
          voicefilterenvgroup->theme();
          voicefilter->theme();

          voiceFMampenvgroup->theme();
          voiceFMfreqenvgroup->theme();
          ;
}

void ADvoiceUI::init(ADnoteParameters *parameters,int npart_, int kititem_, int nvoice_) {
  //
          synth = & parameters->getSynthEngine();
          pars = parameters;
          npart = npart_;
          kititem = kititem_;
          nvoice = nvoice_;
          lastdScale = 0;
          fft = new fft::Calc(synth->oscilsize);
          oscil = new OscilGen(*fft, NULL, synth, parameters->VoicePar[nvoice].POscil);
          oscilFM = new OscilGen(*fft, NULL, synth, parameters->VoicePar[nvoice].POscilFM);
          make_window();
          end();
          if (nvoice == 0)
          {
              UseOsc->deactivate();
              ExtMod->deactivate();
              ExtModOsc->deactivate();
          }
          ADnoteVoiceParameters->show();
          ;
}

ADvoiceUI::~ADvoiceUI() {
  //
          ADnoteVoiceParameters->hide();
          hide();
          if (oscedit)
              delete oscedit;
          delete oscil;
          delete oscilFM;
          delete fft;
          ;
}

void ADvoicelistitem::cb_voiceenabled_i(Fl_Check_Button2* o, void*) {
  //
              bool enab = _SYS_::F2B(o->value());
              collect_writeData(synth, enab, TOPLEVEL::action::forceUpdate, (TOPLEVEL::type::Integer | TOPLEVEL::type::Write), ADDVOICE::control::enableVoice, npart, kititem, PART::engine::addVoice1 + nvoice);
              ;
}
void ADvoicelistitem::cb_voiceenabled(Fl_Check_Button2* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->user_data()))->cb_voiceenabled_i(o,v);
}

void ADvoicelistitem::cb_voicevolume1_i(mwheel_slider_rev* o, void*) {
  //
              int vol = lrint(o->value());
              o->selection_color(setSlider(vol,100));

              collect_writeData(synth, vol, TOPLEVEL::action::forceUpdate, (TOPLEVEL::type::Write | TOPLEVEL::type::Integer), ADDVOICE::control::volume, npart, kititem, PART::engine::addVoice1 + nvoice);
              ;
}
void ADvoicelistitem::cb_voicevolume1(mwheel_slider_rev* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicevolume1_i(o,v);
}

void ADvoicelistitem::cb_voiceresonanceenabled_i(Fl_Check_Button2* o, void*) {
  //
      bool enab = _SYS_::F2B(o->value());
      synth->getGuiMaster()->partui->adnoteui->advoice->ResonanceEn->value(enab);

      collect_writeData(synth, enab, 0, (TOPLEVEL::type::Write | TOPLEVEL::type::Integer), ADDVOICE::control::enableResonance, npart, kititem, PART::engine::addVoice1 + nvoice);
      ;
}
void ADvoicelistitem::cb_voiceresonanceenabled(Fl_Check_Button2* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voiceresonanceenabled_i(o,v);
}

void ADvoicelistitem::cb_voicelistvibratto_i(mwheel_slider_rev* o, void*) {
  //
              int lfodepth = lrint(o->value());
              o->selection_color(setSlider(lfodepth,40));

              collect_writeData(synth, lfodepth, TOPLEVEL::action::forceUpdate, (TOPLEVEL::type::Write | TOPLEVEL::type::Integer), 1, npart, kititem, PART::engine::addVoice1 + nvoice, 0, 1);
              ;
}
void ADvoicelistitem::cb_voicelistvibratto(mwheel_slider_rev* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicelistvibratto_i(o,v);
}

void ADvoicelistitem::cb_voicepanning_i(WidgetPDial* o, void*) {
  //
              int panning = lrint(o->value());
              o->selection_color(setKnob(panning,64));

              collect_writeData(synth, panning, TOPLEVEL::action::forceUpdate, (TOPLEVEL::type::Write | TOPLEVEL::type::Integer), ADDVOICE::control::panning, npart, kititem, PART::engine::addVoice1 + nvoice);
              ;
}
void ADvoicelistitem::cb_voicepanning(WidgetPDial* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicepanning_i(o,v);
}

void ADvoicelistitem::cb_voiceoscil_i(Fl_Group*, void*) {
  //
      update_voiceoscil();
      ;
}
void ADvoicelistitem::cb_voiceoscil(Fl_Group* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voiceoscil_i(o,v);
}

void ADvoicelistitem::cb_noiselabel1_i(Fl_Box*, void*) {
  //
      int tmp = collect_readData(synth,0,ADDVOICE::control::soundType,npart,kititem,PART::engine::addVoice1 + nvoice);
      update_noiselabel();
      if (tmp == 0)
      {
          voiceresonanceenabled->activate();
          detunevalueoutput->activate();
          voicedetune->activate();
          return;
      }
      voiceresonanceenabled->deactivate();
      detunevalueoutput->deactivate();
      voicedetune->deactivate();
      ;
}
void ADvoicelistitem::cb_noiselabel1(Fl_Box* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_noiselabel1_i(o,v);
}

void ADvoicelistitem::cb_modoscil_i(Fl_Group*, void*) {
  //
  	update_modoscil();
  	;
}
void ADvoicelistitem::cb_modoscil(Fl_Group* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_modoscil_i(o,v);
}

void ADvoicelistitem::cb_modlabel_i(Fl_Box*, void*) {
  //
                  update_modlabel();
                  ;
}
void ADvoicelistitem::cb_modlabel(Fl_Box* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_modlabel_i(o,v);
}

void ADvoicelistitem::cb_voicedetune_i(mwheel_slider_rev* o, void*) {
  //
              int detune = lrint(o->value());
              o->selection_color(setSlider(detune,0));
              collect_writeData(synth, detune, TOPLEVEL::action::forceUpdate, TOPLEVEL::type::Write, ADDVOICE::control::detuneFrequency, npart, kititem, PART::engine::addVoice1 + nvoice);
              ;
}
void ADvoicelistitem::cb_voicedetune(mwheel_slider_rev* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_voicedetune_i(o,v);
}

void ADvoicelistitem::cb_detunevalueoutput1_i(Fl_Value_Output* o, void*) {
  //
                int detType = collect_readData(synth, 0, ADDVOICE::control::detuneType, npart, kititem, PART::engine::addVoice1 + nvoice);
  	o->value(getDetune((detType == 0) ? (collect_readData(synth, 0, ADDSYNTH::detuneType, npart, kititem, PART::engine::addSynth)) : (detType), 0, collect_readData(synth, 0, ADDVOICE::control::detuneFrequency, npart, kititem, PART::engine::addVoice1 + nvoice) + 8192) * collect_readData(synth, 0, ADDSYNTH::control::bandwidthMultiplier, npart, kititem, PART::engine::addSynth));
  	;
}
void ADvoicelistitem::cb_detunevalueoutput1(Fl_Value_Output* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_detunevalueoutput1_i(o,v);
}

void ADvoicelistitem::cb_itemedit_i(Fl_Button*, void*) {
  //
                synth->getGuiMaster()->partui->adnoteui->setVoiceTabs(nvoice);
                synth->getGuiMaster()->partui->adnoteui->set_voice(true);
                if ((Fl::event_button() == 3))
                    synth->getGuiMaster()->partui->adnoteui->ADnoteVoiceList->hide();
                ;
}
void ADvoicelistitem::cb_itemedit(Fl_Button* o, void* v) {
  ((ADvoicelistitem*)(o->parent()->parent()->user_data()))->cb_itemedit_i(o,v);
}

Fl_Group* ADvoicelistitem::make_window() {
  { ADnoteVoiceListItem = new Fl_Group(0, 0, 635, 30);
    ADnoteVoiceListItem->box(FL_GTK_THIN_UP_BOX);
    ADnoteVoiceListItem->color(FL_BACKGROUND_COLOR);
    ADnoteVoiceListItem->selection_color(FL_BACKGROUND_COLOR);
    ADnoteVoiceListItem->labeltype(FL_NO_LABEL);
    ADnoteVoiceListItem->labelfont(0);
    ADnoteVoiceListItem->labelsize(14);
    ADnoteVoiceListItem->labelcolor((Fl_Color)64);
    ADnoteVoiceListItem->user_data((void*)(this));
    ADnoteVoiceListItem->align(Fl_Align(FL_ALIGN_TOP));
    ADnoteVoiceListItem->when(FL_WHEN_RELEASE);
    { Fl_Group* o = enabledpatch = new Fl_Group(4, 4, 34, 18, "1");
      enabledpatch->box(FL_UP_BOX);
      enabledpatch->labelfont(2);
      enabledpatch->labelcolor((Fl_Color)226);
      enabledpatch->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      char tmp[12]; snprintf(tmp, 12, "%d", nvoice + 1); o->label(strdup(tmp));
      enabledpatch->end();
    } // Fl_Group* enabledpatch
    { Fl_Check_Button2* o = voiceenabled = new Fl_Check_Button2(18, 7, 15, 15);
      voiceenabled->box(FL_NO_BOX);
      voiceenabled->down_box(FL_DOWN_BOX);
      voiceenabled->color(FL_BACKGROUND_COLOR);
      voiceenabled->selection_color((Fl_Color)64);
      voiceenabled->labeltype(FL_EMBOSSED_LABEL);
      voiceenabled->labelfont(0);
      voiceenabled->labelsize(14);
      voiceenabled->labelcolor((Fl_Color)64);
      voiceenabled->callback((Fl_Callback*)cb_voiceenabled);
      voiceenabled->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      voiceenabled->when(FL_WHEN_RELEASE);
      o->value(collect_readData(synth,0,ADDVOICE::control::enableVoice, npart, kititem, PART::engine::addVoice1 + nvoice));
    } // Fl_Check_Button2* voiceenabled
    { Fl_Group* o = voicelistitemgroup = new Fl_Group(38, 1, 593, 25);
      voicelistitemgroup->box(FL_FLAT_BOX);
      voicelistitemgroup->labelcolor((Fl_Color)64);
      { mwheel_slider_rev* o = voicevolume = new mwheel_slider_rev(155, 4, 122, 20);
        voicevolume->tooltip("Volume");
        voicevolume->type(5);
        voicevolume->box(FL_THIN_DOWN_BOX);
        voicevolume->color(FL_BACKGROUND_COLOR);
        voicevolume->selection_color(FL_BACKGROUND_COLOR);
        voicevolume->labeltype(FL_NORMAL_LABEL);
        voicevolume->labelfont(0);
        voicevolume->labelsize(8);
        voicevolume->labelcolor((Fl_Color)64);
        voicevolume->maximum(127);
        voicevolume->step(1);
        voicevolume->textcolor((Fl_Color)64);
        voicevolume->callback((Fl_Callback*)cb_voicevolume1);
        voicevolume->align(Fl_Align(FL_ALIGN_BOTTOM));
        voicevolume->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDVOICE::control::volume, npart, kititem, PART::engine::addVoice1 + nvoice));
        o->selection_color(setSlider(o->value(),100));
        o->setValueType(VC_ADDVoiceVolume);o->useCustomTip(true);
      } // mwheel_slider_rev* voicevolume
      { Fl_Check_Button2* o = voiceresonanceenabled = new Fl_Check_Button2(305, 5, 15, 17);
        voiceresonanceenabled->tooltip("Resonance On/Off");
        voiceresonanceenabled->box(FL_NO_BOX);
        voiceresonanceenabled->down_box(FL_DOWN_BOX);
        voiceresonanceenabled->color(FL_BACKGROUND_COLOR);
        voiceresonanceenabled->selection_color((Fl_Color)64);
        voiceresonanceenabled->labeltype(FL_EMBOSSED_LABEL);
        voiceresonanceenabled->labelfont(1);
        voiceresonanceenabled->labelsize(11);
        voiceresonanceenabled->labelcolor((Fl_Color)64);
        voiceresonanceenabled->callback((Fl_Callback*)cb_voiceresonanceenabled);
        voiceresonanceenabled->align(Fl_Align(FL_ALIGN_LEFT));
        voiceresonanceenabled->when(FL_WHEN_RELEASE);
        o->value(collect_readData(synth,0, ADDVOICE::control::enableResonance, npart, kititem, PART::engine::addVoice1 + nvoice));
      } // Fl_Check_Button2* voiceresonanceenabled
      { mwheel_slider_rev* o = voicelistvibratto = new mwheel_slider_rev(535, 4, 95, 20);
        voicelistvibratto->tooltip("Frequency LFO amount");
        voicelistvibratto->type(5);
        voicelistvibratto->box(FL_THIN_DOWN_BOX);
        voicelistvibratto->color(FL_BACKGROUND_COLOR);
        voicelistvibratto->selection_color(FL_BACKGROUND_COLOR);
        voicelistvibratto->labeltype(FL_NORMAL_LABEL);
        voicelistvibratto->labelfont(0);
        voicelistvibratto->labelsize(8);
        voicelistvibratto->labelcolor((Fl_Color)64);
        voicelistvibratto->maximum(127);
        voicelistvibratto->step(1);
        voicelistvibratto->textcolor((Fl_Color)64);
        voicelistvibratto->callback((Fl_Callback*)cb_voicelistvibratto);
        voicelistvibratto->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        voicelistvibratto->when(FL_WHEN_CHANGED);
        voicelistvibratto->deactivate();
        o->value(collect_readData(synth, 0, LFOINSERT::control::depth, npart, kititem, PART::engine::addVoice1 + nvoice, 0, 1));
        o->setValueType(VC_LFOdepthFreq);o->useCustomTip(true);
        o->selection_color(setSlider(o->value(),40));
      } // mwheel_slider_rev* voicelistvibratto
      { WidgetPDial* o = voicepanning = new WidgetPDial(282, 4, 20, 20);
        voicepanning->tooltip("Voice panning");
        voicepanning->box(FL_ROUND_UP_BOX);
        voicepanning->color(FL_BACKGROUND_COLOR);
        voicepanning->selection_color(FL_INACTIVE_COLOR);
        voicepanning->labeltype(FL_NORMAL_LABEL);
        voicepanning->labelfont(0);
        voicepanning->labelsize(10);
        voicepanning->labelcolor((Fl_Color)64);
        voicepanning->maximum(127);
        voicepanning->step(1);
        voicepanning->callback((Fl_Callback*)cb_voicepanning);
        voicepanning->align(Fl_Align(FL_ALIGN_LEFT));
        voicepanning->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PanningStd);
        o->value(collect_readData(synth, 0,ADDVOICE::control::panning, npart, kititem, PART::engine::addVoice1 + nvoice));
        o->selection_color(setSlider(o->value(),64));
      } // WidgetPDial* voicepanning
      { Fl_Group* o = voiceoscil = new Fl_Group(88, 4, 30, 20);
        voiceoscil->box(FL_THIN_DOWN_FRAME);
        voiceoscil->color(FL_GRAY0);
        voiceoscil->labelcolor(FL_BACKGROUND_COLOR);
        voiceoscil->callback((Fl_Callback*)cb_voiceoscil);
        osc = new Oscilloscope(o->x(), o->y(), o->w(), o->h(), 20, "");
        update_voiceoscil();
        voiceoscil->end();
      } // Fl_Group* voiceoscil
      { noiselabel = new Fl_Box(93, 5, 20, 20, "N");
        noiselabel->labelfont(1);
        noiselabel->labelsize(13);
        noiselabel->labelcolor(FL_BACKGROUND2_COLOR);
        noiselabel->callback((Fl_Callback*)cb_noiselabel1);
      } // Fl_Box* noiselabel
      { Fl_Group* o = modoscil = new Fl_Group(122, 4, 30, 20);
        modoscil->box(FL_THIN_DOWN_FRAME);
        modoscil->color(FL_GRAY0);
        modoscil->labelcolor(FL_BACKGROUND_COLOR);
        modoscil->callback((Fl_Callback*)cb_modoscil);
        modosc = new Oscilloscope(o->x(), o->y(), o->w(), o->h(), 20, "");
        update_modoscil();
        modoscil->end();
      } // Fl_Group* modoscil
      { modlabel = new Fl_Box(127, 5, 20, 20, "N");
        modlabel->labelfont(1);
        modlabel->labelsize(13);
        modlabel->labelcolor(FL_BACKGROUND2_COLOR);
        modlabel->callback((Fl_Callback*)cb_modlabel);
      } // Fl_Box* modlabel
      { mwheel_slider_rev* o = voicedetune = new mwheel_slider_rev(365, 4, 164, 20);
        voicedetune->tooltip("Fine Detune (cents)");
        voicedetune->type(5);
        voicedetune->box(FL_THIN_DOWN_BOX);
        voicedetune->color(FL_BACKGROUND_COLOR);
        voicedetune->selection_color(FL_BACKGROUND_COLOR);
        voicedetune->labeltype(FL_NORMAL_LABEL);
        voicedetune->labelfont(0);
        voicedetune->labelsize(14);
        voicedetune->labelcolor((Fl_Color)64);
        voicedetune->minimum(-8192);
        voicedetune->maximum(8191);
        voicedetune->step(1);
        voicedetune->callback((Fl_Callback*)cb_voicedetune);
        voicedetune->align(Fl_Align(FL_ALIGN_BOTTOM));
        voicedetune->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth, 0, ADDVOICE::control::detuneFrequency, npart, kititem, PART::engine::addVoice1 + nvoice));
        o->selection_color(setSlider(o->value(),0));
      } // mwheel_slider_rev* voicedetune
      { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(326, 4, 40, 20);
        detunevalueoutput->box(FL_THIN_DOWN_BOX);
        detunevalueoutput->labelsize(10);
        detunevalueoutput->labelcolor((Fl_Color)64);
        detunevalueoutput->minimum(-5000);
        detunevalueoutput->maximum(5000);
        detunevalueoutput->textsize(11);
        detunevalueoutput->textcolor((Fl_Color)64);
        detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput1);
        detunevalueoutput->align(Fl_Align(FL_ALIGN_CENTER));
        detunevalueoutput->when(FL_WHEN_CHANGED | FL_WHEN_NOT_CHANGED);
        o->step(0.01, 1);
      } // Fl_Value_Output* detunevalueoutput
      { itemedit = new Fl_Button(42, 4, 40, 20, "Edit");
        itemedit->tooltip("Right click: also close this");
        itemedit->box(FL_GTK_THIN_UP_BOX);
        itemedit->color((Fl_Color)198);
        itemedit->labelfont(1);
        itemedit->labelsize(12);
        itemedit->labelcolor((Fl_Color)64);
        itemedit->callback((Fl_Callback*)cb_itemedit);
      } // Fl_Button* itemedit
      if (voiceenabled->value() == 0) o->deactivate();
      voicelistitemgroup->end();
    } // Fl_Group* voicelistitemgroup
    ADnoteVoiceListItem->end();
  } // Fl_Group* ADnoteVoiceListItem
  return ADnoteVoiceListItem;
}

ADvoicelistitem::ADvoicelistitem(int x,int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  //
      nvoice = 0;
      pars = NULL;
      ;
}

void ADvoicelistitem::init(ADnoteParameters *parameters, int npart_, int kititem_, int nvoice_) {
  //
      synth = & parameters->getSynthEngine();
      pars = parameters;
      npart = npart_;
      kititem = kititem_;
      nvoice = nvoice_;
      fft = new fft::Calc(synth->oscilsize);
      oscil = new OscilGen(*fft, NULL, synth, parameters->VoicePar[nvoice].POscil);
      oscilFM = new OscilGen(*fft, NULL, synth, parameters->VoicePar[nvoice].POscilFM);
      make_window();
      if (collect_readData(synth,0,ADDVOICE::control::enableFrequencyLFO, npart, kititem, PART::engine::addVoice1 + nvoice) > 0)
          voicelistvibratto->activate();
      else
          voicelistvibratto->deactivate();
      ADnoteVoiceListItem->show();
      end();
      ;
}

void ADvoicelistitem::refreshlist(int nvoice) {
  //
          // a lot missing from here :(
          voiceenabled->value(collect_readData(synth,0,ADDVOICE::control::enableVoice, npart, kititem, PART::engine::addVoice1 + nvoice));
          voiceresonanceenabled->value(collect_readData(synth,0,ADDVOICE::control::enableResonance, npart, kititem, PART::engine::addVoice1 + nvoice));
          voicevolume->value(collect_readData(synth,0,ADDVOICE::control::volume, npart, kititem, PART::engine::addVoice1 + nvoice));
              voicevolume->selection_color(setSlider(voicevolume->value(),100));
          voicedetune->value(collect_readData(synth,0,ADDVOICE::control::detuneFrequency, npart, kititem, PART::engine::addVoice1 + nvoice));
          voicedetune->selection_color(setSlider(voicedetune->value(),0));

          voicepanning->value(collect_readData(synth,0,ADDVOICE::control::panning, npart, kititem, PART::engine::addVoice1 + nvoice));
              voicepanning->selection_color(setKnob(voicepanning->value(),64));
          if (collect_readData(synth,0,ADDVOICE::control::enableFrequencyLFO, npart, kititem, PART::engine::addVoice1 + nvoice)==0)
              voicelistvibratto->deactivate();
          else
              voicelistvibratto->activate();
          // this line dips into the LFO code. needs to be handled differently.
          voicelistvibratto->value(pars->VoicePar[nvoice].FreqLfo->Pintensity);
              voicelistvibratto->selection_color(setKnob(voicelistvibratto->value(),40));

          synth->getGuiMaster()->partui->adnoteui->advoice->update_voiceoscil();

          if (voiceenabled->value() == 0)
          {
              voicelistitemgroup->deactivate();
          }
          else
          {
              voicelistitemgroup->activate();
          }
          detunevalueoutput->do_callback();
          voiceoscil->do_callback();
          noiselabel->do_callback();
          modoscil->do_callback();
          modlabel->do_callback();
          ADnoteVoiceListItem->redraw();
          ;
}

void ADvoicelistitem::update_voiceoscil() {
  // this is identical to code in // updating
          int nvs = nvoice;
          int nvp = nvoice;

          voiceOscUpdate(synth, npart, kititem, nvoice, nvs, nvp);

          // we still need 'pars->' here :(
          oscil->changeParams(pars->VoicePar[nvs].POscil);

          osc->init(oscil,0,64-collect_readData(synth,0,ADDVOICE::control::voiceOscillatorPhase, npart, kititem, PART::engine::addVoice1 + nvoice),synth);

          if (collect_readData(synth,0,ADDVOICE::control::externalOscillator, npart, kititem, PART::engine::addVoice1 + nvoice) >= 0
              || collect_readData(synth,0,ADDVOICE::control::soundType, npart, kititem, PART::engine::addVoice1 + nvoice) > 0)

              voiceoscil->deactivate();
          else
              voiceoscil->activate();

          ;
}

void ADvoicelistitem::update_noiselabel() {
  //
          int extVoice = collect_readData(synth, 0, ADDVOICE::control::externalOscillator, npart, kititem, PART::engine::addVoice1 + nvoice);
          int extOsc = collect_readData(synth, 0, ADDVOICE::control::voiceOscillatorSource, npart, kititem, PART::engine::addVoice1 + nvoice);
          int type = collect_readData(synth, 0, ADDVOICE::control::soundType, npart, kititem, PART::engine::addVoice1 + nvoice);

          bool showNoise = true;
          if (extVoice >= 0)
          {
              char str[15];
              snprintf(str, sizeof(str), "V%d", extVoice + 1);
              noiselabel->copy_label(str);
              noiselabel->labelcolor(ext_voice);
          }
          else if (extOsc >= 0)
          {
              char str[15];
              snprintf(str, sizeof(str), "O%d", extOsc + 1);
              noiselabel->copy_label(str);
              noiselabel->labelcolor(ext_osc);
          }
          else
          {
              noiselabel->copy_label("N");
              switch (type)
              {
                  case 1:
                      noiselabel->labelcolor(7);
                      break;
                  case 2:
                      noiselabel->labelcolor(5);
                      break;
                  case 3:
                      noiselabel->labelcolor(6);
                      break;
                  default:
                      showNoise = false;
              }
          }
          if (showNoise)
              noiselabel->show();
          else
              noiselabel->hide();
          ;
}

void ADvoicelistitem::update_modoscil() {
  // this is identical to code in // updating
          int nvs = nvoice;
          int nvp = nvoice;

          voiceOscUpdate(synth, npart, kititem, nvoice, nvs, nvp);

          // we still need 'pars->' here :(
          oscilFM->changeParams(pars->VoicePar[nvs].POscil);

          modosc->init(oscilFM,0,64-collect_readData(synth,0,ADDVOICE::control::modulatorOscillatorPhase, npart, kititem, PART::engine::addVoice1 + nvoice),synth);

          if (collect_readData(synth,0,ADDVOICE::control::modulatorType, npart, kititem, PART::engine::addVoice1 + nvoice) == NONE
              || collect_readData(synth,0,ADDVOICE::control::externalModulator, npart, kititem, PART::engine::addVoice1 + nvoice) >= 0)

              modoscil->deactivate();
          else
              modoscil->activate();

          ;
}

void ADvoicelistitem::update_modlabel() {
  //
          if (collect_readData(synth,0,ADDVOICE::control::modulatorType, npart, kititem, PART::engine::addVoice1 + nvoice) == NONE)
          {
              modlabel->copy_label("OFF");
              modlabel->labelcolor(41);
              modlabel->deactivate();
              modlabel->show();
          }
          else
          {
              modlabel->activate();
              int voice = collect_readData(synth,0,ADDVOICE::control::externalModulator, npart, kititem, PART::engine::addVoice1 + nvoice);
              int osc = collect_readData(synth,0,ADDVOICE::control::modulatorOscillatorSource, npart, kititem, PART::engine::addVoice1 + nvoice);

              if (voice >= 0)
              {
                  char str[15];
                  snprintf(str, sizeof(str), "V%d", voice + 1);
                  modlabel->copy_label(str);
                  modlabel->labelcolor(ext_voice);
                  modlabel->show();
              }
              else if (osc >= 0)
              {
                  char str[15];
                  snprintf(str, sizeof(str), "M%d", osc + 1);
                  modlabel->copy_label(str);
                  modlabel->labelcolor(ext_osc);
                  modlabel->show();
              }
              else
              {
                  modlabel->hide();
              }
          }
          ;
}

void ADvoicelistitem::itemRtext(float dScale) {
  //

          int size11 = int(11 * dScale);
          int size12 = int(12 * dScale);
          int size14 = int(14 * dScale);

          voiceresonanceenabled->labelsize(size11);
          voiceoscil->labelsize(size14);
          noiselabel->labelsize(size14);
          modoscil->labelsize(size14);
          modlabel->labelsize(size14);
          detunevalueoutput->textsize(size11);
          itemedit->labelsize(size12);
          voiceenabled->labelsize(size12);
          enabledpatch->size(34 * dScale, 18 * dScale);
          enabledpatch->labelsize(size14);
          ;
}

ADvoicelistitem::~ADvoicelistitem() {
  //
          ADnoteVoiceListItem->hide();
          delete oscil;
          delete oscilFM;
          delete fft;
          ;
}

void ADnoteUI::cb_ADnoteGlobalParameters_i(ScaleTrackedWindow* o, void*) {
  //
          saveWin(synth,  ADnoteGlobalParameters->w(),  ADnoteGlobalParameters->h(), ADnoteGlobalParameters->x(), ADnoteGlobalParameters->y(), false, "AddSynth");
          globalSeen = false;
          resui->resonancewindow->hide();
          o->hide();
          ;
}
void ADnoteUI::cb_ADnoteGlobalParameters(ScaleTrackedWindow* o, void* v) {
  ((ADnoteUI*)(o->user_data()))->cb_ADnoteGlobalParameters_i(o,v);
}

void ADnoteUI::cb_octave_i(Fl_Counter* o, void*) {
  //
              send_data(0, ADDSYNTH::control::octave, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_octave(Fl_Counter* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_octave_i(o,v);
}

void ADnoteUI::cb_coarsedet_i(Fl_Counter* o, void*) {
  //
              send_data(0, ADDSYNTH::control::coarseDetune, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_coarsedet(Fl_Counter* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_coarsedet_i(o,v);
}

void ADnoteUI::cb_freq_i(mwheel_slider_rev* o, void*) {
  //
              o->selection_color(setSlider(o->value(),0));
              detunevalueoutput->do_callback();
              send_data(0, ADDSYNTH::control::detuneFrequency, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_freq(mwheel_slider_rev* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_freq_i(o,v);
}

void ADnoteUI::cb_detunetype_i(Fl_Choice* o, void*) {
  //
              send_data(0, ADDSYNTH::control::detuneType, o->value() + 1, TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_detunetype(Fl_Choice* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_detunetype_i(o,v);
}

void ADnoteUI::cb_detunevalueoutput2_i(Fl_Value_Output* o, void*) {
  //
      o->value(getDetune(detunetype->value()+1,0, freq->value()+8192));
      ;
}
void ADnoteUI::cb_detunevalueoutput2(Fl_Value_Output* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_detunevalueoutput2_i(o,v);
}

void ADnoteUI::cb_relBwidth_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),64));
              send_data(0, ADDSYNTH::control::relativeBandwidth, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_relBwidth(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_relBwidth_i(o,v);
}

void ADnoteUI::cb_globalvolume_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),90));
              send_data(0, ADDSYNTH::control::volume, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_globalvolume(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_globalvolume_i(o,v);
}

void ADnoteUI::cb_vsns_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),64));
              send_data(0, ADDSYNTH::control::velocitySense, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_vsns(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_vsns_i(o,v);
}

void ADnoteUI::cb_globalpan_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),64));
              send_data(0, ADDSYNTH::control::panning, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_globalpan(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_globalpan_i(o,v);
}

void ADnoteUI::cb_globalwidth_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),63));
              send_data(0, ADDSYNTH::control::randomWidth, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_globalwidth(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_globalwidth_i(o,v);
}

void ADnoteUI::cb_globalrandompan_i(Fl_Check_Button2* o, void*) {
  //
              int tmp = o->value();
              if (tmp == 0)
                  globalwidth->deactivate();
              else
                  globalwidth->activate();
              send_data(0, ADDSYNTH::control::enableRandomPan, tmp, TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_globalrandompan(Fl_Check_Button2* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_globalrandompan_i(o,v);
}

void ADnoteUI::cb_depop_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),20));
              send_data(0, ADDSYNTH::control::dePop, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_depop(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_depop_i(o,v);
}

void ADnoteUI::cb_pstr_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),0));
              send_data(0, ADDSYNTH::control::punchStrength, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_pstr(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pstr_i(o,v);
}

void ADnoteUI::cb_pt_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),60));
              send_data(0, ADDSYNTH::control::punchDuration, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_pt(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pt_i(o,v);
}

void ADnoteUI::cb_pstc_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),64));
              send_data(0, ADDSYNTH::control::punchStretch, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_pstc(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pstc_i(o,v);
}

void ADnoteUI::cb_pvel_i(WidgetPDial* o, void*) {
  //
              o->selection_color(setKnob(o->value(),72));
              send_data(0, ADDSYNTH::control::punchVelocity, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_pvel(WidgetPDial* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_pvel_i(o,v);
}

void ADnoteUI::cb_rndgrp_i(Fl_Check_Button2* o, void*) {
  //
              send_data(0, ADDSYNTH::control::randomGroup, o->value(), TOPLEVEL::type::Integer);
          ;
}
void ADnoteUI::cb_rndgrp(Fl_Check_Button2* o, void* v) {
  ((ADnoteUI*)(o->parent()->parent()->user_data()))->cb_rndgrp_i(o,v);
}

void ADnoteUI::cb_stereo_i(Fl_Check_Button2* o, void*) {
  //
              send_data(0, ADDSYNTH::control::stereo, o->value(), TOPLEVEL::type::Integer);
              ;
}
void ADnoteUI::cb_stereo(Fl_Check_Button2* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_stereo_i(o,v);
}

void ADnoteUI::cb_showvoicelist_i(Fl_Button*, void*) {
  //
              for (int i = 0; i < NUM_VOICES; ++i)
                  voicelistitem[i]->refreshlist(i);
              int fetchW, fetchH, fetchX, fetchY, fetchO;
              loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "AddSynth-list");

              if (fetchW < listDW || fetchH < listDH)
              {
                  fetchW = listDW;
                  fetchH = listDH;
              }
              checkSane(fetchX, fetchY,fetchW, fetchH, listDW, listDH);
              ADnoteVoiceList->resize(fetchX, fetchY,fetchW, fetchH);
              lastlistW = 0;
              ADnoteVoiceList->show();
              listSeen = true;


              if (Fl::event_button() == 3)
                  ADnoteGlobalParameters->hide();
              ;
}
void ADnoteUI::cb_showvoicelist(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_showvoicelist_i(o,v);
}

void ADnoteUI::cb_showvoicepars_i(Fl_Button*, void*) {
  //
              set_voice(false);
              if ((Fl::event_button() == 3))
                  ADnoteGlobalParameters->hide();
              ;
}
void ADnoteUI::cb_showvoicepars(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_showvoicepars_i(o,v);
}

void ADnoteUI::cb_globalclose_i(Fl_Button*, void*) {
  //
              saveWin(synth,  ADnoteGlobalParameters->w(),  ADnoteGlobalParameters->h(), ADnoteGlobalParameters->x(), ADnoteGlobalParameters->y(), false, "AddSynth");
              globalSeen = false;
              resui->resonancewindow->hide();
              ADnoteGlobalParameters->hide();
              if (Fl::event_button() == 3)
              {
                  if (synth->getGuiMaster()->partui->partKitOn)
                      synth->getGuiMaster()->partui->instrumentkitlist->show();
                  else
                      synth->getGuiMaster()->partui->instrumenteditwindow->show();
              }
              ;
}
void ADnoteUI::cb_globalclose(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_globalclose_i(o,v);
}

void ADnoteUI::cb_resonance_i(Fl_Button*, void*) {
  //
              resui->resonancewindow->redraw();
              resui->Show();
              if ((Fl::event_button() == 3))
                  ADnoteGlobalParameters->hide();
              ;
}
void ADnoteUI::cb_resonance(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_resonance_i(o,v);
}

void ADnoteUI::cb_globalcopy_i(Fl_Button*, void*) {
  //
          synth->getGuiMaster()->getPresetsUi()->Ucopy(npart, kititem, PART::engine::addSynth);
          ;
}
void ADnoteUI::cb_globalcopy(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_globalcopy_i(o,v);
}

void ADnoteUI::cb_globalpaste_i(Fl_Button*, void*) {
  //
              synth->getGuiMaster()->getPresetsUi()->Upaste(npart, kititem, PART::engine::addSynth);
              ;
}
void ADnoteUI::cb_globalpaste(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_globalpaste_i(o,v);
}

void ADnoteUI::cb_ADnoteVoice_i(ScaleTrackedWindow* o, void*) {
  //
          saveWin(synth, o->w(), o->h(), o->x(), o->y(), false,"AddSynth-voice");
          o->hide();
}
void ADnoteUI::cb_ADnoteVoice(ScaleTrackedWindow* o, void* v) {
  ((ADnoteUI*)(o->user_data()))->cb_ADnoteVoice_i(o,v);
}

void ADnoteUI::cb_Vclose_i(Fl_Button*, void*) {
  //
              ADnoteVoice->hide();
              saveWin(synth, ADnoteVoice->w(), ADnoteVoice->h(), ADnoteVoice->x(), ADnoteVoice->y(), false, "AddSynth-voice");
              voiceSeen = false;
              if (Fl::event_button() == 3)
              {
                  if (fromVoiceList)
                      ADnoteVoiceList->show();
                  else
                      ShowGlobal();
              }
}
void ADnoteUI::cb_Vclose(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Vclose_i(o,v);
}

void ADnoteUI::cb_Vcopy_i(Fl_Button*, void*) {
  //
              synth->getGuiMaster()->getPresetsUi()->Ucopy(npart, kititem, nvoice + PART::engine::addVoice1);
}
void ADnoteUI::cb_Vcopy(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Vcopy_i(o,v);
}

void ADnoteUI::cb_Vpaste_i(Fl_Button*, void*) {
  //
              synth->getGuiMaster()->getPresetsUi()->Upaste(npart, kititem, nvoice + PART::engine::addVoice1);
}
void ADnoteUI::cb_Vpaste(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_Vpaste_i(o,v);
}

void ADnoteUI::cb_g1_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(0, !o->value());
}
void ADnoteUI::cb_g1(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g1_i(o,v);
}

void ADnoteUI::cb_g2_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(1, !o->value());
}
void ADnoteUI::cb_g2(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g2_i(o,v);
}

void ADnoteUI::cb_g3_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(2, !o->value());
}
void ADnoteUI::cb_g3(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g3_i(o,v);
}

void ADnoteUI::cb_g4_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(3, !o->value());
}
void ADnoteUI::cb_g4(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g4_i(o,v);
}

void ADnoteUI::cb_g5_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(4, !o->value());
}
void ADnoteUI::cb_g5(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g5_i(o,v);
}

void ADnoteUI::cb_g6_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(5, !o->value());
}
void ADnoteUI::cb_g6(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g6_i(o,v);
}

void ADnoteUI::cb_g7_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(6, !o->value());
}
void ADnoteUI::cb_g7(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g7_i(o,v);
}

void ADnoteUI::cb_g8_i(Fl_Button* o, void*) {
  //
              setVoiceTabs(7, !o->value());
}
void ADnoteUI::cb_g8(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_g8_i(o,v);
}

void ADnoteUI::cb_ADnoteVoiceList_i(ScaleTrackedWindow* o, void*) {
  //
            if (listSeen)
                saveWin(synth, o->w(), o->h(), o->x(), o->y(), false,"AddSynth-list");
            listSeen = false;
            o->hide();
}
void ADnoteUI::cb_ADnoteVoiceList(ScaleTrackedWindow* o, void* v) {
  ((ADnoteUI*)(o->user_data()))->cb_ADnoteVoiceList_i(o,v);
}

void ADnoteUI::cb_listClose_i(Fl_Button*, void*) {
  //
              ADnoteVoiceList->hide();
              listSeen = false;
              saveWin(synth, ADnoteVoiceList->w(), ADnoteVoiceList->h(), ADnoteVoiceList->x(), ADnoteVoiceList->y(), false, "AddSynth-list");

              if (Fl::event_button() == 3)
                  ShowGlobal();
              ;
}
void ADnoteUI::cb_listClose(Fl_Button* o, void* v) {
  ((ADnoteUI*)(o->parent()->user_data()))->cb_listClose_i(o,v);
}

ScaleTrackedWindow* ADnoteUI::make_window() {
// globalrandompan MUST be after globalwidth
  { ScaleTrackedWindow* o = ADnoteGlobalParameters = new ScaleTrackedWindow(580, 405, "ADsynth Global Parameters of the Instrument");
    ADnoteGlobalParameters->box(FL_FLAT_BOX);
    ADnoteGlobalParameters->color(FL_BACKGROUND_COLOR);
    ADnoteGlobalParameters->selection_color(FL_BACKGROUND_COLOR);
    ADnoteGlobalParameters->labeltype(FL_NO_LABEL);
    ADnoteGlobalParameters->labelfont(0);
    ADnoteGlobalParameters->labelsize(14);
    ADnoteGlobalParameters->labelcolor(FL_FOREGROUND_COLOR);
    ADnoteGlobalParameters->callback((Fl_Callback*)cb_ADnoteGlobalParameters, (void*)(this));
    ADnoteGlobalParameters->align(Fl_Align(FL_ALIGN_TOP));
    ADnoteGlobalParameters->when(FL_WHEN_RELEASE);
    { globalfreq = new Fl_Group(5, 255, 570, 115, "FREQUENCY");
      globalfreq->box(FL_THIN_UP_BOX);
      globalfreq->labelfont(1);
      globalfreq->labelsize(12);
      globalfreq->labelcolor((Fl_Color)64);
      globalfreq->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = freqenv = new EnvelopeUI(10, 295, 205, 70, "Yoshimi : AddSynth Global - Frequency Envelope");
        freqenv->box(FL_FLAT_BOX);
        freqenv->color((Fl_Color)51);
        freqenv->selection_color(FL_BACKGROUND_COLOR);
        freqenv->labeltype(FL_NORMAL_LABEL);
        freqenv->labelfont(0);
        freqenv->labelsize(12);
        freqenv->labelcolor(FL_FOREGROUND_COLOR);
        freqenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        freqenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.FreqEnvelope, npart, kititem, PART::engine::addSynth, 1);
        freqenv->end();
      } // EnvelopeUI* freqenv
      { octavetext = new Fl_Text_Display(493, 275, 50, 8, "Octave");
        octavetext->box(FL_NO_BOX);
        octavetext->labelfont(3);
        octavetext->labelsize(10);
        octavetext->labelcolor((Fl_Color)226);
      } // Fl_Text_Display* octavetext
      { Fl_Counter* o = octave = new Fl_Counter(495, 275, 47, 13);
        octave->tooltip("Octave");
        octave->type(1);
        octave->selection_color(FL_BACKGROUND_COLOR);
        octave->labelfont(3);
        octave->labelsize(10);
        octave->minimum(-8);
        octave->maximum(7);
        octave->step(1);
        octave->textfont(1);
        octave->textsize(11);
        octave->textcolor((Fl_Color)64);
        octave->callback((Fl_Callback*)cb_octave);
        octave->align(Fl_Align(FL_ALIGN_TOP));
        int k = collect_readData(synth,0,ADDSYNTH::control::octave, npart, kititem, PART::engine::addSynth) / 1024; if (k >= 8) k -= 16;
        o->value(k);
      } // Fl_Counter* octave
      { Fl_Counter* o = coarsedet = new Fl_Counter(495, 346, 77, 13, "Coarse det.");
        coarsedet->tooltip("Coarse Detune");
        coarsedet->selection_color((Fl_Color)64);
        coarsedet->labelsize(10);
        coarsedet->labelcolor((Fl_Color)64);
        coarsedet->minimum(-64);
        coarsedet->maximum(63);
        coarsedet->step(1);
        coarsedet->textfont(1);
        coarsedet->textsize(11);
        coarsedet->textcolor((Fl_Color)64);
        coarsedet->callback((Fl_Callback*)cb_coarsedet);
        coarsedet->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        int k = collect_readData(synth, 0, ADDSYNTH::control::coarseDetune, npart, kititem, PART::engine::addSynth);
        o->value(k);
        o->lstep(10);
      } // Fl_Counter* coarsedet
      { LFOUI* o = freqlfo = new LFOUI(215, 295, 275, 70, "Frequency LFO");
        freqlfo->box(FL_FLAT_BOX);
        freqlfo->color(FL_DARK1);
        freqlfo->selection_color(FL_BACKGROUND_COLOR);
        freqlfo->labeltype(FL_NORMAL_LABEL);
        freqlfo->labelfont(0);
        freqlfo->labelsize(12);
        freqlfo->labelcolor(FL_FOREGROUND_COLOR);
        freqlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        freqlfo->when(FL_WHEN_RELEASE);
        o->init(synth, npart, kititem, PART::engine::addSynth, TOPLEVEL::insertType::frequency);
        freqlfo->end();
      } // LFOUI* freqlfo
      { mwheel_slider_rev* o = freq = new mwheel_slider_rev(57, 275, 433, 13);
        freq->tooltip("Fine Detune (cents)");
        freq->type(5);
        freq->box(FL_THIN_DOWN_BOX);
        freq->color(FL_BACKGROUND_COLOR);
        freq->selection_color(FL_BACKGROUND_COLOR);
        freq->labeltype(FL_NORMAL_LABEL);
        freq->labelfont(0);
        freq->labelsize(14);
        freq->labelcolor((Fl_Color)64);
        freq->minimum(-8192);
        freq->maximum(8191);
        freq->step(1);
        freq->callback((Fl_Callback*)cb_freq);
        freq->align(Fl_Align(FL_ALIGN_BOTTOM));
        freq->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth, 0, ADDSYNTH::detuneFrequency, npart, kititem, PART::engine::addSynth));
        o->selection_color(setSlider(o->value(),0));
      } // mwheel_slider_rev* freq
      { Fl_Choice* o = detunetype = new Fl_Choice(494, 313, 78, 14, "Detune Type");
        detunetype->down_box(FL_BORDER_BOX);
        detunetype->selection_color((Fl_Color)64);
        detunetype->labelsize(10);
        detunetype->labelcolor((Fl_Color)64);
        detunetype->textfont(1);
        detunetype->textsize(11);
        detunetype->textcolor((Fl_Color)64);
        detunetype->callback((Fl_Callback*)cb_detunetype);
        detunetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->add("L35 cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
        o->value(collect_readData(synth, 0, ADDSYNTH::detuneType, npart, kititem, PART::engine::addSynth)-1);
      } // Fl_Choice* detunetype
      { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(12, 275, 45, 13, "Detune");
        detunevalueoutput->labelsize(10);
        detunevalueoutput->labelcolor((Fl_Color)64);
        detunevalueoutput->minimum(-5000);
        detunevalueoutput->maximum(5000);
        detunevalueoutput->textfont(1);
        detunevalueoutput->textsize(10);
        detunevalueoutput->textcolor((Fl_Color)64);
        detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput2);
        detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        o->step(0.01, 1);
        o->value(getDetune(detunetype->value()+1, 0, freq->value()+8192));
      } // Fl_Value_Output* detunevalueoutput
      { WidgetPDial* o = relBwidth = new WidgetPDial(545, 270, 25, 25, "relBW");
        relBwidth->tooltip("Bandwidth - modify the relative fine detune of the voices");
        relBwidth->box(FL_ROUND_UP_BOX);
        relBwidth->color(FL_BACKGROUND_COLOR);
        relBwidth->selection_color(FL_INACTIVE_COLOR);
        relBwidth->labeltype(FL_NORMAL_LABEL);
        relBwidth->labelfont(0);
        relBwidth->labelsize(10);
        relBwidth->labelcolor((Fl_Color)64);
        relBwidth->maximum(127);
        relBwidth->step(1);
        relBwidth->callback((Fl_Callback*)cb_relBwidth);
        relBwidth->align(Fl_Align(FL_ALIGN_TOP));
        relBwidth->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDSYNTH::control::relativeBandwidth, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),64));
      } // WidgetPDial* relBwidth
      globalfreq->end();
    } // Fl_Group* globalfreq
    { Fl_Box* o = new Fl_Box(10, 7, 275, 68);
      o->box(FL_PLASTIC_UP_BOX);
      o->color(FL_CYAN);
    } // Fl_Box* o
    { amplitudegrp = new Fl_Group(5, 5, 285, 250);
      amplitudegrp->box(FL_THIN_UP_FRAME);
      amplitudegrp->labelfont(1);
      amplitudegrp->labelsize(12);
      amplitudegrp->labelcolor((Fl_Color)64);
      amplitudegrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { WidgetPDial* o = globalvolume = new WidgetPDial(30, 23, 35, 35, "Volume");
        globalvolume->tooltip("Volume");
        globalvolume->box(FL_ROUND_UP_BOX);
        globalvolume->color(FL_BACKGROUND_COLOR);
        globalvolume->selection_color(FL_INACTIVE_COLOR);
        globalvolume->labeltype(FL_NORMAL_LABEL);
        globalvolume->labelfont(0);
        globalvolume->labelsize(10);
        globalvolume->labelcolor((Fl_Color)64);
        globalvolume->maximum(127);
        globalvolume->step(1);
        globalvolume->callback((Fl_Callback*)cb_globalvolume);
        globalvolume->align(Fl_Align(FL_ALIGN_BOTTOM));
        globalvolume->when(FL_WHEN_CHANGED);
        o->setValueType(VC_InstrumentVolume);
        o->value(collect_readData(synth,0,ADDSYNTH::control::volume, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),90));
      } // WidgetPDial* globalvolume
      { WidgetPDial* o = vsns = new WidgetPDial(85, 23, 35, 35, "Vel Sens");
        vsns->tooltip("Velocity Sensing Function - rightmost/max to disable");
        vsns->box(FL_ROUND_UP_BOX);
        vsns->color(FL_BACKGROUND_COLOR);
        vsns->selection_color(FL_INACTIVE_COLOR);
        vsns->labeltype(FL_NORMAL_LABEL);
        vsns->labelfont(0);
        vsns->labelsize(10);
        vsns->labelcolor((Fl_Color)64);
        vsns->maximum(127);
        vsns->step(1);
        vsns->callback((Fl_Callback*)cb_vsns);
        vsns->align(Fl_Align(FL_ALIGN_BOTTOM));
        vsns->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDSYNTH::control::velocitySense, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),64));
        o->setValueType(VC_AmpVelocitySense);
      } // WidgetPDial* vsns
      { WidgetPDial* o = globalpan = new WidgetPDial(155, 23, 35, 35, "Pan");
        globalpan->tooltip("Global panning");
        globalpan->box(FL_ROUND_UP_BOX);
        globalpan->color(FL_BACKGROUND_COLOR);
        globalpan->selection_color(FL_INACTIVE_COLOR);
        globalpan->labeltype(FL_NORMAL_LABEL);
        globalpan->labelfont(0);
        globalpan->labelsize(10);
        globalpan->labelcolor((Fl_Color)64);
        globalpan->maximum(127);
        globalpan->step(1);
        globalpan->callback((Fl_Callback*)cb_globalpan);
        globalpan->align(Fl_Align(FL_ALIGN_BOTTOM));
        globalpan->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PanningStd);
        o->value(collect_readData(synth,0,ADDSYNTH::control::panning, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),64));
      } // WidgetPDial* globalpan
      { WidgetPDial* o = globalwidth = new WidgetPDial(235, 23, 35, 35, "Width");
        globalwidth->tooltip("Global random width");
        globalwidth->box(FL_ROUND_UP_BOX);
        globalwidth->color(FL_BACKGROUND_COLOR);
        globalwidth->selection_color(FL_INACTIVE_COLOR);
        globalwidth->labeltype(FL_NORMAL_LABEL);
        globalwidth->labelfont(0);
        globalwidth->labelsize(10);
        globalwidth->labelcolor((Fl_Color)64);
        globalwidth->maximum(63);
        globalwidth->step(1);
        globalwidth->value(63);
        globalwidth->callback((Fl_Callback*)cb_globalwidth);
        globalwidth->align(Fl_Align(FL_ALIGN_BOTTOM));
        globalwidth->when(FL_WHEN_CHANGED);
        o->setValueType(VC_PanningRandom);
        o->value(collect_readData(synth,0,ADDSYNTH::control::randomWidth, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),63));
      } // WidgetPDial* globalwidth
      { Fl_Check_Button2* o = globalrandompan = new Fl_Check_Button2(205, 32, 15, 15, "Rand");
        globalrandompan->tooltip("Enable random panning");
        globalrandompan->box(FL_NO_BOX);
        globalrandompan->down_box(FL_DOWN_BOX);
        globalrandompan->color((Fl_Color)48);
        globalrandompan->selection_color((Fl_Color)64);
        globalrandompan->labeltype(FL_NORMAL_LABEL);
        globalrandompan->labelfont(0);
        globalrandompan->labelsize(11);
        globalrandompan->labelcolor((Fl_Color)64);
        globalrandompan->callback((Fl_Callback*)cb_globalrandompan);
        globalrandompan->align(Fl_Align(FL_ALIGN_TOP));
        globalrandompan->when(FL_WHEN_RELEASE);
        o->value(collect_readData(synth,0,ADDSYNTH::control::enableRandomPan, npart, kititem, PART::engine::addSynth));
        if (o->value() == 0) globalwidth->deactivate(); else globalwidth->activate();
      } // Fl_Check_Button2* globalrandompan
      { WidgetPDial* o = depop = new WidgetPDial(130, 227, 25, 25, "D.Pop");
        depop->tooltip("Pop Suppression");
        depop->box(FL_ROUND_UP_BOX);
        depop->color(FL_BACKGROUND_COLOR);
        depop->selection_color(FL_INACTIVE_COLOR);
        depop->labeltype(FL_NORMAL_LABEL);
        depop->labelfont(0);
        depop->labelsize(10);
        depop->labelcolor((Fl_Color)64);
        depop->maximum(127);
        depop->step(1);
        depop->callback((Fl_Callback*)cb_depop);
        depop->align(Fl_Align(FL_ALIGN_TOP));
        depop->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDSYNTH::control::dePop, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),20));
      } // WidgetPDial* depop
      { WidgetPDial* o = pstr = new WidgetPDial(170, 227, 25, 25, "P.Str.");
        pstr->tooltip("Punch Strength");
        pstr->box(FL_ROUND_UP_BOX);
        pstr->color(FL_BACKGROUND_COLOR);
        pstr->selection_color(FL_INACTIVE_COLOR);
        pstr->labeltype(FL_NORMAL_LABEL);
        pstr->labelfont(0);
        pstr->labelsize(10);
        pstr->labelcolor((Fl_Color)64);
        pstr->maximum(127);
        pstr->step(1);
        pstr->callback((Fl_Callback*)cb_pstr);
        pstr->align(Fl_Align(FL_ALIGN_TOP));
        pstr->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDSYNTH::control::punchStrength, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),0));
      } // WidgetPDial* pstr
      { WidgetPDial* o = pt = new WidgetPDial(200, 227, 25, 25, "P.t.");
        pt->tooltip("Punch Time (duration)");
        pt->box(FL_ROUND_UP_BOX);
        pt->color(FL_BACKGROUND_COLOR);
        pt->selection_color(FL_INACTIVE_COLOR);
        pt->labeltype(FL_NORMAL_LABEL);
        pt->labelfont(0);
        pt->labelsize(10);
        pt->labelcolor((Fl_Color)64);
        pt->maximum(127);
        pt->step(1);
        pt->callback((Fl_Callback*)cb_pt);
        pt->align(Fl_Align(FL_ALIGN_TOP));
        pt->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDSYNTH::control::punchDuration, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),60));
      } // WidgetPDial* pt
      { WidgetPDial* o = pstc = new WidgetPDial(230, 227, 25, 25, "P.Stc.");
        pstc->tooltip("Punch Stretch");
        pstc->box(FL_ROUND_UP_BOX);
        pstc->color(FL_BACKGROUND_COLOR);
        pstc->selection_color(FL_INACTIVE_COLOR);
        pstc->labeltype(FL_NORMAL_LABEL);
        pstc->labelfont(0);
        pstc->labelsize(10);
        pstc->labelcolor((Fl_Color)64);
        pstc->maximum(127);
        pstc->step(1);
        pstc->callback((Fl_Callback*)cb_pstc);
        pstc->align(Fl_Align(FL_ALIGN_TOP));
        pstc->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDSYNTH::control::punchStretch, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),64));
      } // WidgetPDial* pstc
      { WidgetPDial* o = pvel = new WidgetPDial(260, 227, 25, 25, "P.Vel.");
        pvel->tooltip("Punch Velocity Sensing");
        pvel->box(FL_ROUND_UP_BOX);
        pvel->color(FL_BACKGROUND_COLOR);
        pvel->selection_color(FL_INACTIVE_COLOR);
        pvel->labeltype(FL_NORMAL_LABEL);
        pvel->labelfont(0);
        pvel->labelsize(10);
        pvel->labelcolor((Fl_Color)64);
        pvel->maximum(127);
        pvel->step(1);
        pvel->callback((Fl_Callback*)cb_pvel);
        pvel->align(Fl_Align(FL_ALIGN_TOP));
        pvel->when(FL_WHEN_CHANGED);
        o->value(collect_readData(synth,0,ADDSYNTH::control::punchVelocity, npart, kititem, PART::engine::addSynth));
        o->selection_color(setKnob(o->value(),72));
      } // WidgetPDial* pvel
      { EnvelopeUI* o = ampenv = new EnvelopeUI(10, 75, 275, 70, "Yoshimi : AddSynth Global - Amplitude Envelope");
        ampenv->box(FL_FLAT_BOX);
        ampenv->color((Fl_Color)51);
        ampenv->selection_color(FL_BACKGROUND_COLOR);
        ampenv->labeltype(FL_NORMAL_LABEL);
        ampenv->labelfont(0);
        ampenv->labelsize(12);
        ampenv->labelcolor(FL_FOREGROUND_COLOR);
        ampenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        ampenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.AmpEnvelope, npart, kititem, PART::engine::addSynth, 0);
        ampenv->end();
      } // EnvelopeUI* ampenv
      { LFOUI* o = amplfo = new LFOUI(10, 145, 275, 70, "Amplitude LFO");
        amplfo->box(FL_FLAT_BOX);
        amplfo->color(FL_DARK1);
        amplfo->selection_color(FL_BACKGROUND_COLOR);
        amplfo->labeltype(FL_NORMAL_LABEL);
        amplfo->labelfont(0);
        amplfo->labelsize(12);
        amplfo->labelcolor(FL_FOREGROUND_COLOR);
        amplfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        amplfo->when(FL_WHEN_RELEASE);
        o->init(synth, npart, kititem, PART::engine::addSynth, TOPLEVEL::insertType::amplitude);
        amplfo->end();
      } // LFOUI* amplfo
      { Fl_Check_Button2* o = rndgrp = new Fl_Check_Button2(8, 234, 63, 18, "Rnd Grp");
        rndgrp->tooltip("Disable individual Harmonic Amplitude randomisation for voices that use the s"
"ame oscillator");
        rndgrp->box(FL_NO_BOX);
        rndgrp->down_box(FL_DOWN_BOX);
        rndgrp->color(FL_BACKGROUND_COLOR);
        rndgrp->selection_color((Fl_Color)64);
        rndgrp->labeltype(FL_NORMAL_LABEL);
        rndgrp->labelfont(0);
        rndgrp->labelsize(11);
        rndgrp->labelcolor((Fl_Color)64);
        rndgrp->callback((Fl_Callback*)cb_rndgrp);
        rndgrp->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        rndgrp->when(FL_WHEN_RELEASE);
        o->value(collect_readData(synth,0,ADDSYNTH::control::randomGroup, npart, kititem, PART::engine::addSynth));
      } // Fl_Check_Button2* rndgrp
      { Fl_Box* o = new Fl_Box(135, 24, 4, 44);
        o->box(FL_THIN_DOWN_FRAME);
      } // Fl_Box* o
      { amplitudelabel = new Fl_Box(128, 12, 35, 8, "AMPLITUDE");
        amplitudelabel->labelfont(1);
        amplitudelabel->labelsize(12);
        amplitudelabel->labelcolor((Fl_Color)64);
      } // Fl_Box* amplitudelabel
      amplitudegrp->end();
    } // Fl_Group* amplitudegrp
    { filtergrp = new Fl_Group(290, 5, 285, 250, "FILTER");
      filtergrp->box(FL_THIN_UP_BOX);
      filtergrp->labelfont(1);
      filtergrp->labelsize(12);
      filtergrp->labelcolor((Fl_Color)64);
      filtergrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
      { EnvelopeUI* o = filterenv = new EnvelopeUI(295, 110, 275, 70, "Yoshimi : AddSynth Global - Filter Envelope");
        filterenv->box(FL_FLAT_BOX);
        filterenv->color((Fl_Color)51);
        filterenv->selection_color(FL_BACKGROUND_COLOR);
        filterenv->labeltype(FL_NORMAL_LABEL);
        filterenv->labelfont(0);
        filterenv->labelsize(12);
        filterenv->labelcolor(FL_FOREGROUND_COLOR);
        filterenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterenv->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.FilterEnvelope, npart, kititem, PART::engine::addSynth, 2);
        filterenv->end();
      } // EnvelopeUI* filterenv
      { LFOUI* o = filterlfo = new LFOUI(295, 180, 275, 70, "Filter LFO");
        filterlfo->box(FL_FLAT_BOX);
        filterlfo->color(FL_DARK1);
        filterlfo->selection_color(FL_BACKGROUND_COLOR);
        filterlfo->labeltype(FL_NORMAL_LABEL);
        filterlfo->labelfont(0);
        filterlfo->labelsize(12);
        filterlfo->labelcolor(FL_FOREGROUND_COLOR);
        filterlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterlfo->when(FL_WHEN_RELEASE);
        o->init(synth, npart, kititem, PART::engine::addSynth, TOPLEVEL::insertType::filter);
        filterlfo->end();
      } // LFOUI* filterlfo
      { FilterUI* o = filterui = new FilterUI(295, 35, 275, 75, "Yoshimi : AddSynth Global - Filter");
        filterui->box(FL_FLAT_BOX);
        filterui->color(FL_LIGHT1);
        filterui->selection_color(FL_BACKGROUND_COLOR);
        filterui->labeltype(FL_NORMAL_LABEL);
        filterui->labelfont(0);
        filterui->labelsize(12);
        filterui->labelcolor(FL_FOREGROUND_COLOR);
        filterui->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
        filterui->when(FL_WHEN_RELEASE);
        o->init(pars->GlobalPar.GlobalFilter, &pars->GlobalPar.PFilterVelocityScale, &pars->GlobalPar.PFilterVelocityScaleFunction, npart, kititem, PART::engine::addSynth);
        filterui->end();
      } // FilterUI* filterui
      filtergrp->end();
    } // Fl_Group* filtergrp
    { Fl_Check_Button2* o = stereo = new Fl_Check_Button2(8, 220, 61, 15, " Stereo");
      stereo->box(FL_NO_BOX);
      stereo->down_box(FL_DOWN_BOX);
      stereo->color(FL_BACKGROUND_COLOR);
      stereo->selection_color((Fl_Color)64);
      stereo->labeltype(FL_NORMAL_LABEL);
      stereo->labelfont(3);
      stereo->labelsize(11);
      stereo->labelcolor((Fl_Color)226);
      stereo->callback((Fl_Callback*)cb_stereo);
      stereo->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
      stereo->when(FL_WHEN_RELEASE);
      o->value(collect_readData(synth,0,ADDSYNTH::control::stereo, npart, kititem, PART::engine::addSynth));
    } // Fl_Check_Button2* stereo
    { showvoicelist = new Fl_Button(191, 375, 121, 25, "Show Voice List");
      showvoicelist->tooltip("Right click: also close this");
      showvoicelist->box(FL_GTK_THIN_UP_BOX);
      showvoicelist->color((Fl_Color)198);
      showvoicelist->labelfont(1);
      showvoicelist->labelsize(12);
      showvoicelist->labelcolor((Fl_Color)64);
      showvoicelist->callback((Fl_Callback*)cb_showvoicelist);
    } // Fl_Button* showvoicelist
    { showvoicepars = new Fl_Button(5, 375, 180, 25, "Show Voice Parameters");
      showvoicepars->tooltip("Right click: also close this");
      showvoicepars->box(FL_GTK_THIN_UP_BOX);
      showvoicepars->color((Fl_Color)198);
      showvoicepars->labelfont(1);
      showvoicepars->labelsize(12);
      showvoicepars->labelcolor((Fl_Color)64);
      showvoicepars->callback((Fl_Callback*)cb_showvoicepars);
    } // Fl_Button* showvoicepars
    { globalclose = new Fl_Button(517, 375, 54, 25, "&Close");
      globalclose->tooltip("Right click: also reopen previous");
      globalclose->box(FL_THIN_UP_BOX);
      globalclose->color((Fl_Color)196);
      globalclose->labelfont(1);
      globalclose->labelsize(12);
      globalclose->labelcolor((Fl_Color)64);
      globalclose->callback((Fl_Callback*)cb_globalclose);
    } // Fl_Button* globalclose
    { resonance = new Fl_Button(318, 375, 90, 25, "Resonance");
      resonance->tooltip("Resonance. Right click: also close this");
      resonance->box(FL_GTK_THIN_UP_BOX);
      resonance->color((Fl_Color)198);
      resonance->labelfont(1);
      resonance->labelsize(12);
      resonance->labelcolor((Fl_Color)64);
      resonance->callback((Fl_Callback*)cb_resonance);
    } // Fl_Button* resonance
    { globalcopy = new Fl_Button(455, 380, 25, 15, "C");
      globalcopy->box(FL_THIN_UP_BOX);
      globalcopy->color((Fl_Color)179);
      globalcopy->labelfont(1);
      globalcopy->labelsize(11);
      globalcopy->labelcolor((Fl_Color)197);
      globalcopy->callback((Fl_Callback*)cb_globalcopy);
    } // Fl_Button* globalcopy
    { globalpaste = new Fl_Button(485, 380, 25, 15, "P");
      globalpaste->box(FL_THIN_UP_BOX);
      globalpaste->color((Fl_Color)179);
      globalpaste->labelfont(1);
      globalpaste->labelsize(11);
      globalpaste->labelcolor((Fl_Color)197);
      globalpaste->callback((Fl_Callback*)cb_globalpaste);
    } // Fl_Button* globalpaste
    ADnoteGlobalParameters->resizable(ADnoteGlobalParameters);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("AddSynth Global"), npart, TOPLEVEL::windowTitle, kititem)).c_str());
    addDW = 580; addDH = 405;
    o->size_range(addDW, addDH, 0, 0, 0, 0, 1);
    ADnoteGlobalParameters->end();
  } // ScaleTrackedWindow* ADnoteGlobalParameters
  { ScaleTrackedWindow* o = ADnoteVoice = new ScaleTrackedWindow(805, 610, "ADsynth Voice Parameters");
    ADnoteVoice->box(FL_FLAT_BOX);
    ADnoteVoice->color(FL_BACKGROUND_COLOR);
    ADnoteVoice->selection_color(FL_BACKGROUND_COLOR);
    ADnoteVoice->labeltype(FL_NO_LABEL);
    ADnoteVoice->labelfont(0);
    ADnoteVoice->labelsize(14);
    ADnoteVoice->labelcolor(FL_FOREGROUND_COLOR);
    ADnoteVoice->callback((Fl_Callback*)cb_ADnoteVoice, (void*)(this));
    ADnoteVoice->align(Fl_Align(FL_ALIGN_TOP));
    ADnoteVoice->when(FL_WHEN_RELEASE);
    { ADvoiceUI* o = advoice = new ADvoiceUI(0, 0, 809, 615);
      advoice->box(FL_BORDER_BOX);
      advoice->color(FL_BACKGROUND_COLOR);
      advoice->selection_color(FL_BACKGROUND_COLOR);
      advoice->labeltype(FL_NORMAL_LABEL);
      advoice->labelfont(0);
      advoice->labelsize(14);
      advoice->labelcolor(FL_FOREGROUND_COLOR);
      advoice->align(Fl_Align(FL_ALIGN_TOP));
      advoice->when(FL_WHEN_RELEASE);
      o->init(pars, npart, kititem, nvoice);
      o->show();
      advoice->end();
    } // ADvoiceUI* advoice
    { Vclose = new Fl_Button(695, 575, 90, 25, "Close");
      Vclose->tooltip("Right click: also reopen previous");
      Vclose->box(FL_THIN_UP_BOX);
      Vclose->color((Fl_Color)196);
      Vclose->labelfont(1);
      Vclose->labelsize(12);
      Vclose->labelcolor((Fl_Color)64);
      Vclose->callback((Fl_Callback*)cb_Vclose);
    } // Fl_Button* Vclose
    { Vcopy = new Fl_Button(600, 580, 25, 15, "C");
      Vcopy->box(FL_THIN_UP_BOX);
      Vcopy->color((Fl_Color)179);
      Vcopy->labelfont(1);
      Vcopy->labelsize(11);
      Vcopy->labelcolor((Fl_Color)197);
      Vcopy->callback((Fl_Callback*)cb_Vcopy);
    } // Fl_Button* Vcopy
    { Vpaste = new Fl_Button(630, 580, 25, 15, "P");
      Vpaste->box(FL_THIN_UP_BOX);
      Vpaste->color((Fl_Color)179);
      Vpaste->labelfont(1);
      Vpaste->labelsize(11);
      Vpaste->labelcolor((Fl_Color)197);
      Vpaste->callback((Fl_Callback*)cb_Vpaste);
    } // Fl_Button* Vpaste
    { Fl_Button* o = g1 = new Fl_Button(8, 3, 50, 32, "1");
      g1->box(FL_PLASTIC_THIN_UP_BOX);
      g1->down_box(FL_PLASTIC_THIN_UP_BOX);
      g1->selection_color(FL_CYAN);
      g1->labelfont(1);
      g1->labelcolor((Fl_Color)64);
      g1->callback((Fl_Callback*)cb_g1);
      o->value(1);
    } // Fl_Button* g1
    { Fl_Button* o = g2 = new Fl_Button(60, 3, 50, 32, "2");
      g2->box(FL_PLASTIC_THIN_UP_BOX);
      g2->down_box(FL_PLASTIC_THIN_UP_BOX);
      g2->selection_color(FL_CYAN);
      g2->labelfont(1);
      g2->labelcolor((Fl_Color)64);
      g2->callback((Fl_Callback*)cb_g2);
      o->value(0);
    } // Fl_Button* g2
    { Fl_Button* o = g3 = new Fl_Button(112, 3, 50, 32, "3");
      g3->box(FL_PLASTIC_THIN_UP_BOX);
      g3->down_box(FL_PLASTIC_THIN_UP_BOX);
      g3->selection_color(FL_CYAN);
      g3->labelfont(1);
      g3->labelcolor((Fl_Color)64);
      g3->callback((Fl_Callback*)cb_g3);
      o->value(0);
    } // Fl_Button* g3
    { Fl_Button* o = g4 = new Fl_Button(164, 3, 50, 32, "4 ");
      g4->box(FL_PLASTIC_THIN_UP_BOX);
      g4->down_box(FL_PLASTIC_THIN_UP_BOX);
      g4->selection_color(FL_CYAN);
      g4->labelfont(1);
      g4->labelcolor((Fl_Color)64);
      g4->callback((Fl_Callback*)cb_g4);
      o->value(0);
    } // Fl_Button* g4
    { Fl_Button* o = g5 = new Fl_Button(216, 3, 50, 32, "5");
      g5->box(FL_PLASTIC_THIN_UP_BOX);
      g5->down_box(FL_PLASTIC_THIN_UP_BOX);
      g5->selection_color(FL_CYAN);
      g5->labelfont(1);
      g5->labelcolor((Fl_Color)64);
      g5->callback((Fl_Callback*)cb_g5);
      o->value(0);
    } // Fl_Button* g5
    { Fl_Button* o = g6 = new Fl_Button(268, 3, 50, 32, "6");
      g6->box(FL_PLASTIC_THIN_UP_BOX);
      g6->down_box(FL_PLASTIC_THIN_UP_BOX);
      g6->selection_color(FL_CYAN);
      g6->labelfont(1);
      g6->labelcolor((Fl_Color)64);
      g6->callback((Fl_Callback*)cb_g6);
      o->value(0);
    } // Fl_Button* g6
    { Fl_Button* o = g7 = new Fl_Button(320, 3, 50, 32, "7");
      g7->box(FL_PLASTIC_THIN_UP_BOX);
      g7->down_box(FL_PLASTIC_THIN_UP_BOX);
      g7->selection_color(FL_CYAN);
      g7->labelfont(1);
      g7->labelcolor((Fl_Color)64);
      g7->callback((Fl_Callback*)cb_g7);
      o->value(0);
    } // Fl_Button* g7
    { Fl_Button* o = g8 = new Fl_Button(372, 3, 50, 32, "8");
      g8->box(FL_PLASTIC_THIN_UP_BOX);
      g8->down_box(FL_PLASTIC_THIN_UP_BOX);
      g8->selection_color(FL_CYAN);
      g8->labelfont(1);
      g8->labelcolor((Fl_Color)64);
      g8->callback((Fl_Callback*)cb_g8);
      o->value(0);
    } // Fl_Button* g8
    { voiceTabBar = new Fl_Group(4, 30, 524, 5);
      voiceTabBar->box(FL_PLASTIC_THIN_DOWN_BOX);
      voiceTabBar->color(FL_CYAN);
      voiceTabBar->end();
    } // Fl_Group* voiceTabBar
    ADnoteVoice->resizable(ADnoteVoice);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("AddSynth Voice"), npart, TOPLEVEL::windowTitle, kititem)).c_str());
    voiceDW = int(760 * 9 / 10); voiceDH = int(610 * 9 / 10);
    o->size_range(voiceDW, voiceDH, 0, 0, 0, 0, 1);
    ADnoteVoice->end();
  } // ScaleTrackedWindow* ADnoteVoice
  { ScaleTrackedWindow* o = ADnoteVoiceList = new ScaleTrackedWindow(705, 260, "ADsynth Voices list");
    ADnoteVoiceList->box(FL_FLAT_BOX);
    ADnoteVoiceList->color(FL_BACKGROUND_COLOR);
    ADnoteVoiceList->selection_color(FL_BACKGROUND_COLOR);
    ADnoteVoiceList->labeltype(FL_NO_LABEL);
    ADnoteVoiceList->labelfont(0);
    ADnoteVoiceList->labelsize(14);
    ADnoteVoiceList->labelcolor((Fl_Color)64);
    ADnoteVoiceList->callback((Fl_Callback*)cb_ADnoteVoiceList, (void*)(this));
    ADnoteVoiceList->align(Fl_Align(FL_ALIGN_TOP));
    ADnoteVoiceList->when(FL_WHEN_RELEASE);
    { listNo = new Fl_Text_Display(24, 15, 30, 10, "No.");
      listNo->box(FL_NO_BOX);
      listNo->selection_color((Fl_Color)64);
      listNo->labelfont(1);
      listNo->labelsize(11);
      listNo->labelcolor((Fl_Color)64);
      listNo->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listNo
    { listVolume = new Fl_Text_Display(230, 15, 30, 10, "Volume");
      listVolume->box(FL_NO_BOX);
      listVolume->selection_color((Fl_Color)64);
      listVolume->labelfont(1);
      listVolume->labelsize(11);
      listVolume->labelcolor((Fl_Color)64);
      listVolume->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listVolume
    { listDetune = new Fl_Text_Display(458, 15, 25, 10, "Detune");
      listDetune->box(FL_NO_BOX);
      listDetune->selection_color((Fl_Color)64);
      listDetune->labelfont(1);
      listDetune->labelsize(11);
      listDetune->labelcolor((Fl_Color)64);
      listDetune->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listDetune
    { listPan = new Fl_Text_Display(298, 15, 30, 10, "Pan");
      listPan->box(FL_NO_BOX);
      listPan->selection_color((Fl_Color)64);
      listPan->labelfont(1);
      listPan->labelsize(11);
      listPan->labelcolor((Fl_Color)64);
      listPan->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listPan
    { listVibrato = new Fl_Text_Display(618, 15, 30, 10, "Vibrato Depth");
      listVibrato->box(FL_NO_BOX);
      listVibrato->selection_color((Fl_Color)64);
      listVibrato->labelfont(1);
      listVibrato->labelsize(11);
      listVibrato->labelcolor((Fl_Color)64);
      listVibrato->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listVibrato
    { listResonance = new Fl_Text_Display(329, 15, 25, 10, "Res");
      listResonance->box(FL_NO_BOX);
      listResonance->selection_color((Fl_Color)64);
      listResonance->labelfont(1);
      listResonance->labelsize(11);
      listResonance->labelcolor((Fl_Color)64);
      listResonance->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listResonance
    { listClose = new Fl_Button(582, 235, 62, 20, "Close");
      listClose->tooltip("Right click: also reopen previous");
      listClose->color((Fl_Color)196);
      listClose->labelfont(1);
      listClose->labelsize(12);
      listClose->labelcolor((Fl_Color)64);
      listClose->callback((Fl_Callback*)cb_listClose);
    } // Fl_Button* listClose
    { Fl_Group* o = new Fl_Group(5, 15, 695, 214);
      o->box(FL_THIN_UP_BOX);
      o->labelcolor((Fl_Color)64);
      { Fl_Group* o = new Fl_Group(17, 27, 668, 200);
        //
              for (int i = 0; i < NUM_VOICES; ++i)
              {
                  voicelistitem[i] = new ADvoicelistitem(4, 8, 620, 25, "");
                  voicelistitem[i]->init(pars, npart, kititem, i);
              }
        o->end();
      } // Fl_Group* o
      o->end();
    } // Fl_Group* o
    { listWave = new Fl_Text_Display(105, 15, 30, 10, "Wave");
      listWave->box(FL_NO_BOX);
      listWave->labelfont(1);
      listWave->labelsize(11);
      listWave->labelcolor((Fl_Color)64);
      listWave->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listWave
    { listModulator = new Fl_Text_Display(145, 15, 30, 10, "Mod");
      listModulator->box(FL_NO_BOX);
      listModulator->labelfont(1);
      listModulator->labelsize(11);
      listModulator->labelcolor((Fl_Color)64);
      listModulator->textcolor((Fl_Color)64);
    } // Fl_Text_Display* listModulator
    ADnoteVoiceList->resizable(ADnoteVoiceList);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("AddSynth Voice List"), npart, TOPLEVEL::windowTitle, kititem)).c_str());
    listDW = 705; listDH = 260;
    o->size_range(listDW,listDH,0,0,0,0,1);
    ADnoteVoiceList->end();
  } // ScaleTrackedWindow* ADnoteVoiceList
  return ADnoteVoiceList;
}

void ADnoteUI::setVoiceTabs(int num, bool edit ) {
  //
          g1->value(0);
          g2->value(0);
          g3->value(0);
          g4->value(0);
          g5->value(0);
          g6->value(0);
          g7->value(0);
          g8->value(0);
          switch (num)
          {
              case 0:
                  g1->value(1);
                  if (edit)
                      editVoice(0);
                  break;
              case 1:
                  g2->value(1);
                  if (edit)
                      editVoice(1);
                  break;
              case 2:
                  g3->value(1);
                  if (edit)
                      editVoice(2);
                  break;
              case 3:
                  g4->value(1);
                  if (edit)
                      editVoice(3);
                  break;
              case 4:
                  g5->value(1);
                  if (edit)
                      editVoice(4);
                  break;
              case 5:
                  g6->value(1);
                  if (edit)
                      editVoice(5);
                  break;
              case 6:
                  g7->value(1);
                  if (edit)
                      editVoice(6);
                  break;
              case 7:
                  g8->value(1);
                  if (edit)
                      editVoice(7);
                  break;
          }
      ;
}

void ADnoteUI::setTabColour(int nvoice) {
  //
          int set = voice_off;
          if (collect_readData(synth,0,ADDVOICE::control::enableVoice, npart, kititem, PART::engine::addVoice1 + nvoice))
              set = gen_text;

          switch (nvoice) // there should be a better way to do this
          {
              case 0:
                  g1->labelcolor(set);
                  break;
              case 1:
                  g2->labelcolor(set);
                  break;
              case 2:
                  g3->labelcolor(set);
                  break;
              case 3:
                  g4->labelcolor(set);
                  break;
              case 4:
                  g5->labelcolor(set);
                  break;
              case 5:
                  g6->labelcolor(set);
                  break;
              case 6:
                  g7->labelcolor(set);
                  break;
              case 7:
                  g8->labelcolor(set);
                  break;
          }
          ;
}

void ADnoteUI::send_data(int action, int control, float value, int type) {
  //
          type |= TOPLEVEL::type::Write;
          collect_writeData(synth, value, action, type, control, npart, kititem, PART::engine::addSynth);
          ;
}

void ADnoteUI::returns_update(CommandBlock *getData) {
  //
          float value = getData->data.value;
          unsigned char control = getData->data.control;
          bool val_bool = _SYS_::F2B(value);
          switch(control)
          {
              case ADDSYNTH::control::volume:
                  globalvolume->value(value);
                  globalvolume->selection_color(setKnob(value,90));
                  break;

              case ADDSYNTH::control::velocitySense:
                  vsns->value(value);
                  vsns->selection_color(setKnob(value,64));
                  break;

              case ADDSYNTH::control::panning:
                  globalpan->value(value);
                  globalpan->selection_color(setKnob(value,64));
                  amplitudegrp->changed();
                  break;

              case ADDSYNTH::control::enableRandomPan:
                  globalrandompan->value(val_bool);
                  if (val_bool)
                      globalwidth->activate();
                  else
                      globalwidth->deactivate();
                  amplitudegrp->changed();
                  break;

              case ADDSYNTH::control::randomWidth:
                  globalwidth->value(value);
                  globalwidth->selection_color(setKnob(value,63));
                  amplitudegrp->changed();
                  break;

              case ADDSYNTH::control::detuneFrequency:
                  freq->value(value);
                  freq->selection_color(setSlider(value,0));
                  detunevalueoutput->do_callback();
                  break;

              case ADDSYNTH::control::octave:
                  octave->value((int) value);
                  break;

              case ADDSYNTH::control::detuneType:
                  detunetype->value(int(value) -1);
                  break;

              case ADDSYNTH::control::coarseDetune:
                  coarsedet->value((int) value);
                  break;

              case ADDSYNTH::control::relativeBandwidth:
                  relBwidth->value(value);
                  relBwidth->selection_color(setKnob(value,64));
                  break;

              case ADDSYNTH::control::stereo:
                  stereo->value(val_bool);
                  break;

              case ADDSYNTH::control::randomGroup:
                  rndgrp->value(val_bool);
                  break;

              case ADDSYNTH::control::dePop:
                  depop->value(value);
                  depop->selection_color(setKnob(value,20));
                  break;

              case ADDSYNTH::control::punchStrength:
                  pstr->value(value);
                  pstr->selection_color(setKnob(value,0));
                  break;

              case ADDSYNTH::control::punchDuration:
                  pt->value(value);
                  pt->selection_color(setKnob(value,60));
                  break;

              case ADDSYNTH::control::punchStretch:
                  pstc->value(value);
                  pstc->selection_color(setKnob(value,64));
                  break;

              case ADDSYNTH::control::punchVelocity:
                  pvel->value(value);
                  pvel->selection_color(setKnob(value,72));
                  break;

          }
          ;
}

void ADnoteUI::paste(CommandBlock *getData) {
  //
          switch (getData->data.insert)
          {
              case TOPLEVEL::insert::resonanceGroup:
              {
                  if (resui)
                      resui->refresh();
                  break;
              }
          }
          ;
}

ADnoteUI::ADnoteUI(ADnoteParameters *parameters, int npart_, int kititem_) {
  //
          synth = & parameters->getSynthEngine();
          pars = parameters;
          npart = npart_;
          kititem = kititem_;
          globalSeen = false;
          lastglobalW = 0;
          voiceSeen = false;
          lastvoiceW = 0;
          nvoice = 0;
          resui = new ResonanceUI(pars->GlobalPar.Reson, npart, kititem, PART::engine::addSynth);
          lastlistW = 0;
          listSeen = false;
          lastResuiW = 0;
          make_window();
          for (int i = 0; i < NUM_VOICES; ++i)
          {
              setTabColour(i);
          }
          ;
}

ADnoteUI::~ADnoteUI() {
  //
          if(listSeen)
              saveWin(synth, ADnoteVoiceList->w(), ADnoteVoiceList->h(), ADnoteVoiceList->x(), ADnoteVoiceList->y(), listSeen, "AddSynth-list");
          ADnoteVoiceList->hide();
          listSeen = false;
          if (globalSeen)
              saveWin(synth,  ADnoteGlobalParameters->w(),  ADnoteGlobalParameters->h(), ADnoteGlobalParameters->x(), ADnoteGlobalParameters->y(), globalSeen, "AddSynth");
          ADnoteGlobalParameters->hide();
          globalSeen = false;
          if (voiceSeen)
              saveWin(synth, ADnoteVoice->w(), ADnoteVoice->h(), ADnoteVoice->x(), ADnoteVoice->y(), voiceSeen, "AddSynth-voice");
          voiceSeen = false;
          ADnoteVoice->hide();
          resui->resonancewindow->hide();
          delete ADnoteVoiceList;
          delete ADnoteGlobalParameters;
          delete ADnoteVoice;
          delete resui;
          ;
}

void ADnoteUI::refresh() {
  //
          globalvolume->value(collect_readData(synth, 0, ADDSYNTH::volume, npart, kititem, PART::engine::addSynth));
              globalvolume->selection_color(setKnob(globalvolume->value(),90));
          vsns->value(collect_readData(synth, 0, ADDSYNTH::velocitySense, npart, kititem, PART::engine::addSynth));
              vsns->selection_color(setKnob(vsns->value(),64));
          globalpan->value(collect_readData(synth, 0, ADDSYNTH::panning, npart, kititem, PART::engine::addSynth));
              globalpan->selection_color(setKnob(globalpan->value(),64));
          globalwidth->value(collect_readData(synth, 0, ADDSYNTH::randomWidth, npart, kititem, PART::engine::addSynth));
              globalwidth->selection_color(setKnob(globalwidth->value(),63));
          relBwidth->value(collect_readData(synth, 0, ADDSYNTH::relativeBandwidth, npart, kititem, PART::engine::addSynth));
              relBwidth->selection_color(setKnob(relBwidth->value(),64));
          stereo->value(collect_readData(synth, 0, ADDSYNTH::stereo, npart, kititem, PART::engine::addSynth));
          rndgrp->value(collect_readData(synth, 0, ADDSYNTH::randomGroup, npart, kititem, PART::engine::addSynth));

          pstr->value(collect_readData(synth, 0, ADDSYNTH::punchStrength, npart, kititem, PART::engine::addSynth));
              pstr->selection_color(setKnob(pstr->value(),0));
          depop->value(collect_readData(synth, 0, ADDSYNTH::dePop, npart, kititem, PART::engine::addSynth));
              depop->selection_color(setKnob(depop->value(),20));
          pt->value(collect_readData(synth, 0, ADDSYNTH::punchDuration, npart, kititem, PART::engine::addSynth));
              pt->selection_color(setKnob(pt->value(),60));
          pstc->value(collect_readData(synth, 0, ADDSYNTH::punchStretch, npart, kititem, PART::engine::addSynth));
              pstc->selection_color(setKnob(pstc->value(),64));
          pvel->value(collect_readData(synth, 0,ADDSYNTH::punchVelocity, npart, kititem, PART::engine::addSynth));
              pvel->selection_color(setKnob(pvel->value(),72));

          int detFreq = collect_readData(synth, 0, ADDSYNTH::detuneFrequency, npart, kititem, PART::engine::addSynth);
          freq->value(detFreq);
              freq->selection_color(setSlider(freq->value(), 0));

          int k = collect_readData(synth, 0, ADDSYNTH::coarseDetune, npart, kititem, PART::engine::addSynth) / 1024;
          if (k >= 8)
              k -= 16;
          octave->value(k);

          int detType = collect_readData(synth, 0, ADDSYNTH::detuneType, npart, kititem, PART::engine::addSynth);
          detunetype->value(detType - 1);
          k = collect_readData(synth,0,ADDSYNTH::control::octave, npart, kititem, PART::engine::addSynth);
          if (k >= 512)
              k -= 1024;
          coarsedet->value(k);
          detunevalueoutput->value(getDetune(detType, 0, detFreq + 8192));
          amplfo->refresh();
          freqlfo->refresh();
          filterlfo->refresh();

          ampenv->refresh();
          freqenv->refresh();
          filterenv->refresh();
          filterui->refresh();
          editVoice(nvoice);
          for (int i = 0; i < NUM_VOICES; ++i)
          {
              setTabColour(i);
              voicelistitem[i]->refreshlist(i);
          }
          resui->refresh();
          ;
}

void ADnoteUI::ShowGlobal() {
  //
          int fetchW, fetchH, fetchX, fetchY, fetchO;
          loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "AddSynth");
          if (fetchW < addDW || fetchH < addDH)
          {
              fetchW = addDW;
              fetchH = addDH;
          }
          checkSane(fetchX, fetchY, fetchW, fetchH, addDW, addDH);
          lastglobalW = 0;
          ADnoteGlobalParameters->resize(fetchX, fetchY, fetchW, fetchH);
          ADnoteGlobalParameters->show();
          globalSeen = true;
          ;
}

void ADnoteUI::set_voice(bool type) {
  //
          voicelistitem[nvoice]->refreshlist(nvoice);
          int fetchW, fetchH, fetchX, fetchY, fetchO;

          if (!voiceSeen)
          {
              loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "AddSynth-voice");
              if (fetchW < voiceDW || fetchH < voiceDH)
              {
                  fetchW = voiceDW;
                  fetchH = voiceDH;
              }
              checkSane(fetchX, fetchY, fetchW, fetchH, voiceDW, voiceDH);
              ADnoteVoice->resize(fetchX, fetchY, fetchW, fetchH);
          }

          ADnoteVoice->redraw();
          ADnoteVoice->show();
          lastvoiceW = 0;
          voiceSeen = true;
          fromVoiceList = type;
          ;
}

void ADnoteUI::wincheck() {
  //
          addRtext();
          addVoiceRtext();

          if (ADnoteVoiceList->visible())
              addVoiceListRtext();

          if (resui->resonancewindow->visible() && lastResuiW != resui->resonancewindow->w())
          {
              resui->resonanceRtext();
              lastResuiW = resui->resonancewindow->w();
          }

          if (ampenv)
              ampenv->wincheck();
          if (filterenv)
              filterenv->wincheck();
          if (freqenv)
              freqenv->wincheck();
          ;
}

void ADnoteUI::theme() {
  //
          if(ADnoteGlobalParameters->visible())
          {
              lastglobalW = 0;
              addRtext();
          }
          if (ADnoteVoiceList->visible())
          {
              lastlistW = 0;
              addVoiceListRtext();
          }
          if (resui->resonancewindow->visible())
          {
              lastResuiW = 0;
              resui->resonanceRtext();
          }
          ampenv->theme();
          freqenv->theme();
          filterenv->theme();
          filterui->theme();

          lastvoiceW = 0;
          addVoiceRtext();
          advoice->voicetheme();
          ;
}

void ADnoteUI::addRtext() {
  //
          ampenv->wincheck();
          freqenv->wincheck();
          filterenv->wincheck();

          if (lastglobalW < 3)
          {
              ++lastglobalW;
              return; // in case it is  called before completely redrawn
          }

          if (lastglobalW == ADnoteGlobalParameters->w())
              return;
          lastglobalW = ADnoteGlobalParameters->w();

          float dScale = ADnoteGlobalParameters->w() / float(addDW);
          if (dScale < 0.2f)
              dScale = 0.2f;

          amplfo->lfoRtext(dScale);
          ampenv->envRtext(dScale);

          freqlfo->lfoRtext(dScale);
          freqenv->envRtext(dScale);

          filterlfo->lfoRtext(dScale);
          filterenv->envRtext(dScale);

          filterui->filterRtext(dScale);

          int size = int(10 * dScale);
          int size11 = int(11 * dScale);
          int size12 = int(12 * dScale);

          amplitudelabel->labelsize(size12);
          globalvolume->labelsize(size);
          vsns->labelsize(size);
          globalpan->labelsize(size);
          globalwidth->labelsize(size);
          globalrandompan->labelsize(size);
          depop->labelsize(size);
          pstr->labelsize(size);
          pt->labelsize(size);
          pstc->labelsize(size);
          pvel->labelsize(size);
          rndgrp->labelsize(size);

          stereo->labelsize(size11);

          filtergrp->labelsize(size12);

          globalfreq->labelsize(size12);
          detunevalueoutput->labelsize(size);
              detunevalueoutput->textsize(size);
          octavetext->labelsize(size);
              octave->textsize(size11);
              octave->redraw();
          relBwidth->labelsize(size);
          detunetype->labelsize(size);
              detunetype->textsize(size11);

          coarsedet->labelsize(size);
              coarsedet->textsize(size11);

          showvoicepars->labelsize(size12);
          showvoicelist->labelsize(size12);
          resonance->labelsize(size12);
          globalcopy->labelsize(size11);
          globalpaste->labelsize(size11);
          globalclose->labelsize(size11);

          ADnoteGlobalParameters->redraw();
          ;
}

void ADnoteUI::addVoiceRtext() {
  // this is just for the outer skin

          float dScale = ADnoteVoice->w() / float(voiceDW);
          if (dScale < 0.2f)
              dScale = 0.2f;

          advoice->voiceRtext(dScale); // must be entered (for waveform)

          if (!ADnoteVoice->visible())
              return;

          if (lastvoiceW < 2) // extra time to settle
          {
              ++lastvoiceW;
              return;
          }

          if (ADnoteVoice->w() == lastvoiceW)
              return;

          lastvoiceW = ADnoteVoice->w();

          Vclose->labelsize(int(12 * dScale));

          Vcopy->labelsize(int(11 * dScale));
          Vpaste->labelsize(int(11 * dScale));

          /*
          * scaling of tabs is in near tab size jumps so we
          * have to try to get the best overall size/position
          */
          int size = int((12 * dScale) + (1.85f * dScale * dScale));
          g1->labelsize(size);
          g2->labelsize(size);
          g3->labelsize(size);
          g4->labelsize(size);
          g5->labelsize(size);
          g6->labelsize(size);
          g7->labelsize(size);
          g8->labelsize(size);

          ADnoteVoice->redraw();
          ;
}

void ADnoteUI::addVoiceListRtext() {
  //
          if (lastlistW < 3)
          {
              ++lastlistW;
              return;
          }
          if (lastlistW == ADnoteVoiceList->w())
              return;

          lastlistW = ADnoteVoiceList->w();

          float dScale = ADnoteVoiceList->w() / float(listDW);
          if (dScale < 0.2f)
              dScale = 0.2f;

          for (int i = 0; i < NUM_VOICES; ++i)
          {
              voicelistitem[i]->resize(15 * dScale, (27 + (25 * i)) * dScale, 670 * dScale, 25 * dScale);
              voicelistitem[i]->itemRtext(dScale);
          }

          int size11 = int(11 * dScale);
          listNo->labelsize(size11);
          listVolume->labelsize(size11);
          listDetune->labelsize(size11);
          listPan->labelsize(size11);
          listVibrato->labelsize(size11);
          listResonance->labelsize(size11);
          listWave->labelsize(size11);
          listModulator->labelsize(size11);
          listClose->labelsize(int(14 * dScale));

          ADnoteVoiceList->redraw();
          ;
}

void ADnoteUI::editVoice(int nvoice_) {
  //
          nvoice = nvoice_;
          int adW = advoice->ADnoteVoiceParameters->w();
          int adH = advoice->ADnoteVoiceParameters->h();
          bool lastVoiceState = advoice->voiceonbutton->value();
          advoice->hide();
          ADnoteVoice->remove(advoice);
          delete advoice;

          advoice = new ADvoiceUI(0, 0, adW, adH);
          ADnoteVoice->add(advoice);
          advoice->init(pars, npart, kititem, nvoice);
          /*
          This is only needed to update the tab when a voice has been pasted,
          but duplicates the action every time a different voice is selected.
          Needs improvement!
          */
          if (advoice->voiceonbutton->value() != lastVoiceState)
          {
              setTabColour(nvoice);
          }
          voicelistitem[nvoice]->refreshlist(nvoice);
          advoice->ADnoteVoiceParameters->size(adW, adH);
          advoice->show();
          addVoiceRtext();
          ;
}
