#include "livekit/audio_resampler.h"
#include <cstddef>
#include <cstdint>
#include <memory>
#include <new>
#include <type_traits>
#include <utility>

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#ifdef __clang__
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__
#endif // __GNUC__

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

#ifndef CXXBRIDGE1_IS_COMPLETE
#define CXXBRIDGE1_IS_COMPLETE
namespace detail {
namespace {
template <typename T, typename = std::size_t>
struct is_complete : std::false_type {};
template <typename T>
struct is_complete<T, decltype(sizeof(T))> : std::true_type {};
} // namespace
} // namespace detail
#endif // CXXBRIDGE1_IS_COMPLETE

namespace {
template <bool> struct deleter_if {
  template <typename T> void operator()(T *) {}
};
template <> struct deleter_if<true> {
  template <typename T> void operator()(T *ptr) { ptr->~T(); }
};
} // namespace
} // namespace cxxbridge1
} // namespace rust

namespace livekit {
  using AudioResampler = ::livekit::AudioResampler;
}

namespace livekit {
extern "C" {
::std::size_t livekit$cxxbridge1$AudioResampler$remix_and_resample(::livekit::AudioResampler &self, ::std::int16_t const *src, ::std::size_t samples_per_channel, ::std::size_t num_channels, ::std::int32_t sample_rate, ::std::size_t dst_num_channels, ::std::int32_t dst_sample_rate) noexcept {
  ::std::size_t (::livekit::AudioResampler::*remix_and_resample$)(::std::int16_t const *, ::std::size_t, ::std::size_t, ::std::int32_t, ::std::size_t, ::std::int32_t) = &::livekit::AudioResampler::remix_and_resample;
  return (self.*remix_and_resample$)(src, samples_per_channel, num_channels, sample_rate, dst_num_channels, dst_sample_rate);
}

::std::int16_t const *livekit$cxxbridge1$AudioResampler$data(::livekit::AudioResampler const &self) noexcept {
  ::std::int16_t const *(::livekit::AudioResampler::*data$)() const = &::livekit::AudioResampler::data;
  return (self.*data$)();
}

::livekit::AudioResampler *livekit$cxxbridge1$create_audio_resampler() noexcept {
  ::std::unique_ptr<::livekit::AudioResampler> (*create_audio_resampler$)() = ::livekit::create_audio_resampler;
  return create_audio_resampler$().release();
}
} // extern "C"
} // namespace livekit

extern "C" {
static_assert(::rust::detail::is_complete<::std::remove_extent<::livekit::AudioResampler>::type>::value, "definition of `::livekit::AudioResampler` is required");
static_assert(sizeof(::std::unique_ptr<::livekit::AudioResampler>) == sizeof(void *), "");
static_assert(alignof(::std::unique_ptr<::livekit::AudioResampler>) == alignof(void *), "");
void cxxbridge1$unique_ptr$livekit$AudioResampler$null(::std::unique_ptr<::livekit::AudioResampler> *ptr) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::AudioResampler>();
}
void cxxbridge1$unique_ptr$livekit$AudioResampler$raw(::std::unique_ptr<::livekit::AudioResampler> *ptr, ::std::unique_ptr<::livekit::AudioResampler>::pointer raw) noexcept {
  ::new (ptr) ::std::unique_ptr<::livekit::AudioResampler>(raw);
}
::std::unique_ptr<::livekit::AudioResampler>::element_type const *cxxbridge1$unique_ptr$livekit$AudioResampler$get(::std::unique_ptr<::livekit::AudioResampler> const &ptr) noexcept {
  return ptr.get();
}
::std::unique_ptr<::livekit::AudioResampler>::pointer cxxbridge1$unique_ptr$livekit$AudioResampler$release(::std::unique_ptr<::livekit::AudioResampler> &ptr) noexcept {
  return ptr.release();
}
void cxxbridge1$unique_ptr$livekit$AudioResampler$drop(::std::unique_ptr<::livekit::AudioResampler> *ptr) noexcept {
  ::rust::deleter_if<::rust::detail::is_complete<::livekit::AudioResampler>::value>{}(ptr);
}
} // extern "C"
