﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgent {
namespace Model {

/**
 * <p>Details about unsatisfied conditions for a connection. A condition is
 * unsatisfied if it can never be true, for example two branches of condition node
 * cannot be simultaneously true.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UnsatisfiedConnectionConditionsFlowValidationDetails">AWS
 * API Reference</a></p>
 */
class UnsatisfiedConnectionConditionsFlowValidationDetails {
 public:
  AWS_BEDROCKAGENT_API UnsatisfiedConnectionConditionsFlowValidationDetails() = default;
  AWS_BEDROCKAGENT_API UnsatisfiedConnectionConditionsFlowValidationDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API UnsatisfiedConnectionConditionsFlowValidationDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the connection with unsatisfied conditions.</p>
   */
  inline const Aws::String& GetConnection() const { return m_connection; }
  inline bool ConnectionHasBeenSet() const { return m_connectionHasBeenSet; }
  template <typename ConnectionT = Aws::String>
  void SetConnection(ConnectionT&& value) {
    m_connectionHasBeenSet = true;
    m_connection = std::forward<ConnectionT>(value);
  }
  template <typename ConnectionT = Aws::String>
  UnsatisfiedConnectionConditionsFlowValidationDetails& WithConnection(ConnectionT&& value) {
    SetConnection(std::forward<ConnectionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_connection;
  bool m_connectionHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgent
}  // namespace Aws
