﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amplify/Amplify_EXPORTS.h>
#include <aws/amplify/model/Webhook.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Amplify {
namespace Model {
/**
 * <p>The result structure for the delete webhook request. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteWebhookResult">AWS
 * API Reference</a></p>
 */
class DeleteWebhookResult {
 public:
  AWS_AMPLIFY_API DeleteWebhookResult() = default;
  AWS_AMPLIFY_API DeleteWebhookResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_AMPLIFY_API DeleteWebhookResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Describes a webhook that connects repository events to an Amplify app. </p>
   */
  inline const Webhook& GetWebhook() const { return m_webhook; }
  template <typename WebhookT = Webhook>
  void SetWebhook(WebhookT&& value) {
    m_webhookHasBeenSet = true;
    m_webhook = std::forward<WebhookT>(value);
  }
  template <typename WebhookT = Webhook>
  DeleteWebhookResult& WithWebhook(WebhookT&& value) {
    SetWebhook(std::forward<WebhookT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteWebhookResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Webhook m_webhook;

  Aws::String m_requestId;
  bool m_webhookHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Amplify
}  // namespace Aws
