#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 darcs
version:              2.18.5
visibility:           public
id:                   darcs-2.18.5-JX1B27H5XUnLvQZKfhpHVa
key:                  darcs-2.18.5-JX1B27H5XUnLvQZKfhpHVa
license:              GPL-2.0-or-later
maintainer:           <darcs-devel@darcs.net>
author:               David Roundy <droundy@darcs.net>, <darcs-devel@darcs.net>
stability:            Experimental
homepage:             http://darcs.net/
synopsis:             a distributed, interactive, smart revision control system
description:
    Darcs is a free, open source revision control
    system. It is:

    * Distributed: Darcs was one of the first revision control
    systems in which every user has access to the full command
    set, removing boundaries between server and client or
    committer and non-committers.

    * Interactive: Darcs is easy to learn and efficient to use
    because it asks you questions in response to simple
    commands, giving you choices in your work flow. You can
    choose to record one change in a file, while ignoring
    another. As you update from upstream, you can review each
    patch, picking and choosing which patches are appropriate.

    * Smart: Darcs is different from most revision control
    systems in that it is based on the notion of change (or
    patch), rather than version. An underlying algebra of
    patches determines whether changes can be re-ordered. The
    laws of this algebra guarantee that the result of merging
    depends only on the final set of patches applied in a
    repository and not on their order.

    * Simple: As a consequence, Darcs offers a conceptually
    simpler view of the state of a repository: it is given by
    the set of patches it contains. Pulling and pushing
    patches merely transfers them from one set to another. So
    called "cherry-picking" is the default mode of operation,
    and it fully preserves the identity of patches.

category:             Development
abi:                  4a9716a05bb9ea51e27c41bc11b89304
exposed:              True
exposed-modules:
    Darcs.Patch Darcs.Patch.Annotate Darcs.Patch.Annotate.Class
    Darcs.Patch.Apply Darcs.Patch.ApplyMonad Darcs.Patch.Bracketed
    Darcs.Patch.Bundle Darcs.Patch.Choices Darcs.Patch.Commute
    Darcs.Patch.CommuteFn Darcs.Patch.CommuteNoConflicts
    Darcs.Patch.Conflict Darcs.Patch.Debug Darcs.Patch.Depends
    Darcs.Patch.Effect Darcs.Patch.FileHunk Darcs.Patch.Format
    Darcs.Patch.FromPrim Darcs.Patch.Ident Darcs.Patch.Index.Monad
    Darcs.Patch.Index.Types Darcs.Patch.Info Darcs.Patch.Inspect
    Darcs.Patch.Invert Darcs.Patch.Invertible Darcs.Patch.Match
    Darcs.Patch.Merge Darcs.Patch.Named Darcs.Patch.Object
    Darcs.Patch.PatchInfoAnd Darcs.Patch.Permutations Darcs.Patch.Prim
    Darcs.Patch.Prim.Canonize Darcs.Patch.Prim.Class
    Darcs.Patch.Prim.Coalesce Darcs.Patch.Prim.FileUUID
    Darcs.Patch.Prim.FileUUID.Apply Darcs.Patch.Prim.FileUUID.Coalesce
    Darcs.Patch.Prim.FileUUID.Commute Darcs.Patch.Prim.FileUUID.Core
    Darcs.Patch.Prim.FileUUID.Details
    Darcs.Patch.Prim.FileUUID.ObjectMap Darcs.Patch.Prim.FileUUID.Read
    Darcs.Patch.Prim.FileUUID.Show Darcs.Patch.Prim.Named
    Darcs.Patch.Prim.V1 Darcs.Patch.Prim.V1.Apply
    Darcs.Patch.Prim.V1.Coalesce Darcs.Patch.Prim.V1.Commute
    Darcs.Patch.Prim.V1.Core Darcs.Patch.Prim.V1.Details
    Darcs.Patch.Prim.V1.Mangle Darcs.Patch.Prim.V1.Read
    Darcs.Patch.Prim.V1.Show Darcs.Patch.Prim.WithName
    Darcs.Patch.Progress Darcs.Patch.Read Darcs.Patch.Rebase.Change
    Darcs.Patch.Rebase.Fixup Darcs.Patch.Rebase.Legacy.Item
    Darcs.Patch.Rebase.Legacy.Wrapped Darcs.Patch.Rebase.Name
    Darcs.Patch.Rebase.PushFixup Darcs.Patch.Rebase.Suspended
    Darcs.Patch.RegChars Darcs.Patch.Repair Darcs.Patch.RepoPatch
    Darcs.Patch.Set Darcs.Patch.Show Darcs.Patch.Split
    Darcs.Patch.Summary Darcs.Patch.SummaryData
    Darcs.Patch.TokenReplace Darcs.Patch.TouchesFiles
    Darcs.Patch.Unwind Darcs.Patch.V1 Darcs.Patch.V1.Apply
    Darcs.Patch.V1.Commute Darcs.Patch.V1.Core Darcs.Patch.V1.Prim
    Darcs.Patch.V1.Read Darcs.Patch.V1.Show Darcs.Patch.V1.Viewing
    Darcs.Patch.V2 Darcs.Patch.V2.Non Darcs.Patch.V2.Prim
    Darcs.Patch.V2.RepoPatch Darcs.Patch.V3 Darcs.Patch.V3.Contexted
    Darcs.Patch.V3.Core Darcs.Patch.V3.Resolution Darcs.Patch.Viewing
    Darcs.Patch.Witnesses.Eq Darcs.Patch.Witnesses.Maybe
    Darcs.Patch.Witnesses.Ordered Darcs.Patch.Witnesses.Sealed
    Darcs.Patch.Witnesses.Show Darcs.Patch.Witnesses.Unsafe
    Darcs.Patch.Witnesses.WZipper Darcs.Prelude Darcs.Repository
    Darcs.Repository.ApplyPatches Darcs.Repository.Clone
    Darcs.Repository.Create Darcs.Repository.Diff
    Darcs.Repository.Flags Darcs.Repository.Format
    Darcs.Repository.Hashed Darcs.Repository.Identify
    Darcs.Repository.InternalTypes Darcs.Repository.Inventory
    Darcs.Repository.Inventory.Format Darcs.Repository.Job
    Darcs.Repository.Match Darcs.Repository.Merge Darcs.Repository.Old
    Darcs.Repository.Packs Darcs.Repository.PatchIndex
    Darcs.Repository.Paths Darcs.Repository.Pending
    Darcs.Repository.Prefs Darcs.Repository.Pristine
    Darcs.Repository.Rebase Darcs.Repository.Repair
    Darcs.Repository.Resolution Darcs.Repository.State
    Darcs.Repository.Transaction Darcs.Repository.Traverse
    Darcs.Repository.Unrevert Darcs.Repository.Working
    Darcs.Test.TestOnly Darcs.UI.ApplyPatches Darcs.UI.Commands
    Darcs.UI.Commands.Add Darcs.UI.Commands.Amend
    Darcs.UI.Commands.Annotate Darcs.UI.Commands.Apply
    Darcs.UI.Commands.Clone Darcs.UI.Commands.Convert
    Darcs.UI.Commands.Convert.Darcs2 Darcs.UI.Commands.Convert.Export
    Darcs.UI.Commands.Convert.Import Darcs.UI.Commands.Convert.Util
    Darcs.UI.Commands.Diff Darcs.UI.Commands.Dist
    Darcs.UI.Commands.GZCRCs Darcs.UI.Commands.Help
    Darcs.UI.Commands.Init Darcs.UI.Commands.Log
    Darcs.UI.Commands.MarkConflicts Darcs.UI.Commands.Move
    Darcs.UI.Commands.Optimize Darcs.UI.Commands.Pull
    Darcs.UI.Commands.Push Darcs.UI.Commands.Rebase
    Darcs.UI.Commands.Record Darcs.UI.Commands.Remove
    Darcs.UI.Commands.Repair Darcs.UI.Commands.Replace
    Darcs.UI.Commands.Revert Darcs.UI.Commands.Rollback
    Darcs.UI.Commands.Send Darcs.UI.Commands.SetPref
    Darcs.UI.Commands.Show Darcs.UI.Commands.ShowAuthors
    Darcs.UI.Commands.ShowContents Darcs.UI.Commands.ShowDependencies
    Darcs.UI.Commands.ShowFiles Darcs.UI.Commands.ShowIndex
    Darcs.UI.Commands.ShowPatchIndex Darcs.UI.Commands.ShowRepo
    Darcs.UI.Commands.ShowTags Darcs.UI.Commands.Tag
    Darcs.UI.Commands.Test Darcs.UI.Commands.Test.Impl
    Darcs.UI.Commands.TransferMode Darcs.UI.Commands.Unrecord
    Darcs.UI.Commands.Unrevert Darcs.UI.Commands.Util
    Darcs.UI.Commands.WhatsNew Darcs.UI.Completion Darcs.UI.Defaults
    Darcs.UI.Email Darcs.UI.External Darcs.UI.Flags Darcs.UI.Options
    Darcs.UI.Options.All Darcs.UI.Options.Core Darcs.UI.Options.Flags
    Darcs.UI.Options.Iso Darcs.UI.Options.Markdown
    Darcs.UI.Options.Matching Darcs.UI.Options.Util
    Darcs.UI.PatchHeader Darcs.UI.PrintPatch Darcs.UI.Prompt
    Darcs.UI.RunCommand Darcs.UI.RunHook Darcs.UI.SelectChanges
    Darcs.UI.TestChanges Darcs.UI.TheCommands Darcs.UI.Usage
    Darcs.Util.AtExit Darcs.Util.ByteString Darcs.Util.Cache
    Darcs.Util.CommandLine Darcs.Util.Compat Darcs.Util.DateMatcher
    Darcs.Util.DateTime Darcs.Util.Diff Darcs.Util.Diff.Myers
    Darcs.Util.Diff.Patience Darcs.Util.Encoding Darcs.Util.English
    Darcs.Util.Exception Darcs.Util.Exec Darcs.Util.File
    Darcs.Util.Global Darcs.Util.Graph Darcs.Util.HTTP Darcs.Util.Hash
    Darcs.Util.Index Darcs.Util.IndexedMonad Darcs.Util.IsoDate
    Darcs.Util.Lock Darcs.Util.Parser Darcs.Util.Path
    Darcs.Util.Printer Darcs.Util.Printer.Color Darcs.Util.Progress
    Darcs.Util.Prompt Darcs.Util.Ratified Darcs.Util.Regex
    Darcs.Util.Show Darcs.Util.SignalHandler Darcs.Util.Ssh
    Darcs.Util.StrictIdentity Darcs.Util.Tree Darcs.Util.Tree.Hashed
    Darcs.Util.Tree.Monad Darcs.Util.Tree.Plain Darcs.Util.URL
    Darcs.Util.ValidHash Darcs.Util.Workaround

hidden-modules:       Version
import-dirs:          /usr/lib/ghc-9.6.6/site-local/darcs-2.18.5
library-dirs:         /usr/lib/ghc-9.6.6/site-local/darcs-2.18.5
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/darcs-2.18.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/darcs
hs-libraries:         HSdarcs-2.18.5-JX1B27H5XUnLvQZKfhpHVa
depends:
    array-0.5.6.0 async-2.2.5-A7cw4gHfrNnBMjsgvHD8kq
    attoparsec-0.14.4-K96akOPZKYDKXaMIGNQXgm base-4.18.2.1
    base16-bytestring-1.0.2.0-HJCFai38hrd834YANCdq3 binary-0.8.9.1
    bytestring-0.11.5.3 conduit-1.3.6.1-JmvSlylEAqiI8LFhx2lxVp
    constraints-0.14.2-FnaeOLwKi4Q5h8x6QJtEc8 containers-0.6.7
    crypton-connection-0.4.5-IRXuN8rt5iD9iK3x9Ixu0j
    cryptonite-0.30-6hOCVzlY3J31ea7MSfTNsC
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz
    data-ordlist-0.4.7.0-CHPzjR5nMSs40aYuNILHAG directory-1.3.8.5
    exceptions-0.10.7 fgl-5.8.3.0-8p6k4sbgP4yGyvYiL5xXBb
    filepath-1.4.300.1 hashable-1.4.7.0-L2Cc1YdcpYH9U2sZW5osde
    haskeline-0.8.2.1 html-1.0.1.2-yrvyqtjCXbBHvzYDYrrGC
    http-client-tls-0.3.6.4-JIwEy8eUUufD8fETx9XfAs
    http-conduit-2.3.9.1-AM32SHNXOnEIRTCqLgRxFH
    http-types-0.12.4-Ab6499xPt6j7ocIybq2ygA
    memory-0.18.0-6zo36PbRecTK4fqbBnx0f5
    mmap-0.5.9-AiaaDT3AznV3aaEfoYTVVt mtl-2.3.1
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    network-uri-2.6.4.2-4GU1spYfCy5EsCjKjgc97p
    old-time-1.1.0.4-3lD0LwNFkdkGhWCMuxpBlx parsec-3.1.16.1
    process-1.6.19.0 regex-applicative-0.3.4-Cmv5Ug6GmSsKw5VrN0RAve
    regex-base-0.94.0.3-6fVrfocUW2t4u08iX8Rj6b
    regex-tdfa-1.3.2.5-qZoXOptISAJcpXFSPLOTl
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo stm-2.5.1.0
    tar-0.5.1.1-HQ9Gn06wraDKdGF6LHHQOs
    temporary-1.3-D64vl65CCuJL1VfIJwvdvy
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h terminfo-0.4.1.6
    text-2.0.2 time-1.12.2 tls-2.0.6-G6rzAgmALmfESxoheKWYR8
    transformers-0.6.1.0 unix-2.8.4.0
    unix-compat-0.7.4.1-HX6CmWtGzNSCIQWePfXCFw
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI
    zip-archive-0.4.3.2-LZVIXJHNIlm9n9yyOiWrMh
    zlib-0.7.0.0-1ujaGtF2c5l6Jpv01tSCEr

haddock-interfaces:   /usr/share/doc/darcs/html/darcs.haddock
haddock-html:         /usr/share/doc/darcs/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

