/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.security;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2GlobalObject;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.ext.db2.model.security.DB2GrantorGranteeType;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DB2DatabaseAuth
extends DB2GlobalObject
implements DBAPrivilege {
    private DBSObject grantor;
    private DB2GrantorGranteeType grantorType;
    private Boolean bindAdd;
    private Boolean connect;
    private Boolean createTab;
    private Boolean dbAdm;
    private Boolean externalRoutine;
    private Boolean implicitSchema;
    private Boolean load;
    private Boolean noFence;
    private Boolean quiesceConnect;
    private Boolean libraryAdmin;
    private Boolean securityAdmin;
    private Boolean sqlAdmin;
    private Boolean workLoadAdmin;
    private Boolean explain;
    private Boolean dataAccess;
    private Boolean accessControl;
    private Boolean createSecure;

    public DB2DatabaseAuth(DBRProgressMonitor monitor, DB2DataSource dataSource, ResultSet resultSet) throws DBException {
        super(dataSource, true);
        String grantorName = JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"GRANTOR");
        this.grantorType = (DB2GrantorGranteeType)CommonUtils.valueOf(DB2GrantorGranteeType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)resultSet, (String)"GRANTORTYPE"));
        switch (this.grantorType) {
            case U: {
                this.grantor = dataSource.getUser(monitor, grantorName);
                break;
            }
            case G: {
                this.grantor = dataSource.getGroup(monitor, grantorName);
                break;
            }
        }
        this.bindAdd = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"BINDADDAUTH", (String)DB2YesNo.Y.name());
        this.connect = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"CONNECTAUTH", (String)DB2YesNo.Y.name());
        this.createTab = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"CREATETABAUTH", (String)DB2YesNo.Y.name());
        this.dbAdm = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"DBADMAUTH", (String)DB2YesNo.Y.name());
        this.externalRoutine = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"EXTERNALROUTINEAUTH", (String)DB2YesNo.Y.name());
        this.implicitSchema = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"IMPLSCHEMAAUTH", (String)DB2YesNo.Y.name());
        this.load = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"LOADAUTH", (String)DB2YesNo.Y.name());
        this.noFence = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"NOFENCEAUTH", (String)DB2YesNo.Y.name());
        this.quiesceConnect = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"QUIESCECONNECTAUTH", (String)DB2YesNo.Y.name());
        this.libraryAdmin = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"LIBRARYADMAUTH", (String)DB2YesNo.Y.name());
        this.securityAdmin = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"SECURITYADMAUTH", (String)DB2YesNo.Y.name());
        this.sqlAdmin = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"SQLADMAUTH", (String)DB2YesNo.Y.name());
        this.workLoadAdmin = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"WLMADMAUTH", (String)DB2YesNo.Y.name());
        this.explain = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"EXPLAINAUTH", (String)DB2YesNo.Y.name());
        this.dataAccess = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"DATAACCESSAUTH", (String)DB2YesNo.Y.name());
        this.accessControl = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"ACCESSCTRLAUTH", (String)DB2YesNo.Y.name());
        if (dataSource.isAtLeastV10_1()) {
            this.createSecure = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"CREATESECUREAUTH", (String)DB2YesNo.Y.name());
        }
    }

    @Property(hidden=true)
    @NotNull
    public String getName() {
        return "DBAUTH";
    }

    @Property(viewable=true, order=3)
    public DBSObject getGrantor() {
        return this.grantor;
    }

    @Property(viewable=true, order=4)
    public DB2GrantorGranteeType getGrantorType() {
        return this.grantorType;
    }

    @Property(viewable=true, order=20, category="Authorities")
    public Boolean getDbAdm() {
        return this.dbAdm;
    }

    @Property(viewable=true, order=21, category="Authorities")
    public Boolean getBindAdd() {
        return this.bindAdd;
    }

    @Property(viewable=true, order=22, category="Authorities")
    public Boolean getConnect() {
        return this.connect;
    }

    @Property(viewable=true, order=23, category="Authorities")
    public Boolean getCreateTab() {
        return this.createTab;
    }

    @Property(viewable=true, order=24, category="Authorities")
    public Boolean getExternalRoutine() {
        return this.externalRoutine;
    }

    @Property(viewable=true, order=25, category="Authorities")
    public Boolean getImplicitSchema() {
        return this.implicitSchema;
    }

    @Property(viewable=true, order=26, category="Authorities")
    public Boolean getLoad() {
        return this.load;
    }

    @Property(viewable=true, order=27, category="Authorities")
    public Boolean getDataAccess() {
        return this.dataAccess;
    }

    @Property(viewable=true, order=28, category="Authorities")
    public Boolean getAccessControl() {
        return this.accessControl;
    }

    @Property(viewable=false, order=29, category="Authorities")
    public Boolean getNoFence() {
        return this.noFence;
    }

    @Property(viewable=false, order=30, category="Authorities")
    public Boolean getQuiesceConnect() {
        return this.quiesceConnect;
    }

    @Property(viewable=false, order=31, category="Authorities")
    public Boolean getLibraryAdmin() {
        return this.libraryAdmin;
    }

    @Property(viewable=false, order=32, category="Authorities")
    public Boolean getSecurityAdmin() {
        return this.securityAdmin;
    }

    @Property(viewable=false, order=33, category="Authorities")
    public Boolean getSqlAdmin() {
        return this.sqlAdmin;
    }

    @Property(viewable=false, order=34, category="Authorities")
    public Boolean getWorkLoadAdmin() {
        return this.workLoadAdmin;
    }

    @Property(viewable=false, order=35, category="Authorities")
    public Boolean getExplain() {
        return this.explain;
    }

    @Property(viewable=false, order=36, category="Authorities")
    public Boolean getCreateSecure() {
        return this.createSecure;
    }
}

