/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.quicksearch.internal.core.LineItem;
import org.eclipse.text.quicksearch.internal.core.QuickTextQuery;
import org.eclipse.text.quicksearch.internal.core.QuickTextSearchRequestor;
import org.eclipse.text.quicksearch.internal.core.QuickTextSearcher;
import org.eclipse.text.quicksearch.internal.core.priority.PriorityFunction;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.quickaccess.IQuickAccessComputer;
import org.eclipse.ui.quickaccess.IQuickAccessComputerExtension;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.eclipse.ui.texteditor.ITextEditor;

public class QuickSearchQuickAccessComputer
extends QuickTextSearchRequestor
implements IQuickAccessComputer,
IQuickAccessComputerExtension {
    private static final int MAX_ENTRIES = 20;
    private static final long TIMEOUT = 200L;
    private final PriorityFunction priorities = new QuickSearchContext(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).createPriorityFun();

    public QuickAccessElement[] computeElements(String query, IProgressMonitor monitor) {
        final List matches = Collections.synchronizedList(new ArrayList());
        QuickTextQuery newQuery = new QuickTextQuery(query, true);
        QuickTextSearcher searcher = new QuickTextSearcher(newQuery, this.priorities, QuickSearchActivator.getDefault().getPreferences().getMaxLineLen(), new QuickTextSearchRequestor(){

            @Override
            public void add(LineItem match) {
                if (matches.size() < 20) {
                    matches.add(match);
                }
            }

            @Override
            public void clear() {
                matches.clear();
            }

            @Override
            public void revoke(LineItem line) {
                matches.remove(line);
            }
        });
        searcher.setMaxResults(20);
        long start = System.currentTimeMillis();
        while (matches.size() < 20 && !searcher.isDone() && System.currentTimeMillis() - start < 200L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                QuickSearchActivator.log(e);
            }
        }
        searcher.cancel();
        return (QuickAccessElement[])matches.stream().map(LineItemQuickAccessElement::new).toArray(QuickAccessElement[]::new);
    }

    public QuickAccessElement[] computeElements() {
        return new QuickAccessElement[0];
    }

    public void resetState() {
    }

    public boolean needsRefresh() {
        return false;
    }

    private static class LineItemQuickAccessElement
    extends QuickAccessElement {
        private final LineItem item;

        public LineItemQuickAccessElement(LineItem item) {
            this.item = item;
        }

        public String getLabel() {
            return NLS.bind((String)Messages.quickAccessMatch, (Object)this.item.getText(), (Object)this.item.getFile().getName());
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getId() {
            return this.item.getFile().getFullPath().toString() + "[" + this.item.getOffset() + ":" + (this.item.getOffset() + this.item.getText().length() - 1) + "]";
        }

        public void execute() {
            try {
                IEditorPart part = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.item.getFile());
                if (part instanceof ITextEditor) {
                    ((ITextEditor)part).getSelectionProvider().setSelection((ISelection)new TextSelection(this.item.getOffset(), this.item.getText().length()));
                }
            }
            catch (PartInitException e) {
                QuickSearchActivator.log(e);
            }
        }
    }
}

