/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;

public class DisableSQLSyntaxParserHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "org.jkiss.dbeaver.ui.editors.sql.disableSQLSyntaxParser";

    @Nullable
    public Object execute(@NotNull ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof SQLEditor) {
            IEditorInput editorInput;
            SQLEditorUtils.setSQLSyntaxParserEnabled(editorInput, !SQLEditorUtils.isSQLSyntaxParserEnabled(editorInput = editor.getEditorInput()));
        }
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IEditorPart editor = activePage.getActiveEditor();
            return editor != null && !SQLEditorBase.isBigScript(editor.getEditorInput());
        }
        return false;
    }

    public void updateElement(@NotNull UIElement element, @Nullable Map parameters) {
        IEditorPart editor;
        IWorkbenchPage activePage = ((IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class)).getActivePage();
        if (activePage != null && (editor = activePage.getActiveEditor()) instanceof SQLEditor) {
            element.setChecked(!SQLEditorUtils.isSQLSyntaxParserApplied(((SQLEditor)editor).getEditorInput()));
        }
    }
}

