/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateVariableType;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContext;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLVariableCompletionProposal;

public class SQLVariable
extends TemplateVariable {
    private static final Object DEFAULT_KEY = new Object();
    private SQLContext context;
    private TemplateVariableResolver resolver;
    private final Map<Object, Object[]> fValueMap = new HashMap<Object, Object[]>();
    private Object fKey;
    private Object fCurrentChoice;

    public SQLVariable(SQLContext context, TemplateVariableType type, String name, int[] offsets) {
        super(type, name, name, offsets);
        this.context = context;
        this.fKey = DEFAULT_KEY;
        this.fValueMap.put(this.fKey, new String[]{name});
        this.fCurrentChoice = this.getChoices()[0];
    }

    public void setChoices(Object key, Object[] values) {
        Assert.isNotNull((Object)key);
        Assert.isTrue((values.length > 0 ? 1 : 0) != 0);
        if (this.fValueMap != null) {
            this.fValueMap.put(key, values);
            if (key.equals(this.fKey)) {
                this.fCurrentChoice = this.getChoices()[0];
            }
            this.setResolved(true);
        }
    }

    public void setKey(Object defaultKey) {
        Assert.isTrue((boolean)this.fValueMap.containsKey(defaultKey));
        if (!this.fKey.equals(defaultKey)) {
            this.fKey = defaultKey;
            this.fCurrentChoice = this.getChoices()[0];
        }
    }

    public Object getCurrentChoice() {
        return this.fCurrentChoice;
    }

    public void setCurrentChoice(Object currentChoice) {
        Assert.isTrue((boolean)Arrays.asList(this.getChoices()).contains(currentChoice));
        this.fCurrentChoice = currentChoice;
    }

    public void setValues(String[] values) {
        this.setChoices(values);
    }

    public void setChoices(Object[] values) {
        this.setChoices(DEFAULT_KEY, values);
    }

    public String getDefaultValue() {
        return this.toString(this.fCurrentChoice);
    }

    public String toString(Object object) {
        return object.toString();
    }

    public String[] getValues() {
        Object[] values = this.getChoices();
        String[] result = new String[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.toString(values[i]);
        }
        return result;
    }

    public Object[] getChoices() {
        return this.getChoices(this.fKey);
    }

    public Object[] getChoices(Object key) {
        return this.fValueMap.get(key);
    }

    public Object[][] getAllChoices() {
        return (Object[][])this.fValueMap.values().toArray((T[])new Object[this.fValueMap.size()][]);
    }

    public TemplateVariableResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(TemplateVariableResolver resolver) {
        this.resolver = resolver;
    }

    public ICompletionProposal[] getProposals(Position position, int length) {
        if (this.resolver != null) {
            this.resolver.resolve((TemplateVariable)this, (TemplateContext)this.context);
        }
        String[] values = this.getValues();
        ICompletionProposal[] proposals = new ICompletionProposal[values.length];
        for (int j = 0; j < values.length; ++j) {
            proposals[j] = new SQLVariableCompletionProposal(this, values[j], position, length);
        }
        return proposals;
    }

    public SQLContext getContext() {
        return this.context;
    }
}

