/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.plantuml.rules;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.PackageMatchers;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.AllDependenciesCondition;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import com.tngtech.archunit.library.plantuml.rules.JavaClassDiagramAssociation;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlComponent;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlDiagram;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlParseException;
import com.tngtech.archunit.library.plantuml.rules.PlantUmlParser;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.FluentIterable;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class PlantUmlArchCondition
extends ArchCondition<JavaClass> {
    private final DescribedPredicate<Dependency> ignorePredicate;
    private final JavaClassDiagramAssociation javaClassDiagramAssociation;

    private PlantUmlArchCondition(String description, DescribedPredicate<Dependency> ignorePredicate, JavaClassDiagramAssociation javaClassDiagramAssociation) {
        super(description, new Object[0]);
        this.ignorePredicate = ignorePredicate;
        this.javaClassDiagramAssociation = javaClassDiagramAssociation;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependenciesWithOrigin(DescribedPredicate<? super JavaClass> ignorePredicate) {
        return this.ignoreDependencies(Dependency.Functions.GET_ORIGIN_CLASS.is(ignorePredicate).as("ignoring dependencies with origin " + ignorePredicate.getDescription(), new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependenciesWithTarget(DescribedPredicate<? super JavaClass> ignorePredicate) {
        return this.ignoreDependencies(Dependency.Functions.GET_TARGET_CLASS.is(ignorePredicate).as("ignoring dependencies with target " + ignorePredicate.getDescription(), new Object[0]));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependencies(Class<?> origin, Class<?> target) {
        return this.ignoreDependencies(origin.getName(), target.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependencies(String origin, String target) {
        return this.ignoreDependencies(Dependency.Functions.GET_ORIGIN_CLASS.is(HasName.Predicates.name(origin)).and(Dependency.Functions.GET_TARGET_CLASS.is(HasName.Predicates.name(target))).as("ignoring dependencies from %s to %s", origin, target));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public PlantUmlArchCondition ignoreDependencies(DescribedPredicate<? super Dependency> ignorePredicate) {
        String description = this.getDescription() + ", " + ignorePredicate.getDescription();
        return new PlantUmlArchCondition(description, this.ignorePredicate.or(ignorePredicate), this.javaClassDiagramAssociation);
    }

    @Override
    public void check(JavaClass javaClass, ConditionEvents events) {
        if (this.allDependenciesAreIgnored(javaClass)) {
            return;
        }
        if (!this.javaClassDiagramAssociation.contains(javaClass)) {
            events.add(SimpleConditionEvent.violated(javaClass, String.format("Class %s is not contained in any component", javaClass.getName())));
            return;
        }
        Set<PlantUmlComponent> components = this.javaClassDiagramAssociation.getAssociatedComponents(javaClass);
        if (components.size() > 1) {
            events.add(SimpleConditionEvent.violated(javaClass, String.format("Class %s may not be contained in more than one component, but is contained in [%s]", javaClass.getName(), PlantUmlArchCondition.joinSortedNames(components))));
            return;
        }
        this.checkDependencies(javaClass, events);
    }

    private static String joinSortedNames(Set<PlantUmlComponent> components) {
        return components.stream().map(it -> it.getComponentName().asString()).sorted().collect(Collectors.joining(", "));
    }

    private void checkDependencies(JavaClass javaClass, ConditionEvents events) {
        String[] allAllowedTargets = Sets.union(this.javaClassDiagramAssociation.getPackageIdentifiersFromComponentOf(javaClass), this.javaClassDiagramAssociation.getTargetPackageIdentifiers(javaClass)).toArray(new String[0]);
        AllDependenciesCondition delegate = ArchConditions.onlyHaveDependenciesInAnyPackage(allAllowedTargets).ignoreDependency(this.ignorePredicate);
        ((ArchCondition)delegate).check(javaClass, events);
    }

    private boolean allDependenciesAreIgnored(JavaClass item) {
        return item.getDirectDependenciesFromSelf().stream().allMatch(this.ignorePredicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(URL url, Configuration configuration) {
        return PlantUmlArchCondition.create(url, configuration);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(String fileName, Configuration configuration) {
        return PlantUmlArchCondition.create(PlantUmlArchCondition.toUrl(Paths.get(fileName, new String[0])), configuration);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(Path path, Configuration configuration) {
        return PlantUmlArchCondition.create(PlantUmlArchCondition.toUrl(path), configuration);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static PlantUmlArchCondition adhereToPlantUmlDiagram(File file, Configuration configuration) {
        return PlantUmlArchCondition.create(PlantUmlArchCondition.toUrl(file.toPath()), configuration);
    }

    private static PlantUmlArchCondition create(URL url, Configuration configuration) {
        PlantUmlDiagram diagram = new PlantUmlParser().parse(url);
        Preconditions.checkState(!diagram.getAllComponents().isEmpty(), "No components defined in diagram <%s>", (Object)url);
        JavaClassDiagramAssociation javaClassDiagramAssociation = new JavaClassDiagramAssociation(diagram);
        DescribedPredicate<Dependency> ignorePredicate = configuration.asIgnorePredicate(javaClassDiagramAssociation);
        return new PlantUmlArchCondition(PlantUmlArchCondition.getDescription(url, ignorePredicate.getDescription()), ignorePredicate, javaClassDiagramAssociation);
    }

    private static String getDescription(URL plantUmlUrl, String ignoreDescription) {
        return String.format("adhere to PlantUML diagram <%s>%s", PlantUmlArchCondition.getFileNameOf(plantUmlUrl), ignoreDescription);
    }

    private static String getFileNameOf(URL url) {
        return new File(url.getFile()).getName();
    }

    private static URL toUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new PlantUmlParseException(e);
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Configuration {
        private final Function<JavaClassDiagramAssociation, DescribedPredicate<Dependency>> createIgnorePredicate;

        private Configuration(Function<JavaClassDiagramAssociation, DescribedPredicate<Dependency>> createIgnorePredicate) {
            this.createIgnorePredicate = createIgnorePredicate;
        }

        DescribedPredicate<Dependency> asIgnorePredicate(JavaClassDiagramAssociation javaClassDiagramAssociation) {
            return this.createIgnorePredicate.apply(javaClassDiagramAssociation);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static Configuration consideringAllDependencies() {
            return new Configuration(javaClassDiagramAssociation -> DescribedPredicate.alwaysFalse().as("", new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static Configuration consideringOnlyDependenciesInDiagram() {
            return new Configuration(NotContainedInDiagramPredicate::new);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static Configuration consideringOnlyDependenciesInAnyPackage(String packageIdentifier, String ... furtherPackageIdentifiers) {
            ImmutableList<String> packageIdentifiers = FluentIterable.from(Collections.singleton(packageIdentifier)).append((String[])furtherPackageIdentifiers).toList();
            return new Configuration(javaClassDiagramAssociation -> new NotContainedInPackagesPredicate(packageIdentifiers));
        }

        private static class NotContainedInPackagesPredicate
        extends DescribedPredicate<Dependency> {
            private final List<String> packageIdentifiers;

            NotContainedInPackagesPredicate(List<String> packageIdentifiers) {
                super(" while ignoring dependencies outside of packages [%s]", Formatters.joinSingleQuoted(packageIdentifiers));
                this.packageIdentifiers = packageIdentifiers;
            }

            @Override
            public boolean test(Dependency input) {
                return !PackageMatchers.of(this.packageIdentifiers).test(input.getTargetClass().getPackageName());
            }
        }

        private static class NotContainedInDiagramPredicate
        extends DescribedPredicate<Dependency> {
            private final JavaClassDiagramAssociation javaClassDiagramAssociation;

            NotContainedInDiagramPredicate(JavaClassDiagramAssociation javaClassDiagramAssociation) {
                super(" while ignoring dependencies not contained in the diagram", new Object[0]);
                this.javaClassDiagramAssociation = javaClassDiagramAssociation;
            }

            @Override
            public boolean test(Dependency input) {
                return !this.javaClassDiagramAssociation.contains(input.getTargetClass());
            }
        }
    }
}

