/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;

public class NativeArrayBuffer
extends IdScriptableObject {
    private static final long serialVersionUID = 3110411773054879549L;
    public static final String CLASS_NAME = "ArrayBuffer";
    private static final byte[] EMPTY_BUF = new byte[0];
    final byte[] buffer;
    private static final int Id_constructor = 1;
    private static final int Id_slice = 2;
    private static final int MAX_PROTOTYPE_ID = 2;
    private static final int ConstructorId_isView = -1;
    private static final int Id_byteLength = 1;
    private static final int MAX_INSTANCE_ID = 1;

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeArrayBuffer nativeArrayBuffer = new NativeArrayBuffer();
        nativeArrayBuffer.exportAsJSClass(2, scriptable, bl);
    }

    public NativeArrayBuffer() {
        this.buffer = EMPTY_BUF;
    }

    public NativeArrayBuffer(double d) {
        if (d >= 2.147483647E9) {
            throw ScriptRuntime.rangeError("length parameter (" + d + ") is too large ");
        }
        if (d == Double.NEGATIVE_INFINITY) {
            throw ScriptRuntime.rangeError("Negative array length " + d);
        }
        if (d <= -1.0) {
            throw ScriptRuntime.rangeError("Negative array length " + d);
        }
        int n = ScriptRuntime.toInt32(d);
        if (n < 0) {
            throw ScriptRuntime.rangeError("Negative array length " + d);
        }
        this.buffer = n == 0 ? EMPTY_BUF : new byte[n];
    }

    public int getLength() {
        return this.buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public NativeArrayBuffer slice(double d, double d2) {
        int n = ScriptRuntime.toInt32(Math.max(0.0, Math.min((double)this.buffer.length, d2 < 0.0 ? (double)this.buffer.length + d2 : d2)));
        int n2 = ScriptRuntime.toInt32(Math.min((double)n, Math.max(0.0, d < 0.0 ? (double)this.buffer.length + d : d)));
        int n3 = n - n2;
        NativeArrayBuffer nativeArrayBuffer = new NativeArrayBuffer(n3);
        System.arraycopy(this.buffer, n2, nativeArrayBuffer.buffer, 0, n3);
        return nativeArrayBuffer;
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CLASS_NAME)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case -1: {
                return NativeArrayBuffer.isArg(objectArray, 0) && objectArray[0] instanceof NativeArrayBufferView;
            }
            case 1: {
                double d = NativeArrayBuffer.isArg(objectArray, 0) ? ScriptRuntime.toNumber(objectArray[0]) : 0.0;
                return new NativeArrayBuffer(d);
            }
            case 2: {
                NativeArrayBuffer nativeArrayBuffer = NativeArrayBuffer.realThis(scriptable2, idFunctionObject);
                double d = NativeArrayBuffer.isArg(objectArray, 0) ? ScriptRuntime.toNumber(objectArray[0]) : 0.0;
                double d2 = NativeArrayBuffer.isArg(objectArray, 1) ? ScriptRuntime.toNumber(objectArray[1]) : (double)nativeArrayBuffer.buffer.length;
                return nativeArrayBuffer.slice(d, d2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private static NativeArrayBuffer realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        return NativeArrayBuffer.ensureType(scriptable, NativeArrayBuffer.class, idFunctionObject);
    }

    private static boolean isArg(Object[] objectArray, int n) {
        return objectArray.length > n && !Undefined.instance.equals(objectArray[n]);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 2;
                string = "slice";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(CLASS_NAME, n, string, n2);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "constructor": {
                n = 1;
                break;
            }
            case "slice": {
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        this.addIdFunctionProperty(idFunctionObject, CLASS_NAME, -1, "isView", 1);
    }

    @Override
    protected int getMaxInstanceId() {
        return 1;
    }

    @Override
    protected String getInstanceIdName(int n) {
        if (n == 1) {
            return "byteLength";
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        if (n == 1) {
            return ScriptRuntime.wrapInt(this.buffer.length);
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        if ("byteLength".equals(string)) {
            return NativeArrayBuffer.instanceIdInfo(5, 1);
        }
        return super.findInstanceIdInfo(string);
    }
}

