/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.MediaQuery;
import io.sf.carte.doc.style.css.parser.MediaQueryDatabase;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;

public abstract class AbstractMediaQuery
implements MediaQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashSet<String> rangeFeatureSet = new HashSet(MediaQueryDatabase.rangeFeatures.length);
    private String mediaType = null;
    private boolean negativeQuery = false;
    private boolean onlyPrefix = false;
    private BooleanCondition predicate = null;

    protected AbstractMediaQuery() {
    }

    private static String escapeIdentifier(String medium) {
        return ParseHelper.escape(medium);
    }

    protected static boolean isRangeFeature(String string) {
        return rangeFeatureSet.contains(string);
    }

    @Override
    public BooleanCondition getCondition() {
        return this.predicate;
    }

    @Override
    public String getMedia() {
        StringBuilder buf = new StringBuilder(32);
        if (this.negativeQuery) {
            buf.append("not ");
        } else if (this.onlyPrefix) {
            buf.append("only ");
        }
        if (this.predicate != null) {
            this.predicate.appendText(buf);
        } else if (this.mediaType != null) {
            buf.append(AbstractMediaQuery.escapeIdentifier(this.mediaType));
        }
        return buf.toString();
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getMinifiedMedia() {
        StringBuilder buf = new StringBuilder(32);
        if (this.negativeQuery) {
            buf.append("not ");
        } else if (this.onlyPrefix) {
            buf.append("only ");
        }
        if (this.predicate != null) {
            this.predicate.appendMinifiedText(buf);
        } else if (this.mediaType != null) {
            buf.append(AbstractMediaQuery.escapeIdentifier(this.mediaType));
        }
        return buf.toString();
    }

    @Override
    public boolean isAllMedia() {
        return (this.mediaType == null || "all".equalsIgnoreCase(this.mediaType)) && !this.negativeQuery && this.predicate == null;
    }

    @Override
    public boolean isNegated() {
        return this.negativeQuery;
    }

    @Override
    public boolean isNotAllMedia() {
        return "all".equalsIgnoreCase(this.mediaType) && this.negativeQuery && this.predicate == null;
    }

    protected boolean matches(AbstractMediaQuery other) {
        boolean isAllMedium;
        if (other.isNotAllMedia()) {
            return false;
        }
        boolean bl = isAllMedium = this.mediaType == null || "all".equals(this.mediaType);
        if (this.negativeQuery ? (isAllMedium ? this.predicate == null : (this.mediaType.equals(other.mediaType) ? !other.negativeQuery : other.negativeQuery)) : !isAllMedium && (other.negativeQuery || !this.mediaType.equals(other.mediaType))) {
            return false;
        }
        if (this.predicate == null) {
            return true;
        }
        if (other.predicate == null) {
            return false;
        }
        byte negatedQuery = this.negativeQuery ? (!other.negativeQuery ? (byte)1 : 0) : (other.negativeQuery ? (byte)2 : 0);
        return this.matches(this.predicate, other.predicate, negatedQuery) != 0;
    }

    protected abstract byte matches(BooleanCondition var1, BooleanCondition var2, byte var3);

    public boolean matches(String medium, CSSCanvas canvas) {
        if (this.mediaType != null && (this.mediaType.equals(medium) ? this.negativeQuery : !this.negativeQuery)) {
            return false;
        }
        if (this.predicate != null) {
            if (canvas == null) {
                return false;
            }
            return this.matchesCondition(this.predicate, canvas);
        }
        return true;
    }

    private boolean matchesCondition(BooleanCondition condition, CSSCanvas canvas) {
        switch (condition.getType()) {
            case AND: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (this.matchesCondition(subcond, canvas)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return !this.matchesCondition(condition.getNestedCondition(), canvas);
            }
            case OR: {
                for (BooleanCondition subcond : condition.getSubConditions()) {
                    if (!this.matchesCondition(subcond, canvas)) continue;
                    return true;
                }
                break;
            }
            default: {
                return this.matchesPredicate(condition, canvas);
            }
        }
        return false;
    }

    protected abstract boolean matchesPredicate(BooleanCondition var1, CSSCanvas var2);

    protected void setFeaturePredicate(BooleanCondition predicate) {
        this.predicate = predicate;
    }

    protected void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    protected void setNegative(boolean negative) {
        this.negativeQuery = negative;
    }

    protected void setOnlyPrefix(boolean only) {
        this.onlyPrefix = only;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractMediaQuery other = (AbstractMediaQuery)obj;
        if (this.mediaType == null ? other.mediaType != null : !this.mediaType.equals(other.mediaType)) {
            return false;
        }
        if (this.negativeQuery != other.negativeQuery) {
            return false;
        }
        if (this.onlyPrefix != other.onlyPrefix) {
            return false;
        }
        if (this.predicate == null) {
            if (other.predicate != null) {
                return false;
            }
        } else {
            if (other.predicate == null) {
                return false;
            }
            if (!this.predicate.equals(other.predicate)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        result = 31 * result + (this.negativeQuery ? 1231 : 1237);
        result = 31 * result + (this.onlyPrefix ? 1231 : 1237);
        if (this.predicate != null) {
            result = 31 * result + this.predicate.hashCode();
        }
        return result;
    }

    public String toString() {
        return this.getMedia();
    }

    static {
        Collections.addAll(rangeFeatureSet, MediaQueryDatabase.rangeFeatures);
    }
}

