/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledList;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftFunction;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftGlobalVariableOnceFunctionNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Demangled namespace = null;
        DemangledList names = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case GlobalVariableOnceDeclList: {
                    DemangledList list;
                    Demangled demangled = child.demangle(demangler);
                    if (!(demangled instanceof DemangledList)) continue block4;
                    names = list = (DemangledList)demangled;
                    break;
                }
                case Structure: {
                    namespace = child.demangle(demangler);
                    break;
                }
                default: {
                    this.skip(child);
                }
            }
        }
        StringBuilder name = new StringBuilder("one_time_init");
        if (names != null) {
            if (!names.isEmpty()) {
                name.append("_for");
            }
            for (Demangled entry : names) {
                name.append("_" + entry.getDemangledName());
            }
        }
        return new SwiftFunction(this.properties.mangled(), this.properties.originalDemangled(), name.toString(), namespace, "default");
    }
}

