/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import generic.random.SecureRandomFactory;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.x500.X500Principal;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;

public class PKIUtils {
    public static final String RSA_TYPE = "RSA";
    private static final int KEY_SIZE = 4096;
    private static final String SIGNING_ALGORITHM = "SHA512withRSA";
    private static final int MILLISECONDS_PER_DAY = 86400000;
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final String[] PKCS_FILE_EXTENSIONS = new String[]{"p12", "pks", "pfx"};
    public static final FileNameExtensionFilter PKCS_FILENAME_FILTER = new FileNameExtensionFilter("PKCS Key File", PKCS_FILE_EXTENSIONS);

    public static X509TrustManager getTrustManager(File caCertsFile) throws CancelledException, GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        if (!caCertsFile.isFile()) {
            throw new FileNotFoundException("CA Certificates file not found: " + caCertsFile.getAbsolutePath());
        }
        KeyStore keyStore = PKIUtils.loadCertificateStore(caCertsFile.getAbsolutePath());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        X509TrustManager trustManager = null;
        for (TrustManager trustManager2 : trustManagers = tmf.getTrustManagers()) {
            X509TrustManager mgr;
            if (!(trustManager2 instanceof X509TrustManager)) continue;
            trustManager = mgr = (X509TrustManager)trustManager2;
            break;
        }
        if (trustManager == null) {
            throw new CertStoreException("Failed to load X509 TrustManager from " + caCertsFile.getAbsolutePath());
        }
        return trustManager;
    }

    private static Certificate[] makeCertificateChain(Certificate cert, Certificate ... caCerts) {
        Certificate[] chain = new Certificate[caCerts.length + 1];
        chain[0] = cert;
        System.arraycopy(caCerts, 0, chain, 1, caCerts.length);
        return chain;
    }

    public static void exportX509Certificates(Certificate[] certificates, File outFile) throws IOException, CertificateEncodingException {
        try (FileOutputStream fout = new FileOutputStream(outFile);
             PrintWriter writer = new PrintWriter(fout);){
            for (Certificate certificate : certificates) {
                if (!(certificate instanceof X509Certificate)) continue;
                writer.println(BEGIN_CERT);
                String base64 = Base64.getEncoder().encodeToString(certificate.getEncoded());
                while (base64.length() != 0) {
                    int endIndex = Math.min(44, base64.length());
                    String line = base64.substring(0, endIndex);
                    writer.println(line);
                    base64 = base64.substring(endIndex);
                }
                writer.println(END_CERT);
                writer.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final KeyStore createKeyStore(String alias, String dn, int durationDays, KeyStore.PrivateKeyEntry caEntry, File keyFile, String keystoreType, Collection<String> subjectAlternativeNames, char[] protectedPassphrase) throws KeyStoreException {
        final KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(protectedPassphrase);
        KeyStore.LoadStoreParameter loadStoreParameter = null;
        if (keyFile != null && keyFile.exists()) {
            loadStoreParameter = new KeyStore.LoadStoreParameter(){

                @Override
                public KeyStore.ProtectionParameter getProtectionParameter() {
                    return pp;
                }
            };
        }
        try {
            X500Name x500Name;
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            keyStore.load(loadStoreParameter);
            SecureRandom random = SecureRandomFactory.getSecureRandom();
            KeyPairGenerator rsa = KeyPairGenerator.getInstance(RSA_TYPE);
            rsa.initialize(4096);
            KeyPair keyPair = rsa.generateKeyPair();
            PrivateKey issuerKey = keyPair.getPrivate();
            byte[] encodedPublicKey = keyPair.getPublic().getEncoded();
            SubjectPublicKeyInfo bcPk = SubjectPublicKeyInfo.getInstance((Object)encodedPublicKey);
            X500Name caX500Name = x500Name = new X500Name(dn);
            KeyUsage keyUsage = new KeyUsage(164);
            if (caEntry != null) {
                Certificate caCert = caEntry.getCertificate();
                if (!(caCert instanceof X509Certificate)) {
                    throw new CertificateException("Unsupported certificate type: " + caCert.getType());
                }
                X509Certificate caX509Cert = (X509Certificate)caCert;
                caX500Name = new X500Name(caX509Cert.getSubjectX500Principal().getName());
                keyUsage = new KeyUsage(160);
                issuerKey = caEntry.getPrivateKey();
            }
            Date notBefore = new Date();
            long durationMs = (long)durationDays * 86400000L;
            Date notAfter = new Date(notBefore.getTime() + durationMs);
            BigInteger serialNumber = new BigInteger(128, random);
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(caX500Name, serialNumber, notBefore, notAfter, x500Name, bcPk);
            certificateBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)keyUsage);
            if (subjectAlternativeNames != null && !subjectAlternativeNames.isEmpty()) {
                ArrayList<GeneralName> nameList = new ArrayList<GeneralName>();
                for (String altName : subjectAlternativeNames) {
                    int nameType = IPAddress.isValid((String)altName) ? 7 : 2;
                    nameList.add(new GeneralName(nameType, altName));
                }
                GeneralName[] altNames = (GeneralName[])nameList.toArray(GeneralName[]::new);
                certificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(altNames));
            }
            if (caEntry == null) {
                certificateBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(1));
            }
            ContentSigner contentSigner = new JcaContentSignerBuilder(SIGNING_ALGORITHM).build(issuerKey);
            X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
            Certificate[] chain = caEntry == null ? new Certificate[]{certificate} : PKIUtils.makeCertificateChain(certificate, caEntry.getCertificateChain());
            keyStore.setKeyEntry(alias, keyPair.getPrivate(), protectedPassphrase, chain);
            if (keyFile != null) {
                try (FileOutputStream out = new FileOutputStream(keyFile);){
                    keyStore.store(out, protectedPassphrase);
                    out.flush();
                    out.getFD().sync();
                    Msg.debug(PKIUtils.class, (Object)(out.getChannel().size() + " bytes written to key/cert file: " + String.valueOf(keyFile)));
                }
                keyFile.setReadable(true, true);
                keyFile.setWritable(false);
            }
            Msg.debug(PKIUtils.class, (Object)("Certificate Generated (" + alias + "): " + dn));
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (IOException | GeneralSecurityException | OperatorException e) {
            throw new KeyStoreException("Failed to generate/store certificate (" + dn + ")", e);
        }
        finally {
            try {
                pp.destroy();
            }
            catch (DestroyFailedException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    public static final KeyStore.PrivateKeyEntry createKeyEntry(String alias, String dn, int durationDays, KeyStore.PrivateKeyEntry caEntry, File keyFile, String keystoreType, Collection<String> subjectAlternativeNames, char[] protectedPassphrase) throws KeyStoreException {
        KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(protectedPassphrase);
        try {
            KeyStore keyStore = PKIUtils.createKeyStore(alias, dn, durationDays, caEntry, keyFile, keystoreType, subjectAlternativeNames, protectedPassphrase);
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, pp);
            return privateKeyEntry;
        }
        catch (NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new KeyStoreException("Failed to generate/store certificate (" + dn + ")", e);
        }
        finally {
            try {
                pp.destroy();
            }
            catch (DestroyFailedException e) {
                throw new AssertException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyStore loadCertificateStore(String certsPath) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        int certCount = 0;
        KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
        store.load(null);
        FileInputStream fis = new FileInputStream(certsPath);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bis.available() > 0) {
                try {
                    Certificate cert = cf.generateCertificate(bis);
                    if (!(cert instanceof X509Certificate)) continue;
                    X509Certificate x509Cert = (X509Certificate)cert;
                    String name = PKIUtils.getCommonName(x509Cert.getSubjectX500Principal());
                    store.setCertificateEntry(name, cert);
                    ++certCount;
                }
                catch (CertificateException e) {
                    Throwable cause = e.getCause();
                    if (cause == null || !"Empty input".equals(cause.getMessage())) {
                        throw e;
                    }
                    break;
                }
            }
        }
        if (certCount == 0) {
            return PKIUtils.getKeyStoreInstance(certsPath, null);
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized KeyStore getKeyStoreInstance(String keystorePath, char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String type = PKIUtils.detectKeyStoreType(keystorePath);
        if (type == null) {
            throw new KeyStoreException("Unsupported PKI key store file type: " + keystorePath);
        }
        KeyStore ks = KeyStore.getInstance(type);
        FileInputStream fis = new FileInputStream(keystorePath);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            ks.load(bis, password);
        }
        return ks;
    }

    public static String detectKeyStoreType(String keystorePath) throws IOException {
        try (FileInputStream fis = new FileInputStream(keystorePath);){
            byte[] header = new byte[4];
            int read = fis.read(header);
            if (read < 4) {
                String string = null;
                return string;
            }
            if ((header[0] & 0xFF) == 254 && (header[1] & 0xFF) == 237 && (header[2] & 0xFF) == 254 && (header[3] & 0xFF) == 237) {
                String string = "JKS";
                return string;
            }
            if ((header[0] & 0xFF) == 48 && (header[1] & 0xFF) == 130) {
                String string = "PKCS12";
                return string;
            }
            String string = null;
            return string;
        }
    }

    private static String getCommonName(Principal subject) {
        String name = subject.getName();
        int commaIndex = name.indexOf(44);
        String firstElement = commaIndex < 0 ? name : name.substring(0, commaIndex);
        int equalsIndex = firstElement.indexOf(61);
        if (equalsIndex <= 0) {
            return name;
        }
        String fieldName = firstElement.substring(0, equalsIndex).trim();
        String fieldValue = firstElement.substring(equalsIndex + 1).trim();
        if (!fieldName.equalsIgnoreCase("CN")) {
            return name;
        }
        return fieldValue;
    }

    static void logCerts(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate certificate = keyStore.getCertificate(alias);
                if (certificate == null) continue;
                if (certificate instanceof X509Certificate) {
                    PKIUtils.logCert(alias, (X509Certificate)certificate);
                    continue;
                }
                Msg.warn(PKIUtils.class, (Object)("Ignore unrecognized certificate: alias=" + alias + ", type=" + certificate.getType()));
            }
        }
        catch (KeyStoreException e) {
            Msg.error(PKIUtils.class, (Object)"KeyStore failure", (Throwable)e);
        }
    }

    public static void logCerts(X509Certificate[] x509Certs) {
        for (X509Certificate x509Cert : x509Certs) {
            PKIUtils.logCert(null, x509Cert);
        }
    }

    static void logCert(String alias, X509Certificate x509Cert) {
        Object label;
        X500Principal subj = x509Cert.getSubjectX500Principal();
        X500Principal issuer = x509Cert.getIssuerX500Principal();
        Date now = new Date();
        Object object = label = alias != null ? alias + ": " : "";
        if (now.compareTo(x509Cert.getNotAfter()) > 0) {
            Msg.warn(PKIUtils.class, (Object)("   " + (String)label + PKIUtils.getCommonName(subj) + ", issued by " + PKIUtils.getCommonName(issuer) + ", S/N " + x509Cert.getSerialNumber().toString(16) + ", expired " + String.valueOf(x509Cert.getNotAfter()) + " **EXPIRED**"));
        } else {
            Msg.info(PKIUtils.class, (Object)("   " + (String)label + PKIUtils.getCommonName(subj) + ", issued by " + PKIUtils.getCommonName(issuer) + ", S/N " + x509Cert.getSerialNumber().toString(16) + ", expires " + String.valueOf(x509Cert.getNotAfter())));
        }
    }

    static {
        X500Name.setDefaultStyle((X500NameStyle)RFC4519Style.INSTANCE);
    }
}

