/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.mem.MemBuffer;

public interface DataTypeWithCharset
extends DataType {
    default public byte[] encodeCharacterValue(Object value, MemBuffer buf, Settings settings) throws DataTypeEncodeException {
        char[] normalizedValue;
        if (value instanceof Character) {
            normalizedValue = new char[]{((Character)value).charValue()};
        } else if (value instanceof char[]) {
            normalizedValue = (char[])value;
            if (normalizedValue.length > 2) {
                throw new DataTypeEncodeException("char[] must represent a single code point", value, this);
            }
        } else {
            throw new DataTypeEncodeException("Requires Character or char[] with a single code point", value, this);
        }
        StringDataInstance sdi = new StringDataInstance(this, settings, buf, this.getLength());
        try {
            return sdi.encodeReplacementFromCharValue(normalizedValue);
        }
        catch (Throwable e) {
            throw new DataTypeEncodeException(value, this, e);
        }
    }

    default public byte[] encodeCharacterRepresentation(String repr, MemBuffer buf, Settings settings) throws DataTypeEncodeException {
        StringDataInstance sdi = new StringDataInstance(this, settings, buf, this.getLength());
        try {
            return sdi.encodeReplacementFromCharRepresentation(repr);
        }
        catch (Throwable e) {
            throw new DataTypeEncodeException((Object)repr, this, e);
        }
    }

    default public String getCharsetName(Settings settings) {
        return "US-ASCII";
    }
}

