/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileObject;
import org.apache.commons.vfs2.provider.tar.TarFileObject;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;

public class TarFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(TarFileSystem.class);
    private final char[] ENC = new char[]{'!'};
    private final File file;
    private TarArchiveInputStream tarFile;
    private final Map<FileName, FileObject> cache = new HashMap<FileName, FileObject>();

    protected TarFileSystem(AbstractFileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
        this.file = parentLayer.getFileSystem().replicateFile(parentLayer, Selectors.SELECT_SELF);
        if (!this.file.exists()) {
            this.tarFile = null;
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(TarFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new TarFileObject(name, null, this, false);
    }

    protected TarArchiveInputStream createTarFile(File file) throws FileSystemException {
        try {
            if ("tgz".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarArchiveInputStream((InputStream)new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
            }
            if ("tbz2".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarArchiveInputStream(Bzip2FileObject.wrapInputStream(file.getAbsolutePath(), Files.newInputStream(file.toPath(), new OpenOption[0])));
            }
            return new TarArchiveInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException ioe) {
            throw new FileSystemException("vfs.provider.tar/open-tar-file.error", (Object)file, (Throwable)ioe);
        }
    }

    protected TarFileObject createTarFileObject(AbstractFileName name, TarArchiveEntry entry) {
        return new TarFileObject(name, entry, this, true);
    }

    @Override
    protected void doCloseCommunicationLink() {
        try {
            if (this.tarFile != null) {
                this.tarFile.close();
                this.tarFile = null;
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.tar/close-tar-file.error :" + this.file, e);
        }
    }

    @Override
    protected FileObject getFileFromCache(FileName name) {
        return this.cache.get(name);
    }

    public InputStream getInputStream(TarArchiveEntry entry) throws FileSystemException {
        this.resetTarFile();
        try {
            while (!this.tarFile.getNextEntry().equals(entry)) {
            }
            return this.tarFile;
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    protected TarArchiveInputStream getTarFile() throws FileSystemException {
        if (this.tarFile == null && this.file.exists()) {
            this.recreateTarFile();
        }
        return this.tarFile;
    }

    @Override
    public void init() throws FileSystemException {
        super.init();
        try {
            TarArchiveEntry entry;
            while ((entry = this.getTarFile().getNextTarEntry()) != null) {
                TarFileObject fileObj;
                AbstractFileName name = (AbstractFileName)this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(entry.getName(), this.ENC));
                if (entry.isDirectory() && this.getFileFromCache(name) != null) {
                    fileObj = (TarFileObject)this.getFileFromCache(name);
                    fileObj.setTarEntry(entry);
                    continue;
                }
                fileObj = this.createTarFileObject(name, entry);
                this.putFileToCache(fileObj);
                TarFileObject parent = null;
                for (AbstractFileName parentName = (AbstractFileName)name.getParent(); parentName != null; parentName = (AbstractFileName)parentName.getParent()) {
                    parent = (TarFileObject)this.getFileFromCache(parentName);
                    if (parent == null) {
                        parent = this.createTarFileObject(parentName, null);
                        this.putFileToCache(parent);
                    }
                    parent.attachChild(fileObj.getName());
                    fileObj = parent;
                }
            }
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    @Override
    protected void putFileToCache(FileObject file) {
        this.cache.put(file.getName(), file);
    }

    private void recreateTarFile() throws FileSystemException {
        if (this.tarFile != null) {
            try {
                this.tarFile.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider.tar/close-tar-file.error", (Object)this.file, (Throwable)e);
            }
            this.tarFile = null;
        }
        this.tarFile = this.createTarFile(this.file);
    }

    @Override
    protected void removeFileFromCache(FileName name) {
        this.cache.remove(name);
    }

    protected void resetTarFile() throws FileSystemException {
        if (this.file.exists()) {
            this.recreateTarFile();
        }
    }
}

