/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.FunctionBitPatternInfo;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FileBitPatternInfo {
    static final String XML_ELEMENT_NAME = "FileBitPatternInfo";
    private int numFirstBytes = 0;
    private int numFirstInstructions = 0;
    private int numPreBytes = 0;
    private int numPreInstructions = 0;
    private int numReturnBytes = 0;
    private int numReturnInstructions = 0;
    private String languageID = null;
    private String ghidraURL = null;
    private List<FunctionBitPatternInfo> funcBitPatternInfo = new ArrayList<FunctionBitPatternInfo>();

    public int getNumFirstBytes() {
        return this.numFirstBytes;
    }

    public void setNumFirstBytes(int numFirstBytes) {
        this.numFirstBytes = numFirstBytes;
    }

    public int getNumFirstInstructions() {
        return this.numFirstInstructions;
    }

    public void setNumFirstInstructions(int numFirstInstructions) {
        this.numFirstInstructions = numFirstInstructions;
    }

    public int getNumPreBytes() {
        return this.numPreBytes;
    }

    public void setNumPreBytes(int numPreBytes) {
        this.numPreBytes = numPreBytes;
    }

    public int getNumPreInstructions() {
        return this.numPreInstructions;
    }

    public void setNumPreInstructions(int numPreInstructions) {
        this.numPreInstructions = numPreInstructions;
    }

    public List<FunctionBitPatternInfo> getFuncBitPatternInfo() {
        return this.funcBitPatternInfo;
    }

    public void setFuncBitPatternInfo(List<FunctionBitPatternInfo> funcBitPatternInfo) {
        this.funcBitPatternInfo = funcBitPatternInfo;
    }

    public String getLanguageID() {
        return this.languageID;
    }

    public void setLanguageID(String id) {
        this.languageID = id;
    }

    public void setGhidraURL(String url) {
        this.ghidraURL = url;
    }

    public String getGhidraURL() {
        return this.ghidraURL;
    }

    public int getNumReturnBytes() {
        return this.numReturnBytes;
    }

    public void setNumReturnBytes(int numReturnBytes) {
        this.numReturnBytes = numReturnBytes;
    }

    public int getNumReturnInstructions() {
        return this.numReturnInstructions;
    }

    public void setNumReturnInstructions(int numReturnInstructions) {
        this.numReturnInstructions = numReturnInstructions;
    }

    public Element toXml() {
        Element result = new Element(XML_ELEMENT_NAME);
        XmlUtilities.setStringAttr((Element)result, (String)"ghidraURL", (String)this.ghidraURL);
        XmlUtilities.setStringAttr((Element)result, (String)"languageID", (String)this.languageID);
        XmlUtilities.setIntAttr((Element)result, (String)"numFirstBytes", (int)this.numFirstBytes);
        XmlUtilities.setIntAttr((Element)result, (String)"numFirstInstructions", (int)this.numFirstInstructions);
        XmlUtilities.setIntAttr((Element)result, (String)"numPreBytes", (int)this.numPreBytes);
        XmlUtilities.setIntAttr((Element)result, (String)"numPreInstructions", (int)this.numPreInstructions);
        XmlUtilities.setIntAttr((Element)result, (String)"numReturnBytes", (int)this.numReturnBytes);
        XmlUtilities.setIntAttr((Element)result, (String)"numReturnInstructions", (int)this.numReturnInstructions);
        Element funcBitPatternInfoListEle = new Element("funcBitPatternInfoList");
        for (FunctionBitPatternInfo fbpi : this.funcBitPatternInfo) {
            funcBitPatternInfoListEle.addContent((Content)fbpi.toXml());
        }
        result.addContent((Content)funcBitPatternInfoListEle);
        return result;
    }

    public static FileBitPatternInfo fromXml(Element e) throws IOException {
        String ghidraURL = e.getAttributeValue("ghidraURL");
        String languageID = e.getAttributeValue("languageID");
        int numFirstBytes = XmlUtilities.parseInt((String)XmlUtilities.requireStringAttr((Element)e, (String)"numFirstBytes"));
        int numFirstInstructions = XmlUtilities.parseInt((String)XmlUtilities.requireStringAttr((Element)e, (String)"numFirstInstructions"));
        int numPreBytes = XmlUtilities.parseInt((String)XmlUtilities.requireStringAttr((Element)e, (String)"numPreBytes"));
        int numPreInstructions = XmlUtilities.parseInt((String)XmlUtilities.requireStringAttr((Element)e, (String)"numPreInstructions"));
        int numReturnBytes = XmlUtilities.parseInt((String)XmlUtilities.requireStringAttr((Element)e, (String)"numReturnBytes"));
        int numReturnInstructions = XmlUtilities.parseInt((String)XmlUtilities.requireStringAttr((Element)e, (String)"numReturnInstructions"));
        ArrayList<FunctionBitPatternInfo> funcBitPatternInfoList = new ArrayList<FunctionBitPatternInfo>();
        Element funcBitPatternInfoListEle = e.getChild("funcBitPatternInfoList");
        if (funcBitPatternInfoListEle != null) {
            for (Element childElement : XmlUtilities.getChildren((Element)funcBitPatternInfoListEle, (String)"FunctionBitPatternInfo")) {
                funcBitPatternInfoList.add(FunctionBitPatternInfo.fromXml(childElement));
            }
        }
        FileBitPatternInfo result = new FileBitPatternInfo();
        result.setFuncBitPatternInfo(funcBitPatternInfoList);
        result.setGhidraURL(ghidraURL);
        result.setLanguageID(languageID);
        result.setNumFirstBytes(numFirstBytes);
        result.setNumFirstInstructions(numFirstInstructions);
        result.setNumPreBytes(numPreBytes);
        result.setNumPreInstructions(numPreInstructions);
        result.setNumReturnBytes(numReturnBytes);
        result.setNumReturnInstructions(numReturnInstructions);
        return result;
    }

    public void toXmlFile(File destFile) throws IOException {
        Element rootEle = this.toXml();
        Document doc = new Document(rootEle);
        XmlUtilities.writePrettyDocToFile((Document)doc, (File)destFile);
    }

    public static FileBitPatternInfo fromXmlFile(File inputFile) throws IOException {
        FileBitPatternInfo fileBitPatternInfo;
        SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        FileInputStream fis = new FileInputStream(inputFile);
        try {
            Document doc = sax.build((InputStream)fis);
            Element rootElem = doc.getRootElement();
            fileBitPatternInfo = FileBitPatternInfo.fromXml(rootElem);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JDOMException e) {
                Msg.error(FileBitPatternInfo.class, (Object)("Bad file bit pattern file " + String.valueOf(inputFile)), (Throwable)e);
                throw new IOException("Failed to read file bit pattern " + String.valueOf(inputFile), e);
            }
        }
        ((InputStream)fis).close();
        return fileBitPatternInfo;
    }
}

