/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.util.AddEditDialog;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;

class EditOperandNameAction
extends ListingContextAction {
    FunctionPlugin functionPlugin;

    EditOperandNameAction(FunctionPlugin plugin) {
        super("Rename Function Variable", plugin.getName());
        this.functionPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function Variables", "Rename Variable..."}, null, "FunctionVariable"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Variable var;
        if (this.isEnabled() && (var = this.getVariable(context)) != null) {
            Symbol s = var.getSymbol();
            if (s == null) {
                Msg.showError((Object)((Object)this), null, (String)"Edit Failed", (Object)"Variable may not be modified");
                return;
            }
            AddEditDialog dialog = new AddEditDialog("Edit Variable Name", this.functionPlugin.getTool());
            dialog.editLabel(s, context.getProgram());
        }
    }

    private Variable getVariable(ListingActionContext context) {
        VariableOffset variableOffset;
        if (context.hasSelection() || context.getAddress() == null) {
            return null;
        }
        ProgramLocation loc = context.getLocation();
        Program program = context.getProgram();
        if (!(loc instanceof OperandFieldLocation)) {
            return null;
        }
        OperandFieldLocation oloc = (OperandFieldLocation)loc;
        Instruction inst = program.getListing().getInstructionAt(oloc.getAddress());
        if (inst != null && (variableOffset = oloc.getVariableOffset()) != null) {
            return variableOffset.getVariable();
        }
        return null;
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        Variable v = this.getVariable(context);
        return v != null && v.getSymbol() != null;
    }
}

