/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import ghidra.app.plugin.core.terminal.vt.VtHandler;
import ghidra.util.Msg;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public abstract class TerminalAwtEventEncoder {
    public static final byte[] CODE_NONE = new byte[0];
    public static final byte ESC = 27;
    public static final byte[] CODE_INSERT = TerminalAwtEventEncoder.vtseq(2);
    public static final byte[] CODE_DELETE = TerminalAwtEventEncoder.vtseq(3);
    public static final byte[] CODE_ENTER = new byte[]{13};
    public static final byte[] CODE_PAGE_UP = TerminalAwtEventEncoder.vtseq(5);
    public static final byte[] CODE_PAGE_DOWN = TerminalAwtEventEncoder.vtseq(6);
    public static final byte[] CODE_NUMPAD5 = new byte[]{27, 91, 69};
    public static final byte[] CODE_UP_NORMAL = new byte[]{27, 91, 65};
    public static final byte[] CODE_DOWN_NORMAL = new byte[]{27, 91, 66};
    public static final byte[] CODE_RIGHT_NORMAL = new byte[]{27, 91, 67};
    public static final byte[] CODE_LEFT_NORMAL = new byte[]{27, 91, 68};
    public static final byte[] CODE_UP_APPLICATION = new byte[]{27, 79, 65};
    public static final byte[] CODE_DOWN_APPLICATION = new byte[]{27, 79, 66};
    public static final byte[] CODE_RIGHT_APPLICATION = new byte[]{27, 79, 67};
    public static final byte[] CODE_LEFT_APPLICATION = new byte[]{27, 79, 68};
    public static final byte[] CODE_HOME_NORMAL = new byte[]{27, 91, 72};
    public static final byte[] CODE_END_NORMAL = new byte[]{27, 91, 70};
    public static final byte[] CODE_HOME_APPLICATION = new byte[]{27, 79, 72};
    public static final byte[] CODE_END_APPLICATION = new byte[]{27, 79, 70};
    public static final byte[] CODE_F1 = new byte[]{27, 91, 49, 80};
    public static final byte[] CODE_F2 = new byte[]{27, 91, 49, 81};
    public static final byte[] CODE_F3 = new byte[]{27, 91, 49, 82};
    public static final byte[] CODE_F4 = new byte[]{27, 91, 49, 83};
    public static final byte[] CODE_F5 = TerminalAwtEventEncoder.vtseq(15);
    public static final byte[] CODE_F6 = TerminalAwtEventEncoder.vtseq(17);
    public static final byte[] CODE_F7 = TerminalAwtEventEncoder.vtseq(18);
    public static final byte[] CODE_F8 = TerminalAwtEventEncoder.vtseq(19);
    public static final byte[] CODE_F9 = TerminalAwtEventEncoder.vtseq(20);
    public static final byte[] CODE_F10 = TerminalAwtEventEncoder.vtseq(21);
    public static final byte[] CODE_F11 = TerminalAwtEventEncoder.vtseq(23);
    public static final byte[] CODE_F12 = TerminalAwtEventEncoder.vtseq(24);
    public static final byte[] CODE_F13 = TerminalAwtEventEncoder.vtseq(25);
    public static final byte[] CODE_F14 = TerminalAwtEventEncoder.vtseq(26);
    public static final byte[] CODE_F15 = TerminalAwtEventEncoder.vtseq(28);
    public static final byte[] CODE_F16 = TerminalAwtEventEncoder.vtseq(29);
    public static final byte[] CODE_F17 = TerminalAwtEventEncoder.vtseq(31);
    public static final byte[] CODE_F18 = TerminalAwtEventEncoder.vtseq(32);
    public static final byte[] CODE_F19 = TerminalAwtEventEncoder.vtseq(33);
    public static final byte[] CODE_F20 = TerminalAwtEventEncoder.vtseq(34);
    public static final byte[] CODE_FOCUS_GAINED = new byte[]{27, 91, 73};
    public static final byte[] CODE_FOCUS_LOST = new byte[]{27, 91, 79};
    protected final Charset charset;
    protected final CharsetEncoder encoder;
    protected final ByteBuffer bb = ByteBuffer.allocate(16);
    protected final CharBuffer cb = CharBuffer.allocate(16);

    public static byte[] vtseq(int number) {
        try {
            return ("\u001b[" + number + "~").getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public TerminalAwtEventEncoder(String charsetName) {
        this(Charset.forName(charsetName));
    }

    public TerminalAwtEventEncoder(Charset charset) {
        this.charset = charset;
        this.encoder = charset.newEncoder();
    }

    protected abstract void generateBytes(ByteBuffer var1);

    protected byte[] getModifiedAnsiKeyCode(KeyEvent e) {
        int code;
        int modifier = 1;
        if (e.isShiftDown()) {
            ++modifier;
        }
        if (e.isAltDown()) {
            modifier += 2;
        }
        if (e.isControlDown()) {
            modifier += 4;
        }
        if (e.isMetaDown()) {
            modifier += 8;
        }
        switch (e.getKeyCode()) {
            case 36: {
                int n = 1;
                break;
            }
            case 155: {
                int n = 2;
                break;
            }
            case 127: {
                int n = 3;
                break;
            }
            case 35: {
                int n = 4;
                break;
            }
            case 33: {
                int n = 5;
                break;
            }
            case 34: {
                int n = 6;
                break;
            }
            case 112: {
                int n = 11;
                break;
            }
            case 113: {
                int n = 12;
                break;
            }
            case 114: {
                int n = 13;
                break;
            }
            case 115: {
                int n = 14;
                break;
            }
            case 116: {
                int n = 15;
                break;
            }
            case 117: {
                int n = 17;
                break;
            }
            case 118: {
                int n = 18;
                break;
            }
            case 119: {
                int n = 19;
                break;
            }
            case 120: {
                int n = 20;
                break;
            }
            case 121: {
                int n = 21;
                break;
            }
            case 122: {
                int n = 23;
                break;
            }
            case 123: {
                int n = 24;
                break;
            }
            case 61440: {
                int n = 25;
                break;
            }
            case 61441: {
                int n = 26;
                break;
            }
            case 61442: {
                int n = 28;
                break;
            }
            case 61443: {
                int n = 29;
                break;
            }
            case 61444: {
                int n = 31;
                break;
            }
            case 61445: {
                int n = 32;
                break;
            }
            case 61446: {
                int n = 33;
                break;
            }
            case 61447: {
                int n = 34;
                break;
            }
            default: {
                int n = code = -1;
            }
        }
        if (code == -1) {
            return CODE_NONE;
        }
        try {
            return "\u001b[%d;%d~".formatted(code, modifier).getBytes("ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected byte[] getAnsiKeyCode(KeyEvent e, VtHandler.KeyMode cursorMode, VtHandler.KeyMode keypadMode) {
        if (e.getModifiersEx() != 0) {
            return this.getModifiedAnsiKeyCode(e);
        }
        return switch (e.getKeyCode()) {
            case 155 -> CODE_INSERT;
            case 36 -> cursorMode.choose(CODE_HOME_NORMAL, CODE_HOME_APPLICATION);
            case 35 -> cursorMode.choose(CODE_END_NORMAL, CODE_END_APPLICATION);
            case 33 -> CODE_PAGE_UP;
            case 34 -> CODE_PAGE_DOWN;
            case 101 -> CODE_NUMPAD5;
            case 38 -> cursorMode.choose(CODE_UP_NORMAL, CODE_UP_APPLICATION);
            case 40 -> cursorMode.choose(CODE_DOWN_NORMAL, CODE_DOWN_APPLICATION);
            case 39 -> cursorMode.choose(CODE_RIGHT_NORMAL, CODE_RIGHT_APPLICATION);
            case 37 -> cursorMode.choose(CODE_LEFT_NORMAL, CODE_LEFT_APPLICATION);
            case 112 -> CODE_F1;
            case 113 -> CODE_F2;
            case 114 -> CODE_F3;
            case 115 -> CODE_F4;
            case 116 -> CODE_F5;
            case 117 -> CODE_F6;
            case 118 -> CODE_F7;
            case 119 -> CODE_F8;
            case 120 -> CODE_F9;
            case 121 -> CODE_F10;
            case 122 -> CODE_F11;
            case 123 -> CODE_F12;
            case 61440 -> CODE_F13;
            case 61441 -> CODE_F14;
            case 61442 -> CODE_F15;
            case 61443 -> CODE_F16;
            case 61444 -> CODE_F17;
            case 61445 -> CODE_F18;
            case 61446 -> CODE_F19;
            case 61447 -> CODE_F20;
            default -> CODE_NONE;
        };
    }

    public void keyPressed(KeyEvent e, VtHandler.KeyMode cursorKeyMode, VtHandler.KeyMode keypadMode) {
        byte[] bytes = this.getAnsiKeyCode(e, cursorKeyMode, keypadMode);
        this.bb.put(bytes);
        this.generateBytesExc();
    }

    public void keyTyped(KeyEvent e) {
        this.sendChar(e.getKeyChar());
    }

    public void mousePressed(MouseEvent e, int row, int col) {
        this.mouseEvent(e, row, col, true);
    }

    public void mouseReleased(MouseEvent e, int row, int col) {
        this.mouseEvent(e, row, col, false);
    }

    protected int translateModifiers(InputEvent e) {
        int mods = 0;
        if (e.isShiftDown()) {
            mods += 4;
        }
        if (e.isMetaDown()) {
            mods += 8;
        }
        if (e.isControlDown()) {
            mods += 16;
        }
        return mods;
    }

    protected void sendMouseEvent(int buttonsAndModifiers, int row, int col) {
        this.cb.clear();
        this.cb.put("\u001b[M");
        this.cb.put((char)(32 + buttonsAndModifiers));
        this.cb.put((char)(32 + col));
        this.cb.put((char)(32 + row));
        this.sendCharBuffer();
    }

    protected void mouseEvent(MouseEvent e, int row, int col, boolean isPress) {
        int n;
        block6: {
            block5: {
                if (!isPress) break block5;
                switch (e.getButton()) {
                    case 1: {
                        n = 0;
                        break block6;
                    }
                    case 2: {
                        n = 1;
                        break block6;
                    }
                    case 3: {
                        n = 2;
                        break block6;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            n = 3;
        }
        int buttonsAndModifiers = n;
        this.sendMouseEvent(buttonsAndModifiers += this.translateModifiers(e), row, col);
    }

    public void mouseWheelMoved(MouseWheelEvent e, int row, int col) {
        int buttonsAndModifiers = (e.getWheelRotation() < 0 ? 0 : 1) + 64;
        this.sendMouseEvent(buttonsAndModifiers += this.translateModifiers(e), row, col);
    }

    public void focusGained() {
        this.bb.put(CODE_FOCUS_GAINED);
        this.generateBytesExc();
    }

    public void focusLost() {
        this.bb.put(CODE_FOCUS_LOST);
        this.generateBytesExc();
    }

    protected void sendCharBuffer() {
        this.cb.flip();
        CoderResult result = this.encoder.encode(this.cb, this.bb, true);
        this.cb.compact();
        if (result.isError()) {
            Msg.error((Object)this, (Object)"Error while encoding");
            this.encoder.reset();
            this.cb.clear();
        }
        this.generateBytesExc();
    }

    public void sendChar(char c) {
        switch (c) {
            case '\n': {
                this.bb.put(CODE_ENTER);
                this.generateBytesExc();
                break;
            }
            case '\u007f': {
                this.bb.put(CODE_DELETE);
                this.generateBytesExc();
                break;
            }
            default: {
                this.cb.clear();
                this.cb.put(c);
                this.sendCharBuffer();
            }
        }
    }

    protected void generateBytesExc() {
        this.bb.flip();
        try {
            if (this.bb.hasRemaining()) {
                this.generateBytes(this.bb);
            }
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Error generating bytes: " + String.valueOf(t)), (Throwable)t);
        }
        finally {
            this.bb.clear();
        }
    }

    public void sendText(CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            this.sendChar(text.charAt(i));
        }
    }
}

