/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.program.model.lang.Register;
import java.util.Map;

public class DWARFRegisterMappings {
    public static final DWARFRegisterMappings DUMMY = new DWARFRegisterMappings(Map.of(), null, -1, null, 0, false);
    private final Map<Integer, Register> dwarfRegisterMap;
    private final Integer callFrameCFA;
    private final int stackPointerIndex;
    private final boolean useFormalParameterStorage;
    private Register stackFrameRegister;
    private int stackFrameRegisterOffset;

    public DWARFRegisterMappings(Map<Integer, Register> regmap, Integer callFrameCFA, int stackPointerIndex, Register stackFrameRegister, int stackFrameRegisterOffset, boolean useFPS) {
        this.dwarfRegisterMap = regmap;
        this.callFrameCFA = callFrameCFA;
        this.stackPointerIndex = stackPointerIndex;
        this.stackFrameRegister = stackFrameRegister;
        this.useFormalParameterStorage = useFPS;
        this.stackFrameRegisterOffset = stackFrameRegisterOffset;
    }

    public Register getGhidraReg(int dwarfRegNum) {
        return this.dwarfRegisterMap.get(dwarfRegNum);
    }

    public int getCallFrameCFA() {
        return this.callFrameCFA;
    }

    public boolean hasStaticCFA() {
        return this.callFrameCFA != null;
    }

    public int getDWARFStackPointerRegNum() {
        return this.stackPointerIndex;
    }

    public Register getStackRegister() {
        return this.stackPointerIndex != -1 ? this.getGhidraReg(this.stackPointerIndex) : null;
    }

    public Register getStackFrameRegister() {
        return this.stackFrameRegister;
    }

    public int getStackFrameRegisterOffset() {
        return this.stackFrameRegisterOffset;
    }

    public boolean isUseFormalParameterStorage() {
        return this.useFormalParameterStorage;
    }

    public String toString() {
        return "DWARFRegisterMappings [dwarfRegisterMap=" + String.valueOf(this.dwarfRegisterMap) + ", callFrameCFA=" + this.callFrameCFA + ", stackPointerIndex=" + this.stackPointerIndex + ", useFormalParameterStorage=" + this.useFormalParameterStorage + "]";
    }
}

