/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.pef.LoaderInfoHeader;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ImportedLibrary
implements StructConverter {
    public static final int SIZEOF = 24;
    public static final int OPTION_kPEFWeakImportLibMask = 64;
    public static final int OPTION_kPEFInitLibBeforeMask = 128;
    private int nameOffset;
    private int oldImpVersion;
    private int currentVersion;
    private int importedSymbolCount;
    private int firstImportedSymbol;
    private byte options;
    private byte reservedA;
    private short reservedB;
    private String _name;

    ImportedLibrary(BinaryReader reader, LoaderInfoHeader loader) throws IOException {
        this.nameOffset = reader.readNextInt();
        this.oldImpVersion = reader.readNextInt();
        this.currentVersion = reader.readNextInt();
        this.importedSymbolCount = reader.readNextInt();
        this.firstImportedSymbol = reader.readNextInt();
        this.options = reader.readNextByte();
        this.reservedA = reader.readNextByte();
        this.reservedB = reader.readNextShort();
        long offset = loader.getSection().getContainerOffset() + loader.getLoaderStringsOffset() + this.nameOffset;
        this._name = reader.readAsciiString(offset);
    }

    public String getName() {
        return this._name;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public int getOldImpVersion() {
        return this.oldImpVersion;
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public int getImportedSymbolCount() {
        return this.importedSymbolCount;
    }

    public int getFirstImportedSymbol() {
        return this.firstImportedSymbol;
    }

    public byte getOptions() {
        return this.options;
    }

    public byte getReservedA() {
        return this.reservedA;
    }

    public short getReservedB() {
        return this.reservedB;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this.getClass());
    }
}

