/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomSpace
implements StructConverter {
    public static final int SIZE = 36;
    private String name;
    private boolean isLoadable;
    private boolean isDefined;
    private boolean isPrivate;
    private boolean hasIntermediateCode;
    private boolean isThreadSpecific;
    private int reserved;
    private int sortKey;
    private int reserved2;
    private int spaceNumber;
    private int subspaceIndex;
    private long subspaceQuantity;
    private int loaderFixIndex;
    private long loaderFixQuantity;
    private int initPointerIndex;
    private long initPointerQuantity;

    public SomSpace(BinaryReader reader, long spaceStringsLocation) throws IOException {
        this.name = reader.readAsciiString(spaceStringsLocation + reader.readNextUnsignedInt());
        int bitfield = reader.readNextInt();
        this.reserved2 = bitfield & 0xFF;
        this.sortKey = bitfield >> 8 & 0xFF;
        this.reserved = bitfield >> 16 & 0x7FF;
        this.isThreadSpecific = (bitfield >> 27 & 1) != 0;
        this.hasIntermediateCode = (bitfield >> 28 & 1) != 0;
        this.isPrivate = (bitfield >> 29 & 1) != 0;
        this.isDefined = (bitfield >> 30 & 1) != 0;
        this.isLoadable = (bitfield >> 31 & 1) != 0;
        this.spaceNumber = reader.readNextInt();
        this.subspaceIndex = reader.readNextInt();
        this.subspaceQuantity = reader.readNextUnsignedInt();
        this.loaderFixIndex = reader.readNextInt();
        this.loaderFixQuantity = reader.readNextUnsignedInt();
        this.initPointerIndex = reader.readNextInt();
        this.initPointerQuantity = reader.readNextUnsignedInt();
    }

    public String getName() {
        return this.name;
    }

    public boolean isLoadable() {
        return this.isLoadable;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean hasIntermediateCode() {
        return this.hasIntermediateCode;
    }

    public boolean isThreadSpecific() {
        return this.isThreadSpecific;
    }

    public int getReserved() {
        return this.reserved;
    }

    public int getSortKey() {
        return this.sortKey;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public int getSpaceNumber() {
        return this.spaceNumber;
    }

    public int getSubspaceIndex() {
        return this.subspaceIndex;
    }

    public long getSubspaceQuantity() {
        return this.subspaceQuantity;
    }

    public int getLoaderFixIndex() {
        return this.loaderFixIndex;
    }

    public long getLoaderFixQuantity() {
        return this.loaderFixQuantity;
    }

    public int getInitPonterIndex() {
        return this.initPointerIndex;
    }

    public long getInitPointerQuantity() {
        return this.initPointerQuantity;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("space_dictionary_record", 36);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "name", "index to subspace name");
        try {
            struct.addBitField(DWORD, 1, "is_loadable", "space is loadable");
            struct.addBitField(DWORD, 1, "is_defined", "space is defined within file");
            struct.addBitField(DWORD, 1, "is_private", "space is not sharable");
            struct.addBitField(DWORD, 1, "has_intermediate_code", "contain intermediate code");
            struct.addBitField(DWORD, 1, "is_tspecific", "is thread specific");
            struct.addBitField(DWORD, 11, "reserved", "reserved for future expansion");
            struct.addBitField(DWORD, 8, "sort_key", "sort key for space");
            struct.addBitField(DWORD, 8, "reserved2", "reserved for future expansion");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(DWORD, "space_number", "space index");
        struct.add(DWORD, "subspace_index", "index into subspace dictionary");
        struct.add(DWORD, "subspace_quantity", "number of subspaces in space");
        struct.add(DWORD, "loader_fix_index", "loader usage");
        struct.add(DWORD, "loader_fix_quantity", "loader usage");
        struct.add(DWORD, "init_pointer_index", "index into data(initialization) pointer array");
        struct.add(DWORD, "init_pointer_quantity", "number of data (init) pointers");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

