/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.ios.img3.AbstractImg3Tag;
import ghidra.file.formats.ios.img3.tag.Img3TagFactory;
import ghidra.program.model.data.DataType;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Img3
implements StructConverter {
    private int magic;
    private int size;
    private int dataSize;
    private int checkArea;
    private int identifier;
    private List<AbstractImg3Tag> _tags = new ArrayList<AbstractImg3Tag>();

    public Img3(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Img3(BinaryReader reader) throws IOException {
        this.magic = reader.readNextInt();
        this.size = reader.readNextInt();
        this.dataSize = reader.readNextInt();
        this.checkArea = reader.readNextInt();
        this.identifier = reader.readNextInt();
        while (reader.getPointerIndex() < (long)this.size) {
            long index = reader.getPointerIndex();
            AbstractImg3Tag tag = Img3TagFactory.get(reader);
            this._tags.add(tag);
            reader.setPointerIndex(index + (long)tag.getTotalLength());
        }
    }

    public String getMagic() {
        return StringUtilities.toString((int)this.magic);
    }

    public int getSize() {
        return this.size;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getCheckArea() {
        return this.checkArea;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public List<AbstractImg3Tag> getTags() {
        return this._tags;
    }

    public <T> List<T> getTags(Class<T> classType) {
        ArrayList<T> tmp = new ArrayList<T>();
        for (AbstractImg3Tag tag : this._tags) {
            if (tag.getClass() != classType) continue;
            tmp.add(classType.cast(tag));
        }
        return tmp;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

