/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import java.util.Objects;
import org.jungrapht.visualization.layout.model.Point;

public class PolarPoint {
    public final double theta;
    public final double radius;
    public static PolarPoint ORIGIN = new PolarPoint(0.0, 0.0);

    public static PolarPoint of(double theta, double radius) {
        return new PolarPoint(theta, radius);
    }

    private PolarPoint(double theta, double radius) {
        this.theta = theta;
        this.radius = radius;
    }

    public PolarPoint newRadius(double radius) {
        return PolarPoint.of(this.theta, radius);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PolarPoint)) {
            return false;
        }
        PolarPoint other = (PolarPoint)o;
        return Double.compare(other.theta, this.theta) == 0 && Double.compare(other.radius, this.radius) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.theta, this.radius);
    }

    public static Point polarToCartesian(PolarPoint polar) {
        return PolarPoint.polarToCartesian(polar.theta, polar.radius);
    }

    public static Point polarToCartesian(double theta, double radius) {
        return Point.of(radius * Math.cos(theta), radius * Math.sin(theta));
    }

    public static PolarPoint cartesianToPolar(Point point) {
        return PolarPoint.cartesianToPolar(point.x, point.y);
    }

    public static PolarPoint cartesianToPolar(double x, double y) {
        double theta = Math.atan2(y, x);
        double radius = Math.sqrt(x * x + y * y);
        return new PolarPoint(theta, radius);
    }

    public String toString() {
        return "PolarPoint[" + this.radius + "," + this.theta + "]";
    }
}

