# frozen_string_literal: true

module Security
  class VulnerabilityUUID
    def self.generate(report_type:, primary_identifier_fingerprint:, location_fingerprint:, project_id:)
      Gitlab::UUID.v5("#{report_type}-#{primary_identifier_fingerprint}-#{location_fingerprint}-#{project_id}")
    end

    def self.generate_v2(
      report_type:,
      primary_identifier_fingerprint:,
      location_fingerprint:,
      project_id:,
      context_id: nil
    )
      components = [report_type, primary_identifier_fingerprint, location_fingerprint, project_id, context_id]
      Gitlab::UUID.v5(components.join('-'))
    end
  end
end
