---
stage: Software Supply Chain Security
group: Authentication
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
gitlab_dedicated: yes
title: Two-factor authentication
description: Enable multi-factor authentication for enhanced account protection.
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

Two-factor authentication (2FA) provides an additional level of security to your GitLab account. For others to access
your account, they would need your username and password and access to your second factor of authentication.

GitLab supports the following 2FA methods:

- One-time password ([OTP](https://datatracker.ietf.org/doc/html/rfc6238)) authenticators. During sign in, GitLab prompts
  you for a code generated by your OTP authenticator.
- WebAuthn devices. During sign in, GitLab prompts you to prove ownership of your WebAuthn device. This is generally a physical device like a YubiKey, your phone, or your laptop.
- Email OTP. During sign in, GitLab prompts you for a code sent to your email address.

If you set up a device, also set up an OTP so you can still access your account if you lose the device.

## Enable two-factor authentication

To enable 2FA, verify your email address and register an OTP authenticator, a WebAuthn device,
or email OTP.

### Register an OTP authenticator

> [!warning]
> If you lose access to your OTP authenticator, you might be locked out of your account.
> 
> To minimize this risk:
> 
> - Enable cloud backup in your authenticator app.
> - Save your backup passwords, secret keys, or recovery credentials in a secure location.
> - Review the documentation for your specific OTP authenticator.

To register an OTP authenticator:

1. Configure GitLab.
   1. In the upper-right corner, select your avatar.
   1. Select **Edit profile**.
   1. On the left sidebar, select **Account**.
   1. Select **Enable Two-factor Authentication**.
   1. In the **One-time password authenticator** section, select **Register authenticator**.
      A QR code and your OTP details are displayed.
1. Configure your device.
   1. Install a compatible OTP application on your device. For example:
      - Cloud-based (recommended because you can restore access if you lose the hardware device):
        - [Authy](https://authy.com/).
        - [Cisco Duo](https://duo.com/).
      - Other (proprietary):
        - [Google Authenticator](https://support.google.com/accounts/answer/1066447?hl=en).
        - [Microsoft Authenticator](https://www.microsoft.com/en-us/security/mobile-authenticator-app).
      - Other (Free Software)
        - [Aegis Authenticator](https://getaegis.app/).
        - [FreeOTP](https://freeotp.github.io/).
   1. In the application, add a new entry in one of two ways:
      - Scan the code displayed by GitLab with your device's camera to add the entry automatically.
      - Enter the details provided to add the entry manually.
1. Complete the registration:
   1. Enter your current password.
   1. Enter the six-digit PIN generated from your authenticator.
   1. Select **Register with two-factor app**.

If you entered the correct pin, GitLab displays a list of [recovery codes](#recovery-codes).
Download them and keep them in a safe place.

If your OTP authenticator supports cloud backups, consider configuring the feature now. For more
information, see the documentation for your specific authenticator.

### Register a WebAuthn device

{{< history >}}

- Optional one-time password authentication for WebAuthn devices [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/378844) in GitLab 15.10 [with a feature flag](../../../administration/feature_flags/_index.md) named `webauthn_without_totp`.
- [Generally available](https://gitlab.com/gitlab-org/gitlab/-/issues/396931) in GitLab 17.6. Feature flag `webauthn_without_totp` removed.

{{< /history >}}

WebAuthn is [supported by](https://caniuse.com/#search=webauthn) the following:

- Desktop browsers:
  - Chrome
  - Edge
  - Firefox
  - Opera
  - Safari
- Mobile browsers:
  - Chrome for Android
  - Firefox for Android
  - iOS Safari (since iOS 13.3)

To register a WebAuthn-compatible device:

1. If using a physical device, plug it in to computer.
1. In the upper-right corner, select your avatar.
1. Select **Edit profile**.
1. On the left sidebar, select **Account**.
1. Select **Enable Two-Factor Authentication**.
1. In the **WebAuthn devices** section, select **Register device**.
1. Select **Set up new device**.
1. Follow the directions in your browser window.
1. Depending on your device, you might have to press a button or touch a sensor.
1. Enter your GitLab account password and a device name.
   You might not need to enter this password if you have signed in through your
   identity provider.
1. Select **Register device**.

You should receive a message indicating that you successfully set up your device.

When you set up 2FA with a WebAuthn-compatible device, that device is linked to
a specific browser on a specific computer. Depending on the browser and WebAuthn
device, you might be able to configure settings to use the WebAuthn device on a
different browser or computer.

If this is the first time you have set up 2FA, you
must [download recovery codes](#recovery-codes) so you can recover access to your
account if you lose access.

> [!warning]
> You can lose access to your account if you clear your browser data.

### Enable email OTP

{{< history >}}

- Introduced in GitLab 18.7 [with a feature flag](../../../administration/feature_flags/_index.md) named `email_based_mfa`. Disabled by default.
- Enabled on GitLab.com in GitLab 18.7, with progressive rollout to all users throughout 2026.

{{< /history >}}

> [!flag]
> The availability of this feature is controlled by a feature flag. For more information, see the history.

Email OTP allows you to verify your identity by sending a six-digit verification code to your email address.

> [!note]
> You might be unable to use email OTP if:
> 
> - Your group policy requires the use of other two-factor authentication methods.
> - Your account uses an external identity provider.
> - Your account is scheduled for automatic enablement at a future date.

To enable email OTP for your account:

1. In the upper-right corner, select your avatar.
1. Select **Edit profile**.
1. On the left sidebar, select **Account**.
1. Select **Manage two-factor authentication**.
1. Select **Enable email OTP**.
1. Enter your current password and select **Update email OTP settings**.

### Add a Cisco Duo authenticator

{{< details >}}

- Offering: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/15760) in GitLab 15.10.

{{< /history >}}

You can use Cisco Duo as an OTP provider in GitLab.

DUO® is a registered trademark of Cisco Systems, Inc., and/or its affiliates in the United States and certain other countries.

Prerequisites:

- Your account must exist in both Cisco Duo and GitLab, with the same username in both applications.
- You must have [configured Cisco Duo](https://admin.duosecurity.com/) and have an integration key, secret key, and API hostname.

For more information, see the [Cisco Duo API documentation](https://duo.com/docs/authapi).

1. Open the GitLab configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
    gitlab_rails['duo_auth_enabled'] = false
    gitlab_rails['duo_auth_integration_key'] = '<duo_integration_key_value>'
    gitlab_rails['duo_auth_secret_key'] = '<duo_secret_key_value>'
    gitlab_rails['duo_auth_hostname'] = '<duo_api_hostname>'
   ```

   For self-compiled installations:

   ```yaml
   duo_auth:
     enabled: true
     hostname: <duo_api_hostname>
     integration_key: <duo_integration_key_value>
     secret_key: <duo_secret_key_value>
   ```

1. Save the configuration file.
1. For Linux package installations, [reconfigure GitLab](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation).
   For self-compiled installations, [restart GitLab](../../../administration/restart_gitlab.md#self-compiled-installations).

### Add a FortiAuthenticator authenticator

{{< details >}}

- Offering: GitLab Self-Managed

{{< /details >}}

> [!flag]
> On GitLab Self-Managed, by default this feature is not available. To make it available per user, an administrator can
> [enable the feature flag](../../../administration/feature_flags/_index.md) named `forti_authenticator`.
> On GitLab.com and GitLab Dedicated, this feature is not available.

You can use FortiAuthenticator as an OTP provider in GitLab. Users must:

- Exist in both FortiAuthenticator and GitLab with the same username.
- Have FortiToken configured in FortiAuthenticator.

You need a username and access token for FortiAuthenticator. The `access_token` shown below is the FortiAuthenticator
access key. To get the token, see the REST API Solution Guide at
[Fortinet Document Library](https://docs.fortinet.com/document/fortiauthenticator/6.2.0/rest-api-solution-guide/158294/the-fortiauthenticator-api).
Tested with FortiAuthenticator version 6.2.0.

Configure FortiAuthenticator in GitLab. On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
   gitlab_rails['forti_authenticator_enabled'] = true
   gitlab_rails['forti_authenticator_host'] = 'forti_authenticator.example.com'
   gitlab_rails['forti_authenticator_port'] = 443
   gitlab_rails['forti_authenticator_username'] = '<some_username>'
   gitlab_rails['forti_authenticator_access_token'] = 's3cr3t'
   ```

   For self-compiled installations:

   ```yaml
   forti_authenticator:
     enabled: true
     host: forti_authenticator.example.com
     port: 443
     username: <some_username>
     access_token: s3cr3t
   ```

1. Save the configuration file.
1. [Reconfigure](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation)
   (Linux package installations) or [restart](../../../administration/restart_gitlab.md#self-compiled-installations)
   (self-compiled installations).

### Add a FortiToken Cloud authenticator

{{< details >}}

- Offering: GitLab Self-Managed

{{< /details >}}

> [!flag]
> On GitLab Self-Managed, by default this feature is not available. To make it available per user, an administrator can
> [enable the feature flag](../../../administration/feature_flags/_index.md) named `forti_token_cloud`.
> On GitLab.com and GitLab Dedicated, this feature is not available.
> This feature is not ready for production use.

You can use FortiToken Cloud as an OTP provider in GitLab. Users must:

- Exist in both FortiToken Cloud and GitLab with the same username.
- Have FortiToken configured in FortiToken Cloud.

You need a `client_id` and `client_secret` to configure FortiToken Cloud. To get these, see the REST API Guide at
[Fortinet Document Library](https://docs.fortinet.com/document/fortitoken-cloud/latest/rest-api/456035/overview).

Configure FortiToken Cloud in GitLab. On your GitLab server:

1. Open the configuration file.

   For Linux package installations:

   ```shell
   sudo editor /etc/gitlab/gitlab.rb
   ```

   For self-compiled installations:

   ```shell
   cd /home/git/gitlab
   sudo -u git -H editor config/gitlab.yml
   ```

1. Add the provider configuration.

   For Linux package installations:

   ```ruby
   gitlab_rails['forti_token_cloud_enabled'] = true
   gitlab_rails['forti_token_cloud_client_id'] = '<your_fortinet_cloud_client_id>'
   gitlab_rails['forti_token_cloud_client_secret'] = '<your_fortinet_cloud_client_secret>'
   ```

   For self-compiled installations:

   ```yaml
   forti_token_cloud:
     enabled: true
     client_id: YOUR_FORTI_TOKEN_CLOUD_CLIENT_ID
     client_secret: YOUR_FORTI_TOKEN_CLOUD_CLIENT_SECRET
   ```

1. Save the configuration file.
1. [Reconfigure](../../../administration/restart_gitlab.md#reconfigure-a-linux-package-installation) (Linux package installations) or
   [restart](../../../administration/restart_gitlab.md#self-compiled-installations) (self-compiled installations).

## Recovery codes

Immediately after successfully enabling 2FA with an OTP authenticator, you're prompted to download
a set of generated recovery codes. If you ever lose access to your OTP authenticator, you can use one of
these recovery codes to sign in to your account.

You should copy and print the codes, or use **Download codes** to download them for storage in a safe
place. If you choose to download them, the file is called `gitlab-recovery-codes.txt`.

> [!note]
>
> - You can use each code only once to sign in to your account.
> - Recovery codes are not generated for WebAuthn devices.

For information on regenerating or restoring your recovery codes, see
[recovery options and 2FA reset](two_factor_authentication_troubleshooting.md#recovery-options-and-2fa-reset).

## Sign in with two-factor authentication

When 2FA is enabled, you enter your username and password, then use your second authentication
method to confirm your identity. The sign in process differs slightly depending on which 2FA
method you registered.

### Sign in with an OTP authenticator

When prompted, enter the pin from your OTP authenticator or a recovery code to sign in.

### Sign in with a WebAuthn device

In supported browsers, you should be automatically prompted to activate your WebAuthn device (for example, by touching
or pressing its button) after entering your credentials.

A message displays indicating that your device responded to the authentication request and you're automatically signed
in.

### Sign in with email OTP

When prompted, enter the six-digit verification code that is sent to your email.
The code remains valid for 60 minutes.

If you are unable to use the access code, you can:

- Request a new code. On the sign in page, select **Resend code**.
- Send a code to another verified email address. On the sign in page, select **Send a code to
  another address associated with this account**.
- See [Email OTP troubleshooting](two_factor_authentication_troubleshooting.md#email-otp-troubleshooting).

### Sign in with a personal access token

When 2FA is enabled, you cannot use your password to authenticate with Git over HTTPS or the
[GitLab API](../../../api/rest/_index.md). You must use a
[personal access token](../personal_access_tokens.md) instead.

## Disable two-factor authentication

{{< history >}}

- Ability to disable OTP authenticator and WebAuthn devices individually or simultaneously [introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/393419) in GitLab 17.6.

{{< /history >}}

You can disable the OTP authenticator and WebAuthn devices individually or simultaneously. To disable them simultaneously:

1. In the upper-right corner, select your avatar.
1. Select **Edit profile**.
1. On the left sidebar, select **Account**.
1. Select **Manage two-factor authentication**.
1. Select **Disable 2FA**.
1. On the dialog, enter your current password and select **Disable 2FA**.

This clears all your 2FA registrations, including mobile applications and WebAuthn devices.

## OAuth credential helpers

The following Git credential helpers authenticate to GitLab using OAuth. This is compatible with two-factor authentication. The first time you authenticate, the helper opens the web browser and GitLab asks you to authorize the app. Subsequent authentication requires no interaction.

### Git Credential Manager

[Git Credential Manager](https://github.com/GitCredentialManager/git-credential-manager) (GCM) authenticates by default using OAuth. GCM supports GitLab.com without any manual configuration. To use GCM with GitLab Self-Managed, see [GitLab support](https://github.com/GitCredentialManager/git-credential-manager/blob/main/docs/gitlab.md).

So you do not need to re-authenticate on every push, GCM supports caching as well as a variety of platform-specific credential stores that persist between sessions. This feature is useful whether you use personal access tokens or OAuth.

Git for Windows includes Git Credential Manager.

Git Credential Manager is developed primarily by GitHub, Inc. It is an open-source project and is supported by the community.

### git-credential-oauth

[git-credential-oauth](https://github.com/hickford/git-credential-oauth) supports GitLab.com and several popular public hosts without any manual configuration needed. To use with GitLab Self-Managed, see the [git-credential-oauth custom hosts documentation](https://github.com/hickford/git-credential-oauth#custom-hosts).

Many Linux distributions include git-credential-oauth as a package.

git-credential-oauth is an open-source project supported by the community.

## Information for GitLab administrators

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

- Take care that 2FA keeps working after [restoring a GitLab backup](../../../administration/backup_restore/_index.md).
- To ensure 2FA authorizes correctly with an OTP server, synchronize your GitLab
  server's time using a service like NTP. Otherwise, authorization can always fail because of time differences.
- The GitLab WebAuthn implementation does not work when the GitLab instance is accessed from multiple hostnames
  or FQDNs. Each WebAuthn registration is linked to the current hostname at the time of registration, and
  cannot be used for other hostnames or FQDNs.

  For example, if a user is trying to access a GitLab instance from `first.host.xyz` and `second.host.xyz`:

  - The user signs in by using `first.host.xyz` and registers their WebAuthn key.
  - The user signs out and attempts to sign in by using `first.host.xyz` - WebAuthn authentication succeeds.
  - The user signs out and attempts to sign in by using `second.host.xyz` - WebAuthn authentication fails, because
    the WebAuthn key has only been registered on `first.host.xyz`.

- To enforce 2FA at the system or group levels see, [Enforce two-factor authentication](../../../security/two_factor_authentication.md).
