/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Closeable;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.execution.ProjectExecutionServices;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceRegistry;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ProjectExecutionServiceRegistry
implements AutoCloseable {
    private final NodeExecutionContext global;
    private final LoadingCache<ProjectInternal, NodeExecutionContext> projectRegistries = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ProjectInternal, NodeExecutionContext>(){

        public NodeExecutionContext load(@NonNull ProjectInternal project) {
            return new DefaultNodeExecutionContext(ProjectExecutionServices.create(project));
        }
    });

    public ProjectExecutionServiceRegistry(ServiceRegistry globalServices) {
        this.global = arg_0 -> ((ServiceRegistry)globalServices).get(arg_0);
    }

    public NodeExecutionContext forProject(@Nullable ProjectInternal project) {
        if (project == null) {
            return this.global;
        }
        return (NodeExecutionContext)this.projectRegistries.getUnchecked((Object)project);
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.projectRegistries.asMap().values()).stop();
    }

    private static class DefaultNodeExecutionContext
    implements NodeExecutionContext,
    Closeable {
        private final CloseableServiceRegistry services;

        public DefaultNodeExecutionContext(CloseableServiceRegistry services) {
            this.services = services;
        }

        public <T> T getService(Class<T> type) throws ServiceLookupException {
            return (T)this.services.get(type);
        }

        @Override
        public void close() {
            this.services.close();
        }
    }
}

